// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.database.ProrateTaxTable;

/* ץ졼ξǡ١(rapiddb)󥿡ե */

public interface ProrateDatabase {
  public boolean	openDatabase();
  public void	closeDatabase();

  public class Amount {
    public String	currency;
    public double	value;
  }

  double	getRoeRate(String currency, String date);
  double	get5dayRate(String currency, String date);
  double	getMeanRate(String currency, String date);
  double	getProrateFactor(String from, String to, String date);
  Amount	getBaseAmount(String from, String to, String carrier,
			      String code, String date);
  String	getCountryName(String place, String date);
  String	getAreaName(String place, String date);
  String	getCityName(String place);
  String	getAirwayId(String airwayNo, String date);
  String	getAirwayName(String airwayNo, String date);
  boolean	checkAirwayId(String airwayId, String date);
  String	getOpCarrier(String carrier, String flightNo,
			     String date);
  /* obsolete */
  String	codeShareExcl(String carrier, String flightNo,
			      String date);
  /* obsolete */
  String	codeShareIncl(String carrier, String flightNo,
			      String date);
  /* obsolete?? */
  String	codeShareSpa(String carrier, String flightNo,
			     String date);
  double	getFixedFare(String date);
  ProrateTaxTable	getTaxTable(String taxCode, String date);
  Object[]	getNormalCodes();
  Object[]	getSpecialCodes();
  Object[]	getDiscountCodes();
  Object[]	getIDCHINCodes();
  String	getAgentCountry(String agentCode, String date);
  String	getAgentArea(String agentCode, String date);
  String	getFClasses();
  String	getCClasses();
  String	getYClasses();
  boolean	checkSia(String carrier, String flightNo, String flightDate);
  int	getResult();
  String	getErrCode();
  String	getErrMessage();
}
