// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;

/* AUDITΥեݡͥȤΥǥ */

/**
 * @author   maruyama
 */
public class ProrateFareComponentImpl {

  ProrateAuditImpl	auditImpl = null;

  ProrateFareComponentImpl() {
    super();
  }

  public boolean	prorate(ProrateAuditImpl auditImpl,
				ProrateAudit audit, ProrateFareComponent fcomp,
				ProrateRulebase rulebase) throws Exception {
    setAuditImpl(auditImpl);
    if (!initSectors(fcomp)) {
      return false;
    }

    if (!prorateSRP(fcomp)) {
      return false;
    }

    if (!fcomp.getAudit().isNotRuleApply()) {
      fcomp.setFixedFareDiscount((double)1);
      for (int i = 0; i < fcomp.getSectors().length; i++) {
	ProrateSectorImpl	sectorImpl = new ProrateSectorImpl();
	sectorImpl.prorate(getAuditImpl(),
			   (ProrateSector)fcomp.getSectors()[i],
			   fcomp.getAudit(), fcomp, i);
      }
    }

    /* ;;; user_setv_set()??? */

    if (!prorateClassDiff(fcomp)) {
      return false;
    }
    if (!prorateSecureCharge(fcomp)) {
      return false;
    }
    if (!prorateNuc(fcomp)) {
      return false;
    }
    if (!prorateRest(fcomp)) {
      return false;
    }

    return true;
  }
  
  boolean	initSectors(ProrateFareComponent fcomp) {
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      sector.setProrateValue((double)0);
      sector.setSecureChargeSaved(sector.getSecureCharge());
    }
    return true;
  }

  boolean	prorateSRP(ProrateFareComponent fcomp) {
    double	totalProrateFactor = (double)0;
    boolean	isError = false;
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      if (sector.getProrateFactor() <= (double)0) {
	sector
	  .setProrateFactor(getAuditImpl().database
			    .getProrateFactor(sector.getDepCode(),
					      sector.getDestCode(),
					      fcomp.getAudit()
					      .getIssueDate()));
	if (sector.getProrateFactor() < (double)0) {
	  if (getAuditImpl().database.getResult() > 1) {
	    getAuditImpl().DBError(sector, "getProrateFactor",
				   sector.getDepCode(), sector.getDestCode());
	    return false;
	  }
	  isError = true;
	  getAuditImpl().error(sector, ProrateAudit.ASK_FACTOR);
	}
      }
      totalProrateFactor += sector.getProrateFactor();
    }
    if (isError) {
      return false;
    }
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      sector.setSrpNuc(fcomp.getValue() * sector.getProrateFactor()
		       / totalProrateFactor);
    }
    return true;
  }

  boolean	prorateNuc(ProrateFareComponent fcomp) {
    double	totalProrateFactor = (double)0;
    double	srpProrateFactor = (double)0;
    double	valueCheck = (double)0;

    /* APDPŬѤǤ֤Υץӥۤ¤ */
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      if (((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0
	   && (sector.getProrationType() & ProrateAudit.PRT_PRVS) != 0)
	  || (sector.getProrationType() & ProrateAudit.PRT_APDP) != 0) {
	/* ;;; PRT_UPVɤ??? */
	/* ץӥۤ¤ */
	valueCheck += sector.getApdpNuc();
      }
      else {
	/* ץӥΤʤ֤Υץ졼ȥե¤ */
	srpProrateFactor += sector.getProrateFactor();
      }
      /* ֤Υץ졼ȥե¤ */
      totalProrateFactor += sector.getProrateFactor();
    }

    /* Fixed Fare CheckԤʤ */
    if (fcomp.getSectors().length > 1
	&& checkFixedFare(fcomp, fcomp.getValue() - valueCheck,
			  srpProrateFactor)) {
      /* Fixed Fare Checkѥ硢ץӥͭ */
      double	valueRest = fcomp.getValue() - valueCheck;
      for (int i = 0; i < fcomp.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
	sector.setFixedFareCheck(((ProrateSector)fcomp.getSectors()[0])
				 .getFixedFareCheck());
	sector.setFixedFareDiscount(((ProrateSector)fcomp.getSectors()[0])
				    .getFixedFareDiscount());
	if ((sector.getProrationType() & ProrateAudit.PRT_PRVS) != 0
	    || (sector.getProrationType() & ProrateAudit.PRT_APDP) != 0) {
	  /* ץӥζ֤ξ */
	  if ((sector.getProrationType() & ProrateAudit.PRT_NP) != 0) {
	    if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	      /* Np()ˤꡢSPAۤ줿 */
	      if (sector.getApdpNuc() == (double)0) {
		/* Srp()ޤNp()ˤꡢAPDPۤ줿 */
		sector.setApdpNuc(sector.getApdpDiscountRate()
				  * sector.getSrpNuc());
	      }
	      /* ץӥ(APDP)ۤSPAŬѤ */
	      sector.setSpaBaseAmtType(sector.getApdpBaseAmtType());
	      sector.setSpaBaseAmt(sector.getApdpDiscountRate()
				   * sector.getApdpBaseAmt());
	      sector.setSpaNuc(sector.getSpaDiscountRate()
			       * sector.getApdpNuc()
			       + sector.getProratedClassDiff());
	      sector.setProratedClassDiff((double)0);
	    }
	    else {
	      /* Np()ˤꡢAPDPۤ줿 */
	      /* SRPۤAPDPŬѤ */
	      sector.setApdpNuc(sector.getApdpDiscountRate()
				* sector.getSrpNuc());
	    }
	  }
	  else if ((sector.getProrationType() & ProrateAudit.PRT_FIXSRP)
		   != 0) {
	    if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	      /* Srp()ˤꡢSPAۤ줿 */
	      /* ץӥǤϤʤSRPۤSPAŬѤ */
	      sector.setSpaNuc(sector.getSpaDiscountRate() * sector.getSrpNuc()
			       + sector.getProratedClassDiff());
	      sector.setProratedClassDiff((double)0);
	    }
	    else {
	      /* Srp()ˤꡢAPDPۤ줿 */
	      /* SRPۤAPDPŬѤ */
	      sector.setApdpNuc(sector.getApdpDiscountRate()
				* sector.getSrpNuc());
	    }
	  }
	  /* ;;; PRT_UPVɤ??? */
	  /* ץӥΤ֤ϤΤޤ */
	  sector.setNpPvalues(sector.getApdpNuc());
	}
	else {
	  /* ץӥʤζ֤ξ */
	  if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0
	      && (sector.getProrationType() & ProrateAudit.PRT_FIXSRP) != 0) {
	    /* Srp()ˤꡢSPAۤ줿 */
	    /* ץӥǤϤʤSRPۤSPAŬѤ */
	    sector.setSpaNuc(sector.getSpaDiscountRate() * sector.getSrpNuc()
			     + sector.getProratedClassDiff());
	    sector.setProratedClassDiff((double)0);
	  }
	  /* ץӥʳλĳۤ򥹥ȥ졼ȥ졼ȥץ졼 */
	  sector.setSrpNuc(valueRest * sector.getProrateFactor()
			   / srpProrateFactor);
	  sector.setNpPvalues(sector.getSrpNuc());
	  if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	    if ((sector.getProrationType() & ProrateAudit.PRT_NP) != 0) {
	      /* Np()ˤꡢSPAۤ줿 */
	      /* ץӥǤϤʤSRPۤSPAŬѤ */
	      sector.setSpaNuc(sector.getSpaDiscountRate() * sector.getSrpNuc()
			       + sector.getProratedClassDiff());
	      sector.setProratedClassDiff((double)0);
	    }
	  }
	  else {
	    sector.setProrationType(sector.getProrationType()
				    | ProrateAudit.PRT_SRP);
	  }
	}
      }
    }
    else {
      /* ץӥ̵֤ˤĤƥȥ졼ȥ졼ȥץ졼 */
      for (int i = 0; i < fcomp.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
	sector.setFixedFareCheck(((ProrateSector)fcomp.getSectors()[0])
				 .getFixedFareCheck());
	sector.setFixedFareDiscount(((ProrateSector)fcomp.getSectors()[0])
				    .getFixedFareDiscount());
	sector.setProrationType(sector.getProrationType()
				& ~ProrateAudit.PRT_PRVS);
	if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	  if ((sector.getProrationType() & ProrateAudit.PRT_FIXSRP) != 0
	      || (sector.getProrationType() & ProrateAudit.PRT_NP) != 0) {
	    /* Srp()Np()ˤꡢSPAۤ줿 */
	    /* ץӥǤϤʤSRPۤSPAŬѤ */
	    sector.setSpaNuc(sector.getSpaDiscountRate() * sector.getSrpNuc()
			     + sector.getProratedClassDiff());
	    sector.setProratedClassDiff((double)0);
	  }
	}
	else {
	  /* ץӥǤϤʤSRPۤץ졼ۤȤ */
	  sector.setProrationType(sector.getProrationType()
				  & ~ProrateAudit.PRT_APDP);
	  sector.setProrationType(sector.getProrationType()
				  | ProrateAudit.PRT_SRP);
	}
	sector.setNpPvalues(sector.getSrpNuc());
      }
    }

    /* ֤ˤĤƷꤵ줿ץ졼ȥХ塼򥻥å */
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      if ((sector.getProrationType() & ProrateAudit.PRT_HIGHSPA) != 0) {
	if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	  sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
	  if ((sector.getProrationType() & ProrateAudit.PRT_PRVS) != 0) {
	    if (sector.getSpaNuc()
		>= sector.getNpPvalues() + sector.getNpClassDiff()) {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_APDP);
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SRP);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_SPA);
	      sector.setProratedClassDiff((double)0);
	    }
	    else {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SPA);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_APDP);
	      sector.setProratedClassDiff(sector.getNpClassDiff());
	    }
	  }
	  else {
	    if (sector.getSpaNuc()
		>= sector.getNpPvalues() + sector.getNpClassDiff()) {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_APDP);
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SRP);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_SPA);
	      sector.setProratedClassDiff((double)0);
	    }
	    else {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SPA);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_SRP);
	      sector.setProratedClassDiff(sector.getNpClassDiff());
	    }
	  }
	}
	else {
	  sector.setProrationType(sector.getProrationType()
				  & ~ProrateAudit.PRT_HIGHSPA);
	}
      }
      else if ((sector.getProrationType() & ProrateAudit.PRT_LOWSPA) != 0) {
	if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	  sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
	  if ((sector.getProrationType() & ProrateAudit.PRT_PRVS) != 0) {
	    if (sector.getSpaNuc()
		<= sector.getNpPvalues() + sector.getNpClassDiff()) {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_APDP);
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SRP);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_SPA);
	      sector.setProratedClassDiff((double)0);
	    }
	    else {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SPA);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_APDP);
	      sector.setProratedClassDiff(sector.getNpClassDiff());
	    }
	  }
	  else {
	    if (sector.getSpaNuc()
		<= sector.getNpPvalues() + sector.getNpClassDiff()) {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_APDP);
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SRP);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_SPA);
	      sector.setProratedClassDiff((double)0);
	    }
	    else {
	      sector.setProrationType(sector.getProrationType()
				      & ~ProrateAudit.PRT_SPA);
	      sector.setProrationType(sector.getProrationType()
				      | ProrateAudit.PRT_SRP);
	      sector.setProratedClassDiff(sector.getNpClassDiff());
	    }
	  }
	}
	else {
	  sector.setProrationType(sector.getProrationType()
				  & ~ProrateAudit.PRT_LOWSPA);
	}
      }
      else if ((sector.getProrationType() & ProrateAudit.PRT_HIGHSPAFIX)
	       != 0) {
	sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
	sector.setProratedClassDiff((double)0);
	if (sector.getSpaNuc() < sector.getFixValue()) {
	  sector.setSpaNuc(sector.getFixValue());
	  /*
	    sectors[j]->spaBaseAmtType = sectors[j]->fixCurrency;
	    sectors[j]->spaBaseAmt = sectors[j]->fixAmount;
	    sectors[j]->spaDiscountRate = (double)1;
	  */
	  /*
	    sectors[j]->prorationType &= ~PRT_SPA;
	    if (sectors[j]->prorationType & PRT_PRVS) {
	    sectors[j]->prorationType |= PRT_APDP;
	    }
	    else {
	    sectors[j]->prorationType |= PRT_SRP;
	    }
	  */
	}
      }
      else if ((sector.getProrationType() & ProrateAudit.PRT_LOWSPAFIX) != 0) {
	sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
	sector.setProratedClassDiff((double)0);
	if (sector.getSpaNuc() > sector.getFixValue()) {
	  sector.setSpaNuc(sector.getFixValue());
	  /*
	    sectors[j]->spaBaseAmtType = sectors[j]->fixCurrency;
	    sectors[j]->spaBaseAmt = sectors[j]->fixAmount;
	    sectors[j]->spaDiscountRate = (double)1;
	  */
	  /*
	    sectors[j]->prorationType &= ~PRT_SPA;
	    if (sectors[j]->prorationType & PRT_PRVS) {
	    sectors[j]->prorationType |= PRT_APDP;
	    }
	    else {
	    sectors[j]->prorationType |= PRT_SRP;
	    }
	  */
	}
      }
      if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
	sector.setProratedClassDiff((double)0);
	sector.setProrateValue(sector.getSpaNuc()
			       + sector.getProratedClassDiff()
			       + sector.getProratedSecureCharge());
      }
      if ((sector.getProrationType() & ProrateAudit.PRT_APDP) != 0) {
	sector.setProrateValue(sector.getApdpNuc()
			       + sector.getProratedClassDiff()
			       + sector.getProratedSecureCharge());
      }
      if ((sector.getProrationType() & ProrateAudit.PRT_SRP) != 0) {
	sector.setProrateValue(sector.getSrpNuc()
			       + sector.getProratedClassDiff()
			       + sector.getProratedSecureCharge());
      }
      getAuditImpl().trace.traceValue(fcomp, i);
    }

    return true;
  }

  boolean	checkFixedFare(ProrateFareComponent fcomp,
			       double valueRest, double totalProrateFactor) {
    ProrateSector	sector = (ProrateSector)fcomp.getSectors()[0];
    if (totalProrateFactor == (double)0) {
      if (valueRest >= 0) {
	sector.setFixedFareCheck(0);
	getAuditImpl().trace.traceFixedFareCheck(true, fcomp);
	return true;
      }
      sector.setFixedFareCheck(-1);
      getAuditImpl().trace.traceFixedFareCheck(false, fcomp);
      return false;
    }
    sector.setFixedFareCheck(valueRest / totalProrateFactor * (double)100);
    sector.setFixedFareDiscount(fcomp.getFixedFareDiscount());
    if (sector.getFixedFareCheck()
	>= (fcomp.getAudit().getFixedFare() * fcomp.getFixedFareDiscount())) {
      getAuditImpl().trace.traceFixedFareCheck(true, fcomp);
      return true;
    }
    getAuditImpl().trace.traceFixedFareCheck(false, fcomp);
    return false;
  }

  boolean	prorateClassDiff(ProrateFareComponent fcomp) {
    for (int i = 1; ; i++) {
      double	totalProrateFactor = (double)0;
      double	totalClassDiff = (double)0;
      boolean	found = false;
      for (int j = 0; j < fcomp.getSectors().length; j++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[j];
	if (sector.getClassDiffIndex() == i) {
	  found = true;
	  totalProrateFactor += sector.getProrateFactor();
	  totalClassDiff += sector.getClassDiffPlus();
	}
	else if (sector.getClassDiffIndex() > i) {
	  found = true;
	}
      }
      if (!found) {
	break;
      }
      if (totalProrateFactor == (double)0 || totalClassDiff == (double)0) {
	continue;
      }
      totalClassDiff *=
	fcomp.getAudit().getAmountRatio()
	* fcomp.getAudit().getRoeRate() / fcomp.getAudit().getDay5Rate();
      for (int j = 0; j < fcomp.getSectors().length; j++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[j];
	if (sector.getClassDiffIndex() == i) {
	  sector.setProratedClassDiff(totalClassDiff
				      * sector.getProrateFactor()
				      / totalProrateFactor);
	  sector.setNpClassDiff(sector.getProratedClassDiff());
	}
      }
    }

    double	totalProrateFactor = (double)0;
    double	totalClassDiff = (double)0;
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	if ((sector.getProrationType() & ProrateAudit.PRT_NP) != 0
	    || (sector.getProrationType() & ProrateAudit.PRT_FIXSRP) != 0) {
	  totalClassDiff += sector.getProratedClassDiff();
	  sector.setProratedClassDiff(sector.getProratedClassDiff()
				      * sector.getSpaDiscountRate());
	  totalClassDiff -= sector.getProratedClassDiff();
	}
	else {
	  totalClassDiff += sector.getProratedClassDiff();
	  sector.setProratedClassDiff((double)0);
	}
      }
      else {
	/* ȯꥢ */
	if ((sector.getCarrier().equals(fcomp.getAudit().getAirwayId())
	     && sector.getOpCarrier().equals(""))
	    || sector.getOpCarrier().equals(fcomp.getAudit().getAirwayId())) {
	  totalProrateFactor += sector.getProrateFactor();
	}
      }
    }
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      if ((sector.getProrationType() & ProrateAudit.PRT_SPA) == 0) {
	/* ȯꥢ */
	if ((sector.getCarrier().equals(fcomp.getAudit().getAirwayId())
	     && sector.getOpCarrier().equals(""))
	    || sector.getOpCarrier().equals(fcomp.getAudit().getAirwayId())) {
	  double	value =
	    totalClassDiff * sector.getProrateFactor() / totalProrateFactor;
	  sector.setProratedClassDiff(sector.getProratedClassDiff() + value);
	  /* npClassDiffˤ⺹Ĵ */
	  sector.setNpClassDiff(sector.getProratedClassDiff());
	}
      }
    }
    return true;
  }

  boolean	prorateSecureCharge(ProrateFareComponent fcomp) {
    for (int i = 1; ; i++) {
      double	totalProrateFactor = (double)0;
      double	totalSecureCharge = (double)0;
      boolean	found = false;
      for (int j = 0; j < fcomp.getSectors().length; j++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[j];
	if (sector.getSecureIndex() == i) {
	  found = true;
	  totalProrateFactor += sector.getProrateFactor();
	  totalSecureCharge += sector.getSecureCharge();
	}
	else if (sector.getSecureIndex() > i) {
	  found = true;
	}
      }
      if (!found) {
	break;
      }
      if (totalProrateFactor == (double)0
	  || totalSecureCharge == (double)0) {
	continue;
      }
      totalSecureCharge *= (fcomp.getAudit().getAmountRatio()
			    * fcomp.getAudit().getRoeRate()
			    / fcomp.getAudit().getDay5Rate());
      for (int j = 0; j < fcomp.getSectors().length; j++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[j];
	if (sector.getSecureIndex() == i) {
	  sector.setProratedSecureCharge(totalSecureCharge
					 * sector.getProrateFactor()
					 / totalProrateFactor);
	}
      }
    }
    return true;
  }

  boolean	prorateRest(ProrateFareComponent fcomp) {
    double	totalProrateValue = (double)0;
    double	totalSecurityCharge = (double)0;
    double	totalClassDiff = (double)0;

    /* ݡͥȤζ֤ˤĤƷꤵ줿ץ졼ȥХ塼û */
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
      /* ȯꥢ֤Сʤˤ⤷ʤ */
      if ((sector.getCarrier().equals(fcomp.getAudit().getAirwayId())
	   && sector.getOpCarrier().equals(""))
	  || sector.getOpCarrier().equals(fcomp.getAudit().getAirwayId())) {
	return true;
      }
      totalProrateValue += sector.getProrateValue();
      totalSecurityCharge += sector.getSecureCharge();
      totalClassDiff += sector.getClassDiffPlus();
    }
    totalSecurityCharge *=
      fcomp.getAudit().getAmountRatio()
      * fcomp.getAudit().getRoeRate() / fcomp.getAudit().getDay5Rate();
    totalClassDiff *=
      fcomp.getAudit().getAmountRatio()
      * fcomp.getAudit().getRoeRate() / fcomp.getAudit().getDay5Rate();

    /* ץ졼ȥХ塼­ʬ */
    double	valueRest = (fcomp.getValue() + totalSecurityCharge
			     + totalClassDiff - totalProrateValue);
    
    /* ץ졼ȥХ塼ۤݡͥȲͤȰפʤ(SPAΤ) */
    if (valueRest != (double)0) {
      boolean	found = false;
      double	totalProrateFactor = (double)0;
      /* SPA Code Share֤Υץ졼ȥե¤ */
      for (int i = 0; i < fcomp.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
	String sspa =
	  getAuditImpl().database.codeShareSpa(sector.getCarrier(),
					       sector.getFlightNo(),
					       sector.getFlightDate());
	if (sspa.equals("") && getAuditImpl().database.getResult() > 1) {
	  getAuditImpl().DBError(sector, "codeShareSpa",
				 sector.getCarrier(), sector.getFlightNo());
	  return false;
	}
	if (!sspa.equals("")) {
	  totalProrateFactor += sector.getProrateFactor();
	  found = true;
	}
      }
      if (!found) {
	return true;
      }
      /* SPA Code Share֤صŪ˰ʬƲäƤ */
      for (int i = 0; i < fcomp.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)fcomp.getSectors()[i];
	String sspa =
	  getAuditImpl().database.codeShareSpa(sector.getCarrier(),
					       sector.getFlightNo(),
					       sector.getFlightDate());
	if (sspa.equals("") && getAuditImpl().database.getResult() > 1) {
	  getAuditImpl().DBError(sector, "codeShareSpa",
				 sector.getCarrier(), sector.getFlightNo());
	  return false;
	}
	if (!sspa.equals("")) {
	  sector.setProrateValue(sector.getProrateValue() +
				 valueRest * sector.getProrateFactor()
				 / totalProrateFactor);
	  getAuditImpl().trace.traceRest(fcomp, valueRest,
					 totalProrateFactor, i);
	}
      }
    }
    return true;
  }

  /**
   * @return  auditImpl ᤷޤ
   * @uml.property  name="auditImpl"
   */
  public ProrateAuditImpl getAuditImpl() {
    return auditImpl;
  }
  /**
   * @param auditImpl  auditImpl ꡣ
   * @uml.property  name="auditImpl"
   */
  public void setAuditImpl(ProrateAuditImpl auditImpl) {
    this.auditImpl = auditImpl;
  }
}
