// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;

/**
 * class <code>ProrateImpl</code> ץ졼¹Ԥ饹
 * @author   <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */

public class ProrateImpl implements Prorate {

  /**
   * variable <code>auditImpl</code>	ץ졼󥨥󥸥
   *
   */
  ProrateAuditImpl	auditImpl;

  /**
   * variable <code>rulebase</code>	롼١
   * 
   * @uml.property name="rulebase"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateRulebase rulebase;

  /**
   * variable <code>fcalc</code>	Fare Calculation ϥ󥸥
   * 
   * @uml.property name="fcalc"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateFcalc fcalc;

  /**
   * variable <code>database</code>
   * 	ץ졼ξǡ١(rapiddb)
   * 
   * @uml.property name="database"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateDatabase database;

  /**
   * variable <code>trace</code>	ȥ졼
   * 
   * @uml.property name="trace"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateTrace trace;

  /**
   * variable <code>tax</code>	taxϥ󥸥
   *
   */
  ProrateTax tax;

  
  /**
   * Creates a new <code>ProrateImpl</code> instance.
   *
   */
  public ProrateImpl() {
  }

  /**
   * <code>prorate</code> method
   *	ץ졼¹Ԥ̤֤
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateAudit</code> value
   * @throws Exception 
   */
  public ProrateAudit	prorate(ProrateAudit audit) throws Exception {
    try {
      auditImpl = new ProrateAuditImpl();
      auditImpl.rulebase = getRulebase();
      auditImpl.fcalc = getFcalc();
      auditImpl.database = getDatabase();
      auditImpl.trace = getTrace();
      auditImpl.tax = getTax();
      getTax().setEngine(auditImpl);
      auditImpl.prorate(audit);
    }
    finally {
      getTax().setEngine(null);
      if (auditImpl != null) {
	auditImpl.tax = null;
	auditImpl.trace = null;
	auditImpl.database = null;
	auditImpl.fcalc = null;
	auditImpl.rulebase = null;
	auditImpl = null;
      }
    }
    return audit;
  }

  /**
   * 
   * @uml.property name="rulebase"
   */
  public ProrateRulebase getRulebase() {
    return rulebase;
  }

  /**
   * 
   * @uml.property name="rulebase"
   */
  public void setRulebase(ProrateRulebase rulebase) {
    this.rulebase = rulebase;

  }

  /**
   * 
   * @uml.property name="fcalc"
   */
  public ProrateFcalc getFcalc() {
    return fcalc;
  }

  /**
   * 
   * @uml.property name="fcalc"
   */
  public void setFcalc(ProrateFcalc fcalc) {
    this.fcalc = fcalc;
  }

  /**
   * 
   * @uml.property name="database"
   */
  public ProrateDatabase getDatabase() {
    return database;
  }

  /**
   * 
   * @uml.property name="database"
   */
  public void setDatabase(ProrateDatabase database) {
    this.database = database;
  }

  /**
   * 
   * @uml.property name="trace"
   */
  public ProrateTrace getTrace() {
    return trace;
  }

  /**
   * 
   * @uml.property name="trace"
   */
  public void setTrace(ProrateTrace trace) {
    this.trace = trace;
  }

  /**
   * 
   * @uml.property name="tax"
   */
  public ProrateTax getTax() {
    return tax;
  }

  /**
   * 
   * @uml.property name="tax"
   */
  public void setTax(ProrateTax tax) {
    this.tax = tax;
  }

}
