// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;

/* ץ졼롼빽ʸǥ֥ */

public abstract class ProrateRuleObject implements ProrateRulebaseElement {

  static final int	FBT_NORMAL_FARE = 0x01;
  static final int	FBT_DISCOUNT_FARE = 0x02;
  static final int	FBT_PROMOTIONAL_FARE = 0x04;
  static final int	FBT_ILLEGAL_FARE = 0x10;

  static Object[]	normal_code = null;
  static Object[]	special_code = null;
  static Object[]	discount_code = null;
  static Object[]	IDCHIN_code = null;

  public static String	F_classes = null;
  public static String	C_classes = null;
  public static String	Y_classes = null;

  /* 饹᥽åɡեʸ󽸹ꤹ */
  static void	classInitialize(ProrateDatabase database) {
    normal_code = database.getNormalCodes();
    special_code = database.getSpecialCodes();
    discount_code = database.getDiscountCodes();
    IDCHIN_code = database.getIDCHINCodes();

    F_classes =	database.getFClasses();
    C_classes =	database.getCClasses();
    Y_classes =	database.getYClasses();
  }

  static Map	codeConversionMap;
  /* 饹᥽åɡѴơ֥ꤹ */
  static void	codeConversionInitialize() {
    String[]	code1 = {
      "A",
      "F",
      "P",
      "R",
      "C",
      "I",
      "J",
      "Z",
      "D",
      "B",
      "E",
      "G",
      "H",
      "K",
      "L",
      "M",
      "N",
      "Q",
      "S",
      "T",
      "U",
      "V",
      "W",
      "X",
      "Y"
    };
    String[]	code2 = {
      "FCY",
      "FCY",
      "FCY",
      "FCY",
      "CY",
      "CY",
      "CY",
      "CY",
      "CY",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
      "Y",
    };
    codeConversionMap = new HashMap();
    for (int i = 0; i < code1.length; i++) {
      codeConversionMap.put(code1[i], code2[i]);
    }
  }

  public boolean	isCopied;

  /**
   * 
   * @uml.property name="evaluatedObject"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateRuleObject evaluatedObject;


  /* ɾ¹ */
  public abstract
    ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception;
  public abstract ProrateRuleObject	copy(ProrateRuntime runtime);
  /*  */
  public abstract void	dump();

  ProrateRuleObject() {
    super();
  }

  public short	getRegist() {
    return 0;
  }
  
  public String	getName() {
    return "";
  }
  
  public void writeModel(ProrateRulebase rulebase) {
  }
  
  /*  */
  void	dumpValue() {
    if (evaluatedObject != null && evaluatedObject != this) {
      evaluatedObject.dumpValue();
    }
  }

  /* ȥ졼 */
  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    return trace.trace(this.traceStr(), sector.getSequenceNo(), level);
  }

  boolean traceValue(ProrateSector sector, ProrateTrace trace, int level) {
    if (evaluatedObject != null && evaluatedObject != this) {
      trace.trace(evaluatedObject, sector, level);
    }
    return true;
  }
  
  String	traceStr() {
    return "";
  }
  
  String	traceValueStr() {
    if (evaluatedObject != null && evaluatedObject != this) {
      return "(" + evaluatedObject.traceStr() + ")";
    }
    return "";
  }

  boolean	isEvaluated() {
    return (evaluatedObject != null);
  }

  /**
   * 
   * @uml.property name="evaluatedObject"
   */
  void setEvaluatedObject(ProrateRuleObject pobj) {
    if (isCopied) {
      pobj.isCopied = isCopied;
    }
    evaluatedObject = pobj;
  }

  
  void	setErrorObject(int error_flag, String error_string) {
    setEvaluatedObject(new ProrateRuleError(error_flag, error_string));
  }
  
  void	setErrorObject() {
    setEvaluatedObject(new ProrateRuleError());
  }

  boolean	isTrue() {
    return false;
  }

  boolean	isFalse() {
    return false;
  }

  boolean	isMultival() {
    return false;
  }

  boolean	isInterval() {
    return false;
  }

  boolean	isNumber() {
    return false;
  }

  boolean	isDate() {
    return false;
  }

  boolean	isString() {
    return false;
  }

  boolean	isAmount() {
    return false;
  }

  boolean	isPath() {
    return false;
  }

  boolean	isMultiPath() {
    return false;
  }

  boolean	unification() {
    return false;
  }

  boolean	isError() {
    return false;
  }

  boolean	equal(ProrateRuleObject other) {
    return false;
  }

  boolean	gtEq(ProrateRuleObject other) {
    return false;
  }

  boolean	ltEq(ProrateRuleObject other) {
    return false;
  }

  boolean	include(ProrateRuleObject other) {
    return false;
  }

  boolean	isIncluded(ProrateRuleObject other) {
    return false;
  }


  ProrateRuleObject	set(ProrateRuleObject value, ProrateRuntime runtime) {
    error(ProrateAudit.ERR_ILLARG, "SET:1", runtime);
    return value;
  }
  
  int	identifyFare(String fareBasis) {
    /* prepare fare-basis string for fare type checking */
    String	f_basis = fareBasis;
    int	index = fareBasis.indexOf("//");
    if (index > 0) {
      f_basis = fareBasis.substring(0, index);
    }
    
    /*	check normal fare code	*/
    if (f_basis.length() == 1) {
      return FBT_NORMAL_FARE;
    }

    /* prepare white-space-stripped string for normal fare code checking */
    StringBuffer	f_strip = new StringBuffer();
    for (int i = 0; i < f_basis.length(); i++) {
      char	c = f_basis.charAt(i);
      if (Character.isDigit(c)
	  || Character.isLowerCase(c) || Character.isUpperCase(c)) {
	f_strip.append(c);
      }
    }
    String	f_basis_strip = f_strip.toString();

    int	skip = 0;
    for (int i = 0; i < normal_code.length; i++) {
      String	code = (String)normal_code[i];
      if (f_basis_strip.length() >= code.length()
	  && f_basis_strip.substring(0, code.length()).equals(code)) {
	for (int j = 0; j < code.length(); j++) {
	  char	c = f_basis.charAt(skip);
	  while (!Character.isDigit(c)
		 && !Character.isLowerCase(c) && !Character.isUpperCase(c)) {
	    skip ++;
	    c = f_basis.charAt(skip);
	  }
	  skip ++;
	}
	break;
      }
    }
    f_basis = skip > 0 ? f_basis.substring(skip) : f_basis.substring(1);
    
    if (f_basis.equals("")) {
      return FBT_NORMAL_FARE;
    }

    boolean	special_p = false;	/* flag : special code is found ? */
    boolean	section_special_p = false;/* flag : section is special code? */
    boolean	normal_p = false;	/* flag : discount or ID,CH,IN ? */

    /*	checking tkdesignator sections (separated by white space) */
    while (f_basis.length() <= 0) {
     
      /*	skipping white space	*/
      index = 0;
      char	c = f_basis.charAt(index);
      while (!Character.isDigit(c)
	     && !Character.isLowerCase(c) && !Character.isUpperCase(c)) {

	if (index >= f_basis.length()) {
	  if (special_p) {
	    return FBT_DISCOUNT_FARE;
	  }
	  else {
	    return FBT_NORMAL_FARE;
	  }
	}
	index ++;
	c = f_basis.charAt(index);
      }
      f_basis = f_basis.substring(index);

      /*	only when the section is not normal code	*/
      for (int i = 0; i < discount_code.length; i++) {
	String	code = (String)discount_code[i];
	if (f_basis.length() >= code.length()
	    && f_basis.substring(0, code.length()).equals(code)) {
	  normal_p = true;
	  break;
	}
      }
      for (int i = 0; i < IDCHIN_code.length; i++) {
	String	code = (String)discount_code[i];
	if (f_basis.length() >= code.length()
	    && f_basis.substring(0, code.length()).equals(code)) {
	  normal_p = true;
	  break;
	}
      }

      if (!normal_p) {

	/*	check if this section is special code */
	for (int i = 0; i < special_code.length; i++) {
	  String	code = (String)special_code[i];
	  if (f_basis_strip.length() >= code.length()
	      && f_basis.substring(0, code.length()).equals(code)) {
	    section_special_p = true;
	    special_p = true;
	    break;
	  }
	}

	/*	this section is not special (nor normal) code,
		it's promotional fare	*/
	if (!section_special_p) {
	  return FBT_PROMOTIONAL_FARE;
	}
      }

      /*	set skip after this section of tkdesignator code */
      skip = -1;
      for (int i = 0; i < f_basis.length(); i++) {
	c = f_basis.charAt(i);
	if (!Character.isDigit(c)
	    && !Character.isLowerCase(c) && !Character.isUpperCase(c)) {
	  skip = i;
	  break;
	}
      }
      f_basis = skip >= 0 ? f_basis.substring(skip) : "";
    }

    return FBT_PROMOTIONAL_FARE;
  }
  
  String	getCountryName(ProrateRuntime runtime, String place) {
    String	country = runtime.getAuditImpl().getCountryName(place);
    if (country.equals("")) {
      if (runtime.getAuditImpl().database.getResult() > 1) {
	DBError(runtime, "getCountryName", place);
	return country;
      }
      errorCat(ProrateAudit.ASK_COUNTRY, place, runtime);
    }
    return country;
  }
  
  String	getAreaName(ProrateRuntime runtime, String place) {
    String	area = runtime.getAuditImpl().getAreaName(place);
    if (area.equals("")) {
      if (runtime.getAuditImpl().database.getResult() > 1) {
	DBError(runtime, "getAreaName", place);
	return area;
      }
      errorCat(ProrateAudit.ASK_AREA, place, runtime);
    }
    return area;
  }
  
  ProrateRuleObject	makeMulti(String multiStr) {
    char	MULTI_DELIMITOR = ',';
    int	bi, ei;
    ProrateRuleObject	pobj = null;
    if (multiStr.indexOf(MULTI_DELIMITOR) < 0) {
      return new ProrateRuleString(multiStr);
    }
    List	values = new Vector();
    for (bi = 0, ei = multiStr.indexOf(MULTI_DELIMITOR);
	 ei >= 0;
	 bi = ei+1, ei = multiStr.indexOf(MULTI_DELIMITOR, ei+1)) {
      pobj = new ProrateRuleString(multiStr.substring(bi, ei-bi));
      values.add(pobj);
    }
    pobj = new ProrateRuleString(multiStr.substring(bi));
    values.add(pobj);
    return new ProrateRuleMultival(values);
  }
  
  boolean	multiEq(String str1, String str2) {
    ProrateRuleObject	pobj1 = makeMulti(str1);
    ProrateRuleObject	pobj2 = makeMulti(str2);
    return pobj1.equal(pobj2);
  }

  void	error(int errorNo, ProrateRuntime runtime) {
    runtime.getAuditImpl().error(runtime.sector, errorNo);
    runtime.apply = false;
    setErrorObject(errorNo, "");
  }
  
  void	error(int errorNo, String errorStr, ProrateRuntime runtime) {
    runtime.getAuditImpl().error(runtime.sector, errorNo, errorStr);
    runtime.apply = false;
    setErrorObject(errorNo, errorStr);
  }
  
  void	errorCat(int errorNo, String errorStr, ProrateRuntime runtime) {
    if (runtime.sector.getErrorFlag() == errorNo) {
      if (runtime.sector.getErrorString().equals("")) {
	runtime.getAuditImpl().error(runtime.sector, errorNo, errorStr);
      }
      else {
	String	tmp = runtime.sector.getErrorString() + ":" + errorStr;
	runtime.getAuditImpl().error(runtime.sector, errorNo, tmp);
      }
      runtime.apply = false;
    }
    else if (runtime.sector.getErrorFlag() == 0) {	/* no error */
      error(errorNo, errorStr, runtime);
    }
  }
  
  void	DBError(ProrateRuntime runtime, String pointStr) {
    runtime.getAuditImpl().DBError(runtime.sector, pointStr);
    runtime.apply = false;
    setErrorObject(ProrateAudit.ERR_DATABASE, pointStr);
  }
  
  void	DBError(ProrateRuntime runtime, String pointStr, String arg) {
    DBError(runtime, pointStr + "(" + arg + ")");
  }

  void	DBError(ProrateRuntime runtime, String pointStr,
		String arg, String arg2) {
    DBError(runtime, pointStr + "(" + arg + "," + arg2 + ")");
  }

  public String	getComment() {
    return "";
  }
  public void	setComment(String comment) {
  }
  
  public String	getStringValue() {
    return super.toString();
  }

}

class ProrateRuleError extends ProrateRuleObject {
  int		errorFlag;	/* 顼 */
  String	errorString;	/* 顼ʸ */

  public ProrateRuleError() {
    super();
    errorFlag = 0;
    errorString = "";
  }

  public ProrateRuleError(int error_flag, String error_string) {
    super();
    errorFlag = error_flag;
    errorString = error_string;
  }

  /* ɾ¹ */
  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    runtime.apply = false;
    setEvaluatedObject(this);
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleError();
    pobj.isCopied = true;
    return pobj;
  }

  /*  */
  public void	dump() {
    System.out.print("ERROR(" + errorFlag + " " + errorString + ")");
  }

  /* ȥ졼 */
  String	traceStr() {
    return "ERROR(" + errorFlag + " " + errorString + ")";
  }
  
  boolean	isError() {
    return true;
  }

}

class ProrateRuleEnd extends ProrateRuleObject {
  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    runtime.apply = false;
    setEvaluatedObject(new ProrateRuleBool(true));
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleEnd();
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print("END");
  }

  String	traceStr() {
    return "END";
  }
}

class ProrateRulePart extends ProrateRuleObject {
  protected String	name;	/* ɥѡȤ̾ */
  protected List	rules;	/* ɾ롼륪֥ȷ */

  public ProrateRulePart() {
    super();
    rules = new Vector();
  }

  public ProrateRulePart(String name, List in_rules) {
    super();
    this.name = name;
    rules = in_rules;
  }

  /* ɾ¹ */
  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    @SuppressWarnings("unused") ProrateRuleObject	ret = null;
    for (int i = 0; i < rules.size(); i++) {
      rules.set(i, ((ProrateRuleObject)rules.get(i)).copy(runtime));
      ret = ((ProrateRuleObject)rules.get(i)).eval(runtime);
      if (!runtime.apply) {
	break;
      }
    }
    setEvaluatedObject(this);
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRulePart();
    ((ProrateRulePart)pobj).name = this.name;
    ((ProrateRulePart)pobj).rules = new Vector(this.rules);
    pobj.isCopied = true;
    return pobj; 
  }

  /* 롼١ */
  public void	dump() {
    System.out.println("PART(" + name + ")");
    for (int i = 0; i < rules.size(); i++) {
      ((ProrateRuleObject)rules.get(i)).dump();
    }
  }

  /* ȥ졼 */
  public boolean
    trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer("PART");
    traceStr.append("(");
    traceStr.append(name);
    traceStr.append(")");
    if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
      return false;
    }
    for (int i = 0; i < rules.size(); i++) {
      if (!trace.trace((ProrateRuleObject)rules.get(i), sector, level+1)) {
	return false;
      }
    }
    return true;
  }

}

class ProrateRuleTest extends ProrateRuleObject {
  protected List	tests;
  protected List	thens;
  protected List	elses;

  ProrateRuleTest(List test, List then_s, List else_s) {
    super();
    tests = test;
    thens = then_s;
    elses = else_s;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    ProrateRuleObject ret = null;
    boolean	forUnification = false;
    runtime.status = true;
    runtime.hops = 2;
    for (int i = 0; i < tests.size(); i++) {
      if (((ProrateRuleObject)tests.get(i)).unification()) {
	forUnification = true;
	break;
      }
    }
    if (forUnification) {
      ret = unify(runtime);
    }
    else {
      for (int i = 0; i < tests.size(); i++) {
	ProrateRuleObject pobj = (ProrateRuleObject)tests.get(i);
	tests.set(i, pobj.copy(runtime));
	ret = ((ProrateRuleObject)tests.get(i)).eval(runtime);
	if (!runtime.apply) {
	  if (ret == null) {
	    setErrorObject();
	  }
	  else {
	    setEvaluatedObject(ret);
	  }
	  return ret;
	}
	if (ret.isFalse()) {
	  runtime.status = false;
	}
      }
    }
    if (!runtime.apply) {
      if (ret == null) {
	setErrorObject();
      }
      else {
	setEvaluatedObject(ret);
      }
      return ret;
    }
    setEvaluatedObject(ret);
    if (ret.isTrue()) {
      for (int i = 0; i < thens.size(); i++) {
	ProrateRuleObject pobj = (ProrateRuleObject)thens.get(i);
	thens.set(i, pobj.copy(runtime));
	ret = ((ProrateRuleObject)thens.get(i)).eval(runtime);
	if (!runtime.apply) {
	  return ret;
	}
      }
    }
    else {
      for (int i = 0; i < elses.size(); i++) {
	ProrateRuleObject pobj = (ProrateRuleObject)elses.get(i);
	elses.set(i, pobj.copy(runtime));
	ret = ((ProrateRuleObject)elses.get(i)).eval(runtime);
	if (!runtime.apply) {
	  return ret;
	}
      }
    }
    
    runtime.hops = 2;
    return ret;
  }
  
  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleTest(new Vector(this.tests),
						   new Vector(this.thens),
						   new Vector(this.elses));
    pobj.isCopied = true;
    return pobj;
  }

  ProrateRuleObject	unify(ProrateRuntime runtime) throws Exception {
    ProrateRuleObject ret = null;
    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      runtime.unifiedSector = (ProrateSector)runtime.fcomp.getSectors()[i];
      runtime.status = true;
      runtime.hops = 2;
      for (int j = 0; j < tests.size(); j++) {
	ProrateRuleObject pobj = (ProrateRuleObject)tests.get(j);
	tests.set(j, pobj.copy(runtime));
	ret = ((ProrateRuleObject)tests.get(j)).eval(runtime);
	if (!runtime.apply) {
	  if (ret == null) {
	    setErrorObject();
	  }
	  else {
	    setEvaluatedObject(ret);
	  }
	  return ret;
	}
	if (ret.isFalse()) {
	  runtime.status = false;
	}
      }
      if (ret.isTrue()) {
	return ret;
      }
    }
    return ret;
  }

  public void	dump() {
    System.out.print("TEST[");
    for (int i = 0; i < tests.size(); i++) {
      ((ProrateRuleObject)tests.get(i)).dump();
    }
    System.out.println("]");
    if (thens.size() > 0) {
      System.out.print("THEN[");
      for (int i = 0; i < thens.size(); i++) {
	((ProrateRuleObject)thens.get(i)).dump();
      }
      System.out.println("]");
    }
    if (elses.size() > 0) {
      System.out.print("ELSE[");
      for (int i = 0; i < elses.size(); i++) {
	((ProrateRuleObject)elses.get(i)).dump();
      }
      System.out.println("]");
    }
  }

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer("TEST");
    traceStr.append(traceValueStr());
    traceStr.append("(");
    for (int i = 0; i < tests.size(); i++) {
      if (i > 0) {
	traceStr.append(" ");
      }
      ProrateRuleObject	pobj = (ProrateRuleObject)tests.get(i);
      if (pobj.isEvaluated()) {
	traceStr.append(pobj.traceStr());
	if (traceStr.charAt(traceStr.length()-1) == '(') {
	  traceStr.append(")");
	}
      }
    }
    traceStr.append(")");
    if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
      return false;
    }
    for (int j = 0; j < tests.size(); j++) {
      trace.trace((ProrateRuleObject)tests.get(j), sector, level+1);
    }
    if (evaluatedObject.isTrue() && thens.size() > 0) {
      traceStr = new StringBuffer("THEN");
      traceStr.append("(");
      for (int i = 0; i < thens.size(); i++) {
	if (i > 0) {
	  traceStr.append(" ");
	}
	traceStr.append(((ProrateRuleObject)thens.get(i)).traceStr());
	if (traceStr.charAt(traceStr.length()-1) == '(') {
	  traceStr.append(")");
	}
      }
      if (traceStr.toString().equals("THEN()")) {
	traceStr = new StringBuffer("THEN");
      }
      else {
	traceStr.append(")");
      }
      if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
	return false;
      }
      for (int j = 0; j < thens.size(); j++) {
	trace.trace((ProrateRuleObject)thens.get(j), sector, level+1);
      }
    }
    if (evaluatedObject.isFalse() && elses.size() > 0) {
      traceStr = new StringBuffer("ELSE");
      traceStr.append("(");
      for (int i = 0; i < elses.size(); i++) {
	if (i > 0) {
	  traceStr.append(" ");
	}
	traceStr.append(((ProrateRuleObject)elses.get(i)).traceStr());
	if (traceStr.charAt(traceStr.length()-1) == '(') {
	  traceStr.append(")");
	}
      }
      if (traceStr.toString().equals("ELSE()")) {
	traceStr = new StringBuffer("ELSE");
      }
      else {
	traceStr.append(")");
      }
      if (!trace.trace(traceStr.toString(), sector.getSequenceNo(), level)) {
	return false;
      }
      for (int j = 0; j < elses.size(); j++) {
	trace.trace((ProrateRuleObject)elses.get(j), sector, level+1);
      }
    }
    return true;
  }
}

abstract class ProrateRuleAO extends ProrateRuleObject {
  protected List	statements;

  ProrateRuleAO(List statements) {
    super();
    this.statements = statements;
  }

  public ProrateRuleObject evalAO(ProrateRuntime runtime, boolean status) throws Exception {
    ProrateRuleObject	ret = null;
    runtime.status = status;
    if (runtime.status == status) {
      for (int i = 0; i < statements.size(); i++) {
	ProrateRuleObject pobj = (ProrateRuleObject)statements.get(i);
	statements.set(i, pobj.copy(runtime));
	ret = ((ProrateRuleObject)statements.get(i)).eval(runtime);
	if (!runtime.apply) {
	  setEvaluatedObject(new ProrateRuleBool(false));
	  return ret;
	}
	if (ret.isFalse()) {
	  runtime.status = false;
	}
	else {
	  runtime.status = true;
	}
	if (runtime.status != status) {
	  break;
	}
      }
    }
    ret = new ProrateRuleBool(ret != null ? ret.isTrue() : runtime.status);
    setEvaluatedObject(ret);

    return ret;
  }

  public void	dump() {
    for (int i = 0; i < statements.size(); i++) {
      ((ProrateRuleObject)statements.get(i)).dump();
    }
  }
  
  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    if (!traceStatements()) {
      return false;
    }
    String	traceStr = this.traceAO();
    if (!trace.trace(traceStr, sector.getSequenceNo(), level)) {
      return false;
    }
    for (int i = 0; i < statements.size(); i++) {
      trace.trace((ProrateRuleObject)statements.get(i), sector, level+1);
    }
    return true;
  }
  
  String	traceAO() {
    StringBuffer	traceStr = new StringBuffer("");
    traceStr.append(traceValueStr());
    if (traceStatements()) {
      traceStr.append("[");
      for (int i = 0; i < statements.size(); i++) {
	if (i > 0) {
	  traceStr.append(" ");
	}
	traceStr.append(((ProrateRuleObject)statements.get(i)).traceStr());
	if (traceStr.charAt(traceStr.length()-1) == '(') {
	  traceStr.append(")");
	}
      }
      traceStr.append("]");
    }
    return traceStr.toString();
  }
  
  boolean	traceStatements() {
    return (evaluatedObject != null);
  }
  
  boolean	unification() {
    for (int i = 0; i < statements.size(); i++) {
      if (((ProrateRuleObject)statements.get(i)).unification()) {
	return true;
      }
    }
    return false;
  }

}

class ProrateRuleAnd extends ProrateRuleAO {

  ProrateRuleAnd(List statements) {
    super(statements);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    return evalAO(runtime, true);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleAnd(new Vector(this.statements));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.println("AND(");
    super.dump();
    System.out.println(")");
    this.dumpValue();
  }
  
  String	traceStr() {
    return	"AND" + traceAO();
  }
}

class ProrateRuleOr extends ProrateRuleAO {

  ProrateRuleOr(List statements) {
    super(statements);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    return evalAO(runtime, false);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleOr(new Vector(this.statements));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.println("OR(");
    super.dump();
    System.out.println(")");
    this.dumpValue();
  }

  String	traceStr() {
    return	"OR" + traceAO();
  }
}

class ProrateRuleCase extends ProrateRuleObject {
  protected List	args;
  protected List	branches;
  protected List	argsEvaluated;

  ProrateRuleCase(List in_args, List in_branches) {
    super();
    args = in_args;
    branches = in_branches;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    ProrateRuleObject	ret = null;
    argsEvaluated = new Vector();
    for (int i = 0; i < args.size(); i++) {
      if (((ProrateRuleObject)args.get(i)).unification()) {
	ret = ((ProrateRuleObject)args.get(i));
      }
      else {
	ProrateRuleObject pobj = (ProrateRuleObject)args.get(i);
	args.set(i, pobj.copy(runtime));
	ret = ((ProrateRuleObject)args.get(i)).eval(runtime);
      }
      argsEvaluated.add(ret);
      if (!runtime.apply) {
	setEvaluatedObject(new ProrateRuleBool(false));
	return ret;
      }
    }
    for (int j = 0; j < branches.size(); j++) {
      ProrateRuleObject pobj = (ProrateRuleObject)branches.get(j);
      branches.set(j, pobj.copy(runtime));
      ret = ((ProrateRuleCaseAct)branches.get(j)).eval(runtime, this);
      if (!runtime.apply) {
	setEvaluatedObject(new ProrateRuleBool(false));
	break;
      }
      if (!ret.isFalse()) {
	setEvaluatedObject(new ProrateRuleBool(true));
	break;
      }
    }
    if (evaluatedObject == null) {
      setEvaluatedObject(new ProrateRuleBool(false));
    }
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleCase(new Vector(this.args),
						   new Vector(this.branches));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print("CASE(");
    for (int i = 0; i < args.size(); i++) {
      ((ProrateRuleObject)args.get(i)).dump();
    }
    System.out.println(")");
    System.out.print("(");
    for (int i = 0; i < branches.size(); i++) {
      ((ProrateRuleObject)branches.get(i)).dump();
    }
    System.out.println(")");
  }

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer("CASE(");
    for (int i = 0; i < args.size(); i++) {
      if (i > 0) {
	traceStr.append(" ");
      }
      ProrateRuleObject	pobj = (ProrateRuleObject)args.get(i);
      if (pobj.isEvaluated()) {
	traceStr.append(pobj.traceStr());
	if (traceStr.charAt(traceStr.length()-1) == '(') {
	  traceStr.append(")");
	}
      }
    }
    traceStr.append(")");
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
    for (int j = 0; j < args.size(); j++) {
      trace.trace((ProrateRuleObject)args.get(j), sector, level+1);
    }
    for (int k = 0; k < branches.size(); k++) {
      trace.trace((ProrateRuleObject)branches.get(k), sector, level+1);
    }
    return true;
  }

  ProrateRuleObject	evalArg(int index, ProrateRuntime runtime)
    throws Exception {
    ProrateRuleObject pobj = (ProrateRuleObject)args.get(index);
    args.set(index, pobj.copy(runtime));
    ProrateRuleObject
      ret = ((ProrateRuleObject)args.get(index)).eval(runtime);
    return ret;
  }

  ProrateRuleObject	getArgEvaluated(int index) {
    return ((ProrateRuleObject)argsEvaluated.get(index));
  }

  boolean	unification() {
    for (int i = 0; i < args.size(); i++) {
      if (((ProrateRuleObject)args.get(i)).unification()) {
	return true;
      }
    }
    return false;
  }
}

class ProrateRuleCaseAct extends ProrateRuleObject {
  protected List	branches;
  protected List	actions;

  ProrateRuleCaseAct(List in_branches, List in_actions) {
    super();
    branches = in_branches;
    actions = in_actions;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    return this;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime,
				     ProrateRuleCase ocase) throws Exception {
    ProrateRuleObject	ret = null;
    runtime.hops = 2;
    for (int i = 0; i < branches.size(); i++) {
      ProrateRuleObject	pobj = (ProrateRuleObject)branches.get(i);
      branches.set(i, pobj.copy(runtime));
      ret = ((ProrateRuleCaseBranch)branches.get(i)).eval(runtime, ocase);
      if (ret == null) {
	setErrorObject();
	return null;
      }
      if (!runtime.apply) {
	break;
      }
      if (ret.isTrue()) {
	break;
      }
    }
    if (!runtime.apply) {
      setEvaluatedObject(new ProrateRuleBool(false));
      return ret;
    }
    if (ret.isFalse()) {
      setEvaluatedObject(new ProrateRuleBool(ret.isTrue()));
      return ret;
    }
    for (int j = 0; j < actions.size(); j++) {
      ProrateRuleObject pobj = (ProrateRuleObject)actions.get(j);
      actions.set(j, pobj.copy(runtime));
      ret = ((ProrateRuleObject)actions.get(j)).eval(runtime);
      if (!runtime.apply) {
	break;
      }
    }
    runtime.hops = 2;
    setEvaluatedObject(new ProrateRuleBool(true));
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject
      pobj = new ProrateRuleCaseAct(new Vector(this.branches),
				    new Vector(this.actions));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print("(");
    for (int i = 0; i < branches.size(); i++) {
      ((ProrateRuleObject)branches.get(i)).dump();
    }
    for (int i = 0; i < actions.size(); i++) {
      ((ProrateRuleObject)actions.get(i)).dump();
    }
    System.out.println(")");
  }

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    for (int i = 0; i < branches.size(); i++) {
      trace.trace((ProrateRuleObject)branches.get(i), sector, level+1);
    }
    if (evaluatedObject.isFalse()) {
      return false;
    }
    for (int j = 0; j < actions.size(); j++) {
      trace.trace((ProrateRuleObject)actions.get(j), sector, level+1);
    }
    return true;
  }
}

class ProrateRuleCaseBranch extends ProrateRuleObject {
  protected List	values;

  ProrateRuleCaseBranch(List in_values) {
    super();
    values = in_values;
  }

  /*NeverCalled*/
  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    return this;
  }

  ProrateRuleObject	eval(ProrateRuntime runtime, ProrateRuleCase ocase) throws Exception {
    ProrateRuleObject	ret = null;
    boolean	forUnification = false;
    boolean	status = true;
    if (ocase.unification()) {
      forUnification = true;
    }
    for (int i = 0; i < values.size(); i++) {
      if (((ProrateRuleObject)values.get(i)).unification()) {
	forUnification = true;
	break;
      }
    }
    if (forUnification) {
      ret = unify(runtime, ocase);
    }
    else {
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject	pobj = (ProrateRuleObject)values.get(i);
	values.set(i, pobj.copy(runtime));
	ProrateRuleObject
	  car = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (car == null) {
	  setErrorObject();
	  return null;
	}
	ProrateRuleObject	cdr = ocase.getArgEvaluated(i);
	if (cdr == null) {
	  setErrorObject();
	  return null;
	}
	if (car.isMultiPath()) {
	  car = ((ProrateVarMultiPath)car).makePath(runtime, cdr);
	}
	else if (cdr.isMultiPath()) {
	  cdr = ((ProrateVarMultiPath)cdr).makePath(runtime, car);
	}
	if ((status = car.equal(cdr))) {
	  break;
	}
      }
      ret = new ProrateRuleBool(status);
      setEvaluatedObject(ret);
    }
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject
      pobj = new ProrateRuleCaseBranch(new Vector(this.values));
    pobj.isCopied = true;
    return pobj;
  }

  ProrateRuleObject	unify(ProrateRuntime runtime, ProrateRuleCase ocase) throws Exception {
    ProrateRuleObject	ret = null;
    boolean	status = true;
    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      runtime.unifiedSector = (ProrateSector)runtime.fcomp.getSectors()[i];
      for (int j = 0; j < values.size(); j++) {
	ProrateRuleObject	pobj = (ProrateRuleObject)values.get(j);
	values.set(j, pobj.copy(runtime));
	ret = ((ProrateRuleObject)values.get(j)).eval(runtime);
	if (ret == null) {
	  setErrorObject();
	  return null;
	}
	if (!(status = ret.equal(ocase.evalArg(j, runtime)))) {
	  break;
	}
      }
      if (status) {
	break;
      }
    }
    ret = new ProrateRuleBool(status);
    setEvaluatedObject(ret);
    return ret;
  }

  public void	dump() {
    System.out.print("CASE_BRANCH(");
    for (int i = 0; i < values.size(); i++) {
      ((ProrateRuleObject)values.get(i)).dump();
      System.out.print(" ");
    }
    System.out.println(")");
  }

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer();
    for (int i = 0; i < values.size(); i++) {
      if (i > 0) {
	traceStr.append("@");
      }
      ProrateRuleObject	pobj = (ProrateRuleObject)values.get(i);
      traceStr.append(pobj.traceStr());
      if (traceStr.charAt(traceStr.length()-1) == '(') {
	traceStr.append(")");
      }
    }
    traceStr.append(":");
    traceStr.append(evaluatedObject.isTrue() ? "(true)" : "(false)");
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
    for (int j = 0; j < values.size(); j++) {
      trace.trace((ProrateRuleObject)values.get(j), sector, level+1);
    }
    return true;
  }
}

class ProrateRuleTable extends ProrateRuleObject {
  int	rowIndex;
  int	colIndex;

  /**
   * 
   * @uml.property name="varrow"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject varrow;

  /**
   * 
   * @uml.property name="varrowObj"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject varrowObj;

  /**
   * 
   * @uml.property name="varcol"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject varcol;

  /**
   * 
   * @uml.property name="varcolObj"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject varcolObj;

  protected List	rows;
  protected List	cols;
  protected List	tbls;

  public ProrateRuleTable(ProrateRuleObject prows,
			  ProrateRuleObject pcols,
			  List rows, List cols, List tbls) {
    super();
    rowIndex = -1;
    colIndex = -1;
    varrow = null;
    varrowObj = prows;
    varcol = null;
    varcolObj = pcols;
    this.rows = rows;
    this.cols = cols;
    this.tbls = tbls;
  }

  public ProrateRuleTable(ProrateRuleObject pcols,
			  List cols, List tbls) {
    super();
    rowIndex = -1;
    colIndex = -1;
    varrow = null;
    varrowObj = null;
    varcol = null;
    varcolObj = pcols;
    this.rows = null;
    this.cols = cols;
    this.tbls = tbls;
  }

  public ProrateRuleTable(ProrateRulebaseElement prows,
			  ProrateRulebaseElement pcols,
			  List rows, List cols, List tbls) {
    super();
    rowIndex = -1;
    colIndex = -1;
    varrow = null;
    varrowObj = (ProrateRuleObject)prows;
    varcol = null;
    varcolObj = (ProrateRuleObject)pcols;
    this.rows = rows;
    this.cols = cols;
    this.tbls = tbls;
  }

  public ProrateRuleTable(ProrateRulebaseElement pcols,
			  List cols, List tbls) {
    super();
    rowIndex = -1;
    colIndex = -1;
    varrow = null;
    varrowObj = null;
    varcol = null;
    varcolObj = (ProrateRuleObject)pcols;
    this.rows = null;
    this.cols = cols;
    this.tbls = tbls;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    ProrateRuleObject	ret = null;
    int	i, j;

    setEvaluatedObject(new ProrateRuleBool(true));
    if (varrowObj != null && rows != null) {
      varrowObj = varrowObj.copy(runtime);
      varrow = varrowObj.eval(runtime);
      if (varrow == null) {
	setErrorObject();
	return null;
      }
      for (i = 0; i < rows.size(); i++) {
	ProrateRuleObject pobj = (ProrateRuleObject)rows.get(i);
	rows.set(i, pobj.copy(runtime));
	ret = ((ProrateRuleObject)rows.get(i)).eval(runtime);
	if (ret == null) {
	  setErrorObject();
	  return null;
	}
	if (ret.equal(varrow)) {
	  rowIndex = i;
	  break;
	}
      }
      if (i >= rows.size()) {	/* no match */
	ret = new ProrateRuleBool(false);
	setEvaluatedObject(ret);
	rowIndex = -1;
	return ret;
      }
    }
    else {
      i = 0;
      rowIndex = i;
    }
    varcolObj = varcolObj.copy(runtime);
    varcol = varcolObj.eval(runtime);
    if (varcol == null) {
      setErrorObject();
      return null;
    }
    for (j = 0; j < cols.size(); j++) {
      cols.set(j, ((ProrateRuleObject)cols.get(j)).copy(runtime));
      ret = ((ProrateRuleObject)cols.get(j)).eval(runtime);
      if (ret == null) {
	setErrorObject();
	return null;
      }
      if (ret.equal(varcol)) {
	colIndex = j;
	break;
      }
    }
    if (j >= cols.size()) {	/* no match */
      ret = new ProrateRuleBool(false);
      setEvaluatedObject(ret);
      colIndex = -1;
      return ret;
    }
    int	tblIndex = i * cols.size() + j;
    ProrateRuleObject pobj = (ProrateRuleObject)tbls.get(tblIndex);
    tbls.set(tblIndex, pobj.copy(runtime));
    ret = ((ProrateRuleObject)tbls.get(tblIndex)).eval(runtime);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject
      pobj = new ProrateRuleTable((this.varrowObj != null ?
				   this.varrowObj.copy(runtime) : null),
				  this.varcolObj.copy(runtime),
				  (this.rows != null ?
				   new Vector(this.rows) : null),
				  new Vector(this.cols),
				  new Vector(this.tbls));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.println("");
    System.out.print("TABLE((");
    if (varrowObj != null) {
      varrowObj.dump();
      System.out.print(",");
    }
    varcolObj.dump();
    System.out.println(")");
    if (rows != null) {
      System.out.print("[");
      for (int i = 0; i < rows.size(); i++) {
	((ProrateRuleObject)rows.get(i)).dump();
	System.out.print(" ");
      }
      System.out.print("]");
    }
    if (cols != null) {
      System.out.print("[");
      for (int i = 0; i < cols.size(); i++) {
	((ProrateRuleObject)cols.get(i)).dump();
	System.out.print(" ");
      }
      System.out.print("]");
    }
    if (tbls != null) {
      System.out.print("[");
      for (int i = 0; i < tbls.size(); i++) {
	((ProrateRuleObject)tbls.get(i)).dump();
	System.out.print(" ");
      }
      System.out.print("]");
    }
    System.out.println(")");
  }

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }

    StringBuffer	traceStr = new StringBuffer("TABLE(");
    if (varrowObj != null) {
      traceStr.append(varrowObj.traceStr());
      if (traceStr.charAt(traceStr.length()-1) == '(') {
	traceStr.append(")");
      }
      traceStr.append(" ");
    }
    traceStr.append(varcolObj.traceStr());
    if (traceStr.charAt(traceStr.length()-1) == '(') {
      traceStr.append(")");
    }
    traceStr.append(")");
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
    if (varrowObj != null) {
      trace.trace(varrowObj, sector, level+1);
    }
    trace.trace(varcolObj, sector, level+1);

    if (rows != null && rows.size() > 0) {
      traceStr = new StringBuffer("[");
      for (int i = 0; i < rows.size(); i++) {
	if (i > 0) {
	  traceStr.append(" ");
	}
	ProrateRuleObject	pobj = (ProrateRuleObject)rows.get(i);
	if (pobj.isEvaluated()) {
	  traceStr.append(pobj.traceStr());
	  if (traceStr.charAt(traceStr.length()-1) == '(') {
	    traceStr.append(")");
	  }
	  if (i == rowIndex) {
	    traceStr.append(" ..");
	    break;
	  }
	}
      }
      traceStr.append("]");
      trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
    }

    traceStr = new StringBuffer("[");
    for (int i = 0; i < cols.size(); i++) {
      if (i > 0) {
	traceStr.append(" ");
      }
      ProrateRuleObject	pobj = (ProrateRuleObject)cols.get(i);
      if (pobj.isEvaluated()) {
	traceStr.append(pobj.traceStr());
	if (traceStr.charAt(traceStr.length()-1) == '(') {
	  traceStr.append(")");
	}
	if (colIndex == i) {
	  traceStr.append(" ..");
	  break;
	}
      }
    }
    traceStr.append("]");
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);

    if (colIndex >= 0) {
      traceStr = new StringBuffer("[at (");
      if (rowIndex >= 0) {
	traceStr.append(rowIndex);
	traceStr.append(",");
      }
      traceStr.append(colIndex);
      traceStr.append(") : ");
      ProrateRuleObject
	pobj =	(ProrateRuleObject)tbls.get(rowIndex >= 0 ?
					    rowIndex * cols.size() + colIndex :
					    colIndex);
      traceStr.append(pobj.traceStr());
      if (traceStr.charAt(traceStr.length()-1) == '(') {
	traceStr.append(")");
      }
      traceStr.append("]");
      trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
      for (int i = 0; i < tbls.size(); i++) {
	trace.trace((ProrateRuleObject)tbls.get(i), sector, level+1);
      }
    }
    return true;
  }

}

class ProrateRuleAmount extends ProrateRuleObject {
  /**
   * @uml.property  name="currency"
   */
  protected String	currency;
  /**
   * @uml.property  name="value"
   */
  protected double	value;

  ProrateRuleAmount(String in_currency, double in_value) {
    super();
    currency = in_currency;
    value = in_value;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    evaluatedObject = this;
    if (runtime.hops > 2) {
      if (!setMultiPath(runtime.hops-1, runtime)) {
	error(ProrateAudit.ERR_MULTI, "AMOUNT", runtime);
      }
      return this;
    }

    /* ۤ5Day Rate */
    double	day5Rate = (runtime.isSPA ?
			    runtime.sector.getSpaDay5Rate()
			    : runtime.sector.getApdpDay5Rate());
    if (day5Rate <= (double)0) {
      ProrateDatabase	db = runtime.getAuditImpl().database;
      day5Rate = db.getMeanRate(currency, runtime.audit.getInvoiceMonth());
      if (day5Rate <= (double)0) {
	day5Rate = db.get5dayRate(currency, runtime.audit.getInvoiceMonth());
	/* ;;; error check for day5Rate < 0 (not found) */
	if (day5Rate < (double)0) {
	  if (runtime.audit.getDay5Rate() <= (double)0) {
	    if (db.getResult() > 1) {
	      DBError(runtime, "get5dayRate", currency,
		      runtime.audit.getInvoiceMonth());
	      return this;
	    }
	    int	errorNo = (runtime.isSPA ? ProrateAudit.ASK_5DAYSPA
			   : ProrateAudit.ASK_5DAYAPDP);
	    String	errorMessage = currency;
	    error(errorNo,
		  errorMessage + ":" + runtime.audit.getInvoiceMonth(),
		  runtime);
	    return this;
	  }
	  day5Rate = runtime.audit.getDay5Rate();
	}
      }
    }

    if (runtime.isSPA) {
      runtime.sector.setSpaBaseAmtType(currency);
      runtime.sector.setSpaBaseAmt(value);
      runtime.sector.setSpaNuc(runtime.sector.getSpaDiscountRate()
			       * value / day5Rate);
      runtime.sector
	.setProrationType((runtime.sector.getProrationType()
			   & (ProrateAudit.PRT_APDPSET
			      | ProrateAudit.PRT_SPASET))
			  | ProrateAudit.PRT_SPA | ProrateAudit.PRT_FIX);
    }
    else {
      runtime.sector.setApdpBaseAmtType(currency);
      runtime.sector.setApdpBaseAmt(value);
      runtime.sector.setApdpNuc(runtime.sector.getApdpDiscountRate()
				* value / day5Rate);
      if ((runtime.sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	runtime.sector.setProrationType(runtime.sector.getProrationType()
					| ProrateAudit.PRT_PRVS);
      }
      else {
	runtime.sector
	  .setProrationType(ProrateAudit.PRT_APDP
			    | ProrateAudit.PRT_FIX | ProrateAudit.PRT_PRVS);
      }
    }
	  
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleAmount(currency, value);
    pobj.isCopied = true;
    return pobj;
  }

  boolean	isAmount() {
    return true;
  }

  boolean	setMultiPath(int hops, ProrateRuntime runtime) {
    if (runtime.sectorIndex + hops > runtime.fcomp.getSectors().length) {
      return false;
    }
    double
      totalProrateFactor = runtime.sector.getProrateFactor();
    for (int i = runtime.sectorIndex+1; i < runtime.sectorIndex+hops; i++) {
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      if (!runtime.sector.getCarrier().equals(sector.getCarrier())
	  || !runtime.sector.getFareBasis().equals(sector.getFareBasis())
	  || !runtime.sector.getClassOfService().equals(sector
							.getClassOfService())
	  ) {
	return false;
      }
      totalProrateFactor +=
	((ProrateSector)runtime.fcomp.getSectors()[i]).getProrateFactor();
    }
    /* ۤ5Day Rate */
    double	day5Rate = (runtime.isSPA ?
			    runtime.sector.getSpaDay5Rate()
			    : runtime.sector.getApdpDay5Rate());
    if (day5Rate <= (double)0) {
      ProrateDatabase	db = runtime.getAuditImpl().database;
      day5Rate = db.getMeanRate(currency, runtime.audit.getInvoiceMonth());
      if (day5Rate <= (double)0) {
	day5Rate = db.get5dayRate(currency, runtime.audit.getInvoiceMonth());
	/* ;;; error check for day5Rate < 0 (not found) */
	if (day5Rate < (double)0) {
	  if (runtime.audit.getDay5Rate() <= (double)0) {
	    if (db.getResult() > 1) {
	      DBError(runtime, "get5dayRate", currency,
		      runtime.audit.getInvoiceMonth());
	      return false;
	    }
	    int	errorNo = (runtime.isSPA ?
			   ProrateAudit.ASK_5DAYSPA
			   : ProrateAudit.ASK_5DAYAPDP);
	    String	errorMessage = currency;
	    error(errorNo,
		  errorMessage + ":" + runtime.audit.getInvoiceMonth(),
		  runtime);
	    return false;
	  }
	  day5Rate = runtime.audit.getDay5Rate();
	}
      }
    }

    for (int j = runtime.sectorIndex; j < runtime.sectorIndex+hops; j++) {
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[j];
      if (runtime.isSPA) {
	sector.setSpaBaseAmtType(currency);
	sector.setSpaBaseAmt(value);
	sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate());
	sector.setSpaNuc(sector.getSpaDiscountRate() * value
			 * sector.getProrateFactor()
			 / totalProrateFactor / day5Rate);
	sector.setProrationType(((sector.getProrationType() &
				  (ProrateAudit.PRT_APDPSET
				   | ProrateAudit.PRT_SPASET))
				 | ProrateAudit.PRT_SPA | ProrateAudit.PRT_FIX
				 | ProrateAudit.PRT_MULSPA));
      }
      else {
	sector.setApdpBaseAmtType(currency);
	sector.setApdpBaseAmt(value);
	sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate());
	sector.setApdpNuc(sector.getApdpDiscountRate() * value
			  * sector.getProrateFactor()
			  / totalProrateFactor / day5Rate);
	if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	  sector.setProrationType(sector.getProrationType()
				  | ProrateAudit.PRT_PRVS);
	}
	else {
	  sector.setProrationType((ProrateAudit.PRT_APDP | ProrateAudit.PRT_FIX
				   | ProrateAudit.PRT_PRVS
				   | ProrateAudit.PRT_MULAPDP));
	}
      }
    }
    return true;
  }

  /**
   * 
   * @uml.property name="currency"
   */
  String getCurrency() {
    return currency;
  }

  /**
   * 
   * @uml.property name="value"
   */
  double getValue() {
    return value;
  }

  public void	dump() {
    System.out.print("AMOUNT(" + currency + " " + value + ")");
  }

  public String	toString() {
    StringBuffer	strbuf = new StringBuffer("AMOUNT(");
    strbuf.append(currency);
    strbuf.append(" ");
    strbuf.append(value);
    strbuf.append(")");
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateRulePercent extends ProrateRuleObject {
  protected double	percent;

  /**
   * 
   * @uml.property name="amount"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject amount;

  ProrateRulePercent(double in_percent, ProrateRuleObject obj) {
    percent = in_percent;
    amount = obj;
  }

  ProrateRulePercent(double in_percent, ProrateRulebaseElement obj) {
    super();
    percent = in_percent;
    amount = (ProrateRuleObject)obj;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    evaluatedObject = this;
    if (runtime.isSPA) {
      runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate()
					* percent / (double)100);
    }
    else {
      runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate()
					 * percent / (double)100);
    }
    amount = amount.copy(runtime);
    return amount.eval(runtime);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRulePercent(percent,
						      amount.copy(runtime));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print(percent + "%of ");
    amount.dump();
  }

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    trace.trace(this.traceStr(), sector.getSequenceNo(), level);
    trace.trace(amount, sector, level+1);
    return true;
  }

  public String	toString() {
    StringBuffer	strbuf = new StringBuffer();
    strbuf.append(percent);
    strbuf.append("%of ");
    strbuf.append(amount.toString());
    if (strbuf.charAt(strbuf.length()-1) == '(') {
      strbuf.append(")");
    }
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateRuleReturn extends ProrateRuleObject {

  /**
   * 
   * @uml.property name="value"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject value;

  ProrateRuleReturn(ProrateRuleObject obj) {
    super();
    value = obj;
  }

  ProrateRuleReturn(ProrateRulebaseElement obj) {
    super();
    value = (ProrateRuleObject)obj;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    value = value.copy(runtime);
    setEvaluatedObject(value.eval(runtime));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleReturn(value.copy(runtime));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print("RETURN(");
    value.dump();
    System.out.println(")");
  }

  public String	toString() {
    StringBuffer	strbuf = new StringBuffer("RETURN(");
    strbuf.append(value.toString());
    strbuf.append(")");
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateRuleBool extends ProrateRuleObject {
  protected boolean	value;

  ProrateRuleBool(boolean bool) {
    super();
    value = bool;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    evaluatedObject = this;
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleBool(value);
    pobj.isCopied = true;
    return pobj;
  }

  boolean	isTrue() {
    return value;
  }

  boolean	isFalse() {
    return !value;
  }

  public void	dump() {
    System.out.print(value);
  }

  public String	toString() {
    return (value ? "true" : "false");
  }

  String	traceStr() {
    return toString();
  }
}

/* ;;; not implemented yet */
class ProrateRulePartcall extends ProrateRuleObject {
  protected String	name;

  ProrateRulePartcall(String partname) {
    super();
    name = partname;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    try {
      if (!runtime.getAuditImpl().rulebase.selectPART(name)) {
	String	str = name + " : undefined PART";
	error(ProrateAudit.ERR_ERROR, str, runtime);
	return null;
      }
    }
    catch (ProrateRulebaseException e) {
      String	str = "rulebase error in selecting PART " + name;
      error(ProrateAudit.ERR_ERROR, str, runtime);
      return null;
    }
    List	rules = null;
    try {
      rules = runtime.getAuditImpl().rulebase.read();
    }
    catch (ProrateRulebaseException e) {
      String	str = "rulebase error in reading PART " + name;
      error(ProrateAudit.ERR_ERROR, str, runtime);
      return null;
    }
    ProrateRuleObject	code = new ProrateRulePart(name, rules);
    ProrateRuleObject	pobj = code.copy(runtime);
    ProrateRuleObject	ret = pobj.eval(runtime);
    if (!runtime.apply) {
      if (ret == null) {
	setErrorObject();
      }
      else {
	setEvaluatedObject(ret);
      }
    }
    else {
      setEvaluatedObject(ret);
    }
    runtime.getAuditImpl().rulebase.close();
    pobj = null;
    code = null;
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRulePartcall(name);
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print(toString());
  }

  public String	toString() {
    return ("Partcall " + name);
  }

  public boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
    trace.trace(this.traceStr(), sector.getSequenceNo(), level);
    return evaluatedObject.trace(sector, trace, level+1);
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateRuleMultival extends ProrateRuleObject {
  /**
   * @uml.property  name="values"
   */
  protected List	values;

  ProrateRuleMultival(List in_values) {
    super();
    values = in_values;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    evaluatedObject = this;
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleMultival(new Vector(values));
    for (int i = 0; i < ((ProrateRuleMultival)pobj).values.size(); i++) {
      ((ProrateRuleMultival)pobj).values.set(i,
					     ((ProrateRuleObject)
					      ((ProrateRuleMultival)pobj)
					      .values.get(i)).copy(runtime));
    }
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print("MULTI(");
    for (int i = 0; i < values.size(); i++) {
      ((ProrateRuleObject)values.get(i)).dump();
      System.out.print(",");
    }
    System.out.print(")");
  }

  
  public String	toString() {
    StringBuffer	strbuf = new StringBuffer("");
    for (int i = 0; i < values.size(); i++) {
      if (i > 0) {
	strbuf.append(",");
      }
      strbuf.append(((ProrateRuleObject)values.get(i)).toString());
      if (strbuf.charAt(strbuf.length()-1) == '(') {
	strbuf.append(")");
      }
    }
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }

  boolean	isMultival() {
    return true;
  }

  /**
   * 
   * @uml.property name="values"
   */
  List getValues() {
    return values;
  }

  boolean	equal(ProrateRuleObject other) {
    for (int i = 0; i < values.size(); i++) {
      if (other.equal((ProrateRuleObject)values.get(i))) {
	return true;
      }
    }
    return false;
  }

  boolean	gtEq(ProrateRuleObject other) {
    for (int i = 0; i < values.size(); i++) {
      if (other.ltEq((ProrateRuleObject)values.get(i))) {
	return true;
      }
    }
    return false;
  }

  boolean	ltEq(ProrateRuleObject other) {
    for (int i = 0; i < values.size(); i++) {
      if (other.gtEq((ProrateRuleObject)values.get(i))) {
	return true;
      }
    }
    return false;
  }

  boolean	include(ProrateRuleObject other) {
    for (int i = 0; i < values.size(); i++) {
      ProrateRuleObject obj = (ProrateRuleObject)values.get(i);
      if (other.isMultival() || other.isInterval()) {
	if (other.isIncluded(obj)) {
	  return true;
	}
      }
      else if (obj.include(other)) {
	return true;
      }
    }
    return false;
  }

  boolean	isIncluded(ProrateRuleObject other) {
    for (int i = 0; i < values.size(); i++) {
      ProrateRuleObject obj = (ProrateRuleObject)values.get(i);
      if (other.include(obj)) {
	return true;
      }
    }
    return false;
  }
}

class ProrateRuleInterval extends ProrateRuleObject {

  /**
   * 
   * @uml.property name="low"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject low;

  /**
   * 
   * @uml.property name="high"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  protected ProrateRuleObject high;

  ProrateRuleInterval(ProrateRuleObject in_low, ProrateRuleObject in_high) {
    super();
    low = in_low;
    high = in_high;
  }

  ProrateRuleInterval(ProrateRulebaseElement in_low,
		      ProrateRulebaseElement in_high) {
    super();
    low = (ProrateRuleObject)in_low;
    high = (ProrateRuleObject)in_high;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    evaluatedObject = this;
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleInterval(low.copy(runtime),
						       high.copy(runtime));
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print("INTER(");
    low.dump();
    System.out.print("-");
    high.dump();
    System.out.print(")");
  }

  public String	toString() {
    StringBuffer	strbuf = new StringBuffer();
    strbuf.append(low.toString());
    if (strbuf.charAt(strbuf.length()-1) == '(') {
      strbuf.append(")");
    }
    strbuf.append("-");
    strbuf.append(high.toString());
    if (strbuf.charAt(strbuf.length()-1) == '(') {
      strbuf.append(")");
    }
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }

  boolean	isInterval() {
    return true;
  }

  boolean	equal(ProrateRuleObject other) {
    if (other.isMultival()) {
      return other.equal(this);
    }
    if (other.gtEq(low) && other.ltEq(high)) {
      return true;
    }
    return false;
  }

  boolean	gtEq(ProrateRuleObject other) {
    if (other.isMultival()) {
      return other.ltEq(this);
    }
    if (other.ltEq(high)) {
      return true;
    }
    return false;
  }

  boolean	ltEq(ProrateRuleObject other) {
    if (other.isMultival()) {
      return other.gtEq(this);
    }
    if (other.gtEq(low)) {
      return true;
    }
    return false;
  }

  boolean	include(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      if (other.isIncluded(low)) {
	return true;
      }
      else if (other.isIncluded(high)) {
	return true;
      }
    }
    else if (low.include(other)) {
      return true;
    }
    else if (high.include(other)) {
      return true;
    }
    return false;
  }

  boolean	isIncluded(ProrateRuleObject other) {
    if (other.include(low)) {
      return true;
    }
    if (other.include(high)) {
      return true;
    }
    return false;
  }
}

abstract class ProrateVar extends ProrateRuleObject {

  /* ɾ¹ */
  public abstract ProrateRuleObject	eval(ProrateRuntime runtime);

  /*  */
  public abstract void	dump();

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    String	traceStr = traceStr() + traceValueStr();
    trace.trace(traceStr, sector.getSequenceNo(), level);
    return traceValue(sector, trace, level+1);
  }

  ProrateRuleObject	set(ProrateRuleObject value, ProrateRuntime runtime) {
    error(ProrateAudit.ERR_ILLARG, "SET:1", runtime);
    return value;
  }
}

class ProrateVarAuto extends ProrateVar {
  /**
   * @uml.property  name="regist"
   */
  private short	regist;
  /**
   * @uml.property  name="name"
   */
  private String	name;

  public ProrateVarAuto(short regist, String varName) {
    super();
    this.regist = regist;
    name = varName;
  }

  public ProrateVarAuto(ProrateRulebaseElement pobj) {
    super();
    this.regist = ((ProrateVarAuto)pobj).regist;
    name = ((ProrateVarAuto)pobj).name;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	pobj = runtime.rule.getAutoVar(name);
    if (pobj == null) {
      error(ProrateAudit.ERR_UNBOUND, name, runtime);
      return null;
    }
    setEvaluatedObject(((ProrateVarAuto)pobj).getValue());
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarAuto(regist, name);
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print(name);
  }

  public String	toString() {
    return name;
  }

  String	traceStr() {
    return toString();
  }

  ProrateRuleObject	set(ProrateRuleObject value, ProrateRuntime runtime) {
    ProrateRuleObject	pobj = runtime.rule.getAutoVar(name);
    if (pobj != null) {
      ((ProrateVarAuto)pobj).setValue(value);
    }
    else {
      this.setValue(value);
      runtime.rule.addAutoVar(this);
    }
    return value;
  }

  /**
   * 
   * @uml.property name="regist"
   */
  public short getRegist() {
    return regist;
  }

  /**
   * 
   * @uml.property name="name"
   */
  public String getName() {
    return name;
  }

  ProrateRuleObject	getValue() {
    return evaluatedObject;
  }

  void	setValue(ProrateRuleObject value) {
    setEvaluatedObject(value);
  }
}

class ProrateVarEndorse extends ProrateVar {

  ProrateVarEndorse() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.audit.getEndorsement()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarEndorse();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ENDORSE");
  }

  public String	toString() {
    return "$ENDORSE";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarRestrict extends ProrateVar {
  ProrateVarRestrict() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.audit.getEndorsement()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarRestrict();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$RESTRICT");
  }

  public String	toString() {
    return "$RESTRICT";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarOrigin extends ProrateVar {
  ProrateVarOrigin() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    ProrateSector
      sector = (ProrateSector)runtime.audit.getSectors()[0];
    if (!sector.getDepCode().equals(sector.getDepAirport())
	&& !sector.getDepCode().equals("")
	&& !sector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city =	new ProrateRuleString(sector.getDepCode());
      values.add(city);
      ProrateRuleObject	port = new ProrateRuleString(sector.getDepAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(sector.getDepCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarOrigin();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ORIGIN");
  }

  public String	toString() {
    return "$ORIGIN";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarDest extends ProrateVar {
  ProrateVarDest() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    int	endS = runtime.audit.getSectors().length - 1;
    ProrateSector
      sector = (ProrateSector)runtime.audit.getSectors()[endS];
    if (!sector.getDestCode().equals(sector.getDestAirport())
	&& !sector.getDestCode().equals("")
	&& !sector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city = new ProrateRuleString(sector.getDestCode());
      values.add(city);
      ProrateRuleObject	port = new ProrateRuleString(sector.getDestAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(sector.getDestCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarDest();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$DEST");
  }

  public String	toString() {
    return "$DEST";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarIssueDate extends ProrateVar {
  ProrateVarIssueDate() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    double	num = Double.parseDouble(runtime.audit.getIssueDate());
    setEvaluatedObject(new ProrateRuleNumber(num));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarIssueDate();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ISSUE-DATE");
  }

  public String	toString() {
    return "$ISSUE-DATE";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarIssueBy extends ProrateVar {
  ProrateVarIssueBy() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.audit.getAirwayId()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarIssueBy();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ISSUE-BY");
  }

  public String	toString() {
    return "$ISSUE-BY";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarIssuePlace extends ProrateVar {
  ProrateVarIssuePlace() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.audit.getIssuePlace()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarIssuePlace();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ISSUE-PLACE");
  }

  public String	toString() {
    return "$ISSUE-PLACE";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarMultiPath extends ProrateVar {
  ProrateVarMultiPath() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarMultiPath();
    pobj.isCopied = true;
    return pobj; 
  }

  boolean	isMultiPath() {
    return true;
  }

  ProrateRuleObject	makePath(ProrateRuntime runtime,
				 ProrateRuleObject pobj) {
    int	hops = 0;
    List	vector = new Vector();
    if (pobj.isMultival()) {
      pobj = (ProrateRuleObject)((ProrateRuleMultival)pobj).getValues().get(0);
    }
    if (!pobj.isPath()) {
      hops = 2;
    }
    else {
      hops = ((ProrateRulePath)pobj).getLength();
    }
    runtime.hops = hops;

    ProrateRuleObject	from = null;
    if (!runtime.sector.getDepCode().equals(runtime.sector.getDepAirport())
	&& !runtime.sector.getDepCode().equals("")
	&& !runtime.sector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.sector.getDepCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.sector.getDepAirport());
      values.add(port);
      from = new ProrateRuleMultival(values);
    }
    else {
      from = new ProrateRuleString(runtime.sector.getDepCode());
    }

    ProrateRuleObject	to = null;
    if (!runtime.sector.getDestCode().equals(runtime.sector.getDestAirport())
	&& !runtime.sector.getDestCode().equals("")
	&& !runtime.sector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.sector.getDestCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.sector.getDestAirport());
      values.add(port);
      to = new ProrateRuleMultival(values);
    }
    else {
      to = new ProrateRuleString(runtime.sector.getDestCode());
    }
    vector.add(from);
    vector.add(to);

    if (hops == 2) {
      setEvaluatedObject(new ProrateRulePath(vector));
      return evaluatedObject;
    }

    int	hopsMade = 2;
    for (int i = runtime.sectorIndex+1; i < runtime.sectorIndex+hops; i++) {
      if (i >= runtime.fcomp.getSectors().length) {
	break;
      }
      if (hopsMade >= hops) {
	break;
      }
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      String	lastDest =
	((ProrateSector)runtime.fcomp.getSectors()[i-1]).getDestCode();
      if (!runtime.sector.getCarrier().equals(sector.getCarrier())
	  || !runtime.sector.getFareBasis().equals(sector.getFareBasis())
	  || !runtime.sector.getClassOfService().equals(sector
							.getClassOfService())
	  || !lastDest.equals(sector.getDepCode())) {
	break;
      }

      if (!sector.getDestCode().equals(sector.getDestAirport())
	  && !sector.getDestCode().equals("")
	  && !sector.getDestAirport().equals("")) {
	List	values = new Vector();
	ProrateRuleObject
	  city = new ProrateRuleString(sector.getDestCode());
	values.add(city);
	ProrateRuleObject
	  port = new ProrateRuleString(sector.getDestAirport());
	values.add(port);
	to = new ProrateRuleMultival(values);
      }
      else {
	to = new ProrateRuleString(sector.getDestCode());
      }
      vector.add(to);
      hopsMade++;
    }
    if (hopsMade == hops) {
      runtime.hops = hops;
    }
    setEvaluatedObject(new ProrateRulePath(vector));
    return evaluatedObject;
  }

  public void dump() {
    System.out.print("$MULTI-PATH");
  }

  public String	toString() {
    return "$MULTI-PATH";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFcFrom extends ProrateVar {
  ProrateVarFcFrom() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    ProrateSector
      sector = (ProrateSector)runtime.fcomp.getSectors()[0];
    if (!sector.getDepCode().equals(sector.getDepAirport())
	&& !sector.getDepCode().equals("")
	&& !sector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city = new ProrateRuleString(sector.getDepCode());
      values.add(city);
      ProrateRuleObject	port = new ProrateRuleString(sector.getDepAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(sector.getDepCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFcFrom();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$FC-FROM");
  }

  public String	toString() {
    return "$FC-FROM";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFcTo extends ProrateVar {
  ProrateVarFcTo() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateFareComponent	fcomp = runtime.fcomp;
    int	endS = runtime.fcomp.getSectors().length - 1;
    ProrateSector
      sector = (ProrateSector)fcomp.getSectors()[endS];
    ProrateRuleObject	ret = null;
    if (!sector.getDestCode().equals(sector.getDestAirport())
	&& !sector.getDestCode().equals("")
	&& !sector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city = new ProrateRuleString(sector.getDestCode());
      values.add(city);
      ProrateRuleObject	port = new ProrateRuleString(sector.getDestAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(sector.getDestCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFcTo();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$FC-TO");
  }

  public String	toString() {
    return "$FC-TO";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFcPath extends ProrateVar {
  ProrateVarFcPath() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	from = null;
    ProrateSector
      sector = (ProrateSector)runtime.fcomp.getSectors()[0];
    if (!sector.getDepCode().equals(sector.getDepAirport())
	&& !sector.getDepCode().equals("")
	&& !sector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city = new ProrateRuleString(sector.getDepCode());
      values.add(city);
      ProrateRuleObject	port = new ProrateRuleString(sector.getDepAirport());
      values.add(port);
      from = new ProrateRuleMultival(values);
    }
    else {
      from = new ProrateRuleString(sector.getDepCode());
    }
    from.isCopied = isCopied;

    ProrateFareComponent	fcomp = runtime.fcomp;
    int	endS = runtime.fcomp.getSectors().length - 1;
    sector = (ProrateSector)fcomp.getSectors()[endS];
    ProrateRuleObject	to = null;
    if (!sector.getDestCode().equals(sector.getDestAirport())
	&& !sector.getDestCode().equals("")
	&& !sector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city = new ProrateRuleString(sector.getDestCode());
      values.add(city);
      ProrateRuleObject	port = new ProrateRuleString(sector.getDestAirport());
      values.add(port);
      to = new ProrateRuleMultival(values);
    }
    else {
      to = new ProrateRuleString(sector.getDestCode());
    }
    to.isCopied = isCopied;

    List	vector = new Vector();
    vector.add(from);
    vector.add(to);
    /*vector.isCopied = isCopied;*/
    setEvaluatedObject(new ProrateRulePath(vector));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFcPath();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$FC-TO");
  }

  public String	toString() {
    return "$FC-TO";
  }

  String	traceStr() {
    return toString();
  }
}

/* ;;; add variables 2006.09.19 */
class ProrateVarIssueCountry extends ProrateVar {
  ProrateVarIssueCountry() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateDatabase	db = runtime.getAuditImpl().database;
    String	country = db.getAgentCountry(runtime.audit.getAgentCode(),
					     runtime.audit.getIssueDate());
    setEvaluatedObject(new ProrateRuleString(country));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarIssueCountry();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ISSUE-COUNTRY");
  }

  public String	toString() {
    return "$ISSUE-COUNTRY";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarIssueArea extends ProrateVar {
  ProrateVarIssueArea() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateDatabase	db = runtime.getAuditImpl().database;
    String	area = db.getAgentArea(runtime.audit.getAgentCode(),
				       runtime.audit.getIssueDate());
    ProrateRuleObject	ret = makeMulti(area);
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarIssueArea();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ISSUE-AREA");
  }

  public String	toString() {
    return "$ISSUE-AREA";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarIssueAgent extends ProrateVar {
  ProrateVarIssueAgent() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.audit.getAgentCode()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarIssueAgent();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ISSUE-AGENT");
  }

  public String	toString() {
    return "$ISSUE-AGENT";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarTourcode extends ProrateVar {
  ProrateVarTourcode() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.audit.getTourCode()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarTourcode();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$TOURCODE");
  }

  public String	toString() {
    return "$TOURCODE";
  }

  String	traceStr() {
    return toString();
  }
}
/* ;;; add variables 2006.09.19 */

abstract class ProrateVarSector extends ProrateVar {
  ProrateVarSector() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    return this;
  }

  public void	dump() {
  }

  public String	toString() {
    return "";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFrom extends ProrateVarSector {
  ProrateVarFrom() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (!runtime.sector.getDepCode().equals(runtime.sector.getDepAirport())
	&& !runtime.sector.getDepCode().equals("")
	&& !runtime.sector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.sector.getDepCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.sector.getDepAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(runtime.sector.getDepCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFrom();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$FROM");
  }

  public String	toString() {
    return "$FROM";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarTo extends ProrateVarSector {
  ProrateVarTo() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (!runtime.sector.getDestCode().equals(runtime.sector.getDestAirport())
	&& !runtime.sector.getDestCode().equals("")
	&& !runtime.sector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.sector.getDestCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.sector.getDestAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(runtime.sector.getDestCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarTo();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$TO");
  }

  public String	toString() {
    return "$TO";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFBasis extends ProrateVarSector {
  ProrateVarFBasis() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (runtime.sector.getFareBasis().equals("")) {
      ret = new ProrateRuleString(runtime.sector.getFareBasis());
    }
    else if (!runtime.isSPA && runtime.sector.getClassDiffIndex() > 0) {
      char	classChar = runtime.sector.getFareBasis().charAt(0);
      if (Y_classes.indexOf(classChar) >= 0) {
	ret = new ProrateRuleString("Y");
      }
      else if (C_classes.indexOf(classChar) >= 0) {
	ret = new ProrateRuleString("Y");
      }
      else if (F_classes.indexOf(classChar) >= 0) {
	ret = new ProrateRuleString("C");
      }
      else {
	ret = new ProrateRuleString("");
      }
    }
    else {
      ret =
	new ProrateRuleString(runtime.sector.getFareBasis().substring(0,1));
    }
    ((ProrateRuleString)ret).fareBasis = runtime.sector.getFareBasis();
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFBasis();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$F-BASIS");
  }

  public String	toString() {
    return "$F-BASIS";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarTkdesign extends ProrateVarSector {
  ProrateVarTkdesign() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    String	str = runtime.sector.getFareBasis();
    ProrateRuleObject	ret = null;
    if (str.equals("")) {
      ret = new ProrateRuleString(str);
    }
    else {
      ret = new ProrateRuleString(str.substring(1));
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarTkdesign();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$TKDESIGN");
  }

  public String	toString() {
    return "$TKDESIGN";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFBasisAll extends ProrateVarSector {
  ProrateVarFBasisAll() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (runtime.sector.getFareBasis().equals("")) {
      ret = new ProrateRuleString(runtime.sector.getFareBasis());
    }
    else if (!runtime.isSPA && runtime.sector.getClassDiffIndex() > 0) {
      char	classChar = runtime.sector.getFareBasis().charAt(0);
      if (Y_classes.indexOf(classChar) >= 0) {
	String
	  retFareBasis = "Y" + runtime.sector.getFareBasis().substring(1);
	ret = new ProrateRuleString(retFareBasis);
      }
      else if (C_classes.indexOf(classChar) >= 0) {
	String
	  retFareBasis = "Y" + runtime.sector.getFareBasis().substring(1);
	ret = new ProrateRuleString(retFareBasis);
      }
      else if (F_classes.indexOf(classChar) >= 0) {
	String
	  retFareBasis = "C" + runtime.sector.getFareBasis().substring(1);
	ret = new ProrateRuleString(retFareBasis);
      }
      else {
	ret = new ProrateRuleString("");
      }
    }
    else {
      ret = new ProrateRuleString(runtime.sector.getFareBasis());
    }
    ((ProrateRuleString)ret).fareBasis = runtime.sector.getFareBasis();
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFBasisAll();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$F-BASIS-ALL");
  }

  public String	toString() {
    return "$F-BASIS-ALL";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarCarrier extends ProrateVarSector {
  ProrateVarCarrier() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.sector.getCarrier()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarCarrier();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$CARRIER");
  }

  public String	toString() {
    return "$CARRIER";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFlight extends ProrateVarSector {
  ProrateVarFlight() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    double	num = Double.parseDouble(runtime.sector.getFlightNo());
    setEvaluatedObject(new ProrateRuleNumber(num));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFlight();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$FLIGHT");
  }

  public String	toString() {
    return "$FLIGHT";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarClass extends ProrateVarSector {
  ProrateVarClass() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime.sector
					     .getClassOfService()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarClass();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$CLASS");
  }

  public String	toString() {
    return "$CLASS";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarDate extends ProrateVarSector {
  ProrateVarDate() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    short month = (short)Integer.parseInt(runtime.sector
					  .getFlightDate().substring(4, 6));
    short day = (short)Integer.parseInt(runtime.sector
					.getFlightDate().substring(6, 8));
    setEvaluatedObject(new ProrateRuleDate(month, day));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarDate();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$DATE");
  }

  public String	toString() {
    return "$DATE";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarPath extends ProrateVarSector {
  ProrateVarPath() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	from = null;
    if (!runtime.sector.getDepCode().equals(runtime.sector.getDepAirport())
	&& !runtime.sector.getDepCode().equals("")
	&& !runtime.sector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.sector.getDepCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.sector.getDepAirport());
      values.add(port);
      from = new ProrateRuleMultival(values);
    }
    else {
      from = new ProrateRuleString(runtime.sector.getDepCode());
    }
    from.isCopied = isCopied;

    ProrateRuleObject	to = null;
    if (!runtime.sector.getDestCode().equals(runtime.sector.getDestAirport())
	&& !runtime.sector.getDestCode().equals("")
	&& !runtime.sector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.sector.getDestCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.sector.getDestAirport());
      values.add(port);
      to = new ProrateRuleMultival(values);
    }
    else {
      to = new ProrateRuleString(runtime.sector.getDestCode());
    }
    to.isCopied = isCopied;

    List	vector = new Vector();
    vector.add(from);
    vector.add(to);
    /*vector.isCopied = isCopied;*/
    setEvaluatedObject(new ProrateRulePath(vector));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarPath();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$PATH");
  }

  public String	toString() {
    return "$PATH";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarRoute extends ProrateVarSector {
  ProrateVarRoute() {
    super();
  }

  /* ;;; not implemented yet */
  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (runtime.sector.getViaRouting().equals("")) {
      setEvaluatedObject(new ProrateRuleString("ZZ"));
      return evaluatedObject;
    }
    setEvaluatedObject(new ProrateRuleString(runtime.sector.getViaRouting()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarRoute();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ROUTE");
  }

  public String	toString() {
    return "$ROUTE";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarDiscount extends ProrateVar {
  ProrateVarDiscount() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleNumber	ret = null;
    if (runtime.isSPA) {
      ret = new ProrateRuleNumber(runtime.sector.getSpaDiscountRate());
    }
    else {
      ret = new ProrateRuleNumber(runtime.sector.getApdpDiscountRate());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarDiscount();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$DISCOUNT");
  }

  public String	toString() {
    return "$DISCOUNT";
  }

  String	traceStr() {
    return toString();
  }

  ProrateRuleObject	set(ProrateRuleObject value, ProrateRuntime runtime) {
    if (!value.isNumber()) {
      error(ProrateAudit.ERR_VALUE, runtime);
      return value;
    }
    if (runtime.isSPA) {
      runtime.sector
	.setSpaDiscountRate(runtime.sector.getSpaDiscountRate()
			    * ((ProrateRuleNumber)value).getValue());
      ((ProrateRuleNumber)value).setValue(runtime.sector.getSpaDiscountRate());
    }
    else {
      runtime.sector
	.setApdpDiscountRate(runtime.sector.getApdpDiscountRate()
			     * ((ProrateRuleNumber)value).getValue());
      ((ProrateRuleNumber)value)
	.setValue(runtime.sector.getApdpDiscountRate());
    }
    return value;
  }
}

abstract class ProrateVarAny extends ProrateVar {
  ProrateVarAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    return this;
  }
  public void	dump() {
  }

  public String	toString() {
    return "";
  }

  String	traceStr() {
    return toString();
  }

  boolean	unification() {
    return true;
  }
}

class ProrateVarFromAny extends ProrateVarAny {
  ProrateVarFromAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (!runtime.unifiedSector.getDepCode()
	.equals(runtime.unifiedSector.getDepAirport())
	&& !runtime.unifiedSector.getDepCode().equals("")
	&& !runtime.unifiedSector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.unifiedSector.getDepCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.unifiedSector.getDepAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(runtime.unifiedSector.getDepCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFromAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$FROM-A");
  }

  public String	toString() {
    return "$FROM-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarToAny extends ProrateVarAny {
  ProrateVarToAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (!runtime.unifiedSector.getDestCode()
	.equals(runtime.unifiedSector.getDestAirport())
	&& !runtime.unifiedSector.getDestCode().equals("")
	&& !runtime.unifiedSector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject
	city = new ProrateRuleString(runtime.unifiedSector.getDestCode());
      values.add(city);
      ProrateRuleObject
	port = new ProrateRuleString(runtime.unifiedSector.getDestAirport());
      values.add(port);
      ret = new ProrateRuleMultival(values);
    }
    else {
      ret = new ProrateRuleString(runtime.unifiedSector.getDestCode());
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarToAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$TO-A");
  }

  public String	toString() {
    return "$TO-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFBasisAny extends ProrateVarAny {
  ProrateVarFBasisAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (runtime.unifiedSector.getFareBasis().equals("")) {
      ret = new ProrateRuleString(runtime.unifiedSector.getFareBasis());
    }
    else if (!runtime.isSPA && runtime.unifiedSector.getClassDiffIndex() > 0) {
      char	classChar = runtime.unifiedSector.getFareBasis().charAt(0);
      if (Y_classes.indexOf(classChar) >= 0) {
	ret = new ProrateRuleString("Y");
      }
      else if (C_classes.indexOf(classChar) >= 0) {
	ret = new ProrateRuleString("Y");
      }
      else if (F_classes.indexOf(classChar) >= 0) {
	ret = new ProrateRuleString("C");
      }
      else {
	ret = new ProrateRuleString("");
      }
    }
    else {
      ret = new ProrateRuleString(runtime.unifiedSector
				  .getFareBasis().substring(0,1));
    }
    ((ProrateRuleString)ret).fareBasis = runtime.unifiedSector.getFareBasis();
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFBasisAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$F-BASIS-A");
  }

  public String	toString() {
    return "$F-BASIS-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarTkdesignAny extends ProrateVarAny {
  ProrateVarTkdesignAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    String	str = runtime.unifiedSector.getFareBasis();
    ProrateRuleObject	ret = null;
    if (str.equals("")) {
      ret = new ProrateRuleString(str);
    }
    else {
      ret = new ProrateRuleString(str.substring(1));
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarTkdesignAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$TKDESIGN-A");
  }

  public String	toString() {
    return "$TKDESIGN-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFBasisAllAny extends ProrateVarAny {
  ProrateVarFBasisAllAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject	ret = null;
    if (runtime.unifiedSector.getFareBasis().equals("")) {
      ret = new ProrateRuleString(runtime.sector.getFareBasis());
    }
    else if (!runtime.isSPA && runtime.unifiedSector.getClassDiffIndex() > 0) {
      char	classChar = runtime.unifiedSector.getFareBasis().charAt(0);
      if (Y_classes.indexOf(classChar) >= 0) {
	String	retFareBasis =
	  "Y" + runtime.unifiedSector.getFareBasis().substring(1);
	ret = new ProrateRuleString(retFareBasis);
      }
      else if (C_classes.indexOf(classChar) >= 0) {
	String	retFareBasis =
	  "Y" + runtime.unifiedSector.getFareBasis().substring(1);
	ret = new ProrateRuleString(retFareBasis);
      }
      else if (F_classes.indexOf(classChar) >= 0) {
	String	retFareBasis =
	  "C" + runtime.unifiedSector.getFareBasis().substring(1);
	ret = new ProrateRuleString(retFareBasis);
      }
      else {
	ret = new ProrateRuleString("");
      }
    }
    else {
      ret = new ProrateRuleString(runtime.unifiedSector.getFareBasis());
    }
    
    ((ProrateRuleString)ret).fareBasis = runtime.unifiedSector.getFareBasis();
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFBasisAllAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$F-BASIS-ALL-A");
  }

  public String	toString() {
    return "$F-BASIS-ALL-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarCarrierAny extends ProrateVarAny {
  ProrateVarCarrierAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    setEvaluatedObject(new ProrateRuleString(runtime
					     .unifiedSector.getCarrier()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarCarrierAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$CARRIER-A");
  }

  public String	toString() {
    return "$CARRIER-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarFlightAny extends ProrateVarAny {
  ProrateVarFlightAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    double	num = Double.parseDouble(runtime.unifiedSector.getFlightNo());
    setEvaluatedObject(new ProrateRuleNumber(num));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarFlightAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$FLIGHT-A");
  }

  public String	toString() {
    return "$FLIGHT-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarClassAny extends ProrateVarAny {
  ProrateVarClassAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    ProrateRuleObject
      ret = new ProrateRuleString(runtime.unifiedSector.getClassOfService());
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarClassAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$CLASS-A");
  }

  public String	toString() {
    return "$CLASS-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarDateAny extends ProrateVarAny {
  ProrateVarDateAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    short month = (short)Integer.parseInt(runtime.unifiedSector
					  .getFlightDate().substring(4, 6));
    short day = (short)Integer.parseInt(runtime.unifiedSector
					.getFlightDate().substring(6, 8));
    setEvaluatedObject(new ProrateRuleDate(month, day));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarDateAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$DATE-A");
  }

  public String	toString() {
    return "$DATE-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarPathAny extends ProrateVarAny {
  ProrateVarPathAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    List	vector = new Vector();
    /* ;;; change variable 2001.06.06
       ProrateRuleString	from =
       new ProrateRuleString(runtime.unifiedSector.getDepCode());
    */
    ProrateRuleObject	from = null;
    if (!runtime.unifiedSector.getDepCode()
	.equals(runtime.unifiedSector.getDepAirport())
	&& !runtime.unifiedSector.getDepCode().equals("")
	&& !runtime.unifiedSector.getDepAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city =
	new ProrateRuleString(runtime.unifiedSector.getDepCode());
      values.add(city);
      ProrateRuleObject	port =
	new ProrateRuleString(runtime.unifiedSector.getDepAirport());
      values.add(port);
      from = new ProrateRuleMultival(values);
    }
    else {
      from = new ProrateRuleString(runtime.unifiedSector.getDepCode());
    }
    from.isCopied = isCopied;
    /* ;;; change variable 2001.06.06
       ProrateRuleString	to =
       new ProrateRuleString(runtime.unifiedSector.getDestCode());
    */
    ProrateRuleObject	to = null;
    if (!runtime.unifiedSector.getDestCode()
	.equals(runtime.unifiedSector.getDestAirport())
	&& !runtime.unifiedSector.getDestCode().equals("")
	&& !runtime.unifiedSector.getDestAirport().equals("")) {
      List	values = new Vector();
      ProrateRuleObject	city =
	new ProrateRuleString(runtime.unifiedSector.getDestCode());
      values.add(city);
      ProrateRuleObject	port =
	new ProrateRuleString(runtime.unifiedSector.getDestAirport());
      values.add(port);
      to = new ProrateRuleMultival(values);
    }
    else {
      to = new ProrateRuleString(runtime.unifiedSector.getDestCode());
    }
    to.isCopied = isCopied;
    vector.add(from);
    vector.add(to);
    /*vector.isCopied = isCopied;*/
    ProrateRulePath	ret = new ProrateRulePath(vector);
    setEvaluatedObject(ret);
    return (ProrateRuleObject)ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarPathAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$PATH-A");
  }

  public String	toString() {
    return "$PATH-A";
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateVarRouteAny extends ProrateVarAny {
  ProrateVarRouteAny() {
    super();
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (runtime.unifiedSector.getViaRouting().equals("")) {
      setEvaluatedObject(new ProrateRuleString("ZZ"));
      return evaluatedObject;
    }
    setEvaluatedObject(new ProrateRuleString(runtime.unifiedSector
					     .getViaRouting()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateVarRouteAny();
    pobj.isCopied = true;
    return pobj; 
  }

  public void dump() {
    System.out.print("$ROUTE-A");
  }

  public String	toString() {
    return "$ROUTE-A";
  }

  String	traceStr() {
    return toString();
  }
}

abstract class ProrateFunc extends ProrateRuleObject {
  protected List	args;

  /* ɾ¹ */
  public abstract ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception;
  abstract String	operatorString();

  ProrateFunc(List in_args) {
    super();
    args = in_args;
  }

  public void	dump() {
    for (int i = 0; i < args.size(); i++) {
      ((ProrateRuleObject)args.get(i)).dump();
      System.out.print(" ");
    }
    System.out.print(") ");
  }

  boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer();
    if (evaluatedObject != null && evaluatedObject != this) {
      traceStr.append(evaluatedObject.traceStr());
      traceStr.append("<-");
    }
    traceStr.append(this.traceStr());
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
    if (!this.traceArgs(sector, trace, level)) {
      return false;
    }
    return this.traceValue(sector, trace, level+1);
  }

  boolean	traceArgs(ProrateSector sector, ProrateTrace trace,
			  int level) {
    for (int i = 0; i < args.size(); i++) {
      if (!trace.trace((ProrateRuleObject)args.get(i), sector, level+1)) {
	return false;
      }
    }
    return true;
  }

  boolean	unification() {
    for (int i = 0; i < args.size(); i++) {
      if (((ProrateRuleObject)args.get(i)).unification()) {
	return true;
      }
    }
    return false;
  }

  boolean	checkArgnum(int num, String funcName, ProrateRuntime runtime) {
    if (args.size() != num) {
      error(ProrateAudit.ERR_NUMARG, funcName, runtime);
      return false;
    }
    return true;
  }

  public String	toString() {
    StringBuffer	strbuf = new StringBuffer("");
    strbuf.append(this.operatorString());
    strbuf.append("(");
    for (int i = 0; i < args.size(); i++) {
      if (i > 0) {
	strbuf.append(" ");
      }
      strbuf.append(((ProrateRuleObject)args.get(i)).toString());
      if (strbuf.charAt(strbuf.length()-1) == '(') {
	strbuf.append(")");
      }
    }
    strbuf.append(")");
    return strbuf.toString();
  }
  
  String	traceStr() {
    return toString();
  }
}

class ProrateRuleExtern extends ProrateFunc implements ProrateRule {
  /* ;;; not implemented yet */
  protected String	name;
  protected List	argVars;
  protected List	rules;	/* ɾ롼륪֥ȷ */
  /**
   * @uml.property  name="autoVars"
   */
  protected List	autoVars;	/* ưѿơ֥ */

  ProrateRuleExtern(String extfName, List args) {
    super(args);
    name = extfName;
    this.args = args;
    this.argVars = null;
    this.rules = null;
    setAutoVars(new Vector());
    /* ;;; not implemented yet */
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    try {
      if (!runtime.getAuditImpl().rulebase.selectEXTF(name)) {
	String	str = name + " : undefined EXTF";
	error(ProrateAudit.ERR_ERROR, str, runtime);
	return null;
      }
    }
    catch (ProrateRulebaseException e) {
      String	str = "rulebase error in selecting EXTF " + name;
      error(ProrateAudit.ERR_ERROR, str, runtime);
      return null;
    }
    try {
      rules = runtime.getAuditImpl().rulebase.read();
    }
    catch (ProrateRulebaseException e) {
      String	str = "rulebase error in reading EXTF " + name;
      error(ProrateAudit.ERR_ERROR, str, runtime);
      return null;
    }
    argVars = new Vector();
    int	rulesStart = 0;
    for (int i = 0; i < rules.size(); i++) {
      ProrateRuleObject	obj = (ProrateRuleObject)rules.get(i);
      if (obj instanceof ProrateFuncSet) {
	ProrateFuncSet	funcSet = (ProrateFuncSet)obj;
	if (funcSet.args.size() == 1) {
	  argVars.add(funcSet.args.get(0));
	}
	else {
	  rulesStart = i;
	  break;
	}
      }
      else {
	rulesStart = i;
	break;
      }
    }
    int	oldRulesSize = rules.size();
    List	newRules = new Vector();
    for (int i = rulesStart; i < oldRulesSize; i++) {
      newRules.add(rules.get(i));
    }
    rules = newRules;
    for (int i = 0; i < args.size(); i++) {	/* bind arguments */
      ProrateRuleObject	var = (ProrateRuleObject)argVars.get(i);
      if (var == null) {
	error(ProrateAudit.ERR_FUNC, name, runtime);
	return this;
      }
      args.set(i,
	       ((ProrateRuleObject)args.get(i)).copy(runtime));
      ProrateRuleObject	value = ((ProrateRuleObject)args.get(i)).eval(runtime);
      ((ProrateVarAuto)var).setValue(value);
      addAutoVar(var);
    }
    ProrateRule	scope = runtime.rule;	/* change scope */
    runtime.rule = this;

    /* ProrateRule.eval */
    ProrateRuleObject	ret = null;
    for (int i = 0; i < rules.size(); i++) {
      rules.set(i, ((ProrateRuleObject)rules.get(i)).copy(runtime));
      ret = ((ProrateRuleObject)rules.get(i)).eval(runtime);
      if (!runtime.apply) {
	break;
      }
    }

    runtime.rule = scope;	/* restore scope */
    if (!runtime.apply) {
      if (ret == null) {
	setErrorObject();
      }
      else {
	setEvaluatedObject(ret);
      }
    }
    else {
      setEvaluatedObject(ret);
    }
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    /* ;;; not implemented yet */
    if (isCopied) {
      return this;
    }
    List	argsCopied = new Vector();
    for (int i = 0; i < args.size(); i++) {
      Object	obj = args.get(i);
      argsCopied.add(obj);
    }
    ProrateRuleObject	pobj = new ProrateRuleExtern(name, argsCopied);
    pobj.isCopied = true;
    return pobj; 
  }

  /**
   * 
   * @uml.property name="autoVars"
   */
  public List getAutoVars() {
    return autoVars;
  }

  /**
   * 
   * @uml.property name="autoVars"
   */
  public void setAutoVars(List vector) {
    autoVars = vector;
  }

  public ProrateRuleObject	getAutoVar(String name) {
    ProrateRuleObject	pobj = null;
    for (int i = 0; i < autoVars.size(); i++) {
      pobj = (ProrateRuleObject)autoVars.get(i);
      if (((ProrateVarAuto)pobj).getName().equals(name)) {
	break;
      }
    }
    if (pobj != null && ((ProrateVarAuto)pobj).getName().equals(name)) {
      return pobj;
    }
    return null;
  }

  public void	addAutoVar(ProrateRuleObject pobj) {
    autoVars.add(pobj);
  }

  public void	dump() {
    System.out.print("FUNCTION[" + name + "](");
    super.dump();
  }

  public boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer();
    if (evaluatedObject != null && evaluatedObject != this) {
      traceStr.append(evaluatedObject.traceStr());
      traceStr.append("<-");
    }
    /* ;;; 2009.11.30
    traceStr.append(this.traceStr() + "(");
    for (int i = 0; i < args.size(); i++) {
      if (i > 0) {
	traceStr.append(" ");
      }
      traceStr.append(((ProrateRuleObject)args.get(i)).traceStr());
      if (traceStr.charAt(traceStr.length()-1) == '(') {
	traceStr.append(")");
      }
    }
    traceStr.append(")");
    */
    traceStr.append(this.traceStr());
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
    if (!this.traceArgs(sector, trace, level)) {
      return false;
    }
    for (int i = 0; i < rules.size(); i++) {
      if (!trace.trace((ProrateRuleObject)rules.get(i), sector, level+1)) {
	return false;
      }
    }
    return this.traceValue(sector, trace, level+1);
  }

  public String	operatorString() {
    StringBuffer	strbuf = new StringBuffer("FUNCTION[");
    strbuf.append(name);
    strbuf.append("]");
    return strbuf.toString();
  }
}

/* ;;; ProrateFuncRule not implemented yet */
class ProrateFuncRule extends ProrateFunc implements ProrateRule {

  protected String	carrier;
  protected String	tkCarrier;
  protected boolean	isSPA;
  protected List	rules;	/* ɾ롼륪֥ȷ */
  protected boolean	skipToActions = true;
  /**
   * @uml.property  name="autoVars"
   */
  protected List	autoVars;	/* ưѿơ֥ */
  
  /**
   * Creates a new <code>ProrateFuncRule</code> instance.
   *
   * @param isSPA a <code>boolean</code> value
   * @param carrier a <code>String</code> value
   * @param tkCarrier a <code>String</code> value
   */
  ProrateFuncRule(boolean isSPA, String carrier, String tkCarrier) {
    super(new Vector());
    if (carrier != null) {
      this.carrier = carrier;
    }
    else {
      this.carrier = null;
    }
    if (tkCarrier != null) {
      this.tkCarrier = tkCarrier;
    }
    else {
      this.tkCarrier = null;
    }
    this.isSPA = isSPA;
    this.rules = null;
    setAutoVars(new Vector());
  }
  
  /**
   * Creates a new <code>ProrateFuncRule</code> instance.
   *
   * @param isSPA a <code>boolean</code> value
   * @param carrier a <code>ProrateRulebaseElement</code> value
   * @param tkCarrier a <code>ProrateRulebaseElement</code> value
   */
  ProrateFuncRule(boolean isSPA,
		  ProrateRulebaseElement carrierElement,
		  ProrateRulebaseElement tkCarrierElement) {
    super(new Vector());
    String	carrier = null;
    if (carrierElement != null) {
      carrier = (String)((ProrateRuleString)carrierElement).getValue();
    }
    String	tkCarrier = null;
    if (tkCarrierElement != null) {
      tkCarrier	= (String)((ProrateRuleString)tkCarrierElement).getValue();
    }
    new ProrateFuncRule(isSPA, carrier, tkCarrier);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (runtime.appliedRules.size() > ProrateRulebase.MAX_RECURSIVE_CNT) {
      String	str = null;
      if (isSPA) {
	str = "Apply_SPA(";
	str += carrier;
	str += ",";
	str += tkCarrier;
	str += ")";
      }
      else {
	str += "Apply_APDP(";
	str += carrier;
	str += ")";
      }
      str += ": call stack overflow";
      error(ProrateAudit.ERR_ERROR, str, runtime);
      return null;
    }
    String	key = carrier;
    if (tkCarrier != null) {
      key += tkCarrier;
    }
    for (int i = 0; i < runtime.appliedRules.size(); i++) {
      if (((String)runtime.appliedRules.get(i)).equals(key)) {
	String	str = null;
	if (isSPA) {
	  str = "Apply_SPA(";
	  str += carrier;
	  str += ",";
	  str += tkCarrier;
	  str += ")";
	}
	else {
	  str += "Apply_APDP(";
	  str += carrier;
	  str += ")";
	}
	str += ": call loops";
	error(ProrateAudit.ERR_ERROR, str, runtime);
	return null;
      }
    }
    runtime.appliedRules.add(key);

    rules =
      runtime.getAuditImpl().rulebase.read(isSPA, carrier, tkCarrier,
					   runtime.audit.getIssueDate(),
					   skipToActions);
    if (rules == null || rules.size() == 0) {
      setErrorObject(ProrateAudit.ERR_ERROR,
		     "error in loading SPA rule "
		     + carrier + "/" + tkCarrier + " for "
		     + runtime.audit.getIssueDate());
      return evaluatedObject;
    }
    ProrateRule funcCode, funcRule;
    funcCode = new ProrateRuleTop(rules);
    funcRule = ((ProrateRuleTop)funcCode).copy(runtime);
    
    ProrateRule	scope = runtime.rule;	/* change scope */

    if (isSPA) {
      runtime.setSPA(runtime.audit, runtime.fcomp, runtime.sector, funcRule);
    }
    else {
      runtime.setAPDP(runtime.audit, runtime.fcomp, runtime.sector, funcRule);
    }

    runtime.eval();

    runtime.getAuditImpl().trace.trace(runtime, (isSPA ? "SPA" : "APDP"),
				       carrier, tkCarrier);
    runtime.getAuditImpl().trace.trace(funcRule, runtime.sector, 1);

    runtime.rule = scope;	/* restore scope */
    runtime.getAuditImpl().rulebase.close();
    if (!runtime.apply) {
      setEvaluatedObject(new ProrateRuleBool(false));
    }
    else {
      setEvaluatedObject(new ProrateRuleBool(true));
    }
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    /* ;;; not implemented yet */
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncRule(isSPA, carrier, tkCarrier);
    pobj.isCopied = true;
    return pobj; 
  }

  /**
   * 
   * @uml.property name="autoVars"
   */
  public List getAutoVars() {
    return autoVars;
  }

  /**
   * 
   * @uml.property name="autoVars"
   */
  public void setAutoVars(List vector) {
    autoVars = vector;
  }

  public ProrateRuleObject	getAutoVar(String name) {
    ProrateRuleObject	pobj = null;
    for (int i = 0; i < autoVars.size(); i++) {
      pobj = (ProrateRuleObject)autoVars.get(i);
      if (((ProrateVarAuto)pobj).getName().equals(name)) {
	break;
      }
    }
    if (pobj != null && ((ProrateVarAuto)pobj).getName().equals(name)) {
      return pobj;
    }
    return null;
  }

  public void addAutoVar(ProrateRuleObject pobj) {
    autoVars.add(pobj);
  }

  public void	dump() {
    System.out.print("RULE[" + (isSPA ? "SPA" : "APDP")
		     + ":" + carrier + ":" + tkCarrier + " ](");
    super.dump();
  }

  public boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer();
    if (evaluatedObject != null && evaluatedObject != this) {
      traceStr.append(evaluatedObject.traceStr());
      traceStr.append("<-");
    }
    traceStr.append(this.traceStr());
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);

    for (int i = 0; i < rules.size(); i++) {
      if (!trace.trace((ProrateRuleObject)rules.get(i), sector, level+1)) {
	return false;
      }
    }
    return this.traceValue(sector, trace, level+1);
  }

  public String	operatorString() {
    StringBuffer	strbuf = new StringBuffer("RULE[");
    strbuf.append(isSPA ? "SPA" : "APDP");
    strbuf.append(":");
    strbuf.append(carrier);
    strbuf.append(":");
    strbuf.append(tkCarrier);
    strbuf.append("]");
    return strbuf.toString();
  }

  public boolean isSkipToActions() {
    return skipToActions;
  }

  public void setSkipToActions(boolean skipToActions) {
    this.skipToActions = skipToActions;
  }
}

class ProrateFuncSet extends ProrateFunc {
  ProrateFuncSet(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    evaluatedObject = this;	/* void function */
    if (!checkArgnum(2, "Set", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject car = (ProrateRuleObject)args.get(0);
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject cdr = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (cdr == null) {
      setErrorObject();
      return null;
    }
    return car.set(cdr, runtime);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncSet(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("SET(");
    super.dump();
  }

  public String	operatorString() {
    return "SET";
  }
}

abstract class ProrateFuncMidop extends ProrateFunc {
  ProrateFuncMidop(List in_args) {
    super(in_args);
  }

  boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
    if (!isEvaluated()) {
      return false;
    }
    StringBuffer	traceStr = new StringBuffer();
    if (evaluatedObject != null && evaluatedObject != this) {
      traceStr.append(evaluatedObject.traceStr());
      traceStr.append("<-");
    }
    traceStr.append(this.traceStr());
    trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
    if (!this.traceArgs(sector, trace, level)) {
      return false;
    }
    return this.traceValue(sector, trace, level+1);
  }

  public String	toString() {
    StringBuffer	strbuf = new StringBuffer("(");
    strbuf.append(((ProrateRuleObject)args.get(0)).toString());
    if (strbuf.charAt(strbuf.length()-1) == '(') {
      strbuf.append(")");
    }
    strbuf.append(this.operatorString());
    strbuf.append(((ProrateRuleObject)args.get(1)).toString());
    if (strbuf.charAt(strbuf.length()-1) == '(') {
      strbuf.append(")");
    }
    strbuf.append(")");
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateFuncEq extends ProrateFuncMidop {
  ProrateFuncEq(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "=", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject car = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (car == null) {
      setErrorObject();
      return null;
    }
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject cdr = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (cdr == null) {
      setErrorObject();
      return null;
    }
    if (car.isMultiPath()) {
      car = ((ProrateVarMultiPath)car).makePath(runtime, cdr);
    }
    else if (cdr.isMultiPath()) {
      cdr = ((ProrateVarMultiPath)cdr).makePath(runtime, car);
    }
    setEvaluatedObject(new ProrateRuleBool(car.equal(cdr)));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncEq(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("=(");
    super.dump();
  }
  
  String	operatorString() {
    return (" = ");
  }
}

class ProrateFuncNeq extends ProrateFuncMidop {
  ProrateFuncNeq(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "!=", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject car = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (car == null) {
      setErrorObject();
      return null;
    }
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject cdr = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (cdr == null) {
      setErrorObject();
      return null;
    }
    if (car.isMultiPath()) {
      car = ((ProrateVarMultiPath)car).makePath(runtime, cdr);
    }
    else if (cdr.isMultiPath()) {
      cdr = ((ProrateVarMultiPath)cdr).makePath(runtime, car);
    }
    setEvaluatedObject(new ProrateRuleBool(!car.equal(cdr)));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncNeq(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("!=(");
    super.dump();
  }
  
  String	operatorString() {
    return (" != ");
  }
}

class ProrateFuncSinc extends ProrateFuncMidop {
  ProrateFuncSinc(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, ">=", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject car = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (car == null) {
      setErrorObject();
      return null;
    }
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject cdr = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (cdr == null) {
      setErrorObject();
      return null;
    }
    setEvaluatedObject(new ProrateRuleBool(car.include(cdr)));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncSinc(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("<=(");
    super.dump();
  }
  
  String	operatorString() {
    return (" >= ");
  }
}

class ProrateFuncPfm extends ProrateFunc {
  ProrateFuncPfm(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Pfm", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	code = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (code == null) {
      setErrorObject();
      return null;
    }
    ProrateRuleObject	ret = getPfm("Pfm", runtime, code);
    if (ret != null) {
      setEvaluatedObject(ret);
      ret = ret.eval(runtime);
      if (runtime.isSPA) {
	runtime.sector
	  .setProrationType((runtime.sector.getProrationType()
			     & (ProrateAudit.PRT_APDPSET
				| ProrateAudit.PRT_SPASET)
			     & ~ProrateAudit.PRT_FIX)
			    | ProrateAudit.PRT_PFM);
      }
      else {
	if ((runtime.sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	  runtime.sector.setProrationType(runtime.sector.getProrationType()
					  | ProrateAudit.PRT_PRVS);
	}
	else {
	  runtime.sector
	    .setProrationType((runtime.sector.getProrationType()
			       & ~ProrateAudit.PRT_FIX)
			      | ProrateAudit.PRT_PFM);
	}
      }
    }
    else {
      /* pfm() not found */
      ret = new ProrateRuleEnd();
      setEvaluatedObject(ret);
      ret = ret.eval(runtime);
    }
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncPfm(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  ProrateRuleAmount	getPfm(String caller, ProrateRuntime runtime,
			       ProrateRuleObject pobj) throws Exception {
    ProrateDatabase	db = runtime.getAuditImpl().database;

    if (pobj.isMultival()) {
      List	codes = ((ProrateRuleMultival)pobj).getValues();
      codes.set(0, ((ProrateRuleObject)codes.get(0)).copy(runtime));
      pobj = ((ProrateRuleObject)codes.get(0)).eval(runtime);
      if (pobj == null) {
	setErrorObject();
	return null;
      }
    }
    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, caller+":1", runtime);
      return null;
    }

    String
      code = ((String)((ProrateRuleString)pobj).getValue()).substring(0, 1);
    String	code2 = (String)codeConversionMap.get(code);
    for (int i = 0; i < code2.length(); i++) {
      jp.sourceforge.gnp.prorate.ProrateDatabase.Amount
	amount = db.getBaseAmount(runtime.sector.getDepCode(),
				  runtime.sector.getDestCode(),
				  runtime.sector.getCarrier(),
				  code2.substring(i, i+1),
				  runtime.audit.getIssueDate());
      if (amount != null) {
	return new ProrateRuleAmount(amount.currency, amount.value);
      }
      if (db.getResult() > 1) {
	StringBuffer depDest = new StringBuffer(runtime.sector.getDepCode());
	depDest.append("-");
	depDest.append(runtime.sector.getDestCode());
	StringBuffer
	  carrierClass = new StringBuffer(runtime.sector.getCarrier());
	carrierClass.append(",");
	carrierClass.append(code2.charAt(i));
	DBError(runtime, "getBaseAmount",
		depDest.toString(), carrierClass.toString());
	return null;
      }
    }
    error(ProrateAudit.ERR_PFM,
	  caller+":1:"
	  +runtime.sector.getDepCode()+"-"+runtime.sector.getDestCode()
	  +"("+runtime.sector.getCarrier()+")"+code, runtime);
    return null;
  }

  public void	dump() {
    System.out.print("Pfm(");
    super.dump();
  }

  public String	operatorString() {
    return "Pfm";
  }
}

class ProrateFuncPfmMax extends ProrateFuncPfm {
  ProrateFuncPfmMax(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    String	currency = "";
    double	value = (double)0;
    ProrateRuleObject	ret = null;
    for (int i = 0; i < args.size(); i++) {
      args.set(i, ((ProrateRuleObject)args.get(i)).copy(runtime));
      ProrateRuleObject	code = ((ProrateRuleObject)args.get(i)).eval(runtime);
      if (code == null) {
	setErrorObject();
	return null;
      }
      ret = getPfm("Pfm_max", runtime, code);
      if (ret != null) {
	if (((ProrateRuleAmount)ret).getCurrency().equals("")) {
	  currency = ((ProrateRuleAmount)ret).getCurrency();
	}
	if (value < ((ProrateRuleAmount)ret).getValue()) {
	  value = ((ProrateRuleAmount)ret).getValue();
	}
      }
    }
    if (currency.equals("")) {
      ret = new ProrateRuleAmount(currency, value);
      setEvaluatedObject(ret);
      ret = ret.eval(runtime);
      if (runtime.isSPA) {
	runtime.sector
	  .setProrationType((runtime.sector.getProrationType()
			     & (ProrateAudit.PRT_APDPSET
				| ProrateAudit.PRT_SPASET)
			     & ~ProrateAudit.PRT_FIX)
			    | ProrateAudit.PRT_PFM);
      }
      else {
	if ((runtime.sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	  runtime.sector.setProrationType(runtime.sector.getProrationType()
					  | ProrateAudit.PRT_PRVS);
	}
	else {
	  runtime.sector.setProrationType((runtime.sector.getProrationType()
					   & ~ProrateAudit.PRT_FIX)
					  | ProrateAudit.PRT_PFM);
	}
      }
    }
    else {
      /* pfm() not found */
      ret = new ProrateRuleEnd();
      setEvaluatedObject(ret);
      ret = ret.eval(runtime);
    }
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncPfmMax(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Pfm_Max(");
    super.dump();
  }

  public String	operatorString() {
    return "PfmMax";
  }
}

class ProrateFuncSrp extends ProrateFunc {
  ProrateFuncSrp(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Srp", runtime)) {
      return null;
    }
    if (runtime.isSPA) {
      runtime.sector.setSpaNuc(runtime.sector.getSpaDiscountRate()
			       * runtime.sector.getSrpNuc());
      /* ;;; class differential ??? srp_class_diff() */
      runtime.sector
	.setProrationType(((runtime.sector.getProrationType()
			    & (ProrateAudit.PRT_APDPSET
			       | ProrateAudit.PRT_SPASET))
			   | ProrateAudit.PRT_SPA
			   | ProrateAudit.PRT_FIXSRP));
    }
    else {
      runtime.sector.setApdpNuc(runtime.sector.getApdpDiscountRate()
				* runtime.sector.getSrpNuc());
      /* ;;; class differential ??? srp_class_diff() */
      runtime.sector
	.setProrationType(((runtime.sector.getProrationType()
			    & ProrateAudit.PRT_SPA) != 0 ?
			   (runtime.sector.getProrationType()
			    & ProrateAudit.PRT_PRVS) :
			   (ProrateAudit.PRT_APDP
			    | ProrateAudit.PRT_FIXSRP
			    | ProrateAudit.PRT_PRVS)));
    }
    setEvaluatedObject(new ProrateRuleBool(true));
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncSrp(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Srp(");
    super.dump();
  }

  public String	operatorString() {
    return "Srp";
  }
}

class ProrateFuncNp extends ProrateFunc {
  ProrateFuncNp(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Np", runtime)) {
      return null;
    }
    if (runtime.isSPA) {
      runtime.sector
	.setProrationType(((runtime.sector.getProrationType()
			    & (ProrateAudit.PRT_APDPSET
			       | ProrateAudit.PRT_SPASET))
			   | ProrateAudit.PRT_SPA | ProrateAudit.PRT_NP));
    }
    else {
      runtime.sector
	.setProrationType(((runtime.sector.getProrationType()
			    & ProrateAudit.PRT_SPA) != 0 ?
			   (runtime.sector.getProrationType()
			    & ProrateAudit.PRT_PRVS) :
			   (ProrateAudit.PRT_APDP | ProrateAudit.PRT_NP
			    | ProrateAudit.PRT_PRVS)));
    }
    setEvaluatedObject(new ProrateRuleBool(true));
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncNp(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Np(");
    super.dump();
  }

  public String	operatorString() {
    return "Np";
  }
}

class ProrateFuncApplyDiscount extends ProrateFunc {
  ProrateFuncApplyDiscount(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Apply_discount", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    double	percent = (double)0;
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject	pobj2 = (ProrateRuleObject)values.get(i);
	values.set(i, pobj2.copy(runtime));
	ProrateRuleObject
	  subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return null;
	}
	if (!subobj.isString()) {
	  error(ProrateAudit.ERR_ILLARG, "Apply_discount:1", runtime);
	  return null;
	}
	if ((percent = parseDiscount(runtime.sector.getFareBasis(), subobj))
	    > (double)0) {
	  break;
	}
      }
    }
    else {
      if (!pobj.isString()) {
	error(ProrateAudit.ERR_ILLARG, "Apply_discount:1", runtime);
	return null;
      }
      percent = parseDiscount(runtime.sector.getFareBasis(), pobj);
    }
    percent = (double)100 - percent;

    if (runtime.isSPA) {
      runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate()
					* percent / (double)100);
      runtime.sector.setSpaNuc(runtime.sector.getSpaNuc()
			       * percent / (double)100);
      if ((runtime.sector.getProrationType() & ProrateAudit.PRT_MULSPA) != 0) {
	for (int i = runtime.sectorIndex+1;
	     i < runtime.fcomp.getSectors().length; i++) {
	  ProrateSector
	    sector = (ProrateSector)runtime.fcomp.getSectors()[i];
	  if ((sector.getProrationType() & ProrateAudit.PRT_MULSPA) == 0) {
	    break;
	  }
	  runtime.sector.setSpaDiscountRate(sector.getSpaDiscountRate()
					    * percent / (double)100);
	  runtime.sector.setSpaNuc(sector.getSpaNuc() * percent / (double)100);
	}
      }
    }
    else {
      runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate()
					 * percent / (double)100);
      runtime.sector.setApdpNuc(runtime.sector.getApdpNuc()
				* percent / (double)100);
      runtime.sector
	.setFixedFareDiscount(runtime.sector.getFixedFareDiscount()
			      * percent / (double)100);
      if ((runtime.sector.getProrationType()
	   & ProrateAudit.PRT_MULAPDP) != 0) {
	for (int i = runtime.sectorIndex+1;
	     i < runtime.fcomp.getSectors().length; i++) {
	  ProrateSector
	    sector = (ProrateSector)runtime.fcomp.getSectors()[i];
	  if ((sector.getProrationType() & ProrateAudit.PRT_MULAPDP) == 0) {
	    break;
	  }
	  runtime.sector.setApdpDiscountRate(sector.getApdpDiscountRate()
					     * percent / (double)100);
	  runtime.sector.setApdpNuc(sector.getApdpNuc()
				    * percent / (double)100);
	}
      }
    }
    setEvaluatedObject(new ProrateRuleBool(true));
    return pobj;
  }

  double	parseDiscount(String fareBasis, ProrateRuleObject pobj) {
    String	code = ((ProrateRuleString)pobj).getValue();
    String	str = null;
    if (code.substring(0, 1).equals("^")) {
      if (fareBasis.length() >= code.length()+1
	  &&
	  fareBasis.substring(0, code.length()-1).equals(code.substring(1))) {
	double	ret = (double)0;
	str = fareBasis.substring((int)code.length()-1);
	ret = Double.parseDouble(str);
	return ret;
      }
      return (double)0;
    }

    for (int i = fareBasis.indexOf(code); i >= 0;
	 i = fareBasis.indexOf(code, i+1)) {
      if (fareBasis.length() >= (int)code.length()+i
	  && fareBasis.substring(i, i+(int)code.length()).equals(code)) {
	double	discount = (double)0;
	str = fareBasis.substring((int)code.length()+i);
	if (str.length() == 0) {
	  break;
	}
	if (str.charAt(0) >= '0' && str.charAt(0) <= '9') {
	  discount = Double.parseDouble(str);
	  if (discount == (double)100) {
	    discount = (double)0;
	  }
	  else if (discount == (double)100) {
	    discount = (double)0;
	  }
	  /* ;;; discount_rt66 ??? */
	  return discount;
	}
	str = code.substring(0, 2);
	for (int j = 0; j < discount_code.length; j++) {
	  if (str.equals(discount_code[j])) {
	    /* ;;; ask user ??? */
	    if (discount == (double)100) {
	      discount = (double)0;
	    }
	    else if (discount == (double)100) {
	      discount = (double)0;
	    }
	    return discount;
	  }
	}
      }
    }
    return (double)0;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncApplyDiscount(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Apply_discount(");
    super.dump();
  }

  public String	operatorString() {
    return "Apply_discount";
  }
}

class ProrateFuncCountry extends ProrateFunc {
  ProrateFuncCountry(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Country", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      pobj =
	((ProrateRuleObject)((ProrateRuleMultival)pobj).getValues().get(0))
	.copy(runtime);
    }
    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Country:1", runtime);
      return null;
    }
    String	place = ((ProrateRuleString)pobj).getValue();
    String	country = getCountryName(runtime, place);
    ProrateRuleObject	ret = new ProrateRuleString(country);
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncCountry(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Country(");
    super.dump();
  }

  public String	operatorString() {
    return "Country";
  }
}

class ProrateFuncArea extends ProrateFunc {
  ProrateFuncArea(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Area", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      pobj =
	((ProrateRuleObject)((ProrateRuleMultival)pobj).getValues().get(0))
	.copy(runtime);
    }
    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Area:1", runtime);
      return null;
    }
    String	place = ((ProrateRuleString)pobj).getValue();
    String	area = getAreaName(runtime, place);
    ProrateRuleObject	ret = makeMulti(area);
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncArea(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Area(");
    super.dump();
  }

  public String	operatorString() {
    return "Area";
  }
}

class ProrateFuncRoute extends ProrateFunc {
  ProrateFuncRoute(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "Route", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	car = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (car == null) {
      setErrorObject();
      return null;
    }
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject	cdr = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (cdr == null) {
      setErrorObject();
      return null;
    }

    if (car.isMultival()) {
      car =
	((ProrateRuleObject)((ProrateRuleMultival)car).getValues().get(0))
	.copy(runtime);
    }
    if (!car.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Route:1", runtime);
      return null;
    }
    if (cdr.isMultival()) {
      cdr =
	((ProrateRuleObject)((ProrateRuleMultival)cdr).getValues().get(0))
	.copy(runtime);
    }
    if (!cdr.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Route:2", runtime);
      return null;
    }
    ProrateSector	sector = null;
    String	carPlace = ((ProrateRuleString)car).getValue();
    String	cdrPlace = ((ProrateRuleString)cdr).getValue();
    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      if ((sector.getDepCode().equals(carPlace)
	   && sector.getDestCode().equals(cdrPlace))
	  || (sector.getDepCode().equals(cdrPlace)
	      && sector.getDestCode().equals(carPlace))) {
	if (!sector.getViaRouting().equals("")) {
	  setEvaluatedObject(new ProrateRuleString(sector.getViaRouting()));
	  return evaluatedObject;
	}
	break;
      }
      sector = null;
    }

    String	carArea = getAreaName(runtime, carPlace);
    String	cdrArea = getAreaName(runtime, cdrPlace);
    final int	AREA_SZ = 3;
    if ((carArea.substring(0, AREA_SZ).equals("TC1")
	 && cdrArea.substring(0, AREA_SZ).equals("TC2"))
	|| (carArea.substring(0, AREA_SZ).equals("TC2")
	    && cdrArea.substring(0, AREA_SZ).equals("TC1"))) {
      if (sector != null) {
	sector.setViaRouting("AT");
      }
      setEvaluatedObject(new ProrateRuleString("AT"));
      return evaluatedObject;
    }
    if ((carArea.substring(0, AREA_SZ).equals("TC1")
	 && cdrArea.substring(0, AREA_SZ).equals("TC3"))
	|| (carArea.substring(0, AREA_SZ).equals("TC3")
	    && cdrArea.substring(0, AREA_SZ).equals("TC1"))) {
      if (sector != null) {
	sector.setViaRouting("PA");
      }
      setEvaluatedObject(new ProrateRuleString("PA"));
      return evaluatedObject;
    }
    if (sector != null) {
      sector.setViaRouting("ZZ");
    }
    setEvaluatedObject(new ProrateRuleString("ZZ"));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncRoute(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Route(");
    super.dump();
  }

  public String	operatorString() {
    return "Route";
  }
}

class ProrateFuncVia extends ProrateFunc {
  ProrateFuncVia(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Via", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj2 = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj2.copy(runtime));
	ProrateRuleObject
	  subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return null;
	}
	if (!subobj.isString()) {
	  error(ProrateAudit.ERR_ILLARG, "Via:1", runtime);
	  return null;
	}
	if (via(subobj, runtime)) {
	  setEvaluatedObject(new ProrateRuleBool(true));
	  return evaluatedObject;
	}
      }
      setEvaluatedObject(new ProrateRuleBool(false));
      return evaluatedObject;
    }

    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Via:1", runtime);
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(via(pobj, runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	via(ProrateRuleObject pobj, ProrateRuntime runtime) {
    String	place = ((ProrateRuleString)pobj).getValue();
    if (((ProrateSector)runtime.fcomp.getSectors()[0])
	.getDestCode().equals(place)) {
      return true;
    }
    for (int i = 1; i < runtime.fcomp.getSectors().length; i++) {
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      if (sector.getDepCode().equals(place)
	  || (sector.getDestCode().equals(place)
	      && i < runtime.fcomp.getSectors().length-1)) {
	return true;
      }
    }
    return false;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncVia(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Via(");
    super.dump();
  }

  public String	operatorString() {
    return "Via";
  }
}

class ProrateFuncViaCountry extends ProrateFunc {
  ProrateFuncViaCountry(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Via_country", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj2 = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj2.copy(runtime));
	ProrateRuleObject
	  subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return null;
	}
	if (!subobj.isString()) {
	  error(ProrateAudit.ERR_ILLARG, "Via_country:1", runtime);
	  return null;
	}
	if (viaCountry(subobj, runtime)) {
	  setEvaluatedObject(new ProrateRuleBool(true));
	  return evaluatedObject;
	}
      }
      setEvaluatedObject(new ProrateRuleBool(false));
      return evaluatedObject;
    }

    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Via_country:1", runtime);
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(viaCountry(pobj, runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	viaCountry(ProrateRuleObject pobj, ProrateRuntime runtime) {
    String	country = ((ProrateRuleString)pobj).getValue();
    ProrateSector
      sector = (ProrateSector)runtime.fcomp.getSectors()[0];
    if (getCountryName(runtime, sector.getDestCode()).equals(country)) {
      return true;
    }
    for (int i = 1; i < runtime.fcomp.getSectors().length; i++) {
      sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      String	depCountry = getCountryName(runtime, sector.getDepCode());
      String	destCountry = getCountryName(runtime, sector.getDestCode());
      if (depCountry.equals(country)
	  || (destCountry.equals(country)
	      && i < runtime.fcomp.getSectors().length-1)) {
	return true;
      }
    }
    return false;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncViaCountry(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Via_country(");
    super.dump();
  }

  public String	operatorString() {
    return "Via_country";
  }
}

class ProrateFuncViaArea extends ProrateFunc {
  ProrateFuncViaArea(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Via_area", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject	pobj2 =
	  ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj2.copy(runtime));
	ProrateRuleObject
	  subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return null;
	}
	if (!subobj.isString()) {
	  error(ProrateAudit.ERR_ILLARG, "Via_area:1", runtime);
	  return null;
	}
	if (viaArea(subobj, runtime)) {
	  setEvaluatedObject(new ProrateRuleBool(true));
	  return evaluatedObject;
	}
      }
      setEvaluatedObject(new ProrateRuleBool(false));
      return evaluatedObject;
    }

    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Via_area:1", runtime);
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(viaArea(pobj, runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	viaArea(ProrateRuleObject pobj, ProrateRuntime runtime) {
    String	area = ((ProrateRuleString)pobj).getValue();
    ProrateSector
      sector = (ProrateSector)runtime.fcomp.getSectors()[0];
    if (this.multiEq(getAreaName(runtime, sector.getDestCode()), area)) {
      return true;
    }
    for (int i = 1; i < runtime.fcomp.getSectors().length; i++) {
      sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      String	depArea	= getAreaName(runtime, sector.getDepCode());
      String	destArea = getAreaName(runtime, sector.getDestCode());
      if (this.multiEq(depArea, area)
	  || (this.multiEq(destArea, area)
	      && i < runtime.fcomp.getSectors().length-1)) {
	return true;
      }
    }
    return false;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncViaArea(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Via_area(");
    super.dump();
  }

  public String	operatorString() {
    return "Via_area_p";
  }
}

class ProrateFuncGateway extends ProrateFunc {
  ProrateFuncGateway(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Gateway", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject	pobj2 =
	  ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj2.copy(runtime));
	ProrateRuleObject
	  subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return null;
	}
	if (!subobj.isString()) {
	  error(ProrateAudit.ERR_ILLARG, "Gateway:1", runtime);
	  return null;
	}
	if (gateway(subobj, runtime)) {
	  setEvaluatedObject(new ProrateRuleBool(true));
	  return evaluatedObject;
	}
      }
      setEvaluatedObject(new ProrateRuleBool(false));
      return evaluatedObject;
    }

    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Gateway:1", runtime);
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(gateway(pobj, runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	gateway(ProrateRuleObject pobj, ProrateRuntime runtime) {
    String	objPort = ((ProrateRuleString)pobj).getValue();
    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      String	fromArea = getAreaName(runtime, sector.getDepCode());
      fromArea = fromArea.substring(0, 3);
      String	toArea = getAreaName(runtime, sector.getDestCode());
      toArea = toArea.substring(0, 3);
      if (fromArea.equals(toArea)) {
	continue;
      }
      if (sector.getDepCode().equals(objPort)
	  || sector.getDestCode().equals(objPort)) {
	return true;
      }
    }
    return false;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncGateway(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Gateway(");
    super.dump();
  }

  public String	operatorString() {
    return "Gateway";
  }
}

class ProrateFuncGatewayCountry extends ProrateFunc {
  ProrateFuncGatewayCountry(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Gateway_country", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj2 = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj2.copy(runtime));
	ProrateRuleObject
	  subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return null;
	}
	if (!subobj.isString()) {
	  error(ProrateAudit.ERR_ILLARG, "Gateway_country:1", runtime);
	  return null;
	}
	if (gatewayCountry(subobj, runtime)) {
	  setEvaluatedObject(new ProrateRuleBool(true));
	  return evaluatedObject;
	}
      }
      setEvaluatedObject(new ProrateRuleBool(false));
      return evaluatedObject;
    }

    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Gateway_country:1", runtime);
      return null;
    }
    ProrateRuleObject
      ret = new ProrateRuleBool(gatewayCountry(pobj, runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	gatewayCountry(ProrateRuleObject pobj,
			       ProrateRuntime runtime) {
    String	objCountry = ((ProrateRuleString)pobj).getValue();

    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      String	fromAreas = getAreaName(runtime, sector.getDepCode());
      String	toAreas = getAreaName(runtime, sector.getDestCode());
      String	fromArea = fromAreas.substring(0, 3);
      String	toArea= toAreas.substring(0, 3);
      if (fromArea.equals(toArea)) {
	continue;
      }
      String	fromCountry = getCountryName(runtime, sector.getDepCode());
      String	toCountry = getCountryName(runtime, sector.getDestCode());
      if (fromCountry.equals(objCountry) || toCountry.equals(objCountry)) {
	return true;
      }
    }
    return false;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncGatewayCountry(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Gateway_country(");
    super.dump();
  }

  public String	operatorString() {
    return "Gateway_country";
  }
}

class ProrateFuncRoundTheWorldP extends ProrateFunc {
  ProrateFuncRoundTheWorldP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "RoundTheWorld_p", runtime)) {
      return null;
    }
    int[]	areaPassed = {
      0, 0, 0
    };
    int	areaStart = -1;
    int	areaIndex = -1;
    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      String	fromArea = getAreaName(runtime, sector.getDepCode());
      String	toArea = getAreaName(runtime, sector.getDestCode());
      int	fromAreaIndex = getAreaIndex(fromArea);
      int	toAreaIndex = getAreaIndex(toArea);

      if (areaIndex < 0) {
	areaIndex = areaStart = fromAreaIndex;
	areaPassed[areaIndex] = 1;
      }
      else if (areaIndex != fromAreaIndex) {
	areaIndex = fromAreaIndex;
	if (areaPassed[areaIndex]  == 1 &&
	    (areaIndex != areaStart
	     || areaPassed[0] == 1 || areaPassed[1] == 1
	     || areaPassed[2] == 1)) {
	  setEvaluatedObject(new ProrateRuleBool(false));
	  return evaluatedObject;
	}
	areaPassed[areaIndex] = 1;
      }
      if (areaIndex != toAreaIndex) {
	areaIndex = toAreaIndex;
	if (areaPassed[areaIndex] == 1 &&
	    (areaIndex != areaStart
	     || areaPassed[0] == 1 || areaPassed[1] == 1
	     || areaPassed[2] == 1)) {
	  setEvaluatedObject(new ProrateRuleBool(false));
	  return evaluatedObject;
	}
	areaPassed[areaIndex] = 1;
      }
    }
    setEvaluatedObject(new ProrateRuleBool(true));
    return evaluatedObject;
  }

  int	getAreaIndex(String areaName) {
    String	areaTc = areaName.substring(0, 3);
    int	ret = (areaTc.equals("TC1") ? 0 : (areaTc.equals("TC2") ? 1 : 2));
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncRoundTheWorldP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("RoundTheWorld_p(");
    super.dump();
  }

  public String	operatorString() {
    return "RoundTheWorld_p";
  }
}

class ProrateFuncMileageP extends ProrateFunc {
  ProrateFuncMileageP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Mileage_p", runtime)) {
      return null;
    }
    ProrateRuleObject
      ret = new ProrateRuleBool(runtime.sector.getComponentKind()
				== ProrateAudit.FCT_MILEAGE);
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncMileageP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Mileage_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Mileage_p";
  }
}

class ProrateFuncRouteP extends ProrateFunc {
  ProrateFuncRouteP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Route_p", runtime)) {
      return null;
    }
    ProrateRuleObject
      ret = new ProrateRuleBool(runtime.sector.getComponentKind()
				== ProrateAudit.FCT_ROUTE);
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncRouteP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Route_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Route_p";
  }
}

class ProrateFuncSidetripP extends ProrateFunc {
  ProrateFuncSidetripP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Sidetrip_p", runtime)) {
      return null;
    }
    ProrateRuleObject
      ret = new ProrateRuleBool(runtime.sector.getComponentKind()
				== ProrateAudit.FCT_SIDETRIP);
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncSidetripP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Sidetrip_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Sidetrip_p";
  }
}

class ProrateFuncNoAmountP extends ProrateFunc {
  ProrateFuncNoAmountP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "No_amount_p", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = null;
    if (runtime.isSPA) {
      ret = new ProrateRuleBool(runtime.sector.getSpaNuc() == (double)0);
    }
    else {
      ret = new ProrateRuleBool(runtime.sector.getApdpNuc() == (double)0);
    }
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncNoAmountP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("NoAmount_p(");
    super.dump();
  }

  public String	operatorString() {
    return "NoAmount_p";
  }
}

class ProrateFuncSpecialFareP extends ProrateFunc {
  ProrateFuncSpecialFareP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Special_fare_p", runtime)) {
      return null;
    }
    int	fareType;
    if ((fareType = runtime.sector.getFareType()) == 0) {
      fareType = identifyFare(runtime.sector.getFareBasis());
      runtime.sector.setFareType(fareType);
    }
    if (fareType == FBT_DISCOUNT_FARE || fareType == FBT_PROMOTIONAL_FARE) {
      setEvaluatedObject(new ProrateRuleBool(true));
      return evaluatedObject;
    }
    setEvaluatedObject(new ProrateRuleBool(false));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncSpecialFareP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Special_fare_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Special_fare_p";
  }
}

class ProrateFuncPromotionalFareP extends ProrateFunc {
  ProrateFuncPromotionalFareP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Promotional_fare_p", runtime)) {
      return null;
    }
    int	fareType;
    if ((fareType = runtime.sector.getFareType()) == 0) {
      fareType = identifyFare(runtime.sector.getFareBasis());
      runtime.sector.setFareType(fareType);
    }
    if (fareType == FBT_DISCOUNT_FARE || fareType == FBT_PROMOTIONAL_FARE) {
      setEvaluatedObject(new ProrateRuleBool(true));
      return evaluatedObject;
    }
    setEvaluatedObject(new ProrateRuleBool(false));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject
      pobj = new ProrateFuncPromotionalFareP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Promotional_fare_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Promotional_fare_p";
  }
}

class ProrateFuncNormalFareP extends ProrateFunc {
  ProrateFuncNormalFareP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Normal_fare_p", runtime)) {
      return null;
    }
    int	fareType;
    if ((fareType = runtime.sector.getFareType()) == 0) {
      fareType = identifyFare(runtime.sector.getFareBasis());
      runtime.sector.setFareType(fareType);
    }
    if (fareType == FBT_NORMAL_FARE) {
      setEvaluatedObject(new ProrateRuleBool(true));
      return evaluatedObject;
    }
    setEvaluatedObject(new ProrateRuleBool(false));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncNormalFareP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Normal_fare_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Normal_fare_p";
  }
}

class ProrateFuncTaxDivid extends ProrateFunc {
  ProrateFuncTaxDivid(List in_args) {
    super(in_args);
  }

  /* ;;; not implemented yet */
  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    evaluatedObject = this;	/* void function */
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncTaxDivid(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Tax_divid(");
    super.dump();
  }

  public String	operatorString() {
    return "Normal_fare_p";
  }
}

class ProrateFuncDiscount extends ProrateFunc {
  ProrateFuncDiscount(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Discount", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    double	percent = (double)0;
    if (!pobj.isNumber()) {
      error(ProrateAudit.ERR_ILLARG, "Discount:1", runtime);
      return null;
    }
    percent = ((ProrateRuleNumber)pobj).getValue();

    if (runtime.isSPA) {
      runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate()
					* percent / (double)100);
      runtime.sector.setSpaNuc(runtime.sector.getSpaNuc()
			       * percent / (double)100);
      if ((runtime.sector.getProrationType() & ProrateAudit.PRT_MULSPA) != 0) {
	for (int i = runtime.sectorIndex+1;
	     i < runtime.fcomp.getSectors().length; i++) {
	  ProrateSector
	    sector = (ProrateSector)runtime.fcomp.getSectors()[i];
	  if ((sector.getProrationType() & ProrateAudit.PRT_MULSPA) == 0) {
	    break;
	  }
	  runtime.sector.setSpaDiscountRate(sector.getSpaDiscountRate()
					    * percent / (double)100);
	  runtime.sector.setSpaNuc(sector.getSpaNuc()
				   * percent / (double)100);
	}
      }
    }
    else {
      runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate()
					 * percent / (double)100);
      runtime.sector.setApdpNuc(runtime.sector.getApdpNuc()
				* percent / (double)100);
      if ((runtime.sector.getProrationType()
	   & ProrateAudit.PRT_MULAPDP) != 0) {
	for (int i = runtime.sectorIndex+1;
	     i < runtime.fcomp.getSectors().length; i++) {
	  ProrateSector
	    sector = (ProrateSector)runtime.fcomp.getSectors()[i];
	  if ((sector.getProrationType() & ProrateAudit.PRT_MULAPDP) == 0) {
	    break;
	  }
	  runtime.sector.setApdpDiscountRate(sector.getApdpDiscountRate()
					     * percent / (double)100);
	  runtime.sector.setApdpNuc(sector.getApdpNuc()
				    * percent / (double)100);
	}
      }
    }
    return pobj;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncDiscount(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Discount(");
    super.dump();
  }

  public String	operatorString() {
    return "Discount";
  }
}

class ProrateFuncBiProviso extends ProrateFunc {
  ProrateFuncBiProviso(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Bi_proviso", runtime)) {
      return null;
    }
    /* Bi Proviso not applied today */
    ProrateRuleObject	ret = new ProrateRuleBool(false);
    setEvaluatedObject(ret);
    return ret;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncBiProviso(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Bi_proviso(");
    super.dump();
  }

  public String	operatorString() {
    return "Bi_proviso";
  }
}

class ProrateFuncMultipathAmt extends ProrateFunc {
  ProrateFuncMultipathAmt(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "MultipathAmt", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject
      amount = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (amount == null) {
      setErrorObject();
      return null;
    }
    if (!pobj.isNumber()) {
      error(ProrateAudit.ERR_ILLARG, "MultipathAmt:1", runtime);
      return null;
    }
    if (!amount.isAmount()) {
      error(ProrateAudit.ERR_ILLARG, "Multipath_amt:2", runtime);
      return null;
    }
    int	hops = (int)((ProrateRuleNumber)pobj).getValue();
    if (!((ProrateRuleAmount)amount).setMultiPath(hops, runtime)) {
      error(ProrateAudit.ERR_MULTI, "Multipath_amt", runtime);
    }
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncMultipathAmt(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Multipath_amt(");
    super.dump();
  }

  public String	operatorString() {
    return "Multipath_amt";
  }
}

class ProrateFuncUncertain extends ProrateFunc {
  ProrateFuncUncertain(List in_args) {
    super(in_args);
  }

  /* ;;; not implemented yet */
  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    evaluatedObject = this;	/* void function */
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncUncertain(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Uncertain(");
    super.dump();
  }

  public String	operatorString() {
    return "Uncertain";
  }
}

class ProrateFuncNumberP extends ProrateFunc {
  ProrateFuncNumberP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Number_p", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    setEvaluatedObject(new ProrateRuleBool(pobj.isNumber()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncNumberP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Number_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Number_p";
  }
}

class ProrateFuncDateP extends ProrateFunc {
  ProrateFuncDateP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Date_p", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    setEvaluatedObject(new ProrateRuleBool(pobj.isDate()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncDateP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Date_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Date_p";
  }
}

class ProrateFuncStringP extends ProrateFunc {
  ProrateFuncStringP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "String_p", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    setEvaluatedObject(new ProrateRuleBool(pobj.isString()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncStringP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("String_p(");
    super.dump();
  }

  public String	operatorString() {
    return "String_p";
  }
}

class ProrateFuncAmountP extends ProrateFunc {
  ProrateFuncAmountP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Amount_p", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    setEvaluatedObject(new ProrateRuleBool(pobj.isAmount()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncAmountP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Amount_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Amount_p";
  }
}

class ProrateFuncPathP extends ProrateFunc {
  ProrateFuncPathP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Path_p", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    setEvaluatedObject(new ProrateRuleBool(pobj.isPath()));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncPathP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Path_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Path_p";
  }
}

class ProrateFuncError extends ProrateFunc {
  ProrateFuncError(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    evaluatedObject = this;	/* void function */
    if (!checkArgnum(1, "Error", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (!pobj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Error:1", runtime);
      return null;
    }
    String	errstr = ((ProrateRuleString)pobj).getValue();
    error(ProrateAudit.ERR_ERROR, errstr, runtime);
    return null;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncError(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Error(");
    super.dump();
  }

  public String	operatorString() {
    return "Error";
  }
}

class ProrateWithinFunc extends ProrateFunc {
  ProrateWithinFunc(List in_args) {
    super(in_args);
  }

  @Override
  public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "Within", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(within(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  /* ޤϰȽ */
  boolean	within(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "Within", runtime)) {
      return false;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject
      pathObj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pathObj == null) {
      setErrorObject();
      return false;
    }
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject
      withinObj = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (withinObj == null) {
      setErrorObject();
      return false;
    }

    if (!pathObj.isPath()) {
      error(ProrateAudit.ERR_ILLARG, "Within:1", runtime);
      return false;
    }
    if (withinObj.isMultival()) {
      List	values = ((ProrateRuleMultival)withinObj).getValues();
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj.copy(runtime));
	pobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (pobj == null) {
	  setErrorObject();
	  return false;
	}
	if (withinCheck(pathObj, pobj, runtime)) {
	  return true;
	}
      }
      return false;
    }
    return withinCheck(pathObj, withinObj, runtime);
  }

  boolean	withinCheck(ProrateRuleObject pathObj,
			    ProrateRuleObject withinObj,
			    ProrateRuntime runtime) throws Exception {
    boolean	cmp = false;
    if (!withinObj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Within:2", runtime);
      return false;
    }
    for (int i = 0; i < ((ProrateRulePath)pathObj).getLength(); i++) {
      ProrateRuleObject pobj = ((ProrateRulePath)pathObj).getPlace(i);
      cmp = false;
      if (pobj.isMultival()) {
	List	values = ((ProrateRuleMultival)pobj).getValues();
	for (int j = 0; j < values.size(); j++) {
	  ProrateRuleObject	pobjEach =
	    ((ProrateRuleObject)values.get(j)).copy(runtime);
	  values.set(j, pobjEach.copy(runtime));
	  ProrateRuleObject
	    subobj = ((ProrateRuleObject)values.get(j)).eval(runtime);
	  if (subobj == null) {
	    setErrorObject();
	    return false;
	  }
	  if (check(((ProrateRuleString)withinObj).getValue(),
		    ((ProrateRuleString)subobj).getValue(), runtime)) {
	    cmp = true;
	    break;
	  }
	}
	if (cmp == false) {
	  break;
	}
      }
      else if (check(((ProrateRuleString)withinObj).getValue(),
		     ((ProrateRuleString)pobj).getValue(), runtime)) {
	cmp = true;
      }
      if (cmp == false) {
	break;
      }
    }
    return cmp;
  }

  /* ;;; deBug
  abstract boolean
    check(String within, String place, ProrateRuntime runtime);
  */
  boolean	check(String within, String place, ProrateRuntime runtime) {
    String	pCountry = getCountryName(runtime, place);
    boolean isWithin;
    if ((isWithin = within.equals(pCountry)) ){
      return isWithin;
    }
    String	pArea = getAreaName(runtime, place);
    return this.multiEq(pArea, within);
  }

  @Override
  public ProrateRuleObject copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateWithinFunc(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Within(");
    super.dump();
  }

  @Override
  String operatorString() {
    return "Within";
  }

}

class ProrateFuncWithinCountry extends ProrateWithinFunc {
  ProrateFuncWithinCountry(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "Within_country", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(within(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	check(String country, String place, ProrateRuntime runtime) {
    String	pCountry = getCountryName(runtime, place);
    return (country.equals(pCountry));
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncWithinCountry(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("WithinCountry(");
    super.dump();
  }

  public String	operatorString() {
    return "WithinCountry";
  }
}

class ProrateFuncWithinArea extends ProrateWithinFunc {
  ProrateFuncWithinArea(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(2, "Within_area", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(within(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	check(String area, String place, ProrateRuntime runtime) {
    String	pArea = getAreaName(runtime, place);
    return this.multiEq(pArea, area);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncWithinArea(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Within_area(");
    super.dump();
  }

  public String	operatorString() {
    return "Within_area";
  }
}

class ProrateFuncIntlSectorP extends ProrateFunc {
  ProrateFuncIntlSectorP(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(1, "Intl_sector_p", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	pobj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pobj == null) {
      setErrorObject();
      return null;
    }
    if (!pobj.isPath()) {
      error(ProrateAudit.ERR_ILLARG, "Intl_sector_p:1", runtime);
      return null;
    }
    if (((ProrateRulePath)pobj).getLength() != 2) {
      error(ProrateAudit.ERR_ILLARG, "Intl_sector_p:1", runtime);
      return null;
    }
    ProrateRuleObject	from = ((ProrateRulePath)pobj).getPlace(0);
    if (from.isMultival()) {
      from =
	((ProrateRuleObject)((ProrateRuleMultival)from).getValues().get(0))
	.copy(runtime);
    }
    ProrateRuleObject	to = ((ProrateRulePath)pobj).getPlace(1);
    if (to.isMultival()) {
      to =
	((ProrateRuleObject)((ProrateRuleMultival)to).getValues().get(0))
	.copy(runtime);
    }
    if (!from.isString() || !to.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Intl_sector_p:1", runtime);
      return null;
    }
    String	fromCountry =
      getCountryName(runtime, ((ProrateRuleString)from).getValue());
    String	toCountry =
      getCountryName(runtime, ((ProrateRuleString)to).getValue());
    setEvaluatedObject(new ProrateRuleBool(!fromCountry.equals(toCountry)));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncIntlSectorP(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Intl_sector_p(");
    super.dump();
  }

  public String	operatorString() {
    return "Intl_sector_p";
  }
}

class ProrateBetweenFunc extends ProrateFunc {
  ProrateBetweenFunc(List in_args) {
    super(in_args);
  }

  @Override
  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(3, "Between", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(between(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  /* ޤϰȽ */
  boolean	between(ProrateRuntime runtime) throws Exception {
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject
      pathObj = ((ProrateRuleObject)args.get(0)).eval(runtime);
    if (pathObj == null) {
      setErrorObject();
      return false;
    }
    args.set(1, ((ProrateRuleObject)args.get(1)).copy(runtime));
    ProrateRuleObject
      between1Obj = ((ProrateRuleObject)args.get(1)).eval(runtime);
    if (between1Obj == null) {
      setErrorObject();
      return false;
    }
    args.set(2, ((ProrateRuleObject)args.get(2)).copy(runtime));
    ProrateRuleObject
      between2Obj = ((ProrateRuleObject)args.get(2)).eval(runtime);
    if (between2Obj == null) {
      setErrorObject();
      return false;
    }

    if (!pathObj.isPath()) {
      error(ProrateAudit.ERR_ILLARG, "Between:1", runtime);
      return false;
    }
    boolean	cmp1 = false;
    boolean	cmp2 = false;
    if (between1Obj.isMultival()) {
      List	values = ((ProrateRuleMultival)between1Obj).getValues();
      cmp1 = false;
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj.copy(runtime));
	ProrateRuleObject
	  betweenObj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (betweenObj == null) {
	  setErrorObject();
	  return false;
	}
	if (betweenCheck1(pathObj, betweenObj, 0, runtime)) {
	  cmp1 = true;
	  break;
	}
      }
    }
    else {
      cmp1 = betweenCheck1(pathObj, between1Obj, 0, runtime);
    }
    if (between2Obj.isMultival()) {
      List	values = ((ProrateRuleMultival)between2Obj).getValues();
      cmp2 = false;
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj.copy(runtime));
	ProrateRuleObject
	  betweenObj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (betweenObj == null) {
	  setErrorObject();
	  return false;
	}
	if (betweenCheck2(pathObj, betweenObj, 1, runtime)) {
	  cmp2 = true;
	  break;
	}
      }
    }
    else {
      cmp2 = betweenCheck2(pathObj, between2Obj, 1, runtime);
    }
    if (cmp1 && cmp2) {
      return true;
    }

    if (between1Obj.isMultival()) {
      List	values = ((ProrateRuleMultival)between1Obj).getValues();
      cmp1 = false;
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj.copy(runtime));
	ProrateRuleObject
	  betweenObj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (betweenObj == null) {
	  setErrorObject();
	  return false;
	}
	if (betweenCheck1(pathObj, betweenObj, 1, runtime)) {
	  cmp1 = true;
	  break;
	}
      }
    }
    else {
      cmp1 = betweenCheck1(pathObj, between1Obj, 1, runtime);
    }
    if (between2Obj.isMultival()) {
      List	values = ((ProrateRuleMultival)between2Obj).getValues();
      cmp2 = false;
      for (int i = 0; i < values.size(); i++) {
	ProrateRuleObject
	  pobj = ((ProrateRuleObject)values.get(i)).copy(runtime);
	values.set(i, pobj.copy(runtime));
	ProrateRuleObject
	  betweenObj = ((ProrateRuleObject)values.get(i)).eval(runtime);
	if (betweenObj == null) {
	  setErrorObject();
	  return false;
	}
	if (betweenCheck2(pathObj, betweenObj, 0, runtime)) {
	  cmp2 = true;
	  break;
	}
      }
    }
    else {
      cmp2 = betweenCheck2(pathObj, between2Obj, 0, runtime);
    }
    if (cmp1 && cmp2) {
      return true;
    }
    return false;
  }

  boolean betweenCheck1(ProrateRuleObject pathObj,
			ProrateRuleObject betweenObj,
			int index, ProrateRuntime runtime) throws Exception {
    boolean	cmp = false;
    if (!betweenObj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Between:2", runtime);
      return	false;
    }
    ProrateRuleObject pobj = ((ProrateRulePath)pathObj).getPlace(index);
    cmp = false;
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int j = 0; j < values.size(); j++) {
	ProrateRuleObject
	  pobjEach = ((ProrateRuleObject)values.get(j)).copy(runtime);
	values.set(j, pobjEach.copy(runtime));
	ProrateRuleObject
	  subobj = ((ProrateRuleObject)values.get(j)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return false;
	}
	if (check1(((ProrateRuleString)betweenObj).getValue(),
		   ((ProrateRuleString)subobj).getValue(), runtime)) {
	  cmp = true;
	  break;
	}
      }
    }
    else if (check1(((ProrateRuleString)betweenObj).getValue(),
		    ((ProrateRuleString)pobj).getValue(), runtime)) {
      cmp = true;
    }
    return cmp;
  }

  boolean betweenCheck2(ProrateRuleObject pathObj,
			ProrateRuleObject betweenObj,
			int index, ProrateRuntime runtime) throws Exception {
    boolean	cmp = false;
    if (!betweenObj.isString()) {
      error(ProrateAudit.ERR_ILLARG, "Between:3", runtime);
      return	false;
    }
    ProrateRuleObject pobj = ((ProrateRulePath)pathObj).getPlace(index);
    cmp = false;
    if (pobj.isMultival()) {
      List	values = ((ProrateRuleMultival)pobj).getValues();
      for (int j = 0; j < values.size(); j++) {
	ProrateRuleObject
	  pobjEach = ((ProrateRuleObject)values.get(j)).copy(runtime);
	values.set(j, pobjEach.copy(runtime));
	ProrateRuleObject
	subobj = ((ProrateRuleObject)values.get(j)).eval(runtime);
	if (subobj == null) {
	  setErrorObject();
	  return false;
	}
	if (check2(((ProrateRuleString)betweenObj).getValue(),
		   ((ProrateRuleString)subobj).getValue(), runtime)) {
	  cmp = true;
	  break;
	}
      }
    }
    else if (check2(((ProrateRuleString)betweenObj).getValue(),
		    ((ProrateRuleString)pobj).getValue(), runtime)) {
      cmp = true;
    }
    return cmp;
  }

  /* ;;; deBug
  abstract boolean
    check1(String between, String place, ProrateRuntime runtime);
  abstract boolean
    check2(String between, String place, ProrateRuntime runtime);
  */

  boolean	check1(String between, String place, ProrateRuntime runtime) {
    if (place.equals(between)) {
      return true;
    }
    String	pCountry = getCountryName(runtime, place);
    boolean isWithin;
    if ((isWithin = between.equals(pCountry))) {
      return isWithin;
    }
    String	pArea = getAreaName(runtime, place);
    return multiEq(place, between);
  }

  boolean	check2(String between, String place, ProrateRuntime runtime) {
    return check1(between, place, runtime);
  }

  @Override
  public ProrateRuleObject copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateBetweenFunc(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Between(");
    super.dump();
  }

  @Override
  String operatorString() {
    return "Between";
  }
}

class ProrateFuncBetweenCountry extends ProrateBetweenFunc {
  ProrateFuncBetweenCountry(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(3, "Between_country", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(between(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	check1(String country, String place, ProrateRuntime runtime) {
    String	pCountry = getCountryName(runtime, place);
    return (country.equals(pCountry));
  }

  boolean	check2(String country, String place, ProrateRuntime runtime) {
    return check1(country, place, runtime);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncBetweenCountry(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Between_country(");
    super.dump();
  }

  public String	operatorString() {
    return "Between_country";
  }
}

class ProrateFuncBetweenArea extends ProrateBetweenFunc {
  ProrateFuncBetweenArea(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(3, "Between_area", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(between(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	check1(String area, String place, ProrateRuntime runtime) {
    String	pArea = getAreaName(runtime, place);
    return multiEq(pArea, area);
  }

  boolean	check2(String area, String place, ProrateRuntime runtime) {
    return check1(area, place, runtime);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncBetweenArea(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Between_area(");
    super.dump();
  }

  public String	operatorString() {
    return "Between_area";
  }
}

class ProrateFuncBetweenPC extends ProrateBetweenFunc {
  ProrateFuncBetweenPC(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(3, "Between_PC", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(between(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	check1(String between, String place, ProrateRuntime runtime) {
    return (place.equals(between));
  }

  boolean	check2(String country, String place, ProrateRuntime runtime) {
    String	pCountry = getCountryName(runtime, place);
    return (country.equals(pCountry));
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncBetweenPC(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Between_PC(");
    super.dump();
  }

  public String	operatorString() {
    return "Between_PC";
  }
}

class ProrateFuncBetweenPA extends ProrateBetweenFunc {
  ProrateFuncBetweenPA(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(3, "Between_PA", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(between(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	check1(String between, String place, ProrateRuntime runtime) {
    return (place.equals(between));
  }

  boolean	check2(String area, String place, ProrateRuntime runtime) {
    String	pArea = getAreaName(runtime, place);
    return multiEq(pArea, area);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncBetweenPA(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Between_PA(");
    super.dump();
  }

  public String	operatorString() {
    return "Between_PA";
  }
}

class ProrateFuncBetweenCA extends ProrateBetweenFunc {
  ProrateFuncBetweenCA(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(3, "Between_CA", runtime)) {
      return null;
    }
    ProrateRuleObject	ret = new ProrateRuleBool(between(runtime));
    setEvaluatedObject(ret);
    return ret;
  }

  boolean	check1(String country, String place, ProrateRuntime runtime) {
    String	pCountry = getCountryName(runtime, place);
    return (country.equals(pCountry));
  }

  boolean	check2(String area, String place, ProrateRuntime runtime) {
    String	pArea = getAreaName(runtime, place);
    return multiEq(pArea, area);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncBetweenCA(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Between_CA(");
    super.dump();
  }

  public String	operatorString() {
    return "Between_CA";
  }
}

class ProrateFuncExclusive extends ProrateFunc {
  ProrateFuncExclusive(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Exclusive", runtime)) {
      return null;
    }
    if (!runtime.isSPA) {
      setEvaluatedObject(new ProrateRuleBool(true));
      return evaluatedObject;
    }
    String	spaCarrier = runtime.sector.getCarrier();
    String	tkCarrier = runtime.audit.getAirwayId();
    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      ProrateSector
	sector = (ProrateSector)runtime.fcomp.getSectors()[i];
      if (!sector.getCarrier().equals(spaCarrier)
	  && !sector.getCarrier().equals(tkCarrier)) {
	setEvaluatedObject(new ProrateRuleEnd());
	return evaluatedObject;
      }
    }
    setEvaluatedObject(new ProrateRuleBool(true));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncExclusive(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Exclusive(");
    super.dump();
  }

  public String	operatorString() {
    return "Exclusive";
  }
}

class ProrateFuncAnother extends ProrateFunc {
  ProrateFuncAnother(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Another", runtime)) {
      return null;
    }
    setEvaluatedObject(new ProrateRuleBool((runtime.unifiedSector
					    != runtime.sector)));
    return evaluatedObject;
  }

  boolean	unification() {
    return true;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncAnother(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Another(");
    super.dump();
  }

  public String	operatorString() {
    return "Another";
  }
}

class ProrateFuncHighSpa extends ProrateFunc {
  ProrateFuncHighSpa(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "High_spa", runtime)) {
      return null;
    }
    runtime.sector.setProrationType((runtime.sector.getProrationType()
				     | ProrateAudit.PRT_HIGHSPA));
    setEvaluatedObject(new ProrateRuleBool(true));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncHighSpa(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("HighSpa(");
    super.dump();
  }

  public String	operatorString() {
    return "HighSpa";
  }
}

class ProrateFuncLowSpa extends ProrateFunc {
  ProrateFuncLowSpa(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Low_spa", runtime)) {
      return null;
    }
    runtime.sector.setProrationType((runtime.sector.getProrationType()
				     | ProrateAudit.PRT_LOWSPA));
    setEvaluatedObject(new ProrateRuleBool(true));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncLowSpa(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("LowSpa(");
    super.dump();
  }

  public String	operatorString() {
    return "LowSpa";
  }
}

class ProrateFuncHighSpaFix extends ProrateFunc {
  ProrateFuncHighSpaFix(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(1, "High_spa_fix", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	valueObj = (ProrateRuleObject)args.get(0);
    if (valueObj == null) {
      setErrorObject();
      return null;
    }
    if (!valueObj.isNumber() && !valueObj.isAmount()) {
      error(ProrateAudit.ERR_ILLARG, "High_spa_fix:1", runtime);
      return null;
    }
    if (valueObj.isAmount()) {
      double	day5Rate = (double)0;
      ProrateDatabase	db = runtime.getAuditImpl().database;
      String currency = ((ProrateRuleAmount)valueObj).getCurrency();
      day5Rate = db.getMeanRate(currency, runtime.audit.getInvoiceMonth());
      if (day5Rate <= (double)0) {
	day5Rate = db.get5dayRate(currency, runtime.audit.getInvoiceMonth());
	/* ;;; error check for day5Rate < 0 (not found) */
	if (day5Rate < (double)0) {
	  if (runtime.audit.getDay5Rate() <= (double)0) {
	    if (db.getResult() > 1) {
	      DBError(runtime, "get5dayRate", currency,
		      runtime.audit.getInvoiceMonth());
	      return null;
	    }
	    int	errorNo = ProrateAudit.ASK_5DAYSPA;
	    StringBuffer	errorMessage = new StringBuffer(currency);
	    errorMessage.append(":");
	    errorMessage.append(runtime.audit.getInvoiceMonth());
	    error(errorNo, errorMessage.toString(), runtime);
	    return null;
	  }
	  day5Rate = runtime.audit.getDay5Rate();
	}
      }
      runtime.sector
	.setFixValue(((ProrateRuleAmount)valueObj).getValue() / day5Rate);
      runtime.sector
	.setFixCurrency(((ProrateRuleAmount) valueObj).getCurrency());
      runtime.sector.setFixAmount(((ProrateRuleAmount)valueObj).getValue());
    }
    else {
      runtime.sector.setFixValue(((ProrateRuleNumber)valueObj).getValue());
      runtime.sector.setFixCurrency("");
      runtime.sector.setFixAmount((double)0);
    }
    runtime.sector.setProrationType(runtime.sector.getProrationType()
				    | ProrateAudit.PRT_HIGHSPAFIX);
    setEvaluatedObject(new ProrateRuleBool(true));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncHighSpaFix(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("HighSpaFix(");
    super.dump();
  }

  public String	operatorString() {
    return "HighSpaFix";
  }
}

class ProrateFuncLowSpaFix extends ProrateFunc {
  ProrateFuncLowSpaFix(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(1, "Low_spa_fix", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	valueObj = (ProrateRuleObject)args.get(0);
    if (valueObj == null) {
      setErrorObject();
      return null;
    }
    if (!valueObj.isNumber() && !valueObj.isAmount()) {
      error(ProrateAudit.ERR_ILLARG, "Low_spa_fix:1", runtime);
      return null;
    }
    if (valueObj.isAmount()) {
      double	day5Rate = (double)0;
      ProrateDatabase	db = runtime.getAuditImpl().database;
      String currency = ((ProrateRuleAmount)valueObj).getCurrency();
      day5Rate = db.getMeanRate(currency, runtime.audit.getInvoiceMonth());
      if (day5Rate <= (double)0) {
	day5Rate = db.get5dayRate(currency, runtime.audit.getInvoiceMonth());
	/* ;;; error check for day5Rate < 0 (not found) */
	if (day5Rate < (double)0) {
	  if (runtime.audit.getDay5Rate() <= (double)0) {
	    if (db.getResult() > 1) {
	      DBError(runtime, "get5dayRate", currency,
		      runtime.audit.getInvoiceMonth());
	      return null;
	    }
	    int	errorNo = ProrateAudit.ASK_5DAYSPA;
	    StringBuffer	errorMessage = new StringBuffer(currency);
	    errorMessage.append(":");
	    errorMessage.append(runtime.audit.getInvoiceMonth());
	    error(errorNo, errorMessage.toString(), runtime);
	    return null;
	  }
	  day5Rate = runtime.audit.getDay5Rate();
	}
      }
      runtime.sector
	.setFixValue(((ProrateRuleAmount)valueObj).getValue() / day5Rate);
      runtime.sector
	.setFixCurrency(((ProrateRuleAmount) valueObj).getCurrency());
      runtime.sector.setFixAmount(((ProrateRuleAmount)valueObj).getValue());
    }
    else {
      runtime.sector.setFixValue(((ProrateRuleNumber)valueObj).getValue());
      runtime.sector.setFixCurrency("");
      runtime.sector.setFixAmount((double)0);
    }
    runtime.sector.setProrationType(runtime.sector.getProrationType()
				    | ProrateAudit.PRT_LOWSPAFIX);
    setEvaluatedObject(new ProrateRuleBool(true));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncLowSpaFix(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("LowSpaFix(");
    super.dump();
  }

  public String	operatorString() {
    return "LowSpaFix";
  }
}

class ProrateFuncNet extends ProrateFunc {
  ProrateFuncNet(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(0, "Net", runtime)) {
      return null;
    }
    if (runtime.isSPA) {
      runtime.sector.setSpaDiscountRate(runtime.sector.getSpaDiscountRate()
					/ (double)0.91);
      runtime.sector.setSpaNuc(runtime.sector.getSpaNuc() / (double)0.91);
    }
    else {
      runtime.sector.setApdpDiscountRate(runtime.sector.getApdpDiscountRate()
					 / (double)0.91);
      runtime.sector.setApdpNuc(runtime.sector.getApdpNuc() / (double)0.91);
    }
    setEvaluatedObject(new ProrateRuleBool(true));
    return evaluatedObject;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncNet(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Net(");
    super.dump();
  }

  public String	operatorString() {
    return "Net";
  }
}

class ProrateFuncSrpFix extends ProrateFunc {
  ProrateFuncSrpFix(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    if (!checkArgnum(1, "Srp_fix", runtime)) {
      return null;
    }
    args.set(0, ((ProrateRuleObject)args.get(0)).copy(runtime));
    ProrateRuleObject	valueObj = (ProrateRuleObject)args.get(0);
    if (valueObj == null) {
      setErrorObject();
      return null;
    }
    if (!valueObj.isNumber() && !valueObj.isAmount()) {
      error(ProrateAudit.ERR_ILLARG, "Srp_fix:1", runtime);
      return null;
    }
    double	fixValue = (double)0;
    if (valueObj.isAmount()) {
      double	day5Rate = (double)0;
      ProrateDatabase	db = runtime.getAuditImpl().database;
      String currency = ((ProrateRuleAmount)valueObj).getCurrency();
      day5Rate = db.getMeanRate(currency, runtime.audit.getInvoiceMonth());
      if (day5Rate <= (double)0) {
	day5Rate = db.get5dayRate(currency, runtime.audit.getInvoiceMonth());
	/* ;;; error check for day5Rate < 0 (not found) */
	if (day5Rate < (double)0) {
	  if (runtime.audit.getDay5Rate() <= (double)0) {
	    if (db.getResult() > 1) {
	      DBError(runtime, "get5dayRate", currency,
		      runtime.audit.getInvoiceMonth());
	      return null;
	    }
	    int	errorNo = ProrateAudit.ASK_5DAYSPA;
	    StringBuffer	errorMessage = new StringBuffer(currency);
	    errorMessage.append(":");
	    errorMessage.append(runtime.audit.getInvoiceMonth());
	    error(errorNo, errorMessage.toString(), runtime);
	    return null;
	  }
	  day5Rate = runtime.audit.getDay5Rate();
	}
      }
      fixValue = ((ProrateRuleAmount)valueObj).getValue() / day5Rate;
    }
    else {
      fixValue = ((ProrateRuleNumber)valueObj).getValue();
    }
    double	srpValue = (double)0;
    double	totalProrateFactor = (double)0;
    for (int i = 0; i < runtime.fcomp.getSectors().length; i++) {
      totalProrateFactor +=
	((ProrateSector)runtime.fcomp.getSectors()[i]).getProrateFactor();
    }
    srpValue =
      fixValue * runtime.sector.getProrateFactor() / totalProrateFactor;
    if (runtime.isSPA) {
      runtime.sector.setSpaNuc(runtime.sector.getSpaDiscountRate() * srpValue);
      runtime.sector.setProrationType(((runtime.sector.getProrationType()
					& (ProrateAudit.PRT_APDPSET
					   | ProrateAudit.PRT_SPASET))
				       | ProrateAudit.PRT_SPA));
    }
    else {
      runtime.sector.setApdpNuc(runtime.sector.getApdpDiscountRate()
				* srpValue);
      runtime.sector
	.setProrationType(((runtime.sector.getProrationType()
			    & ProrateAudit.PRT_SPA) != 0 ?
			   (runtime.sector.getProrationType()
			    & ProrateAudit.PRT_PRVS) :
			   (ProrateAudit.PRT_APDP | ProrateAudit.PRT_PRVS)));
    }
    setEvaluatedObject(new ProrateRuleBool(true));
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncSrpFix(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("SrpFix(");
    super.dump();
  }

  public String	operatorString() {
    return "SrpFix";
  }
}

class ProrateFuncSia extends ProrateFunc {

  public static final String	SIA_TKCARRIER = "ZZ";

  ProrateFuncSia(List in_args) {
    super(in_args);
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    if (!checkArgnum(0, "Sia", runtime)) {
      return null;
    }
    if (runtime.isSPA) {
      ProrateDatabase	db = runtime.getAuditImpl().database;
      ProrateSector	sector = runtime.sector;
      if (!db.checkSia(sector.getCarrier(), sector.getFlightNo(),
		       sector.getFlightDate())) {
	setEvaluatedObject(new ProrateRuleBool(false));
	return evaluatedObject;
      }
      ProrateRuleObject
	siaRule = new ProrateFuncRule(true, SIA_TKCARRIER,
				      runtime.audit.getAirwayId());
      ((ProrateFuncRule)siaRule).setSkipToActions(false);
      ProrateRuleObject	pobj = siaRule.eval(runtime);
      if (pobj == null) {	/* error occurred */
	return null;
      }
      else if (pobj.isError()) {
	return pobj;
      }
      if ((sector.getProrationType() & ProrateAudit.PRT_SPA) != 0) {
	sector.setProrationType(sector.getProrationType()
				| ProrateAudit.PRT_SIA);
	setEvaluatedObject(new ProrateRuleBool(true));
	return evaluatedObject;
      }
      else {
	setEvaluatedObject(new ProrateRuleBool(false));
	return evaluatedObject;
      }
    }
    else {
      setEvaluatedObject(new ProrateRuleBool(false));
      return evaluatedObject;
    }
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateFuncSia(new Vector(args));
    pobj.isCopied = true;
    return pobj; 
  }

  public void	dump() {
    System.out.print("Sia(");
    super.dump();
  }

  public String	operatorString() {
    return "Sia";
  }
}

class ProrateRuleNumber extends ProrateRuleObject {
  /**
   * @uml.property  name="value"
   */
  protected double	value;

  ProrateRuleNumber(double number) {
    super();
    value = number;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    evaluatedObject = this;
    return this;
  }
  
  boolean	isNumber() {
    return true;
  }

  /**
   * 
   * @uml.property name="value"
   */
  double getValue() {
    return value;
  }

  /**
   * 
   * @uml.property name="value"
   */
  void setValue(double number) {
    value = number;
  }

  
  boolean	equal(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return other.equal(this);
    }
    if (other.isNumber()) {
      return (value == ((ProrateRuleNumber)other).getValue());
    }
    else if (other.isString()) {
      String	cdrStr = ((ProrateRuleString)other).getValue();
      int	cdrNum = Integer.parseInt(cdrStr);
      return (value == cdrNum);
    }
    return false;
  }
  
  boolean	gtEq(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return other.ltEq(this);
    }
    if (other.isNumber()) {
      return (value >= ((ProrateRuleNumber)other).getValue());
    }
    return false;
  }
  
  boolean	ltEq(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return other.gtEq(this);
    }
    if (other.isNumber()) {
      return (value <= ((ProrateRuleNumber)other).getValue());
    }
    return false;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleNumber(value);
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print(" " + value + " ");
  }
  
  void	dumpValue() {
  }
  
  boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
    return true;
  }
  
  public String	toString() {
    return Double.toString(value);
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateRuleDate extends ProrateRuleObject {
  /**
   * @uml.property  name="month"
   */
  private short	month;
  /**
   * @uml.property  name="day"
   */
  private short	day;

  ProrateRuleDate(short in_month, short in_day) {
    month = in_month;
    day = in_day;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    return this;
  }

  boolean	isDate() {
    return true;
  }

  /**
   * 
   * @uml.property name="month"
   */
  short getMonth() {
    return month;
  }

  /**
   * 
   * @uml.property name="day"
   */
  short getDay() {
    return day;
  }

  boolean	equal(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return other.equal(this);
    }
    if (other.isDate()) {
      return (month == ((ProrateRuleDate)other).getMonth()
	      && day == ((ProrateRuleDate)other).getDay());
    }
    return false;
  }

  boolean	gtEq(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return other.ltEq(this);
    }
    if (other.isDate()) {
      return (month > ((ProrateRuleDate)other).getMonth()
	      || (month == ((ProrateRuleDate)other).getMonth()
		  && day >= ((ProrateRuleDate)other).getDay()));
    }
    return false;
  }

  boolean	ltEq(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return other.gtEq(this);
    }
    if (other.isDate()) {
      return (month < ((ProrateRuleDate)other).getMonth()
	      || (month == ((ProrateRuleDate)other).getMonth()
		  && day <= ((ProrateRuleDate)other).getDay()));
    }
    return false;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleDate(month, day);
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    System.out.print(" " + month + "/" + day + " ");
  }
  
  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    return true;
  }
  
  public String	toString() {
    StringBuffer	strbuf = new StringBuffer();
    strbuf.append(month);
    strbuf.append("/");
    strbuf.append(day);
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }
}

class ProrateRuleString extends ProrateRuleObject {
  /**
   * @uml.property  name="value"
   */
  protected String	value;
  protected String	fareBasis;

  ProrateRuleString(String str) {
    super();
    value = str;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    fareBasis = runtime.sector.getFareBasis();
    evaluatedObject = this;
    return this;
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRuleString(value);
    pobj.isCopied = true;
    return pobj;
  }

  public void dump() {
    System.out.print("\"" + value + "\"");
  }
  
  boolean	isString() {
    return true;
  }

  /**
   * 
   * @uml.property name="value"
   */
  String getValue() {
    return value;
  }

  
  boolean	equal(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return (other.equal(this));
    }
    if (other.isNumber()) {
      return (other.equal(this));
    }
    if (!other.isString()) {
      return false;
    }
    String	cdr = ((ProrateRuleString)other).getValue();
    if (isSpecialString(value)) {
      return specialStringEqual(value, cdr);
    }
    if (isSpecialString(cdr)) {
      return specialStringEqual(cdr, value);
    }
    if (isWildString(value)) {
      return match(value, cdr);
    }
    if (isWildString(cdr)) {
      return match(cdr, value);
    }
    return value.equals(cdr);
  }
  
  boolean	gtEq(ProrateRuleObject other) {
    return equal(other);
  }
  
  boolean	ltEq(ProrateRuleObject other) {
    return equal(other);
  }
  
  boolean	include(ProrateRuleObject other) {
    if (other.isMultival() || other.isInterval()) {
      return other.isIncluded(this);
    }
    if (!other.isString()) {
      return false;
    }
    String	cdr = ((ProrateRuleString)other).getValue();
    if (isWildString(value)) {
      return match(value, cdr);
    }
    if (isWildString(cdr)) {
      StringBuffer	expr = new StringBuffer();
      if (cdr.charAt(0) != '*') {
	expr.append("*");
      }
      expr.append(cdr);
      if (cdr.charAt(cdr.length()-1) != '*') {
	expr.append("*");
      }
      return match(expr.toString(), value);
    }
    return (value.indexOf(((ProrateRuleString)other).getValue()) >= 0);
  }
  
  boolean	isSpecialString(String str) {
    return (str.equals("Y-SP") || str.equals("C-SP") || str.equals("F-SP")
	    || str.equals("F#") || str.equals("C#") || str.equals("Y#"));
  }
  
  boolean	specialStringEqual(String car, String cdr) {
    if (car.equals("Y-SP")) {
      return yspEqual(car, cdr);
    }
    if (car.equals("C-SP")) {
      return cspEqual(car, cdr);
    }
    if (car.equals("F-SP")) {
      return fspEqual(car, cdr);
    }
    if (car.equals("F#")) {
      return fEqual(car, cdr);
    }
    if (car.equals("C#")) {
      return cEqual(car, cdr);
    }
    if (car.equals("Y#")) {
      return yEqual(car, cdr);
    }
    return false;
  }
  
  boolean	yspEqual(String car, String cdr) {
    int	fareType;
    fareType = identifyFare(fareBasis);
    if (fareType == FBT_NORMAL_FARE) {
      return false;
    }
    return yEqual(car, cdr);
  }
  
  boolean	cspEqual(String car, String cdr) {
    int	fareType;
    fareType = identifyFare(fareBasis);
    if (fareType == FBT_NORMAL_FARE) {
      return false;
    }
    return cEqual(car, cdr);
  }
  
  boolean	fspEqual(String car, String cdr) {
    int	fareType;
    fareType = identifyFare(fareBasis);
    if (fareType == FBT_NORMAL_FARE) {
      return false;
    }
    return fEqual(car, cdr);
  }
  
  boolean	fEqual(String car, String cdr) {
    return (F_classes.indexOf(cdr.charAt(0)) >= 0);
  }
  
  boolean	cEqual(String car, String cdr) {
    return (C_classes.indexOf(cdr.charAt(0)) >= 0);
  }
  
  boolean	yEqual(String car, String cdr) {
    return (Y_classes.indexOf(cdr.charAt(0)) >= 0);
  }

  static final char	WILD_CHAR = '*';

  boolean	isWildString(String str) {
    return (str.indexOf(WILD_CHAR) >= 0);
  }
  
  boolean	match(String expr, String str) {
    int	strptr = -1;
    int	nextexpr = -1;

    if (expr.charAt(0) == WILD_CHAR) {
      if (expr.length() == 1) {
	return true;
      }
      expr = expr.substring(1);
      for (strptr = str.indexOf(expr.charAt(0));
	   strptr >= 0;
	   strptr = str.indexOf(expr.charAt(0))) {
	if (match(expr, str.substring(strptr))) {
	  return true;
	}
	str = str.substring(strptr+1);
      }
    }
    else {
      nextexpr = expr.indexOf(WILD_CHAR);
      if (nextexpr >= 0) {
	if (str.length() < nextexpr) {
	  return false;
	}
	if (!str.substring(0, nextexpr).equals(expr.substring(0, nextexpr))) {
	  return false;
	}
      }
      else {
	return(str.equals(expr));
      }
      str = str.substring(nextexpr);
      expr = expr.substring(nextexpr + 1);
      if (expr.length() == 0) {
	return true;
      }
      for (strptr = 0;
	   strptr >= 0;
	   strptr = str.indexOf(expr.charAt(0))) {
	if (match(expr, str.substring(strptr))) {
	  return true;
	}
	str = str.substring(strptr+1);
      }
    }
    return false;
  }

  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    return true;
  }
  
  public String	toString() {
    return "\"" + value + "\"";
  }

  String	traceStr() {
    return toString();
  }
  
  public String	getStringValue() {
    return value;
  }
}

class ProrateRulePath extends ProrateRuleObject {
  protected List	value;

  ProrateRulePath(List in_value) {
    value = in_value;
  }

  public ProrateRuleObject	eval(ProrateRuntime runtime) {
    runtime.hops = getLength();
    evaluatedObject = this;
    return this;
  }

  boolean	isPath() {
    return true;
  }

  int	getLength() {
    return value.size();
  }

  ProrateRuleObject	getPlace(int index) {
    return (ProrateRuleObject)value.get(index);
  }

  boolean	equal(ProrateRuleObject other) {
    boolean	status = true;
    if (other.isMultival() || other.isInterval()) {
      return (other.equal(this));
    }
    if (!other.isPath()) {
      return false;
    }
    ProrateRulePath	obj = (ProrateRulePath)other;
    if (value.size() != obj.getLength()) {
      return false;
    }
    for (int i = 0; i < value.size(); i++) {
      if (!this.getPlace(i).equal(obj.getPlace(i))) {
	status = false;
	break;
      }
    }
    if (status) {
      return true;
    }
    status = true;
    for (int j = 0; j < value.size(); j++) {
      if (!this.getPlace(j).equal(obj.getPlace(value.size()-j-1))) {
	status = false;
	break;
      }
    }
    return status;
  }

  boolean	gtEq(ProrateRuleObject other) {
    return equal(other);
  }

  boolean	ltEq(ProrateRuleObject other) {
    return equal(other);
  }

  public ProrateRuleObject	copy(ProrateRuntime runtime) {
    if (isCopied) {
      return this;
    }
    ProrateRuleObject	pobj = new ProrateRulePath(new Vector(value));
    for (int i = 0; i < ((ProrateRulePath)pobj).value.size(); i++) {
      ((ProrateRulePath)pobj).value
	.set(i,
	     ((ProrateRuleObject)((ProrateRulePath)pobj).value.get(i))
	     .copy(runtime));
    }
    pobj.isCopied = true;
    return pobj;
  }

  public void	dump() {
    for (int i = 0; i < value.size(); i++) {
      if (i > 0) {
	System.out.print("-");
      }
      ((ProrateRuleObject)value.get(i)).dump();
    }
  }

  /* ȥ졼 */
  boolean	trace(ProrateSector sector, ProrateTrace trace, int level) {
    return true;
  }

  public String	toString() {
    StringBuffer	strbuf = new StringBuffer();
    for (int i = 0; i < value.size(); i++) {
      if (i > 0) {
	strbuf.append("-");
      }
      strbuf.append(((ProrateRuleObject)value.get(i)).toString());
      if (strbuf.charAt(strbuf.length()-1) == '(') {
	strbuf.append(")");
      }
    }
    return strbuf.toString();
  }

  String	traceStr() {
    return toString();
  }
}
