// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;


import java.io.Serializable;
import java.util.List;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;


/* ץ졼롼빽饹 */

/**
 * class <code>ProrateRuleObjectFactory</code>
 *	is a factory class of ProrateRuleObject classes.
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class ProrateRuleObjectFactory
  implements ProrateRulebaseElementFactory, Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  public ProrateRulebaseElement
    makeNopObject(short regist, String first, String second,
		  String from, String until, String type, String comment) {
    return null;
  }
  
  public ProrateRulebaseElement	makePartObject(String name, List rules,
					       String comment) {
    return (ProrateRulebaseElement)(new ProrateRulePart(name, rules));
  }

  public ProrateRulebaseElement	makeEndObject(String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleEnd());
  }

  public ProrateRulebaseElement
    makeTestObject(List tests, List thens, List elses, String comment) {
    return
      (ProrateRulebaseElement)(new ProrateRuleTest(tests, thens, elses));
  }
  
  public ProrateRulebaseElement	makeAndObject(List clauses, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleAnd(clauses));
  }
  
  public ProrateRulebaseElement	makeOrObject(List clauses, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleOr(clauses));
  }

  public ProrateRulebaseElement	makeJudgeObject(List clauses, String comment) {
    return (ProrateRulebaseElement)null;
  }

  public ProrateRulebaseElement
    makeSwitchObject(List args, List branchacts, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleCase(args, branchacts));
  }

  public ProrateRulebaseElement
    makeBranchObject(List branches, List actions, String comment) {
    return
      (ProrateRulebaseElement)(new ProrateRuleCaseAct(branches, actions));
  }

  public ProrateRulebaseElement
    makeCaseObject(List values, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleCaseBranch(values));
  }
  
  public ProrateRulebaseElement	makeBoolObject(boolean bool, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleBool(bool));
  }

  public ProrateRulebaseElement
    makeReturnObject(ProrateRulebaseElement value, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleReturn(value));
  }

  public ProrateRulebaseElement
    makeMultivalObject(List values, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleMultival(values));
  }

  public ProrateRulebaseElement
    makeIntervalObject(ProrateRulebaseElement lowvalue,
		       ProrateRulebaseElement highvalue, String comment) {
    return
      (ProrateRulebaseElement)(new ProrateRuleInterval(lowvalue,
						       highvalue));
  }

  public ProrateRulebaseElement
    makeAmountObject(String currency, double value, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleAmount(currency, value));
  }
  
  public ProrateRulebaseElement
    makePercentObject(double percent, ProrateRulebaseElement amount,
		      String comment) {
    return
      (ProrateRulebaseElement)(new ProrateRulePercent(percent, amount));
  }
  
  public ProrateRulebaseElement	makeVarObject(short regist, String comment) {
    /* ;;; 楳˳饹Υ󥹥󥹤 */
    switch (regist) {
    case ProrateRulebaseElement.ENDORSE_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarEndorse());
    case ProrateRulebaseElement.RESTRICT_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarRestrict());
    case ProrateRulebaseElement.ORIGIN_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarOrigin());
    case ProrateRulebaseElement.DEST_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarDest());
    case ProrateRulebaseElement.ISSUE_DATE_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarIssueDate());
    case ProrateRulebaseElement.ISSUE_BY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarIssueBy());
    case ProrateRulebaseElement.ISSUE_PLACE_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarIssuePlace());
    case ProrateRulebaseElement.MULTI_PATH_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarMultiPath());
    case ProrateRulebaseElement.FC_FROM_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFcFrom());
    case ProrateRulebaseElement.FC_TO_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFcTo());
    case ProrateRulebaseElement.FC_PATH_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFcPath());
    case ProrateRulebaseElement.ISSUE_COUNTRY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarIssueCountry());
    case ProrateRulebaseElement.ISSUE_AREA_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarIssueArea());
    case ProrateRulebaseElement.ISSUE_AGENT_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarIssueAgent());
    case ProrateRulebaseElement.TOURCODE_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarTourcode());
    case ProrateRulebaseElement.FROM_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFrom());
    case ProrateRulebaseElement.TO_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarTo());
    case ProrateRulebaseElement.F_BASIS_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFBasis());
    case ProrateRulebaseElement.TKDESIGN_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarTkdesign());
    case ProrateRulebaseElement.F_BASIS_ALL_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFBasisAll());
    case ProrateRulebaseElement.CARRIER_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarCarrier());
    case ProrateRulebaseElement.FLIGHT_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFlight());
    case ProrateRulebaseElement.CLASS_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarClass());
    case ProrateRulebaseElement.DATE_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarDate());
    case ProrateRulebaseElement.PATH_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarPath());
    case ProrateRulebaseElement.ROUTE_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarRoute());
    case ProrateRulebaseElement.FROM_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFromAny());
    case ProrateRulebaseElement.TO_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarToAny());
    case ProrateRulebaseElement.F_BASIS_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFBasisAny());
    case ProrateRulebaseElement.TKDESIGN_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarTkdesignAny());
    case ProrateRulebaseElement.F_BASIS_ALL_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFBasisAllAny());
    case ProrateRulebaseElement.CARRIER_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarCarrierAny());
    case ProrateRulebaseElement.FLIGHT_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarFlightAny());
    case ProrateRulebaseElement.CLASS_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarClassAny());
    case ProrateRulebaseElement.DATE_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarDateAny());
    case ProrateRulebaseElement.PATH_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarPathAny());
    case ProrateRulebaseElement.ROUTE_ANY_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarRouteAny());
    case ProrateRulebaseElement.DISCOUNT_VARIABLE:
      return (ProrateRulebaseElement)(new ProrateVarDiscount());
    default:
      return null;
    }
  }

  /* ;;; not implemented yet */
  public ProrateRulebaseElement
    makeExternObject(String extfName, String parentName,
		     List args, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleExtern(extfName, args));
  }

  public ProrateRulebaseElement
    makePartcallObject(String name, String comment) {
    return (ProrateRulebaseElement)(new ProrateRulePartcall(name));
  }

  public ProrateRulebaseElement
    makeFuncObject(short regist, List args, String comment) {
    switch (regist) {
    case ProrateRulebaseElement.SET_CODE:
      return (ProrateRulebaseElement)(new ProrateFuncSet(args));
    case ProrateRulebaseElement.EQUAL_CODE:
      return (ProrateRulebaseElement)(new ProrateFuncEq(args));
    case ProrateRulebaseElement.NEQ_CODE:
      return (ProrateRulebaseElement)(new ProrateFuncNeq(args));
    case ProrateRulebaseElement.STRINC_CODE:
      return (ProrateRulebaseElement)(new ProrateFuncSinc(args));
    case ProrateRulebaseElement.Pfm_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncPfm(args));
    case ProrateRulebaseElement.Pfm_max_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncPfmMax(args));
    case ProrateRulebaseElement.Srp_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncSrp(args));
    case ProrateRulebaseElement.Np_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncNp(args));
    case ProrateRulebaseElement.Apply_discount_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncApplyDiscount(args));
    case ProrateRulebaseElement.Country_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncCountry(args));
    case ProrateRulebaseElement.Area_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncArea(args));
    case ProrateRulebaseElement.Route_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncRoute(args));
    case ProrateRulebaseElement.Via_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncVia(args));
    case ProrateRulebaseElement.Via_country_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncViaCountry(args));
    case ProrateRulebaseElement.Gateway_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncGateway(args));
    case ProrateRulebaseElement.Gateway_country_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncGatewayCountry(args));
    case ProrateRulebaseElement.RoundTheWorld_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncRoundTheWorldP(args));
    case ProrateRulebaseElement.Mileage_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncMileageP(args));
    case ProrateRulebaseElement.Route_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncRouteP(args));
    case ProrateRulebaseElement.Sidetrip_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncSidetripP(args));
    case ProrateRulebaseElement.No_amount_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncNoAmountP(args));
    case ProrateRulebaseElement.Special_fare_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncSpecialFareP(args));
    case ProrateRulebaseElement.Promotional_fare_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncPromotionalFareP(args));
    case ProrateRulebaseElement.Normal_fare_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncNormalFareP(args));
    case ProrateRulebaseElement.Tax_divid_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncTaxDivid(args));
    case ProrateRulebaseElement.Via_area_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncViaArea(args));
    case ProrateRulebaseElement.Discount_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncDiscount(args));
    case ProrateRulebaseElement.Bi_proviso_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncBiProviso(args));
    case ProrateRulebaseElement.Multipath_amt_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncMultipathAmt(args));
    case ProrateRulebaseElement.Uncertain_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncUncertain(args));
    case ProrateRulebaseElement.Number_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncNumberP(args));
    case ProrateRulebaseElement.Date_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncDateP(args));
    case ProrateRulebaseElement.String_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncStringP(args));
    case ProrateRulebaseElement.Amount_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncAmountP(args));
    case ProrateRulebaseElement.Path_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncPathP(args));
    case ProrateRulebaseElement.Error_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncError(args));
    case ProrateRulebaseElement.Within_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateWithinFunc(args));
    case ProrateRulebaseElement.Within_country_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncWithinCountry(args));
    case ProrateRulebaseElement.Within_area_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncWithinArea(args));
    case ProrateRulebaseElement.Intl_sector_p_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncIntlSectorP(args));
    case ProrateRulebaseElement.Between_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateBetweenFunc(args));
    case ProrateRulebaseElement.Between_country_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncBetweenCountry(args));
    case ProrateRulebaseElement.Between_area_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncBetweenArea(args));
    case ProrateRulebaseElement.Between_PC_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncBetweenPC(args));
    case ProrateRulebaseElement.Between_PA_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncBetweenPA(args));
    case ProrateRulebaseElement.Between_CA_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncBetweenCA(args));
    case ProrateRulebaseElement.Exclusive_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncExclusive(args));
    case ProrateRulebaseElement.Another_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncAnother(args));
    case ProrateRulebaseElement.High_spa_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncHighSpa(args));
    case ProrateRulebaseElement.Low_spa_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncLowSpa(args));
    case ProrateRulebaseElement.High_spa_fix_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncHighSpaFix(args));
    case ProrateRulebaseElement.Low_spa_fix_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncLowSpaFix(args));
    case ProrateRulebaseElement.Net_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncNet(args));
    case ProrateRulebaseElement.Srp_fix_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncSrpFix(args));
    case ProrateRulebaseElement.Sia_FUNCTION:
      return (ProrateRulebaseElement)(new ProrateFuncSia(args));
    default:
      return null;
    }
  }

  /**
   * <code>makeApplyObject</code> method creates ProrateFuncRule instance.
   *
   * @param isSpa a <code>boolean</code> value
   * @param carrier a <code>String</code> value
   * @param tkCarrier a <code>String</code> value
   * @param comment a <code>String</code> value
   * @return a <code>ProrateRulebaseElement</code> value
   */
  @Override
    public ProrateRulebaseElement
    makeApplyObject(boolean isSpa, String carrier, String tkCarrier,
		    String comment) {
    return
      (ProrateRulebaseElement)(new ProrateFuncRule(isSpa, carrier, tkCarrier));
  }

  /**
   * Describe <code>makeApplyObject</code> method here.
   *
   * @param isSpa a <code>boolean</code> value
   * @param tkCarrier a <code>String</code> value
   * @param comment a <code>String</code> value
   * @return a <code>ProrateRulebaseElement</code> value
   */
  @Override
    public ProrateRulebaseElement
    makeApplyObject(boolean isSpa,
		    ProrateRulebaseElement carrierElement,
		    ProrateRulebaseElement tkCarrierElement,
		    String comment) {
    String	carrier = null;
    if (carrierElement != null) {
      carrier = ((ProrateRuleObject)carrierElement).getStringValue();
    }
    String	tkCarrier = null;
    if (tkCarrierElement != null) {
      tkCarrier	= ((ProrateRuleObject)tkCarrierElement).getStringValue();
    }
    return makeApplyObject(isSpa, carrier, tkCarrier, comment);
  }

  /**
   * <code>makeApplyObject</code> method creates ProrateFuncRule instance.
   *
   * @param isSpa a <code>boolean</code> value
   * @param carrier a <code>ProrateRulebaseElement</code> value
   * @param tkCarrier a <code>ProrateRulebaseElement</code> value
   * @param comment a <code>String</code> value
   * @return a <code>ProrateRulebaseElement</code> value
   */
  /*
  public ProrateRulebaseElement
    makeApplyObject(boolean isSpa,
		    ProrateRulebaseElement carrier,
		    ProrateRulebaseElement tkCarrier,
		    String comment) {
    return
      (ProrateRulebaseElement)(new ProrateFuncRule(isSpa, carrier, tkCarrier));
  }
  */

  public ProrateRulebaseElement
    makeNumberObject(double number, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleNumber(number));
  }

  public ProrateRulebaseElement
    makeDateObject(short month, short day, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleDate(month, day));
  }
  
  public ProrateRulebaseElement	makeStringObject(String str, String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleString(str));
  }
  
  public ProrateRulebaseElement	makePathObject(List value, String comment) {
    return (ProrateRulebaseElement)(new ProrateRulePath(value));
  }
  
  public ProrateRulebaseElement	makeVarAutoObject(short regist,
						  String varName,
						  String comment) {
    return (ProrateRulebaseElement)(new ProrateVarAuto(regist, varName));
  }

  public ProrateRulebaseElement
    makeTableObject(ProrateRulebaseElement prows,
		    ProrateRulebaseElement pcols,
		    List rows, List cols, List tbls,
		    String comment) {
    return
      (ProrateRulebaseElement)
      (new ProrateRuleTable(prows, pcols, rows, cols, tbls));
  }

  public ProrateRulebaseElement
    makeTableObject(ProrateRulebaseElement pcols, List cols, List tbls,
		    String comment) {
    return
      (ProrateRulebaseElement)
      (new ProrateRuleTable(pcols, cols, tbls));
  }
  
  public ProrateRulebaseElement	makeErrorObject(int error_flag,
						String error_string,
						String comment) {
    return (ProrateRulebaseElement)(new ProrateRuleError(error_flag,
							 error_string));
  }

}
