// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;


import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;

/* ץ졼롼Υǥ */

public class ProrateRuleTop implements ProrateRule {
  protected List	rules;	/* ɾ롼륪֥ȷ */
  /**
   * @uml.property  name="autoVars"
   */
  protected List	autoVars;	/* ưѿơ֥ */

  public ProrateRuleTop() {
    super();
    rules = new Vector();
    autoVars = new Vector();
  }

  public ProrateRuleTop(List in_rules) {
    super();
    rules = in_rules;
    autoVars = new Vector();
  }

  /* ɾ¹ */
  public ProrateRuleObject	eval(ProrateRuntime runtime) throws Exception {
    ProrateRuleObject	ret = null;
    for (int i = 0; i < rules.size(); i++) {
      rules.set(i, ((ProrateRuleObject)rules.get(i)).copy(runtime));
      ret = ((ProrateRuleObject)rules.get(i)).eval(runtime);
      if (!runtime.apply) {
	break;
      }
    }
    return ret;
  }

  public ProrateRule	copy(ProrateRuntime runtime) {
    ProrateRuleTop	pobj = new ProrateRuleTop();
    pobj.rules = new Vector(this.rules);
    pobj.autoVars = new Vector(this.autoVars);
    for (int i = 0; i < pobj.autoVars.size(); i++) {
      pobj.autoVars
	.set(i, ((ProrateRuleObject)pobj.autoVars.get(i)).copy(runtime));
    }
    return pobj;
  }

  /* 롼١ */
  public void	dump() {
    for (int i = 0; i < rules.size(); i++) {
      ((ProrateRuleObject)rules.get(i)).dump();
    }
  }

  public boolean
    trace(ProrateSector sector, ProrateTrace trace, int level) {
    for (int i = 0; i < rules.size(); i++) {
      if (!trace.trace((ProrateRuleObject)rules.get(i), sector, level)) {
	return false;
      }
    }
    return true;
  }

  /**
   * 
   * @uml.property name="autoVars"
   */
  public List getAutoVars() {
    return autoVars;
  }

  /**
   * 
   * @uml.property name="autoVars"
   */
  public void setAutoVars(List vector) {
    autoVars = vector;
  }

  public ProrateRuleObject	getAutoVar(String name) {
    ProrateRuleObject	pobj = null;
    for (int i = 0; i < autoVars.size(); i++) {
      pobj = (ProrateRuleObject)autoVars.get(i);
      if (((ProrateVarAuto)pobj).getName().equals(name)) {
	break;
      }
    }
    if (pobj != null && ((ProrateVarAuto)pobj).getName().equals(name)) {
      return pobj;
    }
    return null;
  }

  public void	addAutoVar(ProrateRuleObject pobj) {
    autoVars.add(pobj);
  }
}
