// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;


/* ץ졼¹ξ֤ݻ륯饹 */

/**
 * @author   maruyama
 */
public class ProrateRuntime {

  /**
   * variable <code>audit</code>	ץ졼оAUDIT
   *
   * @uml.property name="audit"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateAudit audit;

  /**
   * variable <code>fcomp</code>	եݡͥ
   *
   * @uml.property name="fcomp"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateFareComponent fcomp;

  /**
   * variable <code>sector</code>	
   *
   * @uml.property name="sector"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateSector sector;

  /**
   * variable <code>sectorIndex</code>	֥ǥå
   *
   */
  int	sectorIndex;

  /**
   * variable <code>rule</code>	롼
   *
   * @uml.property name="rule"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateRule rule;

  /**
   * variable <code>isSPA</code>	롼̥ե饰
   *
   */
  boolean	isSPA;

  /**
   * variable <code>apply</code>	롼Ŭѥե饰
   *
   */
  boolean	apply;

  /**
   * variable <code>status</code>	¹Իơ
   *
   */
  boolean	status;

  /**
   * variable <code>unifiedSector</code>	unificationоݶ
   *
   * @uml.property name="unifiedSector"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateSector unifiedSector;

  /**
   * variable <code>hops</code>	$MULTI-PATHζֿ
   *
   */
  int	hops;

  /**
   * variable <code>appliedRules</code>	롼ɾ륹å
   *
   */
  List	appliedRules = null;

  /**
   * variable <code>auditImpl</code>	ץ졼󥨥󥸥
   *
   */
  ProrateAuditImpl	auditImpl;

  ProrateRuntime() {
    audit = null;
    fcomp = null;
    sector = null;
    sectorIndex = -1;
    rule = null;
    apply = true;
    status = true;
    unifiedSector = null;
    hops = 2;
  }

  public void	setAPDP(ProrateAudit audit_in,
			ProrateFareComponent fcomp_in,
			ProrateSector sector_in,
			ProrateRule rule_in) {
    isSPA = false;
    set(audit_in, fcomp_in, sector_in, rule_in);
    appliedRules = new Vector();
  }

  public void	setSPA(ProrateAudit audit_in,
		       ProrateFareComponent fcomp_in,
		       ProrateSector sector_in,
		       ProrateRule rule_in) {
    isSPA = true;
    set(audit_in, fcomp_in, sector_in, rule_in);
    appliedRules = new Vector();
  }

  public void	eval() throws Exception {
    rule.eval(this);
  }

  private void set(ProrateAudit audit_in,
		   ProrateFareComponent fcomp_in,
		   ProrateSector sector_in,
		   ProrateRule rule_in) {
    audit = audit_in;
    fcomp = fcomp_in;
    sector = sector_in;
    sectorIndex = -1;
    rule = rule_in;
    apply = true;
    status = true;
    unifiedSector = null;
    hops = 2;
  }
  /**
   * @return  auditImpl ᤷޤ
   * @uml.property  name="auditImpl"
   */
  public ProrateAuditImpl getAuditImpl() {
    return auditImpl;
  }
  /**
   * @param auditImpl  auditImpl ꡣ
   * @uml.property  name="auditImpl"
   */
  public void setAuditImpl(ProrateAuditImpl auditImpl) {
    this.auditImpl = auditImpl;
  }
}
