// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;


/* AUDITζ֤Υǥ */

/**
 * @author   maruyama
 */
public class ProrateSectorImpl {

  /**
   * constant <code>CH_MPRP_DEFAULT_DISCOUNT</code>
   *	CH MPRP fixed fare check default discount rate
   *
   */
  static final String	CH_MPRP_DEFAULT_DISCOUNT = "0.25";

  /**
   * variable <code>sector</code>	ץ졼оݶ־
   *
   */
  ProrateSector	sector;

  public ProrateSectorImpl() {
    super();
  }

  boolean	prorate(ProrateAuditImpl auditImpl,
			ProrateSector sector, ProrateAudit audit,
			ProrateFareComponent fcomp, int sectorIndex)
    throws Exception {
    /* ;;; not implemented yet */
    this.sector = sector;
    ProrateRuntime runtime = new ProrateRuntime();
    runtime.setAuditImpl(auditImpl);

    if ((sector.getProrationType() & ProrateAudit.PRT_MULAPDP) != 0
	|| (sector.getProrationType() & ProrateAudit.PRT_BIPRVS) != 0) {
      /* ¿APDPޤ2PROVISOŬѤƤС̵ */
    }
    else if (audit.isPlusFlg()) {
      /* ץ饹ץ졼ξϡ̵ */
    }
    else {
      /* ֤APDP롼ɤ߹ࡣХ롼ɾ¹Ԥ */
      if (runtime.getAuditImpl().rulebase.selectAPDP(sector.getCarrier(),
						     audit.getIssueDate())) {
	ProrateRule apdpCode, apdpRule;
	apdpCode = new ProrateRuleTop(runtime.getAuditImpl().rulebase.read());
	/* ;;; System.err.println("apdpCode isLoaded=" + apdpCode.isLoaded); */
	apdpRule = ((ProrateRuleTop)apdpCode).copy(runtime);
	/* ;;; apdpRule = apdpCode; */
	/* ;;;
	   runtime.appliedRules[runtime.recursiveCnt] = sector.getCarrier();
	   runtime.setAPDP(audit, fcomp, sector, apdpRule, sectorIndex);
	*/
	runtime.setAPDP(audit, fcomp, sector, apdpRule);
	sector.setApdpDiscountRate((double)1);
	sector.setFixedFareDiscount((double)1);
	initialize(false);
	runtime.eval();
	runtime.getAuditImpl().trace.trace(runtime, "APDP",
					   sector.getCarrier(), "");
	runtime.getAuditImpl().trace.trace(apdpRule, sector, 1);
	runtime.getAuditImpl().rulebase.close();
	apdpRule = null;
	apdpCode = null;
	if (sector.getFixedFareDiscount() < fcomp.getFixedFareDiscount()) {
	  fcomp.setFixedFareDiscount(sector.getFixedFareDiscount());
	}
      }
    }

    if ((sector.getProrationType() & ProrateAudit.PRT_MULSPA) != 0) {
      /* ¿SPAŬѤƤС̵ */
    }
    else if (audit.isInward()
	     && !sector.getCarrier().equals(audit.getInwardId())
	     && !sector.getOpCarrier().equals(audit.getInwardId())) {
      /* Ƕ֤ΥꥢᥭꥢǤʤС̵ */
    }
    else {
      /* ֤SPA롼ɤ߹ࡣХ롼ɾ¹Ԥ */
      if (runtime.getAuditImpl().rulebase.selectSPA(sector.getCarrier(),
						    audit.getAirwayId(),
						    audit.getIssueDate())) {
	ProrateRule spaCode, spaRule;
	spaCode = new ProrateRuleTop(runtime.getAuditImpl().rulebase.read());
	/* ;;; System.err.println("spaCode isLoaded=" + spaCode.isLoaded); */
	spaRule = ((ProrateRuleTop)spaCode).copy(runtime);
	/* ;;; spaRule = spaCode; */
	/* ;;;
	   runtime.appliedRules[runtime.recursiveCnt] = carrier + audit.airwayId;
	   runtime.setSPA(audit, fcomp, sector, spaRule, sectorIndex);
	*/
	runtime.setSPA(audit, fcomp, sector, spaRule);
	sector.setSpaDiscountRate((double)1);
	initialize(true);
	runtime.eval();
	runtime.getAuditImpl().trace.trace(runtime, "SPA",
					   sector.getCarrier(),
					   audit.getAirwayId());
	runtime.getAuditImpl().trace.trace(spaRule, sector, 1);
	runtime.getAuditImpl().rulebase.close();
	spaRule = null;
	spaCode = null;
      }
    }
    runtime = null;
    return true;
  }
  
  boolean	initialize(boolean isSPA) {

    String	propertyFileName = System.getProperty("PRORATE_PROPERTY_FILE");
    if (propertyFileName == null) {
      propertyFileName = System.getProperty("user.home");
      propertyFileName += System.getProperty("file.separator");
      propertyFileName += ".prorate.properties";
      /* ;;; deBug for Windoze */
      String	separator = System.getProperty("file.separator");
      if (separator != null && separator.equals("\\")) {
	String	homeDir = System.getProperty("user.home");
	System.err.println("user.home = " + homeDir);
	System.err.println("file.separator = " + separator);
	propertyFileName = homeDir + separator + "prorate.properties";
	System.err.println("WIN: propertyFileName = " + propertyFileName);
      }
      /* ;;; deBug for Windoze end */
    }
    InputStream	propertyFile = null;
    try {
      propertyFile = new FileInputStream(propertyFileName);
    }
    catch (FileNotFoundException e) {
      propertyFile = null;
    }
    System.err.println("propertyFileName = " + propertyFileName
		       + ", propertyFile = " + propertyFile);
    InputStream	is = null;
    if (propertyFile == null) {
      ClassLoader	loader = Prorate.class.getClassLoader();
      is = loader.getResourceAsStream(Prorate.propertyFile);
    }
    else {
      is = propertyFile;
    }
    Properties	properties = new Properties();
    try {
      properties.load(is);
    } catch (IOException e) {
      // ignore exception
    }
    String	chMprpDiscountStr =
      properties.getProperty("GNP_CH_MPRP", CH_MPRP_DEFAULT_DISCOUNT);
    double	chMprpDiscount = Double.parseDouble(chMprpDiscountStr);

    /* ;;; discount_rt66_init() */
    sector.setFixedFareDiscount((double)1);
    if (isSPA) {
      return true;
    }
    /* ;;; this should be done in Apply_discount
       if (fareBasis.index("CH33") >= 0) {
       sector.setFixedFareDiscount(0.67);
       }
    */
    int	idx;
    if ((idx = sector.getFareBasis().indexOf("CH")) >= 0) {
      String	rate = sector.getFareBasis().substring(idx+2);
      if (rate.length() > 0) {
	char	c = rate.charAt(0);
	if (c < '0' || c > '9') {	/* discountRate not exist */
	  /* Discount(CH_MPRP_VALUE) is applied */
	  sector.setFixedFareDiscount(chMprpDiscount);
	}
	else {	/* always apply discountRate if it is legal (0 < x < 100) */
	  double	percent = Double.parseDouble(rate);
	  if (percent > 0 && percent < 100) {	/* discountRate is legal */
	    sector.setFixedFareDiscount((100 - percent) / 100);	/* apply */
	  }
	}
      }
      else {
	sector.setFixedFareDiscount(0.5); /* Discount(0.5) must be applied */
      }
    }
    return true;
  }
}
