// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.ProrateAuditImpl;


/* TAX ʬ󥸥󥤥󥿡ե */

/**
 * interface <code>ProrateTax</code>	tax dividing engine interface
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public interface ProrateTax {
  /**
   * <code>setEngine</code> method	set audit proration engine
   *
   * @param engine a <code>ProrateAuditImpl</code> value
   */
  void	setEngine(ProrateAuditImpl engine);
  /**
   * <code>divide</code> method	divide tax in audit using database
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>boolean</code> value
   */
  boolean	divide(ProrateAudit audit);
}
