// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;


/* ȥ졼󥿡ե */

public interface ProrateTrace {
  void	setMaxLevel(int maxLevel_in);
  void	setAudit(ProrateAudit audit);
  public boolean	setData(Object data);
  boolean	trace(ProrateFareComponent fcomp, int index,
		      double localValue, double roeRate, double day5Rate);
  boolean	trace(ProrateRuntime runtime, String rule,
		      String carrier, String tkCarrier);
  boolean	trace(ProrateRule rule, ProrateSector sector, int level);
  boolean	trace(ProrateRuleObject pobj, ProrateSector sector,
		      int level);
  boolean	trace(String traceMessage, int sequenceNo, int level);
  boolean	trace(String traceMessage, int sequenceNo);
  boolean	trace(String traceMessage);
  boolean	close();
  boolean	traceFixedFareCheck(boolean pass, ProrateFareComponent fcomp);
  boolean	traceValue(ProrateFareComponent fcomp, int i);
  boolean	traceRest(ProrateAudit audit, double rest,
			  double totalProrateFactor, int i);
  boolean	traceRest(ProrateFareComponent fcomp, double rest,
			  double totalProrateFactor, int i);
  boolean	traceDiscount(ProrateAudit audit, double rest, boolean add_p,
			      double totalProrateFactor, int i);
  boolean	traceTax(ProrateAudit audit, double taxValue,
			 String type, double amount,
			 int sectors, double error, int i);
  boolean	traceCommission(ProrateAudit audit, boolean noAmt,
				double discountedValue,
				int restIndex, double rest);
}
