// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

/* եȥ졼󥿡ե */

/**
 * @author   maruyama
 */
public class ProrateTraceFile extends ProrateTraceImpl {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  /**
   * @uml.property  name="stream"
   */
  PrintStream	stream = System.err;

  /**
   * <code>setData</code> method	set file stream for trace
   *
   * @param data an <code>Object</code> value
   * @return a <code>boolean</code> value
   */
  public boolean	setData(Object data) {
    super.setData(data);
    try {
       setStream(new PrintStream(new FileOutputStream("/tmp/gnpTrace"), true));
     }
     catch (FileNotFoundException e) {
       return false;
     }
    return true;
  }

  public boolean	trace(String traceMessage) {
    if (getMaxLevel() < 0) {
      return true;
    }
    getStream().println("" + getLevel() + ":" + getSequenceNo()
			+ ":" + traceMessage);
    return true;
  }
  
  public boolean	close() {
    getStream().close();
    return true;
  }
  
  /**
   * @return  stream ᤷޤ
   * @uml.property  name="stream"
   */
  public PrintStream getStream() {
    return stream;
  }
  /**
   * @param stream  stream ꡣ
   * @uml.property  name="stream"
   */
  public void setStream(PrintStream stream) {
    this.stream = stream;
  }
}
