// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import java.io.Serializable;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

/* ȥ졼󥿡ե */

/**
 * @author   maruyama
 */
abstract public class ProrateTraceImpl implements ProrateTrace, Serializable {
  /**
   * @uml.property  name="maxLevel"
   */
  int	maxLevel = -1;
  /**
   * @uml.property  name="level"
   */
  int	level = -1;
  ProrateAudit	audit = null;
  /**
   * @uml.property  name="sequenceNo"
   */
  int	sequenceNo = -1;

  /**
   * <code>setData</code> method	set Audit data for trace
   *
   * @param data an <code>Object</code> value
   * @return a <code>boolean</code> value
   */
  public boolean	setData(Object data) {
    setAudit((ProrateAudit)data);
    setMaxLevel(getAudit().getTraceLevel());
    return true;
  }

  /**
   * <code>trace</code> method	trace fare component division
   *
   * @param fcomp a <code>ProrateFareComponent</code> value
   * @param index an <code>int</code> value
   * @param localValue a <code>double</code> value
   * @param roeRate a <code>double</code> value
   * @param day5Rate a <code>double</code> value
   * @return a <code>boolean</code> value
   */
  public boolean
    trace(ProrateFareComponent fcomp, int index,
	  double localValue, double roeRate, double day5Rate) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    String	traceStr = "Fare Component(";
    traceStr += index;
    traceStr += ") {";
    for (int i = 0; i < fcomp.getSectors().length; i++) {
      traceStr += ((ProrateSector)fcomp.getSectors()[i]).getDepCode();
      traceStr += "-";
      traceStr += ((ProrateSector)fcomp.getSectors()[i]).getDestCode();
      traceStr += " ";
    }
    traceStr += "} ";
    traceStr += fcomp.getValue();
    traceStr += " <- ";
    traceStr += localValue;
    traceStr += " * ";
    traceStr += roeRate;
    traceStr += "(roe) / ";
    traceStr += day5Rate;
    traceStr += "(5dy)";
    return trace(traceStr, -1);
  }

  /**
   * <code>trace</code> method	trace SPA/APDP rule application
   *
   * @param runtime a <code>ProrateRuntime</code> value
   * @param rule a <code>String</code> value
   * @param carrier a <code>String</code> value
   * @param tkCarrier a <code>String</code> value
   * @return a <code>boolean</code> value
   */
  public boolean	trace(ProrateRuntime runtime, String rule,
			      String carrier, String tkCarrier) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    ProrateAudit	audit = runtime.audit;
    ProrateSector	sector = runtime.sector;
    String	traceStr = rule;
    boolean
      apply =
      (rule.equals("SPA") ?
       (runtime.sector.getProrationType() & ProrateAudit.PRT_SPA) != 0
       : (runtime.sector.getProrationType() & ProrateAudit.PRT_PRVS) != 0);
    if (apply) {
      traceStr += " applied on [";
    }
    else {
      traceStr += " not applied on [";
    }
    traceStr += sector.getDepCode();
    traceStr += " - ";
    traceStr += sector.getDestCode();
    traceStr += " ";
    traceStr += carrier;
    if (rule.equals("SPA")) {
      traceStr += "/";
      traceStr += tkCarrier;
    }
    traceStr += " (";
    traceStr += audit.getIssueDate();
    traceStr += ")]";
    if (apply) {
      traceStr += " ";
      traceStr += ((rule.equals("SPA") ?
		    sector.getSpaDiscountRate() : sector.getApdpDiscountRate())
		   * 100);
      traceStr += "%of ";
      traceStr += (rule.equals("SPA") ?
		   sector.getSpaBaseAmtType() : sector.getApdpBaseAmtType());
      traceStr +=
	(rule.equals("SPA") ?
	 sector.getSpaBaseAmt() : sector.getApdpBaseAmt());
      traceStr += "(NUC)";
      traceStr +=
	(rule.equals("SPA") ? sector.getSpaNuc() : sector.getApdpNuc());
    }
    return trace(traceStr, sector.getSequenceNo());
  }
  
  /**
   * <code>trace</code> method	trace prorate rule by sector
   *
   * @param rule a <code>ProrateRule</code> value
   * @param sector a <code>ProrateSector</code> value
   * @param level an <code>int</code> value
   * @return a <code>boolean</code> value
   */
  public boolean
    trace(ProrateRule rule, ProrateSector sector, int level) {
    if (getMaxLevel() < level) {
      return true;
    }
    return rule.trace(sector, this, level);
  }

  /**
   * <code>trace</code> method	trace rule object by sector
   *
   * @param pobj a <code>ProrateRuleObject</code> value
   * @param sector a <code>ProrateSector</code> value
   * @param level an <code>int</code> value
   * @return a <code>boolean</code> value
   */
  public boolean	trace(ProrateRuleObject pobj, ProrateSector sector,
			      int level) {
    if (getMaxLevel() < level) {
      return true;
    }
    setLevel(level);
    return	pobj.trace(sector, this, level);
  }
  
  /**
   * <code>trace</code> method	trace with sequence number and setting level
   *
   * @param traceMessage a <code>String</code> value
   * @param sequenceNo an <code>int</code> value
   * @param level an <code>int</code> value
   * @return a <code>boolean</code> value
   */
  public boolean	trace(String traceMessage, int sequenceNo, int level) {
    setLevel(level);
    trace(traceMessage, sequenceNo);
    return true;
  }
  
  /**
   * <code>trace</code> method	trace with sequence number
   *
   * @param traceMessage a <code>String</code> value
   * @param sequenceNo an <code>int</code> value
   * @return a <code>boolean</code> value
   */
  public boolean	trace(String traceMessage, int sequenceNo) {
    setSequenceNo(sequenceNo);
    trace(traceMessage);
    return true;
  }

  /**
   * <code>trace</code> method	record trace execution	ȥ졼Ͽ¹
   *
   * @param traceMessage a <code>String</code> value
   * @return a <code>boolean</code> value
   */
  abstract public boolean	trace(String traceMessage);
  
  /**
   * <code>close</code> method	close trace
   *
   * @return a <code>boolean</code> value
   */
  public boolean	close() {
    return true;
  }

  public boolean
    traceFixedFareCheck(boolean pass, ProrateFareComponent fcomp) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    String	traceStr = "checkFixedFare";
    traceStr += (pass ? " pass: " : " fail: ");
    traceStr += ((ProrateSector)fcomp.getSectors()[0]).getFixedFareCheck();
    traceStr += " >= ";
    traceStr += fcomp.getAudit().getFixedFare();
    traceStr += " * ";
    traceStr += fcomp.getFixedFareDiscount();
    trace(traceStr, -1);
    return true;
  }

  public boolean	traceValue(ProrateFareComponent fcomp, int i) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    String	traceStr = "prorateValue set by ";
    double	nuc = (double)0, rest = (double)0;
    if ((((ProrateSector)fcomp.getSectors()[i]).getProrationType()
	 & ProrateAudit.PRT_SPA) != 0) {
      traceStr += "SPA: ";
      nuc = ((ProrateSector)fcomp.getSectors()[i]).getSpaNuc();
      rest = (((ProrateSector)fcomp.getSectors()[i]).getProratedClassDiff()
	      + (((ProrateSector)fcomp.getSectors()[i])
		 .getProratedSecureCharge()));
    }
    else if ((((ProrateSector)fcomp.getSectors()[i]).getProrationType()
	      & ProrateAudit.PRT_APDP)
	     != 0) {
      traceStr += "APDP: ";
      nuc = ((ProrateSector)fcomp.getSectors()[i]).getApdpNuc();
      rest = (((ProrateSector)fcomp.getSectors()[i]).getProratedClassDiff()
	      + (((ProrateSector)fcomp.getSectors()[i])
		 .getProratedSecureCharge()));
    }
    else {
      traceStr += "SRP: ";
      nuc = ((ProrateSector)fcomp.getSectors()[i]).getSrpNuc();
      rest = (((ProrateSector)fcomp.getSectors()[i]).getProratedClassDiff()
	      + (((ProrateSector)fcomp.getSectors()[i])
		 .getProratedSecureCharge()));
    }
    traceStr += ((ProrateSector)fcomp.getSectors()[i]).getProrateValue();
    traceStr += " = ";
    traceStr += nuc;
    
    traceStr += "(NUC) + ";
    traceStr += rest;
    trace(traceStr,
	  ((ProrateSector)fcomp.getSectors()[i]).getSequenceNo());
    return true;
  }

  public boolean	traceRest(ProrateAudit audit, double rest,
				  double totalProrateFactor, int i) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    String	traceStr = "set rest to proratevalue ";
    traceStr += ((ProrateSector)audit.getSectors()[i]).getProrateValue();
    traceStr += " <-(+=) ";
    if (totalProrateFactor == (double)0) {
      traceStr += rest;
    }
    else {
      traceStr += rest;
      traceStr += " * ";
      traceStr +=
	((ProrateSector)audit.getSectors()[i]).getProrateFactor();
      traceStr += " / ";
      traceStr += totalProrateFactor;
    }
    trace(traceStr,
	  ((ProrateSector)audit.getSectors()[i]).getSequenceNo());
    return true;
  }

  public boolean	traceRest(ProrateFareComponent fcomp, double rest,
				  double totalProrateFactor, int i) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    String	traceStr = "set rest to proratevalue in fcomp ";
    traceStr += ((ProrateSector)fcomp.getSectors()[i]).getProrateValue();
    traceStr += " <-(+=) ";
    if (totalProrateFactor == (double)0) {
      traceStr += rest;
    }
    else {
      traceStr += rest;
      traceStr += " * ";
      traceStr +=
	((ProrateSector)fcomp.getSectors()[i]).getProrateFactor();
      traceStr += " / ";
      traceStr += totalProrateFactor;
    }
    trace(traceStr, ((ProrateSector)fcomp.getSectors()[i]).getSequenceNo());
    return true;
  }

  public boolean
    traceDiscount(ProrateAudit audit, double rest, boolean add_p,
		  double totalProrateFactor, int i) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    String	traceStr = "discount ";
    traceStr += ((ProrateSector)audit.getSectors()[i]).getProrateValue();
    traceStr += (add_p ? " <-(+=) " : " <-(=) ");
    if (totalProrateFactor == (double)0) {
      traceStr += rest;
    }
    else {
      traceStr += rest;
      traceStr += " * ";
      traceStr +=
	((ProrateSector)audit.getSectors()[i]).getProrateFactor();
      traceStr += " / ";
      traceStr += totalProrateFactor;
    }
    trace(traceStr,
	  ((ProrateSector)audit.getSectors()[i]).getSequenceNo());
    return true;
  }

  public boolean
    traceTax(ProrateAudit audit, double taxValue, String type, double amount,
	     int sectors, double error, int i) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    String	traceStr = "tax ";
    traceStr += type;
    traceStr += " set ";
    traceStr += ((ProrateSector)audit.getSectors()[i]).getTax();
    traceStr += " <-(+=) ";
    traceStr += taxValue;
    traceStr += " (";
    traceStr += amount;
    traceStr += " / ";
    traceStr += sectors;
    traceStr += ")";
    if (error != (double)0) {
      traceStr += " + (";
      traceStr += error;
      traceStr += ")";
    }
    trace(traceStr,
	  ((ProrateSector)audit.getSectors()[i]).getSequenceNo());
    return true;
  }

  public boolean	traceCommission(ProrateAudit audit, boolean noAmt,
					double	discountedValue,
					int restIndex, double rest) {
    setLevel(0);
    if (getMaxLevel() < getLevel()) {
      return true;
    }
    if (audit.isOwnAudit() && audit.isTicketing()) {
      for (int i = 0; i < audit.getSectors().length; i++) {
	String	traceStr = "commission set ";
	traceStr += ((ProrateSector)audit.getSectors()[i]).getCommission();
	traceStr += " <- ";
	traceStr +=
	  ((ProrateSector)audit.getSectors()[i]).getProrateValue();
	traceStr += " * ";
	traceStr += audit.getCommissionAmt();
	if (noAmt) {
	  traceStr += "(";
	  traceStr += discountedValue;
	  traceStr += "*";
	  traceStr += audit.getCommissionRate();
	  traceStr += "/100)";
	}
	traceStr += " / ";
	/* ;;; commission from salesFare
	   traceStr += audit.getTicketFare();
	*/
	traceStr += discountedValue;
	if (i == restIndex) {
	  traceStr += " + (";
	  traceStr += rest;
	  traceStr += ")";
	}
	trace(traceStr,
	      ((ProrateSector)audit.getSectors()[i]).getSequenceNo());
	traceStr = "invoiceValue set ";
	traceStr +=
	  ((ProrateSector)audit.getSectors()[i]).getInvoiceValue();
	traceStr += " <- ";
	traceStr +=
	  ((ProrateSector)audit.getSectors()[i]).getProrateValue();
	traceStr += " + ";
	traceStr += ((ProrateSector)audit.getSectors()[i]).getTax();
	traceStr += " - ";
	traceStr += ((ProrateSector)audit.getSectors()[i]).getCommission();
	trace(traceStr,
	      ((ProrateSector)audit.getSectors()[i]).getSequenceNo());
      }
    }
    else {
      for (int i = 0; i < audit.getSectors().length; i++) {
	String	traceStr = "commission set ";
	traceStr += ((ProrateSector)audit.getSectors()[i]).getCommission();
	traceStr += " <- ";
	traceStr +=
	  ((ProrateSector)audit.getSectors()[i]).getProrateValue();
	traceStr += " * ";
	traceStr += audit.getCommissionRate();
	traceStr += " / 100";
	trace(traceStr,
	      ((ProrateSector)audit.getSectors()[i]).getSequenceNo());
	traceStr = "invoiceValue set ";
	traceStr +=
	  ((ProrateSector)audit.getSectors()[i]).getInvoiceValue();
	traceStr += " <- ";
	traceStr +=
	  ((ProrateSector)audit.getSectors()[i]).getProrateValue();
	traceStr += " + ";
	traceStr += ((ProrateSector)audit.getSectors()[i]).getTax();
	traceStr += " - ";
	traceStr += ((ProrateSector)audit.getSectors()[i]).getCommission();
	trace(traceStr,
	      ((ProrateSector)audit.getSectors()[i]).getSequenceNo());
      }
    }
    return true;
  }
  /**
   * @return  maxLevel ᤷޤ
   * @uml.property  name="maxLevel"
   */
  public int getMaxLevel() {
    return maxLevel;
  }
  /**
   * @param maxLevel  maxLevel ꡣ
   * @uml.property  name="maxLevel"
   */
  public void setMaxLevel(int maxLevel) {
    this.maxLevel = maxLevel;
  }
  /**
   * @return  sequenceNo ᤷޤ
   * @uml.property  name="sequenceNo"
   */
  public int getSequenceNo() {
    return sequenceNo;
  }
  /**
   * @param sequenceNo  sequenceNo ꡣ
   * @uml.property  name="sequenceNo"
   */
  public void setSequenceNo(int sequenceNo) {
    this.sequenceNo = sequenceNo;
  }
  /**
   * @return  audit ᤷޤ
   * @uml.property  name="audit"
   */
  public ProrateAudit getAudit() {
    return audit;
  }
  /**
   * @return  level ᤷޤ
   * @uml.property  name="level"
   */
  public int getLevel() {
    return level;
  }
  /**
   * @param audit  audit ꡣ
   * @uml.property  name="audit"
   */
  public void setAudit(ProrateAudit audit) {
    this.audit = audit;
  }
  /**
   * @param level  level ꡣ
   * @uml.property  name="level"
   */
  public void setLevel(int level) {
    this.level = level;
  }
}
