// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.database;


import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.export.Prorate;

public class ProrateRdb implements ProrateDatabase, Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  static final int	CODE_TABLES = 4;
  static final int	CODE_TABLE_NORMAL = 0;
  static final int	CODE_TABLE_SPECIAL = 1;
  static final int	CODE_TABLE_DISCOUNT = 2;
  static final int	CODE_TABLE_IDCHIN = 3;
  static final int	CLASS_TABLES = 3;
  static final int	CLASS_TABLE_FIRST = 0;
  static final int	CLASS_TABLE_BUSINESS = 1;
  static final int	CLASS_TABLE_ECONOMY = 2;

  Object[]	codeTable = null;
  String[]	classTable = null;
  /**
   * @uml.property  name="result"
   */
  int	result = 0;
  /**
   * @uml.property  name="errCode"
   */
  String	errCode = null;
  /**
   * @uml.property  name="errMessage"
   */
  String	errMessage = null;

  /**
   * 
   * @uml.property name="database"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase database = null;

  /**
   * 
   * @uml.property name="rate"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  Rate rate = null;

  /**
   * 
   * @uml.property name="rateRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase rateRdb = null;

  /**
   * 
   * @uml.property name="factor"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateFactor factor = null;

  /**
   * 
   * @uml.property name="factorRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase factorRdb = null;

  /**
   * 
   * @uml.property name="baseAmount"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  BaseAmount baseAmount = null;

  /**
   * 
   * @uml.property name="provisoRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase provisoRdb = null;

  /**
   * 
   * @uml.property name="airCity"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  AirCity airCity = null;

  /**
   * 
   * @uml.property name="aircityRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase aircityRdb = null;

  /**
   * 
   * @uml.property name="multiAirport"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  MultiAirport multiAirport = null;

  /**
   * 
   * @uml.property name="multiRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase multiRdb = null;

  /**
   * 
   * @uml.property name="airline"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  Airline airline = null;

  /**
   * 
   * @uml.property name="airlineRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase airlineRdb = null;

  /**
   * 
   * @uml.property name="codeShare"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  CodeShare codeShare = null;

  /**
   * 
   * @uml.property name="codeShareRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase codeShareRdb = null;

  /**
   * 
   * @uml.property name="fixedFare"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  FixedFareChk fixedFare = null;

  /**
   * 
   * @uml.property name="fixedFareRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase fixedFareRdb = null;

  /**
   * 
   * @uml.property name="tax"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateTaxTable tax = null;

  /**
   * 
   * @uml.property name="taxRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase taxRdb = null;

  /**
   * 
   * @uml.property name="farecode"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  FareCodes farecode = null;

  /**
   * 
   * @uml.property name="farecodeRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase farecodeRdb = null;

  /**
   * 
   * @uml.property name="agent"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  Agent agent = null;

  /**
   * 
   * @uml.property name="agentRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase agentRdb = null;

  /**
   * 
   * @uml.property name="country"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  Country country = null;

  /**
   * 
   * @uml.property name="countryRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase countryRdb = null;

  /**
   * 
   * @uml.property name="classchg"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ClassChg classchg = null;

  /**
   * 
   * @uml.property name="classchgRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase classchgRdb = null;

  /**
   * 
   * @uml.property name="sia"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  Sia sia = null;

  /**
   * 
   * @uml.property name="siaRdb"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  GnpDatabase siaRdb = null;


  public ProrateRdb() {
  }

  public boolean	openDatabase() {
    String	propertyFileName = System.getProperty("PRORATE_PROPERTY_FILE");
    if (propertyFileName == null) {
      propertyFileName = System.getProperty("user.home");
      propertyFileName += System.getProperty("file.separator");
      propertyFileName += ".prorate.properties";
      /* ;;; deBug for Windoze */
      String	separator = System.getProperty("file.separator");
      if (separator != null && separator.equals("\\")) {
	String	homeDir = System.getProperty("user.home");
	System.err.println("user.home = " + homeDir);
	System.err.println("file.separator = " + separator);
	propertyFileName = homeDir + separator + "prorate.properties";
	System.err.println("WIN: propertyFileName = " + propertyFileName);
      }
      /* ;;; deBug for Windoze end */
    }
    InputStream	propertyFile = null;
    try {
      propertyFile = new FileInputStream(propertyFileName);
    }
    catch (FileNotFoundException e) {
      propertyFile = null;
    }
    System.err.println("propertyFileName = " + propertyFileName
		       + ", propertyFile = " + propertyFile);
    InputStream	is = null;
    if (propertyFile == null) {
      ClassLoader	loader = Prorate.class.getClassLoader();
      is = loader.getResourceAsStream(Prorate.propertyFile);
    }
    else {
      is = propertyFile;
    }
    Properties	properties = new Properties();
    try {
      properties.load(is);
    } catch (IOException e2) {
      // ignore exception
    }
    String	driver =
      properties.getProperty("GNP_DATABASE_DRIVER", "org.gjt.mm.mysql.Driver");
    String	url =
      properties.getProperty("GNP_DATABASE_URL",
			     "jdbc:mysql://localhost:3306/gnp");
    String	user =
      properties.getProperty("GNP_DATABASE_USER", "gnp");
    String	passwd =
      properties.getProperty("GNP_DATABASE_PASSWD", "gnp");
    System.err.println("ProrateRdb.openDatabase() "
		       + "driver = " + driver + ", url = " + url
		       + ", user = " + user + ", passwd = " + passwd);

    database = new GnpDatabase();
    database.setDriver(driver);
    database.setUrl(url);
    database.setUser(user);
    database.setPasswd(passwd);
    database.initialize();
    try {
      if (!database.open()) {
	/*NOTREACHED*/
	result = -1;
	errCode = "-1";
	errMessage = "open error";
	return false;
      }
    }
    catch (SQLException e) {
      result = -1;
      errCode = Integer.toString(e.getErrorCode());
      errMessage = e.getMessage();
      return false;
    }

    rate = new Rate();
    rateRdb = new RateRdb();
    rateRdb.setConnection(database.getConnection());
    rateRdb.setStatement(database.getStatement());
    rateRdb.setData(rate);

    factor = new ProrateFactor();
    factorRdb = new FactorRdb();
    factorRdb.setConnection(database.getConnection());
    factorRdb.setStatement(database.getStatement());
    factorRdb.setData(factor);

    baseAmount = new BaseAmount();
    provisoRdb = new ProvisoRdb();
    provisoRdb.setConnection(database.getConnection());
    provisoRdb.setStatement(database.getStatement());
    provisoRdb.setData(baseAmount);

    airCity = new AirCity();
    aircityRdb = new AircityRdb();
    aircityRdb.setConnection(database.getConnection());
    aircityRdb.setStatement(database.getStatement());
    aircityRdb.setData(airCity);

    multiAirport = new MultiAirport();
    multiRdb = new MultiRdb();
    multiRdb.setConnection(database.getConnection());
    multiRdb.setStatement(database.getStatement());
    multiRdb.setData(multiAirport);

    airline = new Airline();
    airlineRdb = new AirlineRdb();
    airlineRdb.setConnection(database.getConnection());
    airlineRdb.setStatement(database.getStatement());
    airlineRdb.setData(airline);

    codeShare = new CodeShare();
    codeShareRdb = new CodeShareRdb();
    codeShareRdb.setConnection(database.getConnection());
    codeShareRdb.setStatement(database.getStatement());
    codeShareRdb.setData(codeShare);

    fixedFare = new FixedFareChk();
    fixedFareRdb = new FixedFareRdb();
    fixedFareRdb.setConnection(database.getConnection());
    fixedFareRdb.setStatement(database.getStatement());
    fixedFareRdb.setData(fixedFare);

    tax = new ProrateTaxTable();
    taxRdb = new TaxRdb();
    taxRdb.setConnection(database.getConnection());
    taxRdb.setStatement(database.getStatement());
    taxRdb.setData(tax);

    agent = new Agent();
    agentRdb = new AgentRdb();
    agentRdb.setConnection(database.getConnection());
    agentRdb.setStatement(database.getStatement());
    agentRdb.setData(agent);

    country = new Country();
    countryRdb = new CountryRdb();
    countryRdb.setConnection(database.getConnection());
    countryRdb.setStatement(database.getStatement());
    countryRdb.setData(country);

    farecodeRdb = new FarecodeRdb();
    farecodeRdb.setConnection(database.getConnection());
    farecodeRdb.setStatement(database.getStatement());
    farecode = new FareCodes();
    farecodeRdb.setData(farecode);
    codeTable = new Object[CODE_TABLES];
    for (int i = 0; i < CODE_TABLES; i++) {
      farecode.type = i;
      if (!farecodeRdb.search()) {
	/* ;;; do not ignore errorCode,errorMessage */
	result = farecode.result;
	errCode = farecode.errCode;
	errMessage = farecode.errMessage;
	return false;
      }
      Object[]	strarray = farecode.codes.toArray();
      Arrays.sort(strarray,
		  new Comparator() {
		    public int compare(Object o1, Object o2) {
		      String	str1 = (String)o1;
		      String	str2 = (String)o2;
		      if (str1.length() > str2.length()) {
			return -1;
		      }
		      if (str1.length() < str2.length()) {
			return 1;
		      }
		      return 0;
		    }
		  }
		  );
      codeTable[i] = strarray;
    }

    classTable = new String[CLASS_TABLES];
    classchgRdb = new ClasschgRdb();
    classchgRdb.setConnection(database.getConnection());
    classchgRdb.setStatement(database.getStatement());
    classchg = new ClassChg();
    classchgRdb.setData(classchg);
    classchg.mainClass = "F";
    if (!classchgRdb.search()) {
      /* ;;; do not ignore errorCode,errorMessage */
      result = classchg.result;
      errCode = classchg.errCode;
      errMessage = classchg.errMessage;
      return false;
    }
    classTable[CLASS_TABLE_FIRST] = classchg.classes;
    classchg.mainClass = "C";
    if (!classchgRdb.search()) {
      /* ;;; do not ignore errorCode,errorMessage */
      result = classchg.result;
      errCode = classchg.errCode;
      errMessage = classchg.errMessage;
      return false;
    }
    classTable[CLASS_TABLE_BUSINESS] = classchg.classes;
    classchg.mainClass = "Y";
    if (!classchgRdb.search()) {
      /* ;;; do not ignore errorCode,errorMessage */
      result = classchg.result;
      errCode = classchg.errCode;
      errMessage = classchg.errMessage;
      return false;
    }
    classTable[CLASS_TABLE_ECONOMY] = classchg.classes;

    sia = new Sia();
    siaRdb = new SiaRdb();
    siaRdb.setConnection(database.getConnection());
    siaRdb.setStatement(database.getStatement());
    siaRdb.setData(sia);

    return true;
  }

  public void	closeDatabase() {
    codeTable = null;
    classTable = null;

    rate = null;
    rateRdb = null;
    factor = null;
    factorRdb = null;
    baseAmount = null;
    provisoRdb = null;
    airCity = null;
    aircityRdb = null;
    multiAirport = null;
    multiRdb = null;
    airline = null;
    airlineRdb = null;
    codeShare = null;
    codeShareRdb = null;
    fixedFare = null;
    fixedFareRdb = null;
    tax = null;
    taxRdb = null;
    farecode = null;
    farecodeRdb = null;
    agent = null;
    agentRdb = null;
    country = null;
    countryRdb = null;
    classchg = null;
    classchgRdb = null;
    sia = null;
    siaRdb = null;

    try {
      database.close();
    }
    catch (SQLException e) {
      result = -1;
      errCode = Integer.toString(e.getErrorCode());
      errMessage = e.getMessage();
    }

    database = null;
  }

  public double	getRoeRate(String currency, String date) {
    rate.currency = currency;
    rate.applyDate = date.substring(0, 6);
    if (!rateRdb.search()) {
      result = rate.result;
      errCode = rate.errCode;
      errMessage = rate.errMessage;
      if (result < 0) {
	System.err.println("rateRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;;r e-open database */
	  return (double)(-1.0);
	}
	rate.currency = currency;
	rate.applyDate = date.substring(0, 6);
	if (!rateRdb.search()) {	/* ;;; retry search */
	  result = rate.result;
	  errCode = rate.errCode;
	  errMessage = rate.errMessage;
	  return (double)(-1.0);
	}
	else {
	  result = rate.result;
	  errCode = rate.errCode;
	  errMessage = rate.errMessage;
	}
      }
      else {
	return (double)(-1.0);
      }
    }
    return rate.roeRate;
  }

  public double	get5dayRate(String currency, String date) {
    rate.currency = currency;
    rate.applyDate = date.substring(0, 6);
    if (!rateRdb.search()) {
      result = rate.result;
      errCode = rate.errCode;
      errMessage = rate.errMessage;
      if (result < 0) {
	System.err.println("rateRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return (double)(-1.0);
	}
	rate.currency = currency;
	rate.applyDate = date.substring(0, 6);
	if (!rateRdb.search()) {	/* ;;; retry search */
	  result = rate.result;
	  errCode = rate.errCode;
	  errMessage = rate.errMessage;
	  return (double)(-1.0);
	}
	else {
	  result = rate.result;
	  errCode = rate.errCode;
	  errMessage = rate.errMessage;
	}
      }
      else {
	return (double)(-1.0);
      }
    }
    return rate.day5Rate;
  }

  public double	getMeanRate(String currency, String date) {
    rate.currency = currency;
    rate.applyDate = date.substring(0, 6);
    if (!rateRdb.search()) {
      result = rate.result;
      errCode = rate.errCode;
      errMessage = rate.errMessage;
      if (result < 0) {
	System.err.println("rateRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return (double)(-1.0);
	}
	rate.currency = currency;
	rate.applyDate = date.substring(0, 6);
	if (!rateRdb.search()) {	/* ;;; retry search */
	  result = rate.result;
	  errCode = rate.errCode;
	  errMessage = rate.errMessage;
	  return (double)(-1.0);
	}
	else {
	  result = rate.result;
	  errCode = rate.errCode;
	  errMessage = rate.errMessage;
	}
      }
      else {
	return (double)(-1.0);
      }
    }
    return rate.meanRate;
  }

  public double	getProrateFactor(String from, String to, String date) {
    int	yy = Integer.parseInt(date.substring(0, 4));
    int	mm = Integer.parseInt(date.substring(4, 6));
    if (mm == 1 || mm == 2) {
      mm = 12;
      yy = yy - 1;
    }
    else {
      mm -= (mm % 3);
    }
    factor.depCity = from;
    factor.destCity = to;
    factor.applyDate = Integer.toString(yy*100+mm) + "01";
    if (!factorRdb.search()) {
      result = factor.result;
      errCode = factor.errCode;
      errMessage = factor.errMessage;
      if (result < 0) {
	System.err.println("factorRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return (double)(-1.0);
	}
	yy = Integer.parseInt(date.substring(0, 4));
	mm = Integer.parseInt(date.substring(4, 6));
	if (mm == 1 || mm == 2) {
	  mm = 12;
	  yy = yy - 1;
	}
	else {
	  mm -= (mm % 3);
	}
	factor.depCity = from;
	factor.destCity = to;
	factor.applyDate = Integer.toString(yy*100+mm) + "01";
	if (!factorRdb.search()) {	/* ;;; retry search */
	  result = factor.result;
	  errCode = factor.errCode;
	  errMessage = factor.errMessage;
	  return (double)(-1.0);
	}
	else {
	  result = factor.result;
	  errCode = factor.errCode;
	  errMessage = factor.errMessage;
	}
      }
      else {
	return (double)(-1.0);
      }
    }
    return factor.prorateFactor;
  }

  public ProrateDatabase.Amount
    getBaseAmount(String from, String to, String carrier,
		  String code, String date) {
    baseAmount.depCity = from;
    baseAmount.destCity = to;
    baseAmount.carrier = carrier;
    baseAmount.class1 = code;
    baseAmount.applyDate = date.substring(0, 6) + "01";
    if (!provisoRdb.search()) {
      result = baseAmount.result;
      errCode = baseAmount.errCode;
      errMessage = baseAmount.errMessage;
      if (result < 0) {
	System.err.println("provisoRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return null;
	}
	baseAmount.depCity = from;
	baseAmount.destCity = to;
	baseAmount.carrier = carrier;
	baseAmount.class1 = code;
	baseAmount.applyDate = date.substring(0, 6) + "01";
	if (!provisoRdb.search()) {	/* ;;; retry search */
	  result = baseAmount.result;
	  errCode = baseAmount.errCode;
	  errMessage = baseAmount.errMessage;
	  return null;
	}
	else {
	  result = baseAmount.result;
	  errCode = baseAmount.errCode;
	  errMessage = baseAmount.errMessage;
	}
      }
      else {
	return null;
      }
    }
    Amount	amount = new Amount();
    amount.currency = baseAmount.currency;
    amount.value = baseAmount.baseAmount;
    return amount;
  }

  public String	getCountryName(String place, String date) {
    airCity.letter3Code = place;
    airCity.applyDate = date;
    if (!aircityRdb.search()) {
      result = airCity.result;
      errCode = airCity.errCode;
      errMessage = airCity.errMessage;
      if (result < 0) {
	System.err.println("aircityRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	airCity.letter3Code = place;
	airCity.applyDate = date;
	if (!aircityRdb.search()) {	/* ;;; retry search */
	  result = airCity.result;
	  errCode = airCity.errCode;
	  errMessage = airCity.errMessage;
	  return "";
	}
	else {
	  result = airCity.result;
	  errCode = airCity.errCode;
	  errMessage = airCity.errMessage;
	}
      }
      else {
	return "";
      }
    }
    return airCity.country;
  }

  public String	getAreaName(String place, String date) {
    airCity.letter3Code = place;
    airCity.applyDate = date;
    if (!aircityRdb.search()) {
      result = airCity.result;
      errCode = airCity.errCode;
      errMessage = airCity.errMessage;
      if (result < 0) {
	System.err.println("aircityRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	airCity.letter3Code = place;
	airCity.applyDate = date;
	if (!aircityRdb.search()) {	/* ;;; retry search */
	  result = airCity.result;
	  errCode = airCity.errCode;
	  errMessage = airCity.errMessage;
	  return "";
	}
	else {
	  result = airCity.result;
	  errCode = airCity.errCode;
	  errMessage = airCity.errMessage;
	}
      }
      else {
	return "";
      }
    }
    return airCity.area;
  }

  public String	getCityName(String place) {
    multiAirport.airport = place;
    if (!multiRdb.search()) {
      result = multiAirport.result;
      errCode = multiAirport.errCode;
      errMessage = multiAirport.errMessage;
      if (result < 0) {
	System.err.println("multiRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	multiAirport.airport = place;
	if (!multiRdb.search()) {	/* ;;; retry search */
	  result = multiAirport.result;
	  errCode = multiAirport.errCode;
	  errMessage = multiAirport.errMessage;
	  if (result < 0) {
	    return "";
	  }
	  return place;
	}
	else {
	  result = multiAirport.result;
	  errCode = multiAirport.errCode;
	  errMessage = multiAirport.errMessage;
	}
      }
      return place;
    }
    return multiAirport.city;
  }

  public String	getAirwayId(String airwayNo, String date) {
    airline.airlineCode = airwayNo;
    airline.applyDate = date;
    if (!airlineRdb.search()) {
      result = airline.result;
      errCode = airline.errCode;
      errMessage = airline.errMessage;
      if (result < 0) {
	System.err.println("airlineRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	airline.airlineCode = airwayNo;
	airline.applyDate = date;
	if (!airlineRdb.search()) {	/* ;;; retry search */
	  result = airline.result;
	  errCode = airline.errCode;
	  errMessage = airline.errMessage;
	  return "";
	}
	else {
	  result = airline.result;
	  errCode = airline.errCode;
	  errMessage = airline.errMessage;
	}
      }
      else {
	return "";
      }
    }
    return airline.letter2Code;
  }

  public String	getAirwayName(String airwayNo, String date) {
    airline.airlineCode = airwayNo;
    airline.applyDate = date;
    if (!airlineRdb.search()) {
      result = airline.result;
      errCode = airline.errCode;
      errMessage = airline.errMessage;
      if (result < 0) {
	System.err.println("airlineRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	airline.airlineCode = airwayNo;
	airline.applyDate = date;
	if (!airlineRdb.search()) {	/* ;;; retry search */
	  result = airline.result;
	  errCode = airline.errCode;
	  errMessage = airline.errMessage;
	  return "";
	}
	else {
	  result = airline.result;
	  errCode = airline.errCode;
	  errMessage = airline.errMessage;
	}
      }
      else {
	return "";
      }
    }
    return airline.airlineName;
  }

  public boolean	checkAirwayId(String airwayId, String date) {
    airline.airlineCode = null;
    airline.letter2Code = airwayId;
    airline.applyDate = date;
    if (!airlineRdb.search()) {
      result = airline.result;
      errCode = airline.errCode;
      errMessage = airline.errMessage;
      if (result < 0) {
	System.err.println("airlineRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return false;
	}
	airline.airlineCode = null;
	airline.letter2Code = airwayId;
	airline.applyDate = date;
	if (!airlineRdb.search()) {	/* ;;; retry search */
	  result = airline.result;
	  errCode = airline.errCode;
	  errMessage = airline.errMessage;
	  return false;
	}
	else {
	  result = airline.result;
	  errCode = airline.errCode;
	  errMessage = airline.errMessage;
	}
      }
      else {
	return false;
      }
    }
    return true;
  }

  public String	getOpCarrier(String carrier, String flightNo, String date) {
    codeShare.tkCarrier = carrier;
    codeShare.flight = flightNo;
    codeShare.applyDate = date;
    codeShare.termscode = '\0';
    codeShare.spacode = '\0';
    if (!codeShareRdb.search()) {
      result = codeShare.result;
      errCode = codeShare.errCode;
      errMessage = codeShare.errMessage;
      if (result < 0) {
	System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	codeShare.tkCarrier = carrier;
	codeShare.flight = flightNo;
	codeShare.applyDate = date;
	codeShare.termscode = '\0';
	codeShare.spacode = '\0';
	if (!codeShareRdb.search()) {	/* ;;; retry search */
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	  return "";
	}
	else {
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	}
      }
      else {
	return "";
      }
    }
    return codeShare.flightCarrier;
  }

  /* obsolete */
  public String	codeShareExcl(String carrier, String flightNo, String date) {
    codeShare.tkCarrier = carrier;
    codeShare.flight = flightNo;
    codeShare.applyDate = date;
    codeShare.termscode = '2';
    codeShare.spacode = '\0';
    if (!codeShareRdb.search()) {
      result = codeShare.result;
      errCode = codeShare.errCode;
      errMessage = codeShare.errMessage;
      if (result < 0) {
	System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	codeShare.tkCarrier = carrier;
	codeShare.flight = flightNo;
	codeShare.applyDate = date;
	codeShare.termscode = '2';
	codeShare.spacode = '\0';
	if (!codeShareRdb.search()) {	/* ;;; retry search */
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	  return "";
	}
	else {
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	}
      }
      else {
	return "";
      }
    }
    if (codeShare.termscode != '2') {
      result = codeShare.result;
      errCode = codeShare.errCode;
      errMessage = codeShare.errMessage;
      return "";
    }
    return codeShare.flightCarrier;
  }

  /* obsolete */
  public String	codeShareIncl(String carrier, String flightNo, String date) {
    codeShare.tkCarrier = carrier;
    codeShare.flight = flightNo;
    codeShare.applyDate = date;
    codeShare.termscode = '1';
    codeShare.spacode = '\0';
    if (!codeShareRdb.search()) {
      result = codeShare.result;
      errCode = codeShare.errCode;
      errMessage = codeShare.errMessage;
      if (result < 0) {
	System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	codeShare.tkCarrier = carrier;
	codeShare.flight = flightNo;
	codeShare.applyDate = date;
	codeShare.termscode = '1';
	codeShare.spacode = '\0';
	if (!codeShareRdb.search()) {	/* ;;; retry search */
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	  return "";
	}
	else {
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	}
      }
      else {
	return "";
      }
    }
    if (codeShare.termscode != '1') {
      result = codeShare.result;
      errCode = codeShare.errCode;
      errMessage = codeShare.errMessage;
      return "";
    }
    return codeShare.flightCarrier;
  }

  /* obsolete?? */
  public String	codeShareSpa(String carrier, String flightNo, String date) {
    codeShare.tkCarrier = carrier;
    codeShare.flight = flightNo;
    codeShare.applyDate = date;
    codeShare.termscode = '\0';
    codeShare.spacode = '1';
    if (!codeShareRdb.search()) {
      result = codeShare.result;
      errCode = codeShare.errCode;
      errMessage = codeShare.errMessage;
      if (result < 0) {
	System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	codeShare.tkCarrier = carrier;
	codeShare.flight = flightNo;
	codeShare.applyDate = date;
	codeShare.termscode = '\0';
	codeShare.spacode = '1';
	if (!codeShareRdb.search()) {	/* ;;; retry search */
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	  return "";
	}
	else {
	  result = codeShare.result;
	  errCode = codeShare.errCode;
	  errMessage = codeShare.errMessage;
	}
      }
      else {
	return "";
      }
    }
    if (codeShare.spacode != '1') {
      result = codeShare.result;
      errCode = codeShare.errCode;
      errMessage = codeShare.errMessage;
      return "";
    }
    return codeShare.flightCarrier;
  }

  public double	getFixedFare(String date) {
    fixedFare.date = date;
    if (!fixedFareRdb.search()) {
      result = fixedFare.result;
      errCode = fixedFare.errCode;
      errMessage = fixedFare.errMessage;
      if (result < 0) {
	System.err.println("fixedFareRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return (double)(-1.0);
	}
	fixedFare.date = date;
	if (!fixedFareRdb.search()) {	/* ;;; retry search */
	  result = fixedFare.result;
	  errCode = fixedFare.errCode;
	  errMessage = fixedFare.errMessage;
	  return (double)(-1.0);
	}
	else {
	  result = fixedFare.result;
	  errCode = fixedFare.errCode;
	  errMessage = fixedFare.errMessage;
	}
      }
      else {
	return (double)(-1.0);
      }
    }
    return fixedFare.fixedFare;
  }

  public ProrateTaxTable	getTaxTable(String taxCode, String date) {
    tax.code = taxCode;
    tax.applyDate = date;
    if (!taxRdb.search()) {
      result = tax.result;
      errCode = tax.errCode;
      errMessage = tax.errMessage;
      if (result < 0) {
	System.err.println("taxRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return null;
	}
	tax.code = taxCode;
	tax.applyDate = date;
	if (!taxRdb.search()) {	/* ;;; retry search */
	  result = tax.result;
	  errCode = tax.errCode;
	  errMessage = tax.errMessage;
	  return null;
	}
	else {
	  result = tax.result;
	  errCode = tax.errCode;
	  errMessage = tax.errMessage;
	}
      }
      else {
	return null;
      }
    }
    return tax;
  }

  public Object[]	getNormalCodes() {
    return (Object[])codeTable[CODE_TABLE_NORMAL];
  }

  public Object[]	getSpecialCodes() {
    return (Object[])codeTable[CODE_TABLE_SPECIAL];
  }

  public Object[]	getDiscountCodes() {
    return (Object[])codeTable[CODE_TABLE_DISCOUNT];
  }

  public Object[]	getIDCHINCodes() {
    return (Object[])codeTable[CODE_TABLE_IDCHIN];
  }

  public String	getAgentCountry(String agentCode, String date) {
    agent.code = agentCode;
    agent.applyDate = date;
    if (!agentRdb.search()) {
      result = agent.result;
      errCode = agent.errCode;
      errMessage = agent.errMessage;
      if (result < 0) {
	System.err.println("agentRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	agent.code = agentCode;
	agent.applyDate = date;
	if (!agentRdb.search()) {	/* ;;; retry search */
	  result = agent.result;
	  errCode = agent.errCode;
	  errMessage = agent.errMessage;
	  return "";
	}
	else {
	  result = agent.result;
	  errCode = agent.errCode;
	  errMessage = agent.errMessage;
	}
      }
      else {
	return "";
      }
    }
    country.code = agent.country;
    country.applyDate = agent.applyDate;
    if (!countryRdb.search()) {
      result = country.result;
      errCode = country.errCode;
      errMessage = country.errMessage;
      if (result < 0) {
	System.err.println("countryRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	country.code = agent.country;
	country.applyDate = agent.applyDate;
	if (!countryRdb.search()) {	/* ;;; retry search */
	  result = country.result;
	  errCode = country.errCode;
	  errMessage = country.errMessage;
	  return "";
	}
	else {
	  result = country.result;
	  errCode = country.errCode;
	  errMessage = country.errMessage;
	}
      }
      else {
	return "";
      }
    }
    return country.country;
  }

  public String	getAgentArea(String agentCode, String date) {
    agent.code = agentCode;
    agent.applyDate = date;
    if (!agentRdb.search()) {
      result = agent.result;
      errCode = agent.errCode;
      errMessage = agent.errMessage;
      if (result < 0) {
	System.err.println("agentRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	agent.code = agentCode;
	agent.applyDate = date;
	if (!agentRdb.search()) {	/* ;;; retry search */
	  result = agent.result;
	  errCode = agent.errCode;
	  errMessage = agent.errMessage;
	  return "";
	}
	else {
	  result = agent.result;
	  errCode = agent.errCode;
	  errMessage = agent.errMessage;
	}
      }
      else {
	return "";
      }
    }
    country.code = agent.country;
    country.applyDate = agent.applyDate;
    if (!countryRdb.search()) {
      result = country.result;
      errCode = country.errCode;
      errMessage = country.errMessage;
      if (result < 0) {
	System.err.println("countryRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return "";
	}
	country.code = agent.country;
	country.applyDate = agent.applyDate;
	if (!countryRdb.search()) {	/* ;;; retry search */
	  result = country.result;
	  errCode = country.errCode;
	  errMessage = country.errMessage;
	  return "";
	}
	else {
	  result = country.result;
	  errCode = country.errCode;
	  errMessage = country.errMessage;
	}
      }
      else {
	return "";
      }
    }
    return country.area;
  }

  /**
   * <code>checkSia</code> method
   *
   * @param carrier a <code>String</code> value
   * @param flightNo a <code>String</code> value
   * @param flightDate a <code>String</code> value
   * @return a <code>boolean</code> value
   */
  public boolean checkSia(String carrier, String flightNo, String flightDate) {
    sia.mkCarrier = carrier;
    sia.flight = flightNo;
    sia.applyDate = flightDate;
    if (!siaRdb.search()) {
      result = sia.result;
      errCode = sia.errCode;
      errMessage = sia.errMessage;
      if (result < 0) {
	System.err.println("siaRdb re-open ProrateRdb.openDatabase() ");
	if (!openDatabase()) {	/* ;;; re-open database */
	  return false;
	}
	sia.mkCarrier = carrier;
	sia.flight = flightNo;
	sia.applyDate = flightDate;
	if (!siaRdb.search()) {	/* ;;; retry search */
	  result = sia.result;
	  errCode = sia.errCode;
	  errMessage = sia.errMessage;
	  return false;
	}
	else {
	  result = sia.result;
	  errCode = sia.errCode;
	  errMessage = sia.errMessage;
	}
      }
      else {
	return false;
      }
    }
    return true;
  }

  public String	getFClasses() {
    return classTable[CLASS_TABLE_FIRST];
  }

  public String	getCClasses() {
    return classTable[CLASS_TABLE_BUSINESS];
  }

  public String	getYClasses() {
    return classTable[CLASS_TABLE_ECONOMY];
  }
  
  /**
   * 
   * @uml.property name="result"
   */
  public int getResult() {
    return result;
  }

  /**
   * 
   * @uml.property name="errCode"
   */
  public String getErrCode() {
    return errCode;
  }

  /**
   * 
   * @uml.property name="errMessage"
   */
  public String getErrMessage() {
    return errMessage;
  }

}

class Rate implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	currency;
  String	applyDate;
  double roeRate;
  double localRate;
  double day5Rate;
  double meanRate;
  int	result;
  String	errCode;
  String	errMessage;
}

class RateRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT roerate, localrate, day5rate, meanrate FROM rate WHERE currency = ? AND applydate = ?";
    
    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((Rate)getData()).currency);
      pstatement.setString(2, ((Rate)getData()).applyDate);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((Rate)getData()).roeRate = (double)0;
	((Rate)getData()).localRate = (double)0;
	((Rate)getData()).day5Rate = (double)0;
	((Rate)getData()).meanRate = (double)0;
	((Rate)getData()).result = 0;
	((Rate)getData()).errCode = "-1";
	((Rate)getData()).errMessage = "not found";
	return false;
      }

      ((Rate)getData()).roeRate = resultSet.getDouble("roerate");
      ((Rate)getData()).localRate = resultSet.getDouble("localrate");
      ((Rate)getData()).day5Rate = resultSet.getDouble("day5rate");
      ((Rate)getData()).meanRate = resultSet.getDouble("meanrate");
      ((Rate)getData()).result = 1;
      ((Rate)getData()).errCode = "";
      ((Rate)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((Rate)getData()).result = -1;
      ((Rate)getData()).errCode = Integer.toString(e.getErrorCode());
      ((Rate)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class ProrateFactor implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	depCity;
  String	destCity;
  String	applyDate;
  double	prorateFactor;
  int	result;
  String	errCode;
  String	errMessage;
}

class FactorRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT proratefactor FROM proratefactor WHERE depcity = ? AND destcity = ? AND applydate = ?";

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((ProrateFactor)getData()).depCity);
      pstatement.setString(2, ((ProrateFactor)getData()).destCity);
      pstatement.setString(3, ((ProrateFactor)getData()).applyDate);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((ProrateFactor)getData()).prorateFactor = (double)0;
	((ProrateFactor)getData()).result = 0;
	((ProrateFactor)getData()).errCode = "-1";
	((ProrateFactor)getData()).errMessage = "not found";
	return false;
      }

      ((ProrateFactor)getData()).prorateFactor =
	resultSet.getDouble("proratefactor");
      ((ProrateFactor)getData()).result = 1;
      ((ProrateFactor)getData()).errCode = "";
      ((ProrateFactor)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((ProrateFactor)getData()).result = -1;
      ((ProrateFactor)getData()).errCode = Integer.toString(e.getErrorCode());
      ((ProrateFactor)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class BaseAmount implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	carrier;
  String	class1;
  String	depCity;
  String	destCity;
  String	applyDate;
  String	currency;
  double baseAmount;
  int	result;
  String	errCode;
  String	errMessage;
}

class ProvisoRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT currency, baseamount FROM baseamount WHERE carrier = ? AND class1 = ? AND depcity = ? AND destcity = ? AND applystart <= ? AND applyexpiration >= ?";

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((BaseAmount)getData()).carrier);
      pstatement.setString(2, ((BaseAmount)getData()).class1);
      pstatement.setString(3, ((BaseAmount)getData()).depCity);
      pstatement.setString(4, ((BaseAmount)getData()).destCity);
      pstatement.setString(5, ((BaseAmount)getData()).applyDate);
      pstatement.setString(6, ((BaseAmount)getData()).applyDate);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((BaseAmount)getData()).currency = "";
	((BaseAmount)getData()).baseAmount = (double)0;
	((BaseAmount)getData()).result = 0;
	((BaseAmount)getData()).errCode = "-1";
	((BaseAmount)getData()).errMessage = "not found";
	return false;
      }

      ((BaseAmount)getData()).currency = resultSet.getString("currency");
      ((BaseAmount)getData()).baseAmount = resultSet.getDouble("baseamount");
      ((BaseAmount)getData()).result = 1;
      ((BaseAmount)getData()).errCode = "";
      ((BaseAmount)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((BaseAmount)getData()).result = -1;
      ((BaseAmount)getData()).errCode = Integer.toString(e.getErrorCode());
      ((BaseAmount)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class AirCity implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	letter3Code;
  String	applyDate;
  String	airportName;
  String	country;
  String	area;
  int	result;
  String	errCode;
  String	errMessage;
}

class AircityRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT airportname, country, area FROM airportm WHERE letter3code = ?";

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((AirCity)getData()).letter3Code);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((AirCity)getData()).airportName = "";
	((AirCity)getData()).country = "";
	((AirCity)getData()).area = "";
	((AirCity)getData()).result = 0;
	((AirCity)getData()).errCode = "-1";
	((AirCity)getData()).errMessage = "not found";
	return false;
      }

      ((AirCity)getData()).airportName = resultSet.getString("airportname");
      ((AirCity)getData()).country = resultSet.getString("country");
      ((AirCity)getData()).area = resultSet.getString("area");
      ((AirCity)getData()).result = 1;
      ((AirCity)getData()).errCode = "";
      ((AirCity)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((AirCity)getData()).result = -1;
      ((AirCity)getData()).errCode = Integer.toString(e.getErrorCode());
      ((AirCity)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class MultiAirport implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	airport;
  String	city;
  int	result;
  String	errCode;
  String	errMessage;
}

class MultiRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query = "SELECT city FROM airportchg WHERE airport = ?";

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((MultiAirport)getData()).airport);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((MultiAirport)getData()).city = "";
	((MultiAirport)getData()).result = 0;
	((MultiAirport)getData()).errCode = "-1";
	((MultiAirport)getData()).errMessage = "not found";
	return false;
      }

      ((MultiAirport)getData()).city = resultSet.getString("city");
      ((MultiAirport)getData()).result = 1;
      ((MultiAirport)getData()).errCode = "";
      ((MultiAirport)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((MultiAirport)getData()).result = -1;
      ((MultiAirport)getData()).errCode = Integer.toString(e.getErrorCode());
      ((MultiAirport)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class Airline implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	airlineCode;
  String	letter2Code;
  String	applyDate;
  String	airlineName;
  int	result;
  String	errCode;
  String	errMessage;
}

class AirlineRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query = null;
    if (((Airline)getData()).airlineCode == null) {
      query = 
	"SELECT airlinecode, letter2code, airlinename FROM airway WHERE letter2code = ?";
    }
    else {
      query = 
	"SELECT airlinecode, letter2code, airlinename FROM airway WHERE airlinecode = ?";
    }

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      if (((Airline)getData()).airlineCode == null) {
	pstatement.setString(1, ((Airline)getData()).letter2Code);
      }
      else {
	pstatement.setString(1, ((Airline)getData()).airlineCode);
      }

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((Airline)getData()).letter2Code = "";
	((Airline)getData()).airlineName = "";
	((Airline)getData()).result = 0;
	((Airline)getData()).errCode = "-1";
	((Airline)getData()).errMessage = "not found";
	System.err.println("ProrateRdb.AirlineRdb.search() "
			   + "letter2Code = "
			   + ((Airline)getData()).letter2Code
			   + " airlineName = "
			   + ((Airline)getData()).airlineName
			   + " result = " + ((Airline)getData()).result
			   + " errCode = " + ((Airline)getData()).errCode
			   + " errMessage = "
			   + ((Airline)getData()).errMessage);
	return false;
      }

      ((Airline)getData()).airlineCode = resultSet.getString("airlinecode");
      ((Airline)getData()).letter2Code = resultSet.getString("letter2code");
      ((Airline)getData()).airlineName = resultSet.getString("airlinename");
      ((Airline)getData()).result = 1;
      ((Airline)getData()).errCode = "";
      ((Airline)getData()).errMessage = "";
      System.err.println("ProrateRdb.AirlineRdb.search() "
			 + "letter2Code = " + ((Airline)getData()).letter2Code
			 + " airlineName = " + ((Airline)getData()).airlineName
			 + " result = " + ((Airline)getData()).result
			 + " errCode = " + ((Airline)getData()).errCode
			 + " errMessage = " + ((Airline)getData()).errMessage);
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((Airline)getData()).result = -1;
      ((Airline)getData()).errCode = Integer.toString(e.getErrorCode());
      ((Airline)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class CodeShare implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	tkCarrier;
  String	flight;
  String	applyDate;
  String	flightCarrier;
  char	termscode;
  char	spacode;
  int	result;
  String	errCode;
  String	errMessage;
}

class CodeShareRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT flightcarrier, termscode, spacode FROM codeshare WHERE mkcarrier = ? AND flightno = ?";

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((CodeShare)getData()).tkCarrier);
      pstatement.setString(2, ((CodeShare)getData()).flight);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((CodeShare)getData()).flightCarrier = "";
	((CodeShare)getData()).termscode = 0;
	((CodeShare)getData()).spacode = '\0';
	((CodeShare)getData()).result = 0;
	((CodeShare)getData()).errCode = "-1";
	((CodeShare)getData()).errMessage = "not found";
	return false;
      }

      ((CodeShare)getData()).flightCarrier =
	resultSet.getString("flightcarrier");
      ((CodeShare)getData()).termscode = (char)resultSet.getByte("termscode");
      ((CodeShare)getData()).spacode = (char)resultSet.getByte("spacode");
      ((CodeShare)getData()).result = 1;
      ((CodeShare)getData()).errCode = "";
      ((CodeShare)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((CodeShare)getData()).result = -1;
      ((CodeShare)getData()).errCode = Integer.toString(e.getErrorCode());
      ((CodeShare)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class FixedFareChk implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	date;
  double fixedFare;
  int	result;
  String	errCode;
  String	errMessage;
}

class FixedFareRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT minimumpercent FROM minimumcheck WHERE startdate <= ? AND enddate >= ?";

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((FixedFareChk)getData()).date);
      pstatement.setString(2, ((FixedFareChk)getData()).date);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((FixedFareChk)getData()).fixedFare = (double)-1;
	((FixedFareChk)getData()).result = 0;
	((FixedFareChk)getData()).errCode = "-1";
	((FixedFareChk)getData()).errMessage = "not found";
	return false;
      }
      ((FixedFareChk)getData()).fixedFare =
	resultSet.getDouble("minimumpercent");
      ((FixedFareChk)getData()).result = 1;
      ((FixedFareChk)getData()).errCode = "";
      ((FixedFareChk)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((FixedFareChk)getData()).result = -1;
      ((FixedFareChk)getData()).errCode = Integer.toString(e.getErrorCode());
      ((FixedFareChk)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

/* ;;; deBug
   class TaxTable implements Serializable {
   String	code;
   String	applyDate;
   String	country;
   List	city;	/* List of Strings #/
   int[]	id;
   int	result;
   String	errCode;
   String	errMessage;
   }
*/

class TaxRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT taxcode, taxcountry, taxcity1, taxcity2, taxcity3, taxcity4, taxcity5, taxcity6, taxcity7, taxcity8, taxcity9, taxcity10, termsnum1, termsnum2, termsnum3 FROM taxcd WHERE taxcode = ?";

    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      /* ;;; deBug end */
      pstatement.setString(1, ((ProrateTaxTable)getData()).code);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      ((ProrateTaxTable)getData()).city = new Vector();
      if (!resultSet.next()) {
	((ProrateTaxTable)getData()).country = "";
	((ProrateTaxTable)getData()).city = null;
	((ProrateTaxTable)getData()).id = null;
	((ProrateTaxTable)getData()).result = 0;
	((ProrateTaxTable)getData()).errCode = "-1";
	((ProrateTaxTable)getData()).errMessage = "not found";
	return false;
      }
      ((ProrateTaxTable)getData()).country = resultSet.getString("taxcountry");
      String	city = "";
      city = resultSet.getString("taxcity1");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city = new Vector();
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity2");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity3");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity4");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity5");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity6");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity7");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity8");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity9");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      city = resultSet.getString("taxcity10");
      if (city != null && city.length() > 0) {
	((ProrateTaxTable)getData()).city.add(city);
      }
      int	numIds = 0;
      int	num1 = resultSet.getInt("termsnum1");
      numIds = (num1 != 0 ? numIds+1 : numIds);
      int	num2 = resultSet.getInt("termsnum2");
      numIds = (num2 != 0 ? numIds+1 : numIds);
      int	num3 = resultSet.getInt("termsnum3");
      numIds = (num3 != 0 ? numIds+1 : numIds);
      ((ProrateTaxTable)getData()).id = new int[numIds];
      int	numId = 0;
      if (num1 != 0) {
	((ProrateTaxTable)getData()).id[numId++] = num1;
      }
      if (num2 != 0) {
	((ProrateTaxTable)getData()).id[numId++] = num2;
      }
      if (num3 != 0) {
	((ProrateTaxTable)getData()).id[numId++] = num3;
      }
      ((ProrateTaxTable)getData()).result = 1;
      ((ProrateTaxTable)getData()).errCode = "";
      ((ProrateTaxTable)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((ProrateTaxTable)getData()).result = -1;
      ((ProrateTaxTable)getData()).errCode
	= Integer.toString(e.getErrorCode());
      ((ProrateTaxTable)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class FareCodes implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  int type;
  List	codes;	/* List of Strings */
  int	result;
  String	errCode;
  String	errMessage;
}

class FarecodeRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    boolean	retval = false;
    String
      query = "SELECT type, code FROM farecodes WHERE type = ? ORDER BY id";
    
    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setInt(1, ((FareCodes)getData()).type);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      ((FareCodes)getData()).codes = new Vector();
      while (resultSet.next()) {
	retval = true;
	String	code = resultSet.getString("code");
	((FareCodes)getData()).codes.add(code);
      }
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((FareCodes)getData()).result = -1;
      ((FareCodes)getData()).errCode = Integer.toString(e.getErrorCode());
      ((FareCodes)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return retval;
  }
}

class Agent implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	code;
  String	agentClass;
  String	applyDate;
  String	country;
  int	result;
  String	errCode;
  String	errMessage;
}

class AgentRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String
      query = "SELECT agentclass, countrycd FROM agency WHERE agentcd = ?";

    PreparedStatement	pstatement = null;

    try {
      /* ŹɤǸ */
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((Agent)getData()).code);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((Agent)getData()).agentClass = "";
	((Agent)getData()).country = "";
	((Agent)getData()).result = 0;
	((Agent)getData()).errCode = "-1";
	((Agent)getData()).errMessage = "not found";
      }
      else {
	((Agent)getData()).agentClass = resultSet.getString("agentclass");
	((Agent)getData()).country = resultSet.getString("countrycd");
	((Agent)getData()).result = 1;
	((Agent)getData()).errCode = "";
	((Agent)getData()).errMessage = "";
	return true;
      }
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((Agent)getData()).result = -1;
      ((Agent)getData()).errCode = Integer.toString(e.getErrorCode());
      ((Agent)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    query = "SELECT agentclass, countrycd FROM agency WHERE iataagentcd = ?";

    try {
      /* IATAŹɤǸ */
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((Agent)getData()).code);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((Agent)getData()).agentClass = "";
	((Agent)getData()).country = "";
	((Agent)getData()).result = 0;
	((Agent)getData()).errCode = "-1";
	((Agent)getData()).errMessage = "not found";
	return false;
      }

      ((Agent)getData()).agentClass = resultSet.getString("agentclass");
      ((Agent)getData()).country = resultSet.getString("countrycd");
      ((Agent)getData()).result = 1;
      ((Agent)getData()).errCode = "";
      ((Agent)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((Agent)getData()).result = -1;
      ((Agent)getData()).errCode = Integer.toString(e.getErrorCode());
      ((Agent)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}

class Country implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	code;
  String	country;
  String	applyDate;
  String	area;
  int	result;
  String	errCode;
  String	errMessage;
}

class CountryRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    if (((Country)getData()).country != null
	&& ((Country)getData()).country.length() > 0) {
      String	query = "SELECT area FROM country WHERE country = ?";

      PreparedStatement	pstatement = null;
      try {
	pstatement = getConnection().prepareStatement(query);

	// ѥ᡼
	pstatement.setString(1, ((Country)getData()).country);

	// 䤤碌μ¹
	ResultSet	resultSet = pstatement.executeQuery();

	if (!resultSet.next()) {
	  ((Country)getData()).area = "";
	  ((Country)getData()).result = 0;
	  ((Country)getData()).errCode = "-1";
	  ((Country)getData()).errMessage = "not found";
	  return false;
	}

	((Country)getData()).area = resultSet.getString("area");
	((Country)getData()).result = 1;
	((Country)getData()).errCode = "";
	((Country)getData()).errMessage = "";
      }
      catch (SQLException e) {
	System.err.println("catch SQLException");
	((Country)getData()).result = -1;
	((Country)getData()).errCode = Integer.toString(e.getErrorCode());
	((Country)getData()).errMessage = e.getMessage();
	return false;
      }
      finally {
	if (pstatement != null) {
	  try {
	    pstatement.close();
	  } catch (SQLException e) {
	  }
	}
      }

      return true;
    }
    else {
      String query = "SELECT country, area FROM country WHERE countrycd = ?";

      PreparedStatement	pstatement = null;
      try {
	pstatement = getConnection().prepareStatement(query);

	// ѥ᡼
	pstatement.setString(1, ((Country)getData()).code);

	// 䤤碌μ¹
	ResultSet	resultSet = pstatement.executeQuery();

	if (!resultSet.next()) {
	  ((Country)getData()).country = "";
	  ((Country)getData()).area = "";
	  ((Country)getData()).result = 0;
	  ((Country)getData()).errCode = "-1";
	  ((Country)getData()).errMessage = "not found";
	  return false;
	}

	((Country)getData()).country = resultSet.getString("country");
	((Country)getData()).area = resultSet.getString("area");
	((Country)getData()).result = 1;
	((Country)getData()).errCode = "";
	((Country)getData()).errMessage = "";
      }
      catch (SQLException e) {
	System.err.println("catch SQLException");
	((Country)getData()).result = -1;
	((Country)getData()).errCode = Integer.toString(e.getErrorCode());
	((Country)getData()).errMessage = e.getMessage();
	return false;
      }
      finally {
	if (pstatement != null) {
	  try {
	    pstatement.close();
	  } catch (SQLException e) {
	  }
	}
      }

      return true;
    }
  }
}

class ClassChg implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	mainClass;
  String	classes;
  int	result;
  String	errCode;
  String	errMessage;
}

class ClasschgRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    boolean	retval = false;
    String
      query = "SELECT class FROM classchg WHERE mainclass = ? ORDER BY class";
    
    StringBuffer	classes = null;
    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((ClassChg)getData()).mainClass);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      classes = new StringBuffer();
      while (resultSet.next()) {
	retval = true;
	String	cls = resultSet.getString("class");
	classes.append(cls);
      }
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((ClassChg)getData()).result = -1;
      ((ClassChg)getData()).errCode = Integer.toString(e.getErrorCode());
      ((ClassChg)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    ((ClassChg)getData()).classes = classes.toString();

    return retval;
  }
}

class Sia implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  String	mkCarrier;
  String	flight;
  String	applyDate;
  String	flightCarrier;
  char	codeShareFlag;
  int	result;
  String	errCode;
  String	errMessage;
}

class SiaRdb extends GnpDatabase implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  /**
   * <code>search</code> method	ǡ١θ¹Ԥ
   *
   * @return a <code>boolean</code> value	
   * @exception SQLException if an error occurs
   */
  public boolean search() {
    String	query =
      "SELECT flightcarrier, codeshareflag FROM sia WHERE mkcarrier = ? AND flightno = ? AND applystart <= ? AND applyexpiration >= ?";
    
    PreparedStatement	pstatement = null;
    try {
      pstatement = getConnection().prepareStatement(query);

      // ѥ᡼
      pstatement.setString(1, ((Sia)getData()).mkCarrier);
      pstatement.setString(2, ((Sia)getData()).flight);
      pstatement.setString(3, ((Sia)getData()).applyDate);
      pstatement.setString(4, ((Sia)getData()).applyDate);

      // 䤤碌μ¹
      ResultSet	resultSet = pstatement.executeQuery();
    
      if (!resultSet.next()) {
	((Sia)getData()).flightCarrier = "";
	((Sia)getData()).codeShareFlag = 0;
	((Sia)getData()).result = 0;
	((Sia)getData()).errCode = "-1";
	((Sia)getData()).errMessage = "not found";
	return false;
      }

      ((Sia)getData()).flightCarrier =
	resultSet.getString("flightcarrier");
      ((Sia)getData()).codeShareFlag =
	(char)resultSet.getByte("codeshareflag");
      ((Sia)getData()).result = 1;
      ((Sia)getData()).errCode = "";
      ((Sia)getData()).errMessage = "";
    }
    catch (SQLException e) {
      System.err.println("catch SQLException");
      ((Sia)getData()).result = -1;
      ((Sia)getData()).errCode = Integer.toString(e.getErrorCode());
      ((Sia)getData()).errMessage = e.getMessage();
      return false;
    }
    finally {
      if (pstatement != null) {
	try {
	  pstatement.close();
	} catch (SQLException e) {
	}
      }
    }

    return true;
  }
}
