// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.ejb;

import javax.ejb.Stateless;

import jp.sourceforge.gnp.prorate.export.ProrateException;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.dcheck.ejb.interfaces.CheckEjb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebaseLru;
import jp.sourceforge.gnp.prorate.ProrateDatabase;

/**
 * @ejb.bean name="ProrateEjb"
 *           display-name="Name for ProrateEjb"
 *           description="Description for ProrateEjb"
 *           jndi-name="ejb/ProrateEjb"
 *           type="Stateless"
 *           view-type="both"
 */
@Stateless
  public class ProrateCheckEjbBean implements ProrateEjb, CheckEjb {

    /**
     * variable <code>prorate</code>	proration饹
     *
     */
    ProrateImpl	prorate = null;

    /**
     * Creates a new <code>ProrateEjbBean</code> instance.
     *
     * @exception Exception if an error occurs
     */
    public ProrateCheckEjbBean() throws Exception {
      super();
      ProrateRulebase rulebase = null;
      try {
	/* ;;;
	   rulebase = new XmlRulebase();
	   XmlRulebase.initialize();
	*/
	rulebase = new XmlRulebaseLru();
	XmlRulebaseLru.initialize();
      } catch (Exception e) {
	e.printStackTrace();
	throw new ProrateException("error in rulebase initialize", e);
      }
      ProrateRulebaseElementFactory factory = new ProrateRuleObjectFactory();
      rulebase.setElementFactory(factory);
      prorate = new ProrateImpl();
      prorate.setRulebase(rulebase);
      prorate.setFcalc(new ProrateFCalcImpl());
      prorate.setTax(new ProrateTaxImpl());
      ProrateTrace	trace = new ProrateTraceString();
      prorate.setTrace(trace);
      prorate.setDatabase(new ProrateRdb());
      if (!prorate.getDatabase().openDatabase()) {
	throw new ProrateException("database open error:"
				   + prorate.getDatabase().getErrMessage(),
				   null);
      }
    }

    /**
     * Business method <code>prorate</code>
     *
     * @throws ProrateException 
     * @ejb.interface-method  view-type = "both"
     */
    public ProrateAudit prorate(ProrateAudit audit) throws ProrateException {
      prorate.getTrace().setData(audit);
      ProrateAudit	auditRet = null;
      try {
	auditRet = prorate.prorate(audit);
      }
      catch(Exception e) {
	e.printStackTrace();
	throw new ProrateException("error in prorate", e);
      }
      prorate.getTrace().close();
      ProrateTraceString traceString = (ProrateTraceString)prorate.getTrace();
      String[]	stringsArray = new String[traceString.getStrings().size()];
      for (int i = 0; i < traceString.getStrings().size(); i++) {
	stringsArray[i] = (String)(traceString.getStrings().get(i));
      }
      auditRet.setTraceStrings(stringsArray);
      return auditRet;
    }

    /**
     * Business method <code>checkCountryName</code>
     *
     * @param countryName a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @ejb.interface-method  view-type = "both"
     */
    public boolean checkPlace( String place, String date )
      throws ProrateException {
      ProrateDatabase	database = prorate.getDatabase();
      String	country = database.getCountryName(place, date);
      if (country == null || country == "") {
	return false;
      }
      return true;
    }

    /**
     * Business method <code>checkAirwayId</code>
     *
     * @param airwayId a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @ejb.interface-method  view-type = "both"
     */
    public boolean checkAirwayId( String airwayId, String date )
      throws ProrateException {
      ProrateDatabase	database = prorate.getDatabase();
      boolean	retval = database.checkAirwayId(airwayId, date);
      System.err.println("CheckEjb.checkAirwayId() "
			 + "airwayId = " + airwayId
			 + " date = " + date + " retval = " + retval
			 + " result = " + database.getResult()
			 + " errCode = " + database.getErrCode()
			 + " errMessage = " + database.getErrMessage());
      return retval;
    }

    /**
     * Business method <code>checkAirwayNo</code>
     *
     * @param airwayNo a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @ejb.interface-method  view-type = "both"
     */
    public boolean checkAirwayNo( String airwayNo, String date )
      throws ProrateException {
      ProrateDatabase	database = prorate.getDatabase();
      String	airwayId = database.getAirwayId(airwayNo, date);
      System.err.println("CheckEjb.checkAirwayNo() "
			 + "airwayNo = " + airwayNo
			 + " date = " + date + " airwayId = " + airwayId
			 + " result = " + database.getResult()
			 + " errCode = " + database.getErrCode()
			 + " errMessage = " + database.getErrMessage());
      if (airwayId == null || airwayId == "") {
	return false;
      }
      return true;
    }

    /**
     * Business method <code>checkCurrency</code>
     *
     * @param currency a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @ejb.interface-method  view-type = "both"
     */
    public boolean checkCurrency( String currency, String date )
      throws ProrateException {
      ProrateDatabase	database = prorate.getDatabase();
      double	roeRate = database.getRoeRate(currency, date);
      System.err.println("CheckEjb.checkCurrency() "
			 + "currency = " + currency
			 + " date = " + date + " roeRate = " + roeRate
			 + " result = " + database.getResult()
			 + " errCode = " + database.getErrCode()
			 + " errMessage = " + database.getErrMessage());
      if (roeRate < (double)0) {
	return false;
      }
      return true;
    }

  }
