// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.ejb;

import javax.ejb.Stateless;

import jp.sourceforge.gnp.prorate.export.ProrateException;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebaseLru;
import jp.sourceforge.gnp.prorate.ProrateDatabase;

/**
 * @ejb.bean name="ProrateEjb"
 *           display-name="Name for ProrateEjb"
 *           description="Description for ProrateEjb"
 *           jndi-name="ejb/ProrateEjb"
 *           type="Stateless"
 *           view-type="both"
 */
@Stateless
  public class ProrateEjbBean implements ProrateEjb {

    /**
     * variable <code>prorate</code>	proration饹
     *
     */
    ProrateImpl	prorate = null;

    /**
     * Creates a new <code>ProrateEjbBean</code> instance.
     *
     * @exception Exception if an error occurs
     */
    public ProrateEjbBean() throws Exception {
      super();
      ProrateRulebase rulebase = null;
      try {
	/* ;;;
	   rulebase = new XmlRulebase();
	   XmlRulebase.initialize();
	*/
	rulebase = new XmlRulebaseLru();
	XmlRulebaseLru.initialize();
      } catch (Exception e) {
	e.printStackTrace();
	throw new ProrateException("error in rulebase initialize", e);
      }
      ProrateRulebaseElementFactory factory = new ProrateRuleObjectFactory();
      rulebase.setElementFactory(factory);
      prorate = new ProrateImpl();
      prorate.setRulebase(rulebase);
      prorate.setFcalc(new ProrateFCalcImpl());
      prorate.setTax(new ProrateTaxImpl());
      ProrateTrace	trace = new ProrateTraceString();
      prorate.setTrace(trace);
      prorate.setDatabase(new ProrateRdb());
      if (!prorate.getDatabase().openDatabase()) {
	throw new ProrateException("database open error:"
				   + prorate.getDatabase().getErrMessage(),
				   null);
      }
    }

    /**
     * Business method <code>prorate</code>
     *
     * @throws ProrateException 
     * @ejb.interface-method  view-type = "both"
     */
    public ProrateAudit prorate(ProrateAudit audit) throws ProrateException {
      prorate.getTrace().setData(audit);
      ProrateAudit	auditRet = null;
      try {
	auditRet = prorate.prorate(audit);
      }
      catch(Exception e) {
	e.printStackTrace();
	throw new ProrateException("error in prorate", e);
      }
      prorate.getTrace().close();
      ProrateTraceString traceString = (ProrateTraceString)prorate.getTrace();
      String[]	stringsArray = new String[traceString.getStrings().size()];
      for (int i = 0; i < traceString.getStrings().size(); i++) {
	stringsArray[i] = (String)(traceString.getStrings().get(i));
      }
      auditRet.setTraceStrings(stringsArray);
      return auditRet;
    }
  }
