// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.ejb.client;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;

public class ProrateEjbClient {
  
  /**
   * <code>makeInstance</code> method
   *	creates and returnsProrateEjb client instance
   *
   * @return a <code>ProrateEjb</code> value
   * @throws NamingException 
   */
  static public ProrateEjb	makeInstance() throws NamingException {

    /**
     * variable <code>prorate</code>	ProrateEjb EJB3 object
     *
     */
    ProrateEjb	prorate = null;

    Context context = null;
    try {
      context = new InitialContext();
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    Object ref = null;
    try {
      ref = context.lookup(ProrateEjb.JNDI_NAME);
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    prorate = (ProrateEjb)ref;
    return prorate;
  }
}

