// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.export;



/**
 * interface <code>Prorate</code>
 *	the interface for executing proration calculation
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
/* ץ졼¹Ԥ륤󥿡ե */
public interface Prorate {
  /**
   * constant <code>propertyFile</code>
   *	property file name for Prorate application in gnp.prorate package.
   *
   */
  public static final
    String propertyFile = "jp/sourceforge/gnp/prorate.properties";

  /**
   * <code>prorate</code> method
   *	execute proration calculation and return the result of the calculation
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateAudit</code> value
   * @exception exception if an error occurs
   */
  /* ץ졼¹Ԥ̤֤ */
  ProrateAudit	prorate(ProrateAudit audit) throws Exception;
}
