// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.export;

import java.io.Serializable;

/*
 * Ask information Table
 *
 * Class ProrateAskTable
 *
 * Member
 *	bool	isArea	: the flag whether the asking is area or not
 *	String	place	: City name 3Letter
 *	String	answer	: Answer(Country name string or Area name string)
 */

/**
 * class <code>ProrateAskTable</code>
 *	the ask table for values which is not found in the database
 * @author  <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class ProrateAskTable implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  /**
   * variable <code>isArea</code>
   *	the flag tells whether the questioning value is area name
   * @uml.property  name="isArea"
   */
  public boolean isArea;
  /**
   * variable <code>place</code>
   *	key string (3letter code of the city or airport)
   * @uml.property  name="place"
   */
  public String	place;
  /**
   * variable <code>answer</code>
   *	answer value string which is the country or the area for the key
   * @uml.property  name="answer"
   */
  public String	answer;

  /**
   * Creates a new <code>ProrateAskTable</code> instance.
   *
   */
  public ProrateAskTable() {
    super();
  }

  /**
   * @return  answer
   * @uml.property  name="answer"
   */
  public String getAnswer() {
    return answer;
  }

  /**
   * @param  answer
   * @uml.property  name="answer"
   */
  public void setAnswer(String answer) {
    this.answer = answer;
  }

  /**
   * @return  isArea
   * @uml.property  name="isArea"
   */
  public boolean isArea() {
    return isArea;
  }

  /**
   * @param  area
   * @uml.property  name="isArea"
   */
  public void setArea(boolean isArea) {
    this.isArea = isArea;
  }

  /**
   * @return  place
   * @uml.property  name="place"
   */
  public String getPlace() {
    return place;
  }

  /**
   * @param  place
   * @uml.property  name="place"
   */
  public void setPlace(String place) {
    this.place = place;
  }
}
