// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.export;

import java.io.Serializable;

/**
 * class <code>ProrateAudit</code>
 *	The model of the whole audit (of all sectors in the itineraty).
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */
/* model of the AUDIT whole data */
public class ProrateAudit implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  /* fare component types */
  /**
   * constant <code>FCT_MILEAGE</code>	fare component type: Mileage
   *
   */
  public static final int FCT_MILEAGE = 1;
  /**
   * constant <code>FCT_MILEAGE</code>	fare component type: Route
   *
   */
  public static final int FCT_ROUTE = 2;
  /**
   * constant <code>FCT_MILEAGE</code>	fare component type: Side Trip
   *
   */
  public static final int FCT_SIDETRIP = 3;

  /* proration types */
  /**
   * constant <code>PRT_SPA</code>
   *	proration type: prorate value is set by SPA
   *
   */
  public static final int PRT_SPA = 0x01000000;

  /**
   * constant <code>PRT_APDP</code>
   *	proration type: prorate value is set by APDP
   *
   */
  public static final int PRT_APDP = 0x02000000;
  /**
   * constant <code>PRT_SPA</code>
   *	proration type: prorate value is set by SIA
   *
   */
  public static final int PRT_SIA = 0x04000000;
  /**
   * constant <code>PRT_HIGHSPA</code>
   *	proration type:	prorate value is set by SPA
   *	when the SPA is higher than the normal value
   *
   */
  public static final int PRT_HIGHSPA = 0x10000000;
  /**
   * constant <code>PRT_LOWSPA</code>
   *	proration type:	prorate value is set by SPA
   *	when the SPA is lower than the normal value
   *
   */
  public static final int PRT_LOWSPA = 0x20000000;
  /**
   * constant <code>PRT_HIGHSPAFIX</code>
   *	proration type:	prorate value is set by SPA
   *	when the SPA is higher than the specified value
   *
   */
  public static final int PRT_HIGHSPAFIX = 0x40000000;
  /**
   * constant <code>PRT_LOWSPAFIX</code>
   *	proration type:	prorate value is set by SPA
   *	when the SPA is lower than the specified value
   *
   */
  public static final int PRT_LOWSPAFIX = 0x80000000;
  /**
   * constant <code>PRT_PFM</code>
   *	proration type: prorate value is set to base amount in PFM
   *
   */
  public static final int PRT_PFM = 0x00010000;
  /**
   * constant <code>PRT_FIX</code>
   *	proration type: prorate value is set to fixed amount
   *	described in the rule.
   *
   */
  public static final int PRT_FIX = 0x00020000;
  /**
   * constant <code>PRT_FIXSRP</code>
   *	proration type: prorate value is set to srp result as the fixed amount
   *
   */
  public static final int PRT_FIXSRP = 0x00040000;
  /**
   * constant <code>PRT_NP</code>
   *	proration type: prorate value is set to SPA value
   *	set by the normal proration value
   *
   */
  public static final int PRT_NP = 0x00080000;
  /**
   * constant <code>PRT_UCCY</code>
   *	proration type:
   *	currency of the prorate value is set by the user by hand
   *
   */
  public static final int PRT_UCCY = 0x00001000;
  /**
   * constant <code>PRT_UBASE</code>
   *	proration type:
   *	base amount of the prorate value is set by the user by hand
   *
   */
  public static final int PRT_UBASE = 0x00002000;
  /**
   * constant <code>PRT_UDIS</code>
   *	proration type:
   *	discount rate of the prorate value is set by the user by hand
   *
   */
  public static final int PRT_UDIS = 0x00004000;
  /**
   * constant <code>PRT_UPFACT</code>
   *	proration type:	prorate factor is set by the user by hand
   *
   */
  public static final int PRT_UPFACT = 0x00008000;
  /**
   * constant <code>PRT_USPA</code>
   *	proration type:	SPA value is set by the user by hand
   *
   */
  public static final int PRT_USPA = 0x00100000;
  /**
   * constant <code>PRT_UAPDP</code>
   *	proration type:	APDP value is set by the user by hand
   *
   */
  public static final int PRT_UAPDP = 0x00200000;
  /**
   * constant <code>PRT_PRVS</code>
   *	proration type:	APDP Proviso is set
   *
   */
  public static final int PRT_PRVS = 0x00000100; 
  /**
   * constant <code>PRT_MULSPA</code>
   *	proration type:	SPA for multiple sectors are set
   *
   */
  public static final int PRT_MULSPA = 0x00000200; 
  /**
   * constant <code>PRT_BIPRVS</code>
   *	proration type:	Proviso for bi sectors are set
   *
   */
  public static final int PRT_BIPRVS = 0x00000400;
  /**
   * constant <code>PRT_MULAPDP</code>
   *	proration type:	APDP for multiple sectors are set
   *
   */
  public static final int PRT_MULAPDP = 0x00000800;
  /**
   * constant <code>PRT_SRP</code>
   *	proration type:	prorate value is set by strate rate proration
   *
   */
  public static final int PRT_SRP = 0x00000001;
  /**
   * constant <code>PRT_UPV</code>
   *	proration type: prorate value is set by the user by hand
   *
   */
  public static final int PRT_UPV = 0x00000002;
  /**
   * constant <code>PRT_USETS</code>
   *	bits definition for user setting prorate value
   *
   */
  public static final int PRT_USETS = 0x0000f002;
  /**
   * constant <code>PRT_USET2</code>
   *	bits definition for user setting base amount
   *
   */
  public static final int PRT_USET2 = 0x00007000;
  /**
   * constant <code>PRT_APDPSET</code>
   *	bits definition for APDP attribute sttings
   *
   */
  public static final int PRT_APDPSET = 0x00000d00;
  /**
   * constant <code>PRT_SPASET</code>
   *	bits definition for SPA attribute sttings
   *
   */
  public static final int PRT_SPASET = 0xf1000000;

  /* proration errors in a sector */
  /**
   * constant <code>ERR_NUMARG</code>
   *	proration errors in a sector: wrong number of arguments
   *	(for the function in the proration rule)
   *
   */
  public static final int ERR_NUMARG = 1;
  /**
   * constant <code>ERR_ILLARG</code>
   *	proration errors in a sector: illegal argument
   *	(for the function in the proration rule)
   *
   */
  public static final int ERR_ILLARG = 2;
  /*  */
  /**
   * constant <code>ERR_FUNC</code>
   *	proration errors in a sector:
   *	function not defined or illegal definitions
   *
   */
  public static final int ERR_FUNC = 3;
  /**
   * constant <code>ERR_UNBOUND</code>
   *	proration errors in a sector: unbound variable
   *	(in the proration rule)
   *
   */
  public static final int ERR_UNBOUND = 4;
  /**
   * constant <code>ERR_MULTI</code>
   *	proration errors in a sector: set multi path amount failed
   *	(in the proration rule)
   *
   */
  public static final int ERR_MULTI = 5;
  /**
   * constant <code>ERR_PFM</code>
   *	proration errors in a sector: baseamount data not found
   *	(in the proration rule)
   *
   */
  public static final int ERR_PFM = 6;
  /**
   * constant <code>ERR_VALUE</code>
   *	proration errors in a sector: SET: illegal value $DISCOUNT
   *	(in the proration rule)
   *
   */
  public static final int ERR_VALUE = 7;
  /**
   * constant <code>ERR_ERROR</code>
   *	proration errors in a sector: message from Error(...) in Rule
   *	(in the proration rule)
   *
   */
  public static final int ERR_ERROR = 8;
  /**
   * constant <code>ERR_MEMORY</code>
   *	proration errors in a sector: Memory Exhausted
   *
   */
  public static final int ERR_MEMORY = 9;
  /**
   * constant <code>ERR_CURRENCY</code>
   *	proration errors in a sector: Currency not match
   *
   */
  public static final int ERR_CURRENCY = 10;
  /**
   * constant <code>ERR_DATABASE</code>
   *	proration errors in a sector: database error
   *
   */
  public static final int ERR_DATABASE = 31;

  /* proration errors in a coupon */
  /**
   * constant <code>ERA_SIDETRIP</code>
   *	proration errors in a coupon: Value for a Side Trip not defined
   *
   */
  public static final int ERA_SIDETRIP = 33;
  
  /**
   * constant <code>ERA_FCOMP</code>
   *	proration errors in a coupon:
   *	Value for the last Fare Component not defined
   *
   */
  public static final int ERA_FCOMP = 34;
  /**
   * constant <code>ERA_LASTSIDE</code>
   *	proration errors in a coupon: Value for the last Side Trip not defined
   *
   */
  public static final int ERA_LASTSIDE = 35;
  /**
   * constant <code>ERA_TOTALNUC</code>
   *	proration errors in a coupon: Amount Mismatch in Total Nuc and Fare
   *
   */
  public static final int ERA_TOTALNUC = 36;
  /**
   * constant <code>ERA_FARECALC</code>
   *	proration errors in a coupon: Error in Fare Calculation
   *
   */
  public static final int ERA_FARECALC = 37;
  /**
   * constant <code>ERA_MEMORY</code>
   *	proration errors in a coupon: Memory Exhausted
   *
   */
  public static final int ERA_MEMORY = 38;
  /**
   * constant <code>ERA_STRHEAP</code>
   *	proration errors in a coupon: String Heap Block Memory Exhausted
   *
   */
  public static final int ERA_STRHEAP = 39;
  /**
   * constant <code>ERA_NOFARE</code>
   *	proration errors in a coupon: No Fare on Coupon Audit
   *
   */
  public static final int ERA_NOFARE = 40;
  /**
   * constant <code>ERA_FCOMPEMPTY</code>
   *	proration errors in a coupon: Empty Fare Component
   *
   */
  public static final int ERA_FCOMPEMPTY = 41;
  /**
   * constant <code>ERA_TAXNOTMATCH</code>
   *	proration errors in a coupon: Tax amount total not match
   *
   */
  public static final int ERA_TAXNOTMATCH = 51;
  /**
   * constant <code>ERA_TAXNOTFOUND</code>
   *	proration errors in a coupon: Tax code is not found
   *
   */
  public static final int ERA_TAXNOTFOUND = 52;
  /**
   * constant <code>ERA_OS</code>
   *	proration errors in a coupon: OS error
   *
   */
  public static final int ERA_OS = 62;
  /**
   * constant <code>ERA_DATABASE</code>
   *	proration errors in a coupon: database error
   *
   */
  public static final int ERA_DATABASE = 63;

  /* proration errors during searching database */
  /**
   * constant <code>ASK_AIRWAYID</code>
   *	proration errors during searching database:
   *	cannot get AirwayId of the ticket
   *
   */
  public static final int ASK_AIRWAYID = 65;
  /**
   * constant <code>ASK_FACTOR</code>
   *	proration errors during searching database:
   *
   */
  public static final int ASK_FACTOR = 66; /* Prorate Factor not found */
  /**
   * constant <code>ASK_ROERATE</code>
   *	proration errors during searching database:
   *	cannot get RoeRate for ..
   *
   */
  public static final int ASK_ROERATE = 67;
  /**
   * constant <code>ASK_5DAYRATE</code>
   *	proration errors during searching database:
   *	cannot get 5DayRate for ..
   *
   */
  public static final int ASK_5DAYRATE = 68;
  /**
   * constant <code>ASK_5DAYSPA</code>
   *	proration errors during searching database:
   *	cannot get 5DayRate for ..
   *
   */
  public static final int ASK_5DAYSPA = 69;
  /**
   * constant <code>ASK_5DAYAPDP</code>
   *	proration errors during searching database:
   *	cannot get 5DayRate for ..
   *
   */
  public static final int ASK_5DAYAPDP = 70;
  /**
   * constant <code>ASK_COUNTRY</code>
   *	proration errors during searching database:
   *	cannot get CountryName for ..
   *
   */
  public static final int ASK_COUNTRY = 71;
  /**
   * constant <code>ASK_AREA</code>
   *	proration errors during searching database:
   *	cannot get AreaName for ..
   *
   */
  public static final int ASK_AREA = 72;
  /**
   * constant <code>ASK_FIXEDFARE</code>
   *	proration errors during searching database:
   *	cannot get FixedFare for ..
   *
   */
  public static final int ASK_FIXEDFARE = 73;

  /* proration errors during reading rulebase */
  /**
   * constant <code>ERB_FOPEN</code>
   * proration errors during reading rulebase: cannot open rulebase file
   *
   */
  public static final int ERB_FOPEN = 97;

  /**
   * variable <code>components</code>
   *	the list of the analyzed and separeted fare components
   *
   */
  ProrateFareComponent[]	components;
  /**
   * variable <code>sectors</code>	sectors in the AUDIT
   *
   * @uml.property  name="sectors"
   */
  ProrateSector[]	sectors;

  /**
   * variable <code>isOwnAudit</code>
   *	the flag tells whether the audit is issued by own airline
   *
   */
  boolean isOwnAudit;
  /**
   * variable <code>isInward</code>
   *	the flag tells whether the proration is inward
   *
   */
  boolean isInward;
  /**
   * variable <code>isTicketing</code>
   *	the flag tells whether the proration is for the ticketing data
   *
   */
  boolean isTicketing;
  /**
   * variable <code>isNotRuleApply</code>
   *	the flag when it is on then the proration rule(SPA/APDP) is not applied
   *
   */
  boolean isNotRuleApply;
  /**
   * variable <code>nonProrateRest</code>
   *	the flag when it is on
   *	then do not adjust the total difference in whole itinerary
   *
   * @uml.property  name="nonProrateRest"
   */
  boolean nonProrateRest;
  /**
   * variable <code>isOneComponent</code>
   *	the flag when it is on
   *	then the whole itinerary is processed as one fare component
   *
   */
  boolean isOneComponent;
  /**
   * variable <code>ignoreFareCalc</code>
   *	the flag when it is on then the fare calculation is not analyzed
   *
   */
  boolean ignoreFareCalc;
  /**
   * variable <code>ignoreFareCalcCarrier</code>
   *	the flag when it is on then the carrier check is disabled
   *	during the fare calculation analisis
   *
   */
  boolean ignoreFareCalcCarrier;

  /**
   * variable <code>fareCalculation</code>
   *	fare calculation column string
   *
   */
  String	fareCalculation = "";

  /**
   * variable <code>ownAirwayId</code>
   *	own airway id(2 letter alphabetic) of the processing.
   *
   */
  String	ownAirwayId = "";
  /**
   * variable <code>airwayNumber</code>
   *	airway number(3 letter number) of the ticketing airline
   *
   */
  String	airwayNumber = "0";
  /**
   * variable <code>airwayId</code>
   *	airway id(2 letter alphabetic) of the ticketing airline
   *
   */
  String	airwayId = "";
  /**
   * variable <code>inwardNumber</code>
   *	airway number(3 letter number) of the invoice airline
   *
   */
  String	inwardNumber = "0";
  /**
   * variable <code>inwardId</code>
   *	airway id(2 letter alphabetic) of the invoice airline
   *
   */
  String	inwardId = "";
  /**
   * variable <code>endorsement</code>
   *	ENDORSEMENT/RESTRICTION column string
   *
   */
  String	endorsement = "";
  /**
   * variable <code>issueDate</code>
   *	issue date column string
   *
   */
  String	issueDate = "0";
  /**
   * variable <code>issuePlace</code>
   *	issue place column string
   *
   */
  String	issuePlace = "";
  /**
   * variable <code>origin</code>
   *	origin column string(airport 3letter code)
   *
   */
  String	origin = "";
  /**
   * variable <code>destination</code>
   *	destination column string(airport 3letter code)
   *
   */
  String	destination = "";
  /**
   * variable <code>currency</code>
   *	currency column string
   *
   */
  String	currency = "";
  /**
   * variable <code>ticketFare</code>
   *	ticket fare column amount
   *
   */
  double	ticketFare;
  /**
   * variable <code>salesCurrency</code>
   *	sales currency column string
   *
   */
  String	salesCurrency = "";
  /**
   * variable <code>salesFare</code>
   *	sales fare column amount
   *
   */
  double	salesFare;
  /**
   * variable <code>plusAdjustment</code>
   *	plus adjustment amount
   *
   */
  double	plusAdjustment;
  /**
   * variable <code>lessAdjustment</code>
   *	less adjustment amount
   *
   */
  double	lessAdjustment;
  /**
   * variable <code>commissionCurrency</code>
   *	commission currency column string
   *
   */
  String	commissionCurrency = "";
  /**
   * variable <code>commissionRate</code>
   *	commission applying rate value
   *
   */
  double	commissionRate;
  /**
   * variable <code>commissionAmt</code>
   *	commission amount value
   *
   */
  double	commissionAmt;
  /**
   * variable <code>totalNuc</code>
   *	total nuc column amount
   *
   */
  double	totalNuc;
  /**
   * variable <code>roeRate</code>
   *	roe rate value
   *
   */
  double	roeRate;
  /**
   * variable <code>day5Rate</code>
   *	5day rate value
   *
   */
  double	day5Rate;
  /**
   * variable <code>meanRate</code>
   *	mean 5day rate value
   *
   */
  double	meanRate;
  /**
   * variable <code>lessAmt</code>
   *	less amount value
   *
   */
  double	lessAmt;
  /**
   * variable <code>stopOverCharge</code>
   *	stop over charge amount
   *
   */
  double	stopOverCharge;
  /**
   * variable <code>fareDirtyFlag</code> not used
   *
   */
  int		fareDirtyFlag;
  /**
   * variable <code>fixedFare</code>
   *	value for fixed fare check basis
   *
   */
  double	fixedFare;
  /**
   * variable <code>invoiceMonth</code>
   *	invoice month
   *
   */
  String	invoiceMonth = "";
  /**
   * variable <code>amountRatio</code>
   *	the ratio of amount in ticket fare to amounts in fare components
   *
   */
  double	amountRatio;
  /**
   * variable <code>tourCode</code>
   *	tour code string
   *
   */
  String	tourCode = "";
  /**
   * variable <code>agentCode</code>
   *	agent code string
   *
   */
  String	agentCode = "";
  /**
   * variable <code>plusFlg</code>
   *	the flag which is set when the plus is described in fare calculation
   *	and the proration calculation is done by the algothm with plus
   *
   */
  boolean plusFlg;

  /**
   * variable <code>isNotDivideTax</code>
   *	the flag when it is on then the tax is not divided
   *
   */
  boolean	isNotDivideTax;
  /**
   * variable <code>tax</code>
   *	the list of 3 taxes column values(type and amount)
   *
   */
  ProrateTaxData[]	tax;
  /**
   * variable <code>taxMisc</code>
   *	the list of 10 taxes column values(type and amount)
   *	misc_tax(type,amount)
   *
   */
  ProrateTaxData[]	taxMisc;	/* misc_tax(type,amount) */

  /**
   * variable <code>errorFlag</code>
   *	error specification number
   *	of the error which is occurred during proration
   *
   * @uml.property  name="errorFlag"
   */
  int	errorFlag;
  /**
   * variable <code>errorString</code>
   *	the message string of the error which is occurred during proration
   *
   */
  String	errorString = "";

  /**
   * variable <code>askTable</code>
   *	the list of the ask table for values which is not found in the database
   *
   */
  ProrateAskTable[]	askTable;

  /**
   * variable <code>traceLevel</code>
   *	the number of the trace level(how deeply to trace)
   *
   */
  int	traceLevel;
  /**
   * variable <code>traceStrings</code>
   *	the list of trace result strings
   *
   */
  String[]	traceStrings;

  /**
   * Creates a new <code>ProrateAudit</code> instance.
   *
   */
  public ProrateAudit() {
    super();
  }

  /**
   * @return  agentCode
   * @uml.property  name="agentCode"
   */
  public String getAgentCode() {
    return agentCode;
  }
  /**
   * @param agentCode  agentCode to be set
   * @uml.property  name="agentCode"
   */
  public void setAgentCode(String agentCode) {
    this.agentCode = agentCode;
  }
  /**
   * @return  airwayId
   * @uml.property  name="airwayId"
   */
  public String getAirwayId() {
    return airwayId;
  }
  /**
   * @param airwayId  airwayId to be set
   * @uml.property  name="airwayId"
   */
  public void setAirwayId(String airwayId) {
    this.airwayId = airwayId;
  }
  /**
   * @return  airwayNumber
   * @uml.property  name="airwayNumber"
   */
  public String getAirwayNumber() {
    return airwayNumber;
  }
  /**
   * @param airwayNumber  airwayNumber to be set
   * @uml.property  name="airwayNumber"
   */
  public void setAirwayNumber(String airwayNumber) {
    this.airwayNumber = airwayNumber;
  }
  /**
   * @return  amountRatio
   * @uml.property  name="amountRatio"
   */
  public double getAmountRatio() {
    return amountRatio;
  }
  /**
   * @param amountRatio  amountRatio to be set
   * @uml.property  name="amountRatio"
   */
  public void setAmountRatio(double amountRatio) {
    this.amountRatio = amountRatio;
  }
  /**
   * @return  askTable
   * @uml.property  name="askTable"
   */
  public ProrateAskTable[] getAskTable() {
    return askTable;
  }
  /**
   * @param askTable  askTable to be set
   * @uml.property  name="askTable"
   */
  public void setAskTable(ProrateAskTable[] askTable) {
    this.askTable = askTable;
  }
  /**
   * @return  commissionAmt
   * @uml.property  name="commissionAmt"
   */
  public double getCommissionAmt() {
    return commissionAmt;
  }
  /**
   * @param commissionAmt  commissionAmt to be set
   * @uml.property  name="commissionAmt"
   */
  public void setCommissionAmt(double commissionAmt) {
    this.commissionAmt = commissionAmt;
  }
  /**
   * @return  commissionCurrency
   * @uml.property  name="commissionCurrency"
   */
  public String getCommissionCurrency() {
    return commissionCurrency;
  }
  /**
   * @param commissionCurrency  commissionCurrency to be set
   * @uml.property  name="commissionCurrency"
   */
  public void setCommissionCurrency(String commissionCurrency) {
    this.commissionCurrency = commissionCurrency;
  }
  /**
   * @return  commissionRate
   * @uml.property  name="commissionRate"
   */
  public double getCommissionRate() {
    return commissionRate;
  }
  /**
   * @param commissionRate  commissionRate to be set
   * @uml.property  name="commissionRate"
   */
  public void setCommissionRate(double commissionRate) {
    this.commissionRate = commissionRate;
  }
  /**
   * @return  components
   * @uml.property  name="components"
   */
  public ProrateFareComponent[] getComponents() {
    return components;
  }
  /**
   * @param components  components to be set
   * @uml.property  name="components"
   */
  public void setComponents(ProrateFareComponent[] components) {
    this.components = components;
  }
  /**
   * @return  currency
   * @uml.property  name="currency"
   */
  public String getCurrency() {
    return currency;
  }
  /**
   * @param currency  currency to be set
   * @uml.property  name="currency"
   */
  public void setCurrency(String currency) {
    this.currency = currency;
  }
  /**
   * @return  day5Rate
   * @uml.property  name="day5Rate"
   */
  public double getDay5Rate() {
    return day5Rate;
  }
  /**
   * @param day5Rate  day5Rate to be set
   * @uml.property  name="day5Rate"
   */
  public void setDay5Rate(double day5Rate) {
    this.day5Rate = day5Rate;
  }
  /**
   * @return  destination
   * @uml.property  name="destination"
   */
  public String getDestination() {
    return destination;
  }
  /**
   * @param destination  destination to be set
   * @uml.property  name="destination"
   */
  public void setDestination(String destination) {
    this.destination = destination;
  }
  /**
   * @return  endorsement
   * @uml.property  name="endorsement"
   */
  public String getEndorsement() {
    return endorsement;
  }
  /**
   * @param endorsement  endorsement to be set
   * @uml.property  name="endorsement"
   */
  public void setEndorsement(String endorsement) {
    this.endorsement = endorsement;
  }
  /**
   * @return  errorFlag
   * @uml.property  name="errorFlag"
   */
  public int getErrorFlag() {
    return errorFlag;
  }
  /**
   * @param errorFlag  errorFlag to be set
   * @uml.property  name="errorFlag"
   */
  public void setErrorFlag(int errorFlag) {
    this.errorFlag = errorFlag;
  }
  /**
   * @return  errorString
   * @uml.property  name="errorString"
   */
  public String getErrorString() {
    return errorString;
  }
  /**
   * @param errorString  errorString to be set
   * @uml.property  name="errorString"
   */
  public void setErrorString(String errorString) {
    this.errorString = errorString;
  }
  /**
   * @return  fareCalculation
   * @uml.property  name="fareCalculation"
   */
  public String getFareCalculation() {
    return fareCalculation;
  }
  /**
   * @param fareCalculation  fareCalculation to be set
   * @uml.property  name="fareCalculation"
   */
  public void setFareCalculation(String fareCalculation) {
    this.fareCalculation = fareCalculation;
  }
  /**
   * @return  fareDirtyFlag
   * @uml.property  name="fareDirtyFlag"
   */
  public int getFareDirtyFlag() {
    return fareDirtyFlag;
  }
  /**
   * @param fareDirtyFlag  fareDirtyFlag to be set
   * @uml.property  name="fareDirtyFlag"
   */
  public void setFareDirtyFlag(int fareDirtyFlag) {
    this.fareDirtyFlag = fareDirtyFlag;
  }
  /**
   * @return  fixedFare
   * @uml.property  name="fixedFare"
   */
  public double getFixedFare() {
    return fixedFare;
  }
  /**
   * @param fixedFare  fixedFare to be set
   * @uml.property  name="fixedFare"
   */
  public void setFixedFare(double fixedFare) {
    this.fixedFare = fixedFare;
  }
  /**
   * @return  ignoreFareCalc
   * @uml.property  name="ignoreFareCalc"
   */
  public boolean isIgnoreFareCalc() {
    return ignoreFareCalc;
  }
  /**
   * @param ignoreFareCalc  ignoreFareCalc to be set
   * @uml.property  name="ignoreFareCalc"
   */
  public void setIgnoreFareCalc(boolean ignoreFareCalc) {
    this.ignoreFareCalc = ignoreFareCalc;
  }
  /**
   * <code>isIgnoreFareCalcCarrier</code> method
   *
   * @return a <code>boolean</code> ignoreFareCalcCarrier value
   */
  public boolean isIgnoreFareCalcCarrier() {
    return ignoreFareCalcCarrier;
  }
  /**
   * <code>setIgnoreFareCalcCarrier</code> method
   *
   * @param ignoreFareCalcCarrier a <code>boolean</code> value
   */
  public void setIgnoreFareCalcCarrier(boolean ignoreFareCalcCarrier) {
    this.ignoreFareCalcCarrier = ignoreFareCalcCarrier;
  }
  /**
   * @return  invoiceMonth
   * @uml.property  name="invoiceMonth"
   */
  public String getInvoiceMonth() {
    return invoiceMonth;
  }
  /**
   * @param invoiceMonth  invoiceMonth to be set
   * @uml.property  name="invoiceMonth"
   */
  public void setInvoiceMonth(String invoiceMonth) {
    this.invoiceMonth = invoiceMonth;
  }
  /**
   * @return  inwardId
   * @uml.property  name="inwardId"
   */
  public String getInwardId() {
    return inwardId;
  }
  /**
   * @param inwardId  inwardId to be set
   * @uml.property  name="inwardId"
   */
  public void setInwardId(String inwardId) {
    this.inwardId = inwardId;
  }
  /**
   * @return  inwardNumber
   * @uml.property  name="inwardNumber"
   */
  public String getInwardNumber() {
    return inwardNumber;
  }
  /**
   * @param inwardNumber  inwardNumber to be set
   * @uml.property  name="inwardNumber"
   */
  public void setInwardNumber(String inwardNumber) {
    this.inwardNumber = inwardNumber;
  }
  /**
   * @return
   * @uml.property  name="isInward"
   */
  public boolean isInward() {
    return isInward;
  }
  /**
   * @param isInward  isInward to be set
   * @uml.property  name="isInward"
   */
  public void setInward(boolean isInward) {
    this.isInward = isInward;
  }
  /**
   * @return
   * @uml.property  name="isNotRuleApply"
   */
  public boolean isNotRuleApply() {
    return isNotRuleApply;
  }
  /**
   * @param isNotRuleApply  isNotRuleApply to be set
   * @uml.property  name="isNotRuleApply"
   */
  public void setNotRuleApply(boolean isNotRuleApply) {
    this.isNotRuleApply = isNotRuleApply;
  }
  /**
   * @return
   * @uml.property  name="isOneComponent"
   */
  public boolean isOneComponent() {
    return isOneComponent;
  }
  /**
   * @param isOneComponent  isOneComponent to be set
   * @uml.property  name="isOneComponent"
   */
  public void setOneComponent(boolean isOneComponent) {
    this.isOneComponent = isOneComponent;
  }
  /**
   * @return
   * @uml.property  name="isOwnAudit"
   */
  public boolean isOwnAudit() {
    return isOwnAudit;
  }
  /**
   * @param isOwnAudit  isOwnAudit to be set
   * @uml.property  name="isOwnAudit"
   */
  public void setOwnAudit(boolean isOwnAudit) {
    this.isOwnAudit = isOwnAudit;
  }
  /**
   * @return  issueDate
   * @uml.property  name="issueDate"
   */
  public String getIssueDate() {
    return issueDate;
  }
  /**
   * @param issueDate  issueDate to be set
   * @uml.property  name="issueDate"
   */
  public void setIssueDate(String issueDate) {
    this.issueDate = issueDate;
  }
  /**
   * @return  issuePlace
   * @uml.property  name="issuePlace"
   */
  public String getIssuePlace() {
    return issuePlace;
  }
  /**
   * @param issuePlace  issuePlace to be set
   * @uml.property  name="issuePlace"
   */
  public void setIssuePlace(String issuePlace) {
    this.issuePlace = issuePlace;
  }
  /**
   * @return
   * @uml.property  name="isTicketing"
   */
  public boolean isTicketing() {
    return isTicketing;
  }
  /**
   * @param isTicketing  isTicketing to be set
   * @uml.property  name="isTicketing"
   */
  public void setTicketing(boolean isTicketing) {
    this.isTicketing = isTicketing;
  }
  /**
   * @return  lessAdjustment
   * @uml.property  name="lessAdjustment"
   */
  public double getLessAdjustment() {
    return lessAdjustment;
  }
  /**
   * @param lessAdjustment  lessAdjustment to be set
   * @uml.property  name="lessAdjustment"
   */
  public void setLessAdjustment(double lessAdjustment) {
    this.lessAdjustment = lessAdjustment;
  }
  /**
   * @return  lessAmt
   * @uml.property  name="lessAmt"
   */
  public double getLessAmt() {
    return lessAmt;
  }
  /**
   * @param lessAmt  lessAmt to be set
   * @uml.property  name="lessAmt"
   */
  public void setLessAmt(double lessAmt) {
    this.lessAmt = lessAmt;
  }
  /**
   * @return  meanRate
   * @uml.property  name="meanRate"
   */
  public double getMeanRate() {
    return meanRate;
  }
  /**
   * @param meanRate  meanRate to be set
   * @uml.property  name="meanRate"
   */
  public void setMeanRate(double meanRate) {
    this.meanRate = meanRate;
  }
  /**
   * @return  nonProrateRest
   * @uml.property  name="nonProrateRest"
   */
  public boolean isNonProrateRest() {
    return nonProrateRest;
  }
  /**
   * @param nonProrateRest  nonProrateRest to be set
   * @uml.property  name="nonProrateRest"
   */
  public void setNonProrateRest(boolean nonProrateRest) {
    this.nonProrateRest = nonProrateRest;
  }
  /**
   * @return  origin
   * @uml.property  name="origin"
   */
  public String getOrigin() {
    return origin;
  }
  /**
   * @param origin  origin to be set
   * @uml.property  name="origin"
   */
  public void setOrigin(String origin) {
    this.origin = origin;
  }
  /**
   * @return  ownAirwayId
   * @uml.property  name="ownAirwayId"
   */
  public String getOwnAirwayId() {
    return ownAirwayId;
  }
  /**
   * @param ownAirwayId  ownAirwayId to be set
   * @uml.property  name="ownAirwayId"
   */
  public void setOwnAirwayId(String ownAirwayId) {
    this.ownAirwayId = ownAirwayId;
  }
  /**
   * @return  plusAdjustment
   * @uml.property  name="plusAdjustment"
   */
  public double getPlusAdjustment() {
    return plusAdjustment;
  }
  /**
   * @param plusAdjustment  plusAdjustment to be set
   * @uml.property  name="plusAdjustment"
   */
  public void setPlusAdjustment(double plusAdjustment) {
    this.plusAdjustment = plusAdjustment;
  }
  /**
   * @return  plusFlg
   * @uml.property  name="plusFlg"
   */
  public boolean isPlusFlg() {
    return plusFlg;
  }
  /**
   * @param plusFlg  plusFlg to be set
   * @uml.property  name="plusFlg"
   */
  public void setPlusFlg(boolean plusFlg) {
    this.plusFlg = plusFlg;
  }
  /**
   * @return  roeRate
   * @uml.property  name="roeRate"
   */
  public double getRoeRate() {
    return roeRate;
  }
  /**
   * @param roeRate  roeRate to be set
   * @uml.property  name="roeRate"
   */
  public void setRoeRate(double roeRate) {
    this.roeRate = roeRate;
  }
  /**
   * @return  salesCurrency
   * @uml.property  name="salesCurrency"
   */
  public String getSalesCurrency() {
    return salesCurrency;
  }
  /**
   * @param salesCurrency  salesCurrency to be set
   * @uml.property  name="salesCurrency"
   */
  public void setSalesCurrency(String salesCurrency) {
    this.salesCurrency = salesCurrency;
  }
  /**
   * @return  salesFare
   * @uml.property  name="salesFare"
   */
  public double getSalesFare() {
    return salesFare;
  }
  /**
   * @param salesFare  salesFare to be set
   * @uml.property  name="salesFare"
   */
  public void setSalesFare(double salesFare) {
    this.salesFare = salesFare;
  }
  /**
   * @return  sectors
   * @uml.property  name="sectors"
   */
  public ProrateSector[] getSectors() {
    return sectors;
  }
  /**
   * @param sectors  sectors to be set
   * @uml.property  name="sectors"
   */
  public void setSectors(ProrateSector[] sectors) {
    this.sectors = sectors;
  }
  /**
   * @return  stopOverCharge
   * @uml.property  name="stopOverCharge"
   */
  public double getStopOverCharge() {
    return stopOverCharge;
  }
  /**
   * @param stopOverCharge  stopOverCharge to be set
   * @uml.property  name="stopOverCharge"
   */
  public void setStopOverCharge(double stopOverCharge) {
    this.stopOverCharge = stopOverCharge;
  }
  /**
   * @return  ticketFare
   * @uml.property  name="ticketFare"
   */
  public double getTicketFare() {
    return ticketFare;
  }
  /**
   * @param ticketFare  ticketFare to be set
   * @uml.property  name="ticketFare"
   */
  public void setTicketFare(double ticketFare) {
    this.ticketFare = ticketFare;
  }
  /**
   * @return  totalNuc
   * @uml.property  name="totalNuc"
   */
  public double getTotalNuc() {
    return totalNuc;
  }
  /**
   * @param totalNuc  totalNuc to be set
   * @uml.property  name="totalNuc"
   */
  public void setTotalNuc(double totalNuc) {
    this.totalNuc = totalNuc;
  }
  /**
   * @return  tourCode
   * @uml.property  name="tourCode"
   */
  public String getTourCode() {
    return tourCode;
  }
  /**
   * @param tourCode  tourCode to be set
   * @uml.property  name="tourCode"
   */
  public void setTourCode(String tourCode) {
    this.tourCode = tourCode;
  }
  /**
   * @return  traceLevel
   * @uml.property  name="traceLevel"
   */
  public int getTraceLevel() {
    return traceLevel;
  }
  /**
   * @param traceLevel  traceLevel to be set
   * @uml.property  name="traceLevel"
   */
  public void setTraceLevel(int traceLevel) {
    this.traceLevel = traceLevel;
  }
  /**
   * @return  traceStrings
   * @uml.property  name="traceStrings"
   */
  public String[] getTraceStrings() {
    return traceStrings;
  }
  /**
   * @param traceStrings  traceStrings to be set
   * @uml.property  name="traceStrings"
   */
  public void setTraceStrings(String[] traceStrings) {
    this.traceStrings = traceStrings;
  }
  /**
   * @return
   * @uml.property  name="isNotDivideTax"
   */
  public boolean isNotDivideTax() {
    return isNotDivideTax;
  }
  /**
   * @param isNotDivideTax  isNotDivideTax to be set
   * @uml.property  name="isNotDivideTax"
   */
  public void setNotDivideTax(boolean isNotDivideTax) {
    this.isNotDivideTax = isNotDivideTax;
  }
  /**
   * @return  tax
   * @uml.property  name="tax"
   */
  public ProrateTaxData[] getTax() {
    return tax;
  }
  /**
   * @param tax  tax to be set
   * @uml.property  name="tax"
   */
  public void setTax(ProrateTaxData[] tax) {
    this.tax = tax;
  }
  /**
   * @return  taxMisc
   * @uml.property  name="taxMisc"
   */
  public ProrateTaxData[] getTaxMisc() {
    return taxMisc;
  }
  /**
   * @param taxMisc  taxMisc to be set
   * @uml.property  name="taxMisc"
   */
  public void setTaxMisc(ProrateTaxData[] taxMisc) {
    this.taxMisc = taxMisc;
  }
  /**
   * <code>toString</code> method
   *	returns String which describes the audit
   *
   * @return a <code>String</code> value
   */
  public String toString() {
    String
      ret = (getSectors()[0].getDepCode() + "-"
	     + getSectors()[getSectors().length-1].getDestCode()
	     + "/" + getComponents().length + "/"
	     + getCurrency() + getTicketFare());
    return ret;
  }
}
