// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.export;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;



/* Model of the FareComponent in the AUDIT */

/**
 * class <code>ProrateFareComponent</code> The model of the separated fare component.
 * @author   <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */
public class ProrateFareComponent implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  /**
   * variable <code>audit</code>
   *	the reference to the whole audit model object
   *	in which this fare component belongs
   *
   */
  ProrateAudit	audit;
  /**
   * variable <code>sectors</code>
   *	the list of the all sectors in this fare component 
   * @uml.property  name="sectors"
   */
  ProrateSector[]	sectors;
  /**
   * variable <code>value</code> the amount value of the fare compont
   * @uml.property  name="value"
   */
  double	value;
  /**
   * variable <code>kind</code>
   *	the classification number of the fare component type
   * @uml.property  name="kind"
   */
  int	kind;
  /**
   * variable <code>fixedFareDiscount</code>
   *	fixed fare check discounting rate Fixed
   * @uml.property  name="fixedFareDiscount"
   */
  double	fixedFareDiscount;

  /**
   * Creates a new <code>ProrateFareComponent</code> instance.
   *
   */
  public ProrateFareComponent() {
  }

  public ProrateFareComponent(ProrateAudit audit_in,
			      ProrateSector[] sectors_in) {
    audit = audit_in;
    sectors = sectors_in;
  }

  /**
   * @return  audit
   * @uml.property  name="audit"
   */
  public ProrateAudit getAudit() {
    return audit;
  }

  /**
   * @param audit  audit to be set
   * @uml.property  name="audit"
   */
  public void setAudit(ProrateAudit audit) {
    this.audit = audit;
  }

  /**
   * @return  fixedFareDiscount
   * @uml.property  name="fixedFareDiscount"
   */
  public double getFixedFareDiscount() {
    return fixedFareDiscount;
  }

  /**
   * @param fixedFareDiscount  fixedFareDiscount to be set
   * @uml.property  name="fixedFareDiscount"
   */
  public void setFixedFareDiscount(double fixedFareDiscount) {
    this.fixedFareDiscount = fixedFareDiscount;
  }

  /**
   * @return  kind
   * @uml.property  name="kind"
   */
  public int getKind() {
    return kind;
  }

  /**
   * @param kind  kind to be set
   * @uml.property  name="kind"
   */
  public void setKind(int kind) {
    this.kind = kind;
  }

  /**
   * <code>getSectors</code> method
   *
   * @return  sectors
   * @uml.property  name="sectors"
   */
  public ProrateSector[] getSectors() {
    return sectors;
  }

  /**
   * <code>setSectors</code> method
   *
   * @param sectors  sectors to be set
   * @uml.property  name="sectors"
   */
  public void setSectors(ProrateSector[] sectors) {
    this.sectors = sectors;
  }

  /**
   * @return  value
   * @uml.property  name="value"
   */
  public double getValue() {
    return value;
  }

  /**
   * @param value  value to be set
   * @uml.property  name="value"
   */
  public void setValue(double value) {
    this.value = value;
  }
  /**
   * <code>toString</code> method
   *	returns String which describes the fare component
   *
   * @return a <code>String</code> value
   */
  public String toString() {
    String
      ret = (getSectors()[0].getDepCode() + "-"
	     + getSectors()[getSectors().length-1].getDestCode()
	     + "/" + getValue() + "/" + getKind());
    return ret;
  }
}
