// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.export;

import java.io.Serializable;

/**
 * class <code>ProrateAuditTax</code>
 *	the model of the tax description in the audit
 * @author  <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class ProrateTaxData implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  /**
   * variable <code>type</code> the type string of the tax
   * @uml.property  name="type"
   */
  String	type;
  /**
   * variable <code>amount</code> the amount value of the tax
   * @uml.property  name="amount"
   */
  double	amount;
  
  /**
   * <code>getAmount</code> method	returns amount
   * @return  a <code>double</code> value
   * @uml.property  name="amount"
   */
  public double getAmount() {
    return amount;
  }
  /**
   * <code>setAmount</code>	sets amount
   * @param amount  a <code>double</code> value
   * @uml.property  name="amount"
   */
  public void setAmount(double amount) {
    this.amount = amount;
  }
  /**
   * <code>getType</code> method	returns type
   * @return  a <code>String</code> value
   * @uml.property  name="type"
   */
  public String getType() {
    return type;
  }
  /**
   * <code>setType</code> method	sets type
   * @param type  a <code>String</code> value
   * @uml.property  name="type"
   */
  public void setType(String type) {
    this.type = type;
  }
}
