// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.fcalc;


import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateAuditImpl;
import jp.sourceforge.gnp.prorate.ProrateFcalc;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

/**
 * @author   maruyama
 */
public class ProrateFCalcImpl implements ProrateFcalc, Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  static final int	ResultAllTkSector = 0;
  static final int	ResultSectorCheckFail = 1;
  static final int	ResultPlusCheckFail = 2;
  static final int	ResultSecurityCharge = 3;
  static final int	ResultClassDiff = 4;
  static final int	ResultDifficultDiff = 5;
  static final int	ResultNoTotalCurrency = 6;
  static final int	ResultLess = 7;
  static final int	ResultSurface = 8;
  static final int	ResultSurfaceOnEnd = 9;
  static final int	ResultParseError = 10;
  static final int	ResultParseErrorO = 11;
  static final int	ResultParseErrorB = 12;
  static final int	ResultValueZero = 13;
  static final int	ResultLowestCombi = 14;
  static final int	ResultFcompNoEnd = 15;
  static final int	ResultTotalSumFail = 16;
  static final int	ResultPlusNormal = 17;
  static final int	ResultPlusSector = 18;
  static final int	ResultPlusHalfRt = 19;
  static final int	ResultPlusYSect = 20;
  static final int	ResultPlusLowCombi = 21;
  static final int	ResultOverMaxTax = 22;
  static final int	ResultFTax = 23;
  static final int	ResultSideTrip = 24;
  /* ;;; ResultRoeBeforeEnd added ;;; 20110201 */
  static final int	ResultRoeBeforeEnd = 25;
  /* ;;; ResultRoeBeforeEnd added ;;; 20110201
  static final int	MAX_FC_RESULT = 24;
  */
  static final int	MAX_FC_RESULT = 26;

  static final int	MAX_TAX = 32;	/* TAX */
  static final int	MAX_DIFFS = 32;	/* DIFFơ֥ */
  static final int	MAX_FC = 60;	/* fare calculation ֺ */
  static final int	MAX_FC_COMP = 60;	/* fcal ݡͥȺ */

  /**
   * 
   * @uml.property name="audit"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateAudit audit; /* audit */

  /**
   * variable <code>auditImpl</code>	ץ졼󥨥󥸥
   *
   */
  ProrateAuditImpl	auditImpl;

  /**
   * 
   * @uml.property name="yylex"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  Yylex yylex; /* ϥ֥ */

  int	lex;	/* Ϸ */

  int[]	oldlex;	/* 顼ˤʤλϷ */
  int[]	oldpos;	/* 顼ˤʤλϳʸ */

  /* doubleͤ0(ư黻顼Τ) ;;; ?? */
  static final double	ZERO_VALUE = (double)0;

  int	def_point;	/* Ͼ󡦥ݡͥȳ֥ǥå */
  int	side_start;	/* Ͼ󡦥ɥȥå׳϶֥ǥå */
  boolean	free_flag;	/* Ͼ󡦥ݡͥʬ̵ͭ */
  /* ;;; ??? ȥåץСû߷פΰ˵ */
  double	stop_over_sum;	/* Ͼ󡦥ȥåץСû߷׳ */
  double	stop_over_tmp;	/* Ͼñ֥ȥåץСû߷ */

  int	place_no;	/* Fare CalculationϷֿ̡/index */
  /* Fare CalculationϷֿ̡Ѥߥե饰 */
  boolean	place_no_fix;
  /* Fare CalculationϷ̡־Ϸ */
  class	_fare_cal {
    char	stop_over;
    String	dep_code = "";
    String	dest_code = "";
    String	carrier = "";
    int	fare_compo_kbn;
    int	fare_compo_kind;
    int	compo_end;
    double  fare_component;
    double  class_differ_plus;
    double  security_chrg;
    int	security_index;
    /* double  plus; */
    double	stop_over_chrg;
    double	side_trip_plus;
    int	side_trip_index;
    int	diff_index;
    double	exst_plus;
    String	via = "";
  };

  /**
   * @uml.property  name="fc"
   * @uml.associationEnd  multiplicity="(0 -1)"
   */
  _fare_cal[] fc;


  int	mileage;	/* Ϸ̡եݡͥȿ/index */
  int[]	fc_id;	/* Ϸ̡եݡͥȶڶ */

  /* Fare CalculationϷ̡FAREϷ */
  double	roe_rate;
  double	total;
  String	total_type;
  double	add_stop_over_chrg;
  double	less;

  int	tax_no;	/* Fare CalculationϷ̡TAX/index */
  /* Fare CalculationϷ̡TAXϷ */
  class	_tax_value{
    double	tax = (double)0;
    String	tax_kind = "";
  };

  /**
   * @uml.property  name="tx"
   * @uml.associationEnd  multiplicity="(0 -1)"
   */
  _tax_value[] tx;

  //StringBuffer	FC_RESULT = null;
  int	FC_RESULT = 0;

  boolean	fc_error;
  boolean	plus;

  int		it_cnt;		/* /ITפνи */
  boolean	it_flg;		/* ̲ߥɡסܡ/ITפνиե饰 */

  /* Fare CalculationϷ̡DIFFϷ */
  class	_diff_table {
    String	from = "";
    String	to = "";
    double	value = (double)0;
    int	count = 0;
  };

  /**
   * @uml.property  name="dftbl"
   * @uml.associationEnd  multiplicity="(0 -1)"
   */
  _diff_table[] dftbl;

  int	diff_index = 0;	/* Fare CalculationϷ̡DIFFindex */
  /* Fare CalculationϷ̡DIFF־ȹ */
  boolean[]	diffApplicable;

  /* ;;; ResultRoeBeforeEnd added ;;; 20110201 */
  boolean	hpn_roe_end = false;
  
  public ProrateFCalcImpl() {
    audit = null;
    lex = -1;
    oldlex = new int[3];
    oldpos = new int[3];
    def_point = -1;
    side_start = 0;
    free_flag = false;
    stop_over_sum = (double)0;
    stop_over_tmp = (double)0;
    place_no = 0;
    place_no_fix = false;
    fc = new _fare_cal[MAX_FC];
    mileage = 0;
    fc_id = new int[MAX_FC_COMP];;
    roe_rate = (double)0;
    total = (double)0;
    total_type = "";
    add_stop_over_chrg = (double)0;
    less = (double)0;
    tx = new _tax_value[MAX_TAX];
    //FC_RESULT = new StringBuffer("                               ");
    FC_RESULT = 0;
    fc_error = false;
    plus = false;
    it_cnt = 0;
    it_flg = false;
    dftbl = new _diff_table[MAX_DIFFS];
    diffApplicable = new boolean[MAX_DIFFS];
    diff_index = 0;
  }

  public boolean	analyze(ProrateAuditImpl auditImpl,
				ProrateAudit audit) {
    setAuditImpl(auditImpl);
    this.audit = audit;
    fc_error = false;
    boolean	status = true;
    boolean	analyzeStatus = true;
    /* ѥХåե */
    String[]	fareCal = new String[1];
    fareCal[0] = audit.getFareCalculation();

    audit.setFareDirtyFlag(1);	/* Fare˴ؤѹե饰 */

    int[]	fareCalPtr = new int[1];
    fareCalPtr[0] = 0;
    if (!preProcess(fareCal)) {
      StringBuffer	errorString =
	new StringBuffer("error in analyzing fare calculation [");
      //errorString.append(FC_RESULT);
      errorString.append(makeFcResultStr(FC_RESULT));
      errorString.append("]");
      errorString.append(fareCal[0]);
      getAuditImpl().error(ProrateAudit.ERA_FARECALC, errorString.toString());
      terminate();
      return false;
    }
    status = analyzeStatus = doAnalyze(fareCal[0], fareCalPtr);

    /* MILEAGEθfareBasis񤤤Ƥäƥ顼ˤʤä */
    if (!status) {
      debugFareCalInfo(fareCal[0], fareCalPtr[0]);	/* ;;; deBug *//* 1ѥ */
      if ((oldlex[0] >= Yylex.MILEAGE && oldlex[0] <= Yylex.ROUTE)
	  || oldlex[0] == Yylex.INCTOUR || oldlex[0] == Yylex.INCTOUR2
	  || (oldlex[0] >= Yylex.DIFF && oldlex[0] <= Yylex.DIFFCADT)
	  || oldlex[0] == Yylex.EXTRASEAT) {
	if (skipFareBasis(fareCalPtr[0] - oldpos[0], fareCalPtr, fareCal)) {
	  fareCalPtr[0] = 0;
	  /* 2ѥܤβ */
	  status = analyzeStatus = doAnalyze(fareCal[0], fareCalPtr);
	}
      }
      else if (((oldlex[1] >= Yylex.MILEAGE && oldlex[1] <= Yylex.ROUTE)
		|| oldlex[1] == Yylex.INCTOUR || oldlex[1] == Yylex.INCTOUR2
		|| (oldlex[1] >= Yylex.DIFF && oldlex[1] <= Yylex.DIFFCADT)
		|| oldlex[1] == Yylex.EXTRASEAT)
	       && (oldlex[0] >= Yylex.CARRIER
		   && oldlex[0] <= Yylex.CARRIERROUTE)) {
	if (skipFareBasis(fareCalPtr[0] - oldpos[0] - oldpos[1], fareCalPtr,
			  fareCal)) {
	  fareCalPtr[0] = 0;
	  /* 2ѥܤβ */
	  status = analyzeStatus = doAnalyze(fareCal[0], fareCalPtr);
	}
      }
      else if (((oldlex[2] >= Yylex.MILEAGE && oldlex[2] <= Yylex.ROUTE)
		|| oldlex[2] == Yylex.INCTOUR || oldlex[2] == Yylex.INCTOUR2
		|| (oldlex[2] >= Yylex.DIFF && oldlex[2] <= Yylex.DIFFCADT)
		|| oldlex[2] == Yylex.EXTRASEAT)
	       && (oldlex[1] >= Yylex.CARRIER
		   && oldlex[1] <= Yylex.CARRIERROUTE)
	       && (oldlex[0] >= Yylex.PLACE
		   && oldlex[0] <= Yylex.PLACENOPASS)) {
	if (skipFareBasis(fareCalPtr[0] - oldpos[0] - oldpos[1] - oldpos[2],
			  fareCalPtr, fareCal)) {
	  fareCalPtr[0] = 0;
	  /* 2ѥܤβ */
	  status = analyzeStatus = doAnalyze(fareCal[0], fareCalPtr);
	}
      }
      if (!status) {
	/* ;;; deBug *//* 2ѥ */
	debugFareCalInfo(fareCal[0], fareCalPtr[0]);
      }
    }

    if (status) {
      status = setFareCalInfo(); /* FareCalculationϷ̤audit˥å */
    }
    debugFareCalInfo(fareCal[0], fareCalPtr[0]);	/* ;;; deBug */

    /* MILEAGEθfareBasis񤤤Ƥäƶ֤Υ顼ˤʤä */
    if (!status) {
      if (skipFareBasis(0, fareCalPtr, fareCal, false)) {
	fareCalPtr[0] = 0;
	status = analyzeStatus = doAnalyze(fareCal[0], fareCalPtr);/* Ʋ */
      }
      if (status) {
	/* FareCalculationϷ̤audit˥å */
	status = setFareCalInfo();
	debugFareCalInfo(fareCal[0], fareCalPtr[0]);	/* ;;; deBug */
      }
    }
    if (!status || fc_error) {
      StringBuffer	errorString =
	new StringBuffer("error in analyzing fare calculation [");
      //errorString.append(FC_RESULT);
      errorString.append(makeFcResultStr(FC_RESULT));
      errorString.append("]");
      /* errorString.append(fareCalPtr[0]); */
      if (!analyzeStatus) {
	errorString.append(fareCal[0].substring(fareCalPtr[0] -
						yylex.yytext().length()));
      }
      getAuditImpl().error(ProrateAudit.ERA_FARECALC, errorString.toString());
    }

    fareCal = null;
    if (fc_error) {	/* ;;; DPLESSʤɤäϡϥ顼Ȥ */
      terminate();
      return false;
    }
    if (plus) {
      audit.setPlusFlg(true);	/* ץ饹ץ졼ե饰å */
    }
    terminate();
    return status;
  }

  boolean	doAnalyze(String fareCal, int[] fareCalPtr) {
    return doAnalyze(fareCal, fareCalPtr, null, null);
  }

  boolean	doAnalyze(String fareCal, int[] fareCalPtr,
			  int stop_lex[], int stop_pos[]) {
    /* ;;; not implemented yet */
    boolean	status = false;
    int	stopPos = -1;

    yylex = new Yylex(new StringReader(fareCal.substring(fareCalPtr[0])));

    initialize();

    lex = 0;

    while (!isFinish(fareCal, yylex.getPos())) {

      oldlex[2] = oldlex[1];
      oldlex[1] = oldlex[0];
      oldlex[0] = lex;
      
      try {
	lex = yylex.yylex();
	if (lex < 0) {
	  break;
	}
      }
      catch (IOException e) {
	return false;
      }

      fareCalPtr[0] = yylex.getPos();
      oldpos[2] = oldpos[1];
      oldpos[1] = oldpos[0];
      oldpos[0] = yylex.yytext().length();

      if (stop_lex != null) {
	for (int i = 0; stop_lex[i] >= 0; i++) {
	  if (lex == stop_lex[i]) {
	    stopPos++;
	    if (stop_pos != null && stopPos > stop_pos[0]) {
	      /* *stop_posܤstop_lex򸫤ĤȤ򼨤 */
	      stop_pos[0] = stopPos;
	      return false;
	    }
	  }
	}
      }

      if (!(status = getFareCalInfo())) {	/* FareCalΰ̣ */
	break;	/* ϤǤʤ礬Ǥ */
      }
    }

    if (!place_no_fix && !yylex.get_end) {	/* ENDROEʤ */
      place_no_fix = true;
      place_no --;
    }

    if (stop_pos != null) {
      stop_pos[0] = -1;	/* stop_lexˤߤǤϤʤȤ򼨤 */
    }
    return status;
  }

  boolean	setFareCalInfo() {
    if (place_no == 0 || free_flag) {
      /* Fare Calculation ˶֡եݡͥȤξʤ */
      //FC_RESULT.setCharAt(ALLTK, 'w');
      FC_RESULT |= 1 << ResultAllTkSector;
      return true;
    }
    if (!yylex.hpn_end) {
      /* ENDʤ */
      //FC_RESULT.setCharAt(NOEND, 'm');
      FC_RESULT |= 1 << ResultFcompNoEnd;
    }
    if (total_type.equals("")) {
      /* TOTAL̲ۤߥʤ */
      //FC_RESULT.setCharAt(FTYP, 't');
      FC_RESULT |= 1 << ResultNoTotalCurrency;
      return false;
    }
    if (audit.getSectors().length > 0) {
      if (!sectorCheck()) {
	//FC_RESULT.setCharAt(ROO, 'u');
	FC_RESULT |= 1 << ResultSectorCheckFail;
	return false;
      }
      if (plus && diff_index == 0 && !plusCheck()) {
	//FC_RESULT.setCharAt(PLU, 'P');
	FC_RESULT |= 1 << ResultPlusCheckFail;
	return false;
      }
    }
    else {
      if (!sectorCreate()) {
	return false;
      }
    }
    if (!totalSumCheck()) {
      //FC_RESULT.setCharAt(UNTOTAL, 'z');
      FC_RESULT |= 1 << ResultTotalSumFail;
      if (total != (double)0) {
	return false;
      }
    }

    if (roe_rate > (double)0) {
      audit.setRoeRate(roe_rate);	/* ROEҤroeRate򥻥å ;;; */
    }
    double	roerate = (double)1.0;
    if (roe_rate > (double)0 && !total_type.equals("NUC")) {
      roerate = roe_rate;
    }
    audit.setTotalNuc(total / roerate);	/* totalNucTOTAL饻å */

    int si = 0;	/* եݡͥȶ֤Υǥå */
    boolean	isFareComponent = false; /* եݡͥȤä */
    for (int i = 0; i < place_no; i++) {
      if (fc[i].carrier.equals("XX") || fc[i].carrier.equals("//")) {
	if (fc[i].compo_end == 1) {
	  /* եݡͥȤκǽ֤Surface */
	  //FC_RESULT.setCharAt(SONC, 'p');
	  FC_RESULT |= 1 << ResultSurfaceOnEnd;
	  if (si <= 0) {
	    return false;
	  }
	  ProrateSector
	    beforeSector = (ProrateSector)audit.getSectors()[si-1];
	  if (beforeSector.getFareComponent() > 0) {
	    return false;
	  }
	  beforeSector.setFareComponent((fc[i].fare_component < 0 ? (double)-1
					 : fc[i].fare_component / roerate));
	}
	if (((ProrateSector)audit.getSectors()[si])
	    .getCarrier().equals("XX")
	    ||
	    ((ProrateSector)audit.getSectors()[si])
	    .getCarrier().equals("//")) {
	  si++;
	}
	continue;
      }
      ProrateSector	sector = (ProrateSector)audit.getSectors()[si];
      sector.setFareComponent((fc[i].fare_component < 0 ?
			       (double)-1 : fc[i].fare_component / roerate));
      if (sector.getFareComponent() >= (double)0) {
	isFareComponent = true;
      }
      sector.setSecureCharge(fc[i].security_chrg / roerate);
      sector.setSideTripPlus((fc[i].side_trip_plus < 0 ?
			      (double)-1 : fc[i].side_trip_plus / roerate));
      sector.setClassDiffIndex((fc[i].diff_index > 0) ? 'D' : 0);
      sector.setExstPlus(fc[i].exst_plus / roerate);
      sector.setComponentIndex(fc[i].fare_compo_kbn);
      sector.setComponentKind(fc[i].fare_compo_kind);
      sector.setClassDiffPlus(fc[i].class_differ_plus);
      sector.setSideTripIndex(fc[i].side_trip_index);
      /* ;;; plus[0].amt */
      sector.setSecureIndex(fc[i].security_index);
      sector.setViaRouting(fc[i].via);
      si++;
    }

    if (mileage == 1 && !isFareComponent) {
      ((ProrateSector)audit.getSectors()[si-1]).setFareComponent(total);
    }
    audit.setLessAmt(less);
    audit.setStopOverCharge(add_stop_over_chrg);

    return true;
  }

  void	initialize() {
    yylex.get_end = false;
    yylex.hpn_end = false;
    /* ;;; ResultRoeBeforeEnd added ;;; 20110201 */
    hpn_roe_end = false;

    def_point = 0;
    side_start = 0;
    free_flag = true;

    stop_over_sum = stop_over_tmp = 0;

    place_no = 0;
    place_no_fix = false;
    for (int i = 0; i < MAX_FC; i++) {
      fc[i] = new _fare_cal();
      fc[i].fare_component = (double)-1;
      fc[i].side_trip_plus = (double)-1;
    }

    mileage = 0;
    for (int i = 0; i < MAX_FC_COMP; i++) {
      fc_id[i] = 0;
    }

    roe_rate = (double)0;
    total = (double)0;
    total_type = "";
    add_stop_over_chrg = (double)0;
    less = (double)0;

    tax_no = 0;
    for (int i = 0; i < MAX_TAX; i++) {
      tx[i] = new _tax_value();
    }

    //FC_RESULT = new StringBuffer("                               ");
    FC_RESULT = 0;

    /* /ITפνи */
    it_cnt = 0;
    /* ̲ߥɡסܡ/ITפνиե饰 */
    it_flg = false;

    for (int i = 0; i < MAX_DIFFS; i++) {
      dftbl[i] = new _diff_table();
      diffApplicable[i] = false;
    }
    diff_index = 0;
  }
  
  void	terminate() {
    for (int i = 0; i < MAX_FC; i++) {
      fc[i] = null;
    }
    for (int i = 0; i < MAX_TAX; i++) {
      tx[i] = null;
    }
    for (int i = 0; i < MAX_DIFFS; i++) {
      dftbl[i] = null;
    }
  }

  boolean	isFinish(String fareCal, int fareCalPtr) {
    if (fareCalPtr >= fareCal.length()) {
      return true;
    }
    return false;
  }
  
  boolean	getFareCalInfo() {
    double	value;
    String[]	fromPlace = new String[1], toPlace = new String[1];
    int[]	fromId = null, toId = null;
    int[]	nextId = null;
    boolean	isDiffApplied = false;
    /* ;;; PLUS Proration ۥȡ */
    double	plus_total = (double)0;
    int	i;

    switch (lex) {

    case Yylex.DATE:
      break;

    case Yylex.FC:
      break;

    case Yylex.PLACE:
      if (place_no == 0) {
	/* Fare Calculationκǽζɡoriginȯ */
	fc[0].dep_code = yylex.yytext();
      }
      else {
	/* ǽʳζɡϤޤϽ */
	fc[place_no-1].dest_code = yylex.yytext();
	fc[place_no].dep_code = yylex.yytext();
	fc[place_no-1].fare_compo_kbn = mileage;
      }
      place_no++;
      break;

    case Yylex.PLACENOSTOP:
    case Yylex.PLACENOSTOP2:
      if (place_no == 0) {
	fc[0].dep_code = right(yylex.yytext(), 3);
	fc[0].stop_over = 'X';
      }
      else {
	fc[place_no-1].dest_code = right(yylex.yytext(), 3);
	fc[place_no].dep_code = fc[place_no-1].dest_code;
	fc[place_no].stop_over = 'X';
	fc[place_no-1].fare_compo_kbn = mileage;
      }
      place_no++;
      break;

    case Yylex.PLACEEMA:
    case Yylex.PLACERMR:
      if (place_no == 0) {
	fc[0].dep_code = right(yylex.yytext(), 3);
      }
      else {
	fc[place_no-1].dest_code = right(yylex.yytext(), 3);
	fc[place_no].dep_code = fc[place_no-1].dest_code;
	fc[place_no-1].fare_compo_kbn = mileage;
      }
      place_no++;
      break;

    case Yylex.LOWESTCOMBI2:
      break;

    case Yylex.LOWESTCOMBI:
      if (place_no == 0) {
	fc[0].dep_code = right(yylex.yytext(), 3);
      }
      else {
	fc[place_no-1].dest_code = right(yylex.yytext(), 3);
	fc[place_no-1].carrier = "XX";
	fc[place_no].dep_code = fc[place_no-1].dest_code;
	fc[place_no-1].fare_compo_kbn = mileage;
      }
      place_no++;
      //FC_RESULT.setCharAt(LOWES, 'j');
      FC_RESULT |= 1 << ResultLowestCombi;
      break;

    case Yylex.PLACENOPASS:
      if (place_no == 0) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
	return false;
      }
      fc[place_no-1].dest_code = yylex.yytext().substring(1, 4);
      fc[place_no-1].carrier = "XX";
      fc[place_no].dep_code = fc[place_no-1].dest_code;
      fc[place_no-1].fare_compo_kbn = mileage;
      place_no ++;
      //FC_RESULT.setCharAt(SRFC, 'r');
      FC_RESULT |= 1 << ResultSurface;
      break;

    case Yylex.CARRIER:
      if (place_no == 0) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
	return false;
      }
      fc[place_no-1].carrier = yylex.yytext();
      break;

    case Yylex.CARRIERROUTE:
      if (place_no == 0) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
	return false;
      }
      fc[place_no-1].carrier = yylex.yytext().substring(0, 2);
      fc[place_no-1].via = right(yylex.yytext(), 4).substring(1, 3);
      break;

    case Yylex.WALK:
      if (place_no == 0) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
	return false;
      }
      fc[place_no-1].carrier = "XX";
      //FC_RESULT.setCharAt(SRFC, 'r');
      FC_RESULT |= 1 << ResultSurface;
      break;

    case Yylex.MILEAGE:
    case Yylex.ROUTE:
    case Yylex.MILEAGE1SECT:
    case Yylex.MILEAGE2:
      if (place_no < 2) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
	return false;
      }
      fc[place_no - 2].compo_end = 1;
      fc_id[mileage] = place_no - 2;
      value = getNumber(yylex.yytext());
      if (value == (double)0) {
	value = ZERO_VALUE;
	//FC_RESULT.setCharAt(FCDUM, 'v');
	FC_RESULT |= 1 << ResultValueZero;
      }
      else {
	free_flag = false;
      }
      if (side_start == 0) {
	for (i = def_point; i < place_no-1; i++) {
	  if (fc[i].fare_compo_kind == 0) {
	    fc[i].fare_compo_kind = 1;
	  }
	}
	def_point = place_no - 1;
	mileage++;
	fc[place_no-2].fare_component = value;
      }
      else {
	for (i = side_start; i < place_no-1; i++) {
	  fc[i].fare_compo_kind = 3;
	  fc[i].side_trip_index = 'S';
	}
	fc[place_no-2].side_trip_plus = value;
      }
      break;

    case Yylex.DIFF:
    case Yylex.DIFF2:
    case Yylex.DIFFREV:
    case Yylex.DIFFREV2:
    case Yylex.DIFFADT:
    case Yylex.DIFFFCADT:
    case Yylex.DIFFFADT:
    case Yylex.DIFFCADT:
    case Yylex.EXTRASEAT:
      /* CLASS DIFFERENTIALղóۤ */
      value = getNumber(yylex.yytext());
      /* CLASS DIFFERENTIALоݶ֤ */
      fromId = new int[1];
      toId = new int[1];
      nextId = new int[1];
      fromId[0] = toId[0] = nextId[0] = -1;
      while (analyzeFromTo(true, fromId, toId, nextId, fromPlace, toPlace)) {
	if (lex == Yylex.EXTRASEAT) {	/* ;;; EXTRASEAT not defined (yet??) */
	  for (i = fromId[0]; i <= toId[0]; i++) {
	    fc[i].exst_plus = value;
	  }
	  continue;
	}
	boolean	isAlreadyDiff = false;
	for (i = fromId[0]; i <= toId[0]; i++) {
	  if (fc[i].diff_index > 0) {
	    isAlreadyDiff = true;
	  }
	}
	if (isAlreadyDiff) {
	  continue;
	}
	if (fromId[0] >= 0 && toId[0] >= 0) {
	  for (i = fromId[0]; i <= toId[0]; i++) {
	    fc[i].diff_index = diff_index + 1;
	  }
	  fc[toId[0]].class_differ_plus = value;
	  isDiffApplied = true;
	}
      }
      if (!isDiffApplied) {
	for (i = 0; i < diff_index+1; i++) {
	  if (((dftbl[i].from.equals(fromPlace[0])
		&& dftbl[i].to.equals(toPlace[0]))
	       || (dftbl[i].from.equals(toPlace[0])
		   && dftbl[i].to.equals(fromPlace[0])))
	      && value == dftbl[i].value) {
	    if (dftbl[i].count >= 2) {
	      //FC_RESULT.setCharAt(DIF, 'G');
	      FC_RESULT |= 1 << ResultDifficultDiff;
	      fc_error = true;
	      return false;
	    }
	    dftbl[i].count = 2;
	    return true;
	  }
	}
	//FC_RESULT.setCharAt(DIF, 'G');
	FC_RESULT |= 1 << ResultDifficultDiff;
	fc_error = true;
	return false;
      }

      if (lex == Yylex.EXTRASEAT) {
	/* ;;; EXTRASEAT not defined (yet??), handle as an Error */
	//FC_RESULT.setCharAt(DIF, 'G');
	FC_RESULT |= 1 << ResultDifficultDiff;
	fc_error = true;
	return false;
      }

      if (toPlace[0].compareTo(fromPlace[0]) > 0) {
	dftbl[diff_index+1].from = toPlace[0];
	dftbl[diff_index+1].to = fromPlace[0];
	dftbl[diff_index+1].value = value;
	dftbl[diff_index+1].count = 1;
      }
      else {
	dftbl[diff_index+1].from = fromPlace[0];
	dftbl[diff_index+1].to = toPlace[0];
	dftbl[diff_index+1].value = value;
	dftbl[diff_index+1].count = 1;
      }
      diff_index++;
      //FC_RESULT.setCharAt(DIF, 'g');
      FC_RESULT |= 1 << ResultClassDiff;
      /* ;;;
	 return false;
	 fc_error = true;
      */
      break;

    case Yylex.STOPOVER:
      value = getNumber(yylex.yytext());
      if (Character.isLowerCase(yylex.yytext().charAt(0))
	  || Character.isUpperCase(yylex.yytext().charAt(0))) {
	add_stop_over_chrg = value;
      }
      else {
	if (place_no < 2) {
	  //FC_RESULT.setCharAt(DEFA, 'a');
	  FC_RESULT |= 1 << ResultParseError;
	  return false;
	}
	fc[place_no-2].stop_over_chrg = value;
	stop_over_tmp += value;
	add_stop_over_chrg = stop_over_tmp;
      }
      stop_over_sum += value;
      break;

    case Yylex.SECURE:
      if (place_no < 2) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
	return false;
      }
      fc[place_no-2].security_chrg = getNumber(yylex.yytext());
      fc[place_no-2].security_index = 'Q';
      //FC_RESULT.setCharAt(SECU, 'q');
      FC_RESULT |= 1 << ResultSecurityCharge;
      break;

    case Yylex.PLUSNORMAL:
      /*
	if (FC_RESULT.charAt(PLU) == 0 || FC_RESULT.charAt(PLU) == ' ') {
	FC_RESULT.setCharAt(PLU, 'e');
	}
      */
      if (FC_RESULT == 0) {
	FC_RESULT |= 1 << ResultPlusNormal;
      }
      /* ;;;
	 return false;
      */
      /* ;;;
	 fc_error = true;
	 break;
      */

    case Yylex.PLUS1SECT:
    case Yylex.PLUS2SECT:
      /* PLUSоݶ֤ */
      /* ;;; this process is out now
	 (void)analyzeFromTo(false, fromId, toId, nextId,
	 &fromPlace, &toPlace);
	 if (fromId[0] == toId[0]) {
	 resetFareComponent();
	 }
	 else {
	 value = getNumber(yylex.yytext());
	 for (i = fromId[0]; i <= toId[0]; i++) {
	 fc[i].plus = value;
	 }
	 if (fc[toId[0]].fare_component > 0) {
	 fc[toId[0]].fare_component += value;
	 }
	 else {
	 fc[toId[0]].fare_component = value;
	 }
	 }
	 if (FC_RESULT.charAt(PLU) == 0 || FC_RESULT.charAt(PLU) == ' ') {
	 FC_RESULT.setCharAt(PLU, 'f');
	 }
      */
      if (FC_RESULT == 0) {
	FC_RESULT |= 1 << ResultPlusSector;
      }
      /* ;;;
	 return false;
      */
      /* ;;;
	 fc_error = true;
	 break;
      */

    case Yylex.PLUSHALFRT:
      /* PLUSоݶ֤ */
      /* ;;; this process is out now
	 (void)analyzeFromTo(false, fromId, toId, nextId,
	 &fromPlace, &toPlace);
	 value = getNumber(yylex.yytext());
	 for (i = fromId[0]; i <= toId[0]; i++) {
	 fc[i].plus = value;
	 }
	 if (fc[toId[0]].fare_component > 0) {
	 fc[toId[0]].fare_component += value;
	 }
	 else {
	 fc[toId[0]].fare_component = value;
	 }
	 if (FC_RESULT.charAt(PLU) == 0 || FC_RESULT.charAt(PLU) == ' ') {
	 FC_RESULT.setCharAt(PLU, 'i');
	 }
      */
      if (FC_RESULT == 0) {
	FC_RESULT |= 1 << ResultPlusHalfRt;
      }
      /* ;;;
	 return false;
      */
      /* ;;;
	 fc_error = true;
	 break;
      */

    case Yylex.PLUSYSECT:
    case Yylex.PLUSLOWCOMBI:
      /*
	if (FC_RESULT.charAt(PLU) == 0 || FC_RESULT.charAt(PLU) == ' ') {
	FC_RESULT.setCharAt(PLU, ((lex == Yylex.PLUSYSECT) ? 'k' : 'l'));
	}
      */
      if (FC_RESULT == 0) {
	FC_RESULT |= 1 << ((lex == Yylex.PLUSYSECT) ?
			   ResultPlusYSect : ResultPlusLowCombi);
      }
      /* ;;;
	 return false;
      */
      /* ;;;
	 fc_error = true;
	 break;
      */
      /* ;;; PLUS Proration ̽ */
      if (place_no < 2) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
	return false;
      }
      plus = true;
      plus_total = (double)0;
      /* PLUSûۤ */
      value = getNumber(yylex.yytext());
      for (i = 0; i <= place_no - 2; i++) {
	if (fc[i].fare_component >= 0) {
	  plus_total += fc[i].fare_component;
	}
	fc[i].fare_component = (double)-1;
	if (fc[i].side_trip_plus >= 0) {
	  plus_total += fc[i].side_trip_plus;
	}
	fc[i].side_trip_plus = (double)-1;
	if (fc[i].side_trip_index == 'S') {
	  fc[i].side_trip_index = '\0';
	}
	fc[i].fare_compo_kbn = 0;
	fc[i].fare_compo_kind = 1;
	fc[i].compo_end = 0;
      }
      fc[place_no - 2].fare_component = plus_total + value;
      fc[place_no - 2].compo_end = 1;
      break;

    case Yylex.LESS:
      less = getNumber(yylex.yytext());
      //FC_RESULT.setCharAt(LES, 'l');
      FC_RESULT |= 1 << ResultLess;
      /* ;;;
	 return false;
      */
      fc_error = true;
      break;

    case Yylex.MEQUALIZE:
      break;

    case Yylex.TOTAL:
      total = getNumber(yylex.yytext());
      total_type = yylex.yytext().substring(0, 3);
      break;

    case Yylex.BINCTOUR:
      break;

      /* M/IT/ITפλM100.0פȲ᤹ */
    case Yylex.INCTOUR:
    case Yylex.INCTOUR2:
      if (place_no < 2) {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
      }
      fc[place_no - 2].compo_end = 1;
      fc_id[mileage] = place_no - 2;
      value = 100.0;
      if (value == (double)0) {
	value = ZERO_VALUE;
	//FC_RESULT.setCharAt(FCDUM, 'v');
	FC_RESULT |= 1 << ResultValueZero;
      }
      else {
	free_flag = false;
      }
      if (side_start == 0) {
	for (i = def_point; i < place_no-1; i++) {
	  if (fc[i].fare_compo_kind == 0) {
	    fc[i].fare_compo_kind = 1;
	  }
	}
	def_point = place_no - 1;
	mileage++;
	fc[place_no-2].fare_component = value;
      }
      else {
	for (i = side_start; i < place_no-1; i++) {
	  fc[i].fare_compo_kind = 3;
	  fc[i].side_trip_index = 'S';
	}
	fc[place_no-2].side_trip_plus = value;
      }

      /* /ITפνи򥫥 */
      it_cnt++;

      break;

      /* ̲ߥɡסܡ/ITפλ̲ߥɡסܡx00.00פȲ᤹ */
    case Yylex.TOTAL2:
      total = (double)it_cnt * 100.0;
      total_type = yylex.yytext().substring(0, 3);

      /* ̲ߥɡסܡ/ITפνиե饰ϣ */
      it_flg = true;

      break;

    case Yylex.END:
      /* ;;; ResultRoeBeforeEnd added ;;; 20110201 */
      if (hpn_roe_end) {
	FC_RESULT |= 1 << ResultRoeBeforeEnd;
	fc_error = true;
	System.err.println("hpn_roe_end = [" + hpn_roe_end + "], fc_error = [" +  fc_error + "], return false");
	return false;
      }
      /* ;;; ResultRoeBeforeEnd added ;;; 20110201 END */
      if (place_no > 0) {
	place_no --;
      }
      else {
	mileage = 0;
      }

      /* /ITפи̲ߥɡסܡ/ITפиʤä
	 NUC x00.00פˤ */
      if (it_cnt >= 1 && it_flg == false) {
	total_type = "NUC";
	total = (double)it_cnt * 100.0;
      }
	    
      break;

    case Yylex.END_ROE:
      /* ;;; ResultRoeBeforeEnd added ;;; 20110201 */
      hpn_roe_end = true;
      if (place_no > 0) {
	place_no --;
      }
      else {
	mileage = 0;
      }
      roe_rate = getNumber(yylex.yytext());

      /* /ITפи̲ߥɡסܡ/ITפиʤä
	 NUC x00.00פˤ */
      if (it_cnt >= 1 && it_flg == false) {
	total_type = "NUC";
	total = (double)it_cnt * 100.0;
      }

      break;

    case Yylex.ROE:
      roe_rate = getNumber(yylex.yytext());

      /* /ITפи̲ߥɡסܡ/ITפиʤä
	 NUC x00.00פˤ */
      if (it_cnt >= 1 && it_flg == false) {
	total_type = "NUC";
	total = (double)it_cnt * 100.0;
      }

      break;

    case Yylex.XT:
      break;

    case Yylex.FTAX:
      if (tax_no < MAX_TAX) {
	tx[tax_no].tax = getNumber(yylex.yytext());
	tx[tax_no].tax_kind = right(yylex.yytext(), 2);
      }
      tax_no++;
      if (tax_no > MAX_TAX) {
	//FC_RESULT.setCharAt(MTAX, 'c');
	FC_RESULT |= 1 << ResultOverMaxTax;
	/* ;;;
	   return false;
	*/
	fc_error = true;
      }
      //FC_RESULT.setCharAt(TA, 'x');
      FC_RESULT |= 1 << ResultFTax;
      break;

    case Yylex.XFTAX:
      break;

    case '(':
    case '<':
      side_start = place_no-1;
      //FC_RESULT.setCharAt(SITR, 's');
      FC_RESULT |= 1 << ResultSideTrip;
      break;

    case ')':
    case '>':
      side_start = 0;
      break;

    case 0:
      break;

    default:
      if (yylex.yytext().equals("C")) {
	//FC_RESULT.setCharAt(DEFA, 'o');
	FC_RESULT |= 1 >> ResultParseErrorO;
      }
      else if (yylex.yytext().equals(" ")) {
	//FC_RESULT.setCharAt(DEFA, 'b');
	FC_RESULT |= 1 << ResultParseErrorB;
      }
      else {
	//FC_RESULT.setCharAt(DEFA, 'a');
	FC_RESULT |= 1 << ResultParseError;
      }
      return false;
    }

    return true;
  }
  
  double	getNumber(String str) {
    int	index;
    char	c;
    for (index = str.length()-1, c = str.charAt(index);
	 index > 0 && !Character.isDigit(c) && c != '-' && c != '+';
	 index --, c = str.charAt(index));
    int	postIndex = (Character.isDigit(c) ? index+1 : index);
    for ( ;
	  index > 0 && (Character.isDigit(c) || c == '.');
	  index --, c = str.charAt(index));
    if (!Character.isDigit(c) && c != '-') {
      index ++;
    }
    return Double.parseDouble(str.substring(index, postIndex));
  }
  
  String	right(String src, int len) {
    return ((src.length() > len) ? src.substring(src.length() - len) : src);
  }

  boolean	analyzeFromTo(boolean flag,
			      int[] fromId, int[] toId, int[] nextId,
			      String[] fromPlaceRet, String[] toPlaceRet) {
    int	index = 1;

    while (!Character.isLowerCase(yylex.yytext().charAt(index))
	   && !Character.isUpperCase(yylex.yytext().charAt(index))) {
      index++;
    }

    fromPlaceRet[0] = yylex.yytext().substring(index, index+3);
    index += 3;
    while (!Character.isLowerCase(yylex.yytext().charAt(index))
	   && !Character.isUpperCase(yylex.yytext().charAt(index))) {
      index++;
    }
    toPlaceRet[0] = yylex.yytext().substring(index, index+3);

    int	min = -1;
    int	max = -1;
    if (flag) {	/* եݡͥζ֤Τߤоݤ˲Ϥ */
      if (nextId[0] >= 0) {
	min = nextId[0];
	if (min > place_no - 2) {
	  return false;
	}
      }
      else {
	min = 0;
      }
      if (min > place_no - 2) {
	min = place_no - 2;
      }
      while (min <= place_no - 2) {
	for (max = min;
	     (max <= place_no - 2
	      && fc[max].fare_component < 0 && fc[max].side_trip_plus < 0);
	     max ++);
	if (max > place_no - 2) {
	  max = place_no - 2;
	}
	if (doAnalyzeFromTo(min, max, fromPlaceRet[0], toPlaceRet[0],
			    fromId, toId)) {
	  if (fromId[0] >= 0 && toId[0] >= 0) {
	    nextId[0] = toId[0] + 1;
	  }
	  else {
	    nextId[0] = max + 1;
	  }
	  return true;
	}
	min = max + 1;
      }
    }
    else {
      fromId[0] = toId[0] = nextId[0] = -1;
      return doAnalyzeFromTo(0, place_no - 2, fromPlaceRet[0], toPlaceRet[0],
			     fromId, toId);
    }
    return false;
  }

  boolean	doAnalyzeFromTo(int min, int max,
				String fromPlace, String toPlace,
				int fromId[], int toId[]) {
    int	i;
    fromId[0] = -1;
    toId[0] = -1;
    for (i = min;
	 i <= max && !fc[i].dep_code.equals("")
	   && !fc[i].dep_code.equals(fromPlace);
	 i++);
    if (i <= max && !fc[i].dep_code.equals("")) {
      fromId[0] = i;
    }
    for (;
	 i <= max && !fc[i].dest_code.equals("")
	   && !fc[i].dest_code.equals(toPlace);
	 i++);
    if (i <= max && !fc[i].dest_code.equals("")) {
      toId[0] = i;
    }
    if (fromId[0] >= 0 && toId[0] >= 0) {
      return true;
    }
    for (i = min;
	 i <= max && !fc[i].dep_code.equals("")
	   && !fc[i].dep_code.equals(toPlace);
	 i++);
    if (i <= max && !fc[i].dep_code.equals("")) {
      fromId[0] = i;
    }
    for (;
	 i <= max && !fc[i].dest_code.equals("")
	   && !fc[i].dest_code.equals(fromPlace);
	 i++);
    if (i <= max && !fc[i].dest_code.equals("")) {
      toId[0] = i;
    }
    if (fromId[0] >= 0 && toId[0] >= 0) {
      return true;
    }
    return false;
  }

  void	resetFareComponent() {
    for (int i = 0; i <= place_no-2; i++) {
      fc[place_no-2].fare_component +=
	(fc[i].fare_component > 0 ? fc[i].fare_component : 0);
      fc[i].fare_component = (double)-1;
      fc[i].fare_compo_kbn = 1;
    }
    fc[place_no-2].fare_compo_kbn = 1;
  }

  boolean	totalSumCheck() {
    double	fare_total = (double)0;
    for (int i = 0; i < place_no; i++) {
      fare_total += (fc[i].fare_component > 0 ? fc[i].fare_component : 0);
      fare_total += fc[i].class_differ_plus;
      fare_total += fc[i].security_chrg;
      /* fare_total += fc[i].plus; */
      fare_total += (fc[i].side_trip_plus > 0 ? fc[i].side_trip_plus : 0);
      fare_total += fc[i].exst_plus;
    }
    fare_total += add_stop_over_chrg;
    if (Math.abs(fare_total - total) < 0.01) {
      return true;
    }
    return false;
  }

  boolean	sectorCheck() {
    for (int i = 0; i <= diff_index; i++) {
      diffApplicable[i] = false;
    }
    int	compoBegin = 0;
    int	compoBeginSector = 0;
    int	j = 0;
    for (int i = 0; i < place_no; i++) {
      if (j >= audit.getSectors().length) {
	return false;
      }
      ProrateSector	sector = (ProrateSector)audit.getSectors()[j];
      if ((fc[i].carrier.equals("XX") || fc[i].carrier.equals("//"))
	  && !sector.getCarrier().equals("XX")
	  && !sector.getCarrier().equals("//")) {
	continue;
      }
      if (!fc[i].carrier.equals("XX") && !fc[i].carrier.equals("//")
	  && (sector.getCarrier().equals("XX")
	      || sector.getCarrier().equals("//"))) {
	j++;
	i--;
	continue;
      }
      if ((!audit.isIgnoreFareCalcCarrier()
	   && !sector.getCarrier().equals(fc[i].carrier))
	  || (!sector.getDepCode().equals(fc[i].dep_code)
	      && !sector.getDepAirport().equals(fc[i].dep_code))
	  || (!sector.getDestCode().equals(fc[i].dest_code)
	      && !sector.getDestAirport().equals(fc[i].dest_code))) {
	return false;
      }
      if (fc[i].fare_component >= 0 || fc[i].side_trip_plus >= 0) {
	if (!classDiffCheck(compoBegin, compoBeginSector, i, j)) {
	  //FC_RESULT.setCharAt(DIF, 'G');
	  FC_RESULT |= 1 << ResultDifficultDiff;
	  fc_error = true;
	  return false;
	}
	compoBegin = i + 1;
	compoBeginSector = j + 1;
      }
      j++;
    }
    if (j != audit.getSectors().length) {
      return false;
    }
    for (int i = 1; i <= diff_index; i++) {
      if (!diffApplicable[i]) {
	//FC_RESULT.setCharAt(DIF, 'G');
	FC_RESULT |= 1 << ResultDifficultDiff;
	fc_error = true;
	return false;
      }
    }
    return true;
  }

  boolean	plusCheck() {
    char	commonClass = '\0';
    for (int i = 0, j = 0; i < place_no; i++) {
      if (j >= audit.getSectors().length) {
	return false;
      }
      ProrateSector	sector = (ProrateSector)audit.getSectors()[j];
      if ((fc[i].carrier.equals("XX") || fc[i].carrier.equals("//"))
	  && !sector.getCarrier().equals("XX")
	  && !sector.getCarrier().equals("//")) {
	continue;
      }
      if (!fc[i].carrier.equals("XX") && !fc[i].carrier.equals("//")
	  && (sector.getCarrier().equals("XX")
	      || sector.getCarrier().equals("//"))) {
	j++;
	i--;
	continue;
      }
      char	cls = sector.getFareBasis().charAt(0);
      if (ProrateRuleObject.Y_classes.indexOf(cls) >= 0) {
	cls = 'Y';
      }
      else if (ProrateRuleObject.C_classes.indexOf(cls) >= 0) {
	cls = 'C';
      }
      else if (ProrateRuleObject.F_classes.indexOf(cls) >= 0) {
	cls = 'F';
      }
      if (commonClass == '\0' && fc[i].diff_index == 0) {
	commonClass = cls;
      }
      else if (commonClass != cls && fc[i].diff_index == 0) {
	return false;
      }
      j++;
    }
    return true;
  }

  boolean	sectorCreate() {
    int	numSectors = 0;	/* FareCalculationֿͭ */
    for (int i = 0; i < place_no; i++) {
      if (fc[i].carrier.equals("XX") || fc[i].carrier.equals("//")) {
	continue;
      }
      numSectors++;
    }
    List	sectors = null;
    if (numSectors > 0) {
      sectors = new Vector();
    }
    for (int i = 0; i < place_no; i++) {
      if (fc[i].carrier.equals("XX") || fc[i].carrier.equals("//")) {
	continue;
      }
      ProrateSector	sector = new ProrateSector();
      sector.setCarrier(fc[i].carrier);
      sector.setDepCode(fc[i].dep_code);
      sector.setDestCode(fc[i].dest_code);
      sectors.add(sector);
    }
    if (sectors == null) {
      audit.setSectors(null);
      return true;
    }
    ProrateSector[]	sectorsArray = new ProrateSector[sectors.size()];
    for (int j = 0; j < sectors.size(); j++) {
      sectorsArray[j] = (ProrateSector)sectors.get(j);
    }
    audit.setSectors(sectorsArray);
    return true;
  }

  boolean
    classDiffCheck(int min, int minSector, int max, int maxSector) {
    boolean	found_indexes[] = new boolean[diff_index+1];
    boolean	apply_indexes[] = new boolean[diff_index+1];
    for (int i = 0; i <= diff_index; i++) {
      found_indexes[i] = false;
      apply_indexes[i] = true;
    }
    boolean	found_index = false;
    boolean	found_value = false;
    for (int i = min; i <= max; i++) {
      if (fc[i].diff_index > 0) {
	found_index = true;
	found_indexes[fc[i].diff_index] = true;
      }
      if (fc[i].class_differ_plus > 0) {
	found_value = true;
      }
    }
    if (!found_index && !found_value) {
      return true;
    }
    else if (!found_index || !found_value) {
      return false;
    }

    char	lowest;
    if ((lowest = getLowestClass()) == 'F') {
      return false;
    }
    int	j = minSector;
    for (int i = min; i <= max && j <= maxSector; i++) {
      ProrateSector	sector = (ProrateSector)audit.getSectors()[j];
      if ((fc[i].carrier.equals("XX") || fc[i].carrier.equals("//"))
	  && !sector.getCarrier().equals("XX")
	  && !sector.getCarrier().equals("//")) {
	continue;
      }
      if (!fc[i].carrier.equals("XX") && !fc[i].carrier.equals("//")
	  && (sector.getCarrier().equals("XX")
	      || sector.getCarrier().equals("//"))) {
	j++;
	i--;
	continue;
      }
      if (fc[i].diff_index > 0) {
	if (!isUpperClass(j, lowest)) {
	  apply_indexes[fc[i].diff_index] = false;
	}
      }
      j++;
    }
    j = minSector;
    for (int i = min; i <= max && j <= maxSector; i++) {
      if (fc[i].diff_index > 0 && !apply_indexes[fc[i].diff_index]) {
	fc[i].diff_index = 0;
	fc[i].class_differ_plus = (double)0;
      }
    }
    for (int i = 0; i <= diff_index; i++) {
      if (found_indexes[i] && apply_indexes[i] && diffApplicable[i]) {
	if (dftbl[i].count > 2) {
	  return false;
	}
	if (dftbl[i].count == 2) {
	  dftbl[i].count = 3;
	}
	else {
	  return false;
	}
      }
      if (found_indexes[i] && apply_indexes[i]) {
	diffApplicable[i] = true;
      }
    }

    return true;
  }

  boolean
    skipFareBasis(int pos, int[] fareCalPtr, String fareCal[]) {
    return skipFareBasis(pos, fareCalPtr, fareCal, true);
  }

  static int	stop_lex[] = {
    Yylex.MILEAGE, Yylex.MILEAGE1SECT, Yylex.MILEAGE2, Yylex.ROUTE,
    Yylex.INCTOUR, Yylex.INCTOUR2,
    Yylex.DIFF, Yylex.DIFF2, Yylex.DIFFREV, Yylex.DIFFREV2,
    Yylex.DIFFADT, Yylex.DIFFFCADT, Yylex.DIFFFADT, Yylex.DIFFCADT,
    Yylex.EXTRASEAT, -1
  };

  boolean	skipFareBasis(int pos, int[] fareCalPtr, String fareCal[],
			      boolean exactPos) {
    int	stop_pos[] = new int[1];
    stop_pos[0] = -1;
    if (exactPos) {
      /* 顼֤fareBasis԰ */
      if (!doSkipFareBasis(pos, fareCal)) {
	return false;
      }
      fareCalPtr[0] = 0;
      if (doAnalyze(fareCal[0], fareCalPtr, stop_lex, stop_pos) == false) {
	if (stop_pos[0] < 0) {
	  return false;	/* ¾Υ顼ȯ */
	}
      }
    }
    fareCalPtr[0] = 0;
    while (doAnalyze(fareCal[0], fareCalPtr, stop_lex, stop_pos) == false) {
      if (stop_pos[0] < 0) {
	return false;	/* ¾Υ顼ȯ */
      }
      /* ƤMILEAGEθfareBasisʤƤ */
      doSkipFareBasis(fareCalPtr[0], fareCal);
      fareCalPtr[0] = 0;
    }
    return true;
  }

  boolean	doSkipFareBasis(int pos, String[] str) {
    for (;
	 (pos < str[0].length() &&
	  (str[0].charAt(pos) == ' ' || str[0].charAt(pos) == '\t'));
	 pos++);

    List	basisStrList = new Vector();
    for (int i = 0; i < audit.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)audit.getSectors()[i];

      basisStrList.add(sector.getFareBasis());

      int	index = -1;
      if ((index = sector.getFareBasis().indexOf(' ')) >= 0) {
	basisStrList.add(sector.getFareBasis().substring(0, index));
      }

      index = -1;
      if ((index = sector.getFareBasis().indexOf('/')) >= 0) {
	basisStrList.add(sector.getFareBasis().substring(0, index));
      }

      index = -1;
      int	index2 = -1;
      if ((index = sector.getFareBasis().lastIndexOf('/')) >= 0) {
	if ((index2 = sector.getFareBasis().lastIndexOf(' ')) >= 0
	    && index2 > index) {
	  index = index2;
	}
	basisStrList.add(sector.getFareBasis().substring(index+1));
      }

      basisStrList.add(sector.getFareBasisFullStr());

      index = -1;
      if ((index = sector.getFareBasisFullStr().indexOf(' ')) >= 0) {
	basisStrList.add(sector.getFareBasisFullStr().substring(0, index));
      }

      index = -1;
      if ((index = sector.getFareBasisFullStr().indexOf('/')) >= 0) {
	basisStrList.add(sector.getFareBasisFullStr().substring(0, index));
      }

      index = -1;
      index2 = -1;
      if ((index = sector.getFareBasisFullStr().lastIndexOf('/')) >= 0) {
	if ((index2 = sector.getFareBasisFullStr().lastIndexOf(' ')) >= 0
	    && index2 > index) {
	  index = index2;
	}
	basisStrList.add(sector.getFareBasisFullStr().substring(index+1));
      }

    }

    Object[]	basisStrArray = (Object[])basisStrList.toArray();
    Arrays.sort(basisStrArray,
		new Comparator() {
		  public int compare(Object o1, Object o2) {
		    String	str1 = (String)o1;
		    String	str2 = (String)o2;
		    if (str1.length() > str2.length()) {
		      return -1;
		    }
		    if (str1.length() < str2.length()) {
		      return 1;
		    }
		    return 0;
		  }
		}
		);

    for (int i = 0; i < basisStrArray.length; i++) {
      String	basisStr = (String)basisStrArray[i];
      /* MILEAGEθfareBasisʤԲǽ */
      if (str[0].substring(pos).length() < basisStr.length()) {
	return false;
      }
      if (basisStr.equals(str[0].substring(pos, pos+basisStr.length()))) {
	StringBuffer	strbuf = new StringBuffer(str[0]);
	for (int k = 0; k < basisStr.length(); k++) {
	  strbuf.setCharAt(pos+k, ' ');
	}
	str[0] = strbuf.toString();
	return true;
      }
    }
    return false;
  }

  boolean	preProcess(String[] fareCal) {
    /* Ƭʸֱѻܿפξ硢Ƭαѻ */
    if ((Character.isLowerCase(fareCal[0].charAt(0))
	 || Character.isUpperCase(fareCal[0].charAt(0)))
	&& Character.isDigit(fareCal[0].charAt(1))) {
      fareCal[0] = fareCal[0].substring(1);
      return true;
    }

    /* ƬʸITפξ硢Ϥߤ */
    if (fareCal[0].substring(0, 2).equals("IT")) {
      if (fareCal[0].substring(0, 3).equals("ITM")
	  || fareCal[0].substring(0, 3).equals("ITH")
	  || fareCal[0].substring(0, 3).equals("ITK")
	  || fareCal[0].substring(0, 3).equals("ITN")
	  || fareCal[0].substring(0, 3).equals("ITO")) {
      }
      else {
	return false;
      }
    }

    /* ƬʸFPפξ硢ǽ˸FCפõ
       FPסFCפ */
    if (fareCal[0].substring(0, 2).equals("FP")) {
      int	fareCalPtr = fareCal[0].indexOf("FC");
      if (fareCalPtr >= 0) {
	fareCal[0] = fareCal[0].substring(fareCalPtr+2);
	return true;
      }
    }

    return true;
  }

  char	getLowestClass() {
    char	lowest = 'F';
    char	cls;
    for (int i = 0, j = 0; i < place_no; i++) {
      if (j >= audit.getSectors().length) {
	return lowest;
      }
      ProrateSector	sector = (ProrateSector)audit.getSectors()[j];
      if ((fc[i].carrier.equals("XX") || fc[i].carrier.equals("//"))
	  && !sector.getCarrier().equals("XX")
	  && !sector.getCarrier().equals("//")) {
	continue;
      }
      if (lowest == 'F') {
	cls = sector.getFareBasis().charAt(0);
	if (ProrateRuleObject.Y_classes.indexOf(cls) >= 0) {
	  lowest = 'Y';
	  break;
	}
	else if (ProrateRuleObject.C_classes.indexOf(cls) >= 0) {
	  lowest = 'C';
	}
      }
      else if (lowest == 'C') {
	cls = sector.getFareBasis().charAt(0);
	if (ProrateRuleObject.Y_classes.indexOf(cls) >= 0) {
	  lowest = 'Y';
	  break;
	}
      }
      j++;
    }
    return	lowest;
  }

  boolean	isUpperClass(int idx, char lowest) {
    char
      cls = ((ProrateSector)audit.getSectors()[idx]).getFareBasis().charAt(0);
    if (lowest == 'F') {
      return false;
    }
    else if (lowest == 'C') {
      if (ProrateRuleObject.F_classes.indexOf(cls) >= 0) {
	return true;
      }
      return false;
    }
    if (ProrateRuleObject.F_classes.indexOf(cls) >= 0) {
      return true;
    }
    if (ProrateRuleObject.C_classes.indexOf(cls) >= 0) {
      return true;
    }
    return false;
  }

  String	makeFcResultStr(int FC_RESULT) {
    StringBuffer	resultStr = new StringBuffer();
    for (int i = 0; i < MAX_FC_RESULT; i++) {
      int	bit = 1 << i;
      if ((FC_RESULT & bit) != 0) {
	if (resultStr.length() > 0) {
	  resultStr.append(",");
	}
	String	mesg = "";
	switch (i) {
	case ResultAllTkSector:
	  mesg = "AllSectorsAreByTicketingCarrier";
	  break;
	case ResultSectorCheckFail:
	  mesg = "SectorCheckFailed";
	  break;
	case ResultPlusCheckFail:
	  mesg = "PlusCheckFailed";
	  break;
	case ResultSecurityCharge:
	  mesg = "SecurityChargeAcounted";
	  break;
	case ResultClassDiff:
	  mesg = "ClassDifferentialAcounted";
	  break;
	case ResultDifficultDiff:
	  mesg = "ClassDifferentialNotProcessed";
	  break;
	case ResultNoTotalCurrency:
	  mesg = "NoCurrencyInTotal";
	  break;
	case ResultLess:
	  mesg = "LessAccounted";
	  break;
	case ResultSurface:
	  mesg = "ThereIsSurfaceSector";
	  break;
	case ResultSurfaceOnEnd:
	  mesg = "SurfaceSectorOnTheEnd";
	  break;
	case ResultParseError:
	  mesg = "ParseError";
	  break;
	case ResultParseErrorO:
	  mesg = "ParseErrorInINCTOURWithout2Sectors";
	  break;
	case ResultParseErrorB:
	  mesg = "ParseErrorInINCTOURWithSpace";
	  break;
	case ResultValueZero:
	  mesg = "ZeroValueForMileageOrRoute";
	  break;
	case ResultLowestCombi:
	  mesg = "ThereIsLowestCombi";
	  break;
	case ResultFcompNoEnd:
	  mesg = "NoEND";
	  break;
	case ResultTotalSumFail:
	  mesg = "TotalSumCheckFailed";
	  break;
	case ResultPlusNormal:
	  mesg = "ThereIsPlusNormal";
	  break;
	case ResultPlusSector:
	  mesg = "ThereIsPlusSector";
	  break;
	case ResultPlusHalfRt:
	  mesg = "ThereIsPlusHalfRT";
	  break;
	case ResultPlusYSect:
	  mesg = "ThereIsPlusYSect";
	  break;
	case ResultPlusLowCombi:
	  mesg = "ThereIsPlusLowCombi";
	  break;
	case ResultOverMaxTax:
	  mesg = "ThereAreTooManyTaxes";
	  break;
	case ResultFTax:
	  mesg = "ThereIsFTax";
	  break;
	case ResultSideTrip:
	  mesg = "ThereIsSideTrip";
	  break;
	case ResultRoeBeforeEnd:
	  /* ;;; ResultRoeBeforeEnd added ;;; 20110201 */
	  mesg = "ROEDescriptionBeforeEND";
	  break;
	}
	resultStr.append(mesg);
      }
    }
    return resultStr.toString();
  }

  /* ;;; deBug */
  void	debugFareCalInfo(String fareCal, int fareCalPtr) {
    /* ;;; deBug */
    System.err.println("fareCal = [" + fareCal + "]");
    System.err.println("fareCalPtr = [" + fareCalPtr + "]");
    System.err.println("FC_RESULT = [" + makeFcResultStr(FC_RESULT) + "]");
    System.err.println("oldlex = " + oldlex[2] + "," + oldlex[1] + ","
		       + oldlex[0] + " oldpos = " + oldpos[2] + "," + oldpos[1]
		       + "," + oldpos[0]
		       + " yyresult = [" + yylex.yytext() + "]");
    System.err.println("place_no = " + place_no);
    for (int i = 0; i < place_no; i++) {
      System.err.print("" + (fc[i].stop_over != '\0' ?
			     Character.toString(fc[i].stop_over) : " ")
		       + " ");
      System.err.print("[" + fc[i].dep_code + "] - [" + fc[i].dest_code
		       + "] [" + fc[i].carrier + "] ");
      System.err.print("" +  fc[i].fare_compo_kbn + " " +
		       fc[i].fare_compo_kind + " " + fc[i].compo_end + " ");
      System.err.print("" +
		       (fc[i].security_index != '\0' ?
			Integer.toString(fc[i].security_index) : " ")
		       + " ");
      System.err.print("" +
		       (fc[i].side_trip_index != '\0'?
			Integer.toString(fc[i].side_trip_index) : " ")
		       + " ");
      if (fc[i].diff_index > 0) {
	System.err.print("D(" + fc[i].diff_index + ") ");
      }
      else {
	System.err.print("     ");
      }
      /*
	System.err.println("%lf %lf %lf %lf %lf %lf %lf %s",
	fc[i].fare_component, fc[i].class_differ_plus,
	fc[i].security_chrg, fc[i].plus, fc[i].stop_over_chrg,
	fc[i].side_trip_plus, fc[i].exst_plus, fc[i].via);
      */
      System.err.println("" + fc[i].fare_component + " "
			 + fc[i].class_differ_plus + " "
			 + fc[i].security_chrg + " "
			 + fc[i].stop_over_chrg + " "
			 + fc[i].side_trip_plus + " "
			 + fc[i].exst_plus + " " + fc[i].via);
    }
    System.err.println("");
    System.err.println("free_flag = " + free_flag);
    System.err.print("mileage = " + mileage);
    for (int j = 0; j < mileage; j++) {
      System.err.print("" + fc_id[j] + " ");
    }
    System.err.println("");
    System.err.println("");
    System.err.println("roe_rate = " + roe_rate);
    System.err.println("total = " + total_type + " " + total);
    System.err.println("stop_over_sum = " + stop_over_sum);
    System.err.println("stop_over_tmp = " + stop_over_tmp);
    System.err.println("add_stop_over_chrg = " + add_stop_over_chrg);
    System.err.println("less = " + less);
    System.err.print("tax_no = " + tax_no + " ");
    for (int k = 0; k < tax_no; k++) {
      System.err.println("" + tx[k].tax + " " + tx[k].tax_kind + " ");
    }
    System.err.println("");
  }
  /**
   * @return  auditImpl ᤷޤ
   * @uml.property  name="auditImpl"
   */
  public ProrateAuditImpl getAuditImpl() {
    return auditImpl;
  }
  /**
   * @param auditImpl  auditImpl ꡣ
   * @uml.property  name="auditImpl"
   */
  public void setAuditImpl(ProrateAuditImpl auditImpl) {
    this.auditImpl = auditImpl;
  }
}
