// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.jdl;

import java.util.Properties;

import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;
import jp.sourceforge.gnp.prorate.export.ProrateAskTable;

import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import org.omg.CORBA.*;

public class ProrateClient {

  ProrateJdl prorateRef = null;
  ORB orb = null;

  /**
   * Creates a new <code>ProrateClient</code> instance.
   *
   */
  public ProrateClient() {
  }

  public ProrateClient(String[] args) {
    // ORBȽ
    orb = ORB.init(args, null);
  }
  
  public ProrateClient(Properties properties) {
    // ORBȽ
    orb = ORB.init((String[])null, properties);
  }
  
  public ProrateAudit	prorate(ProrateAudit audit) throws Exception {
    ProrateAuditJdlHolder	auditJdlHolder = new ProrateAuditJdlHolder();
    ProrateAuditJdl	auditJdl = new ProrateAuditJdl();
    auditJdl.amountRatio = audit.getAmountRatio();
    auditJdl.commissionAmt = audit.getCommissionAmt();
    auditJdl.commissionRate = audit.getCommissionRate();
    auditJdl.day5Rate = audit.getDay5Rate();
    auditJdl.errorFlag = audit.getErrorFlag();
    auditJdl.fareDirtyFlag = audit.getFareDirtyFlag();
    auditJdl.fixedFare = audit.getFixedFare();
    auditJdl.ignoreFareCalc = audit.isIgnoreFareCalc();
    auditJdl.isInward = audit.isInward();
    auditJdl.isNotDivideTax = audit.isNotDivideTax();
    auditJdl.isNotRuleApply = audit.isNotRuleApply();
    auditJdl.isOneComponent = audit.isOneComponent();
    auditJdl.isOwnAudit = audit.isOwnAudit();
    auditJdl.isTicketing = audit.isTicketing();
    auditJdl.lessAdjustment = audit.getLessAdjustment();
    auditJdl.lessAmt = audit.getLessAmt();
    auditJdl.meanRate = audit.getMeanRate();
    auditJdl.nonProrateRest = audit.isNonProrateRest();
    auditJdl.plusAdjustment = audit.getPlusAdjustment();
    auditJdl.plusFlg = audit.isPlusFlg();
    auditJdl.roeRate = audit.getRoeRate();
    auditJdl.salesFare = audit.getSalesFare();
    auditJdl.stopOverCharge = audit.getStopOverCharge();
    auditJdl.ticketFare = audit.getTicketFare();
    auditJdl.totalNuc = audit.getTotalNuc();
    auditJdl.traceLevel = audit.getTraceLevel();
    auditJdl.agentCode = audit.getAgentCode();
    auditJdl.airwayId = audit.getAirwayId();
    auditJdl.airwayNumber = audit.getAirwayNumber();
    auditJdl.commissionCurrency = audit.getCommissionCurrency();
    auditJdl.currency = audit.getCurrency();
    auditJdl.destination = audit.getDestination();
    auditJdl.endorsement = audit.getEndorsement();
    auditJdl.errorString = audit.getErrorString();
    auditJdl.fareCalculation = audit.getFareCalculation();
    auditJdl.invoiceMonth = audit.getInvoiceMonth();
    auditJdl.inwardId = audit.getInwardId();
    auditJdl.inwardNumber = audit.getInwardNumber();
    auditJdl.issueDate = audit.getIssueDate();
    auditJdl.issuePlace = audit.getIssuePlace();
    auditJdl.origin = audit.getOrigin();
    auditJdl.ownAirwayId = audit.getOwnAirwayId();
    auditJdl.salesCurrency = audit.getSalesCurrency();
    auditJdl.tourCode = audit.getTourCode();
    auditJdl.traceStrings = audit.getTraceStrings();
    if (auditJdl.traceStrings == null) {
      auditJdl.traceStrings = new String[0];
    }
    if (auditJdl.sectors == null
	|| audit.getSectors().length > auditJdl.sectors.length) {
      auditJdl.sectors = new ProrateSectorJdl[audit.getSectors().length];
      for (int i = 0; i < audit.getSectors().length; i++) {
	auditJdl.sectors[i] = new ProrateSectorJdl();
      }
    }
    else {
      auditJdl.sectors = new ProrateSectorJdl[0];
    }
    for (int i = 0; i < audit.getSectors().length; i++) {
      ProrateSector	sector = audit.getSectors()[i];
      auditJdl.sectors[i].amountInLocal = sector.getAmountInLocal();
      auditJdl.sectors[i].apdpBaseAmt = sector.getApdpBaseAmt();
      auditJdl.sectors[i].apdpClassDiff = sector.getApdpClassDiff();
      auditJdl.sectors[i].apdpDay5Rate = sector.getApdpDay5Rate();
      auditJdl.sectors[i].apdpDiscountRate = sector.getApdpDiscountRate();
      auditJdl.sectors[i].apdpNuc = sector.getApdpNuc();
      auditJdl.sectors[i].certainty = sector.getCertainty();
      auditJdl.sectors[i].classDiffIndex = sector.getClassDiffIndex();
      auditJdl.sectors[i].classDiffPlus = sector.getClassDiffPlus();
      auditJdl.sectors[i].commission = sector.getCommission();
      auditJdl.sectors[i].componentIndex = sector.getComponentIndex();
      auditJdl.sectors[i].componentKind = sector.getComponentKind();
      auditJdl.sectors[i].errorFlag = sector.getErrorFlag();
      auditJdl.sectors[i].exstPlus = sector.getExstPlus();
      auditJdl.sectors[i].fareComponent = sector.getFareComponent();
      auditJdl.sectors[i].fareType = sector.getFareType();
      auditJdl.sectors[i].fixAmount = sector.getFixAmount();
      auditJdl.sectors[i].fixValue = sector.getFixValue();
      auditJdl.sectors[i].fixedFareCheck = sector.getFixedFareCheck();
      auditJdl.sectors[i].fixedFareDiscount = sector.getFixedFareDiscount();
      auditJdl.sectors[i].invoiceFlg = sector.isInvoiceFlg();
      auditJdl.sectors[i].invoiceValue = sector.getInvoiceValue();
      auditJdl.sectors[i].npClassDiff = sector.getNpClassDiff();
      auditJdl.sectors[i].npPvalues = sector.getNpPvalues();
      auditJdl.sectors[i].prorateError = sector.getProrateError();
      auditJdl.sectors[i].prorateFactor = sector.getProrateFactor();
      auditJdl.sectors[i].prorateValue = sector.getProrateValue();
      auditJdl.sectors[i].proratedClassDiff = sector.getProratedClassDiff();
      auditJdl.sectors[i].proratedExstPlus = sector.getProratedExstPlus();
      auditJdl.sectors[i].proratedSecureCharge
	= sector.getProratedSecureCharge();
      auditJdl.sectors[i].prorationType = sector.getProrationType();
      auditJdl.sectors[i].secureCharge = sector.getSecureCharge();
      auditJdl.sectors[i].secureChargeSaved = sector.getSecureChargeSaved();
      auditJdl.sectors[i].secureIndex = sector.getSecureIndex();
      auditJdl.sectors[i].sequenceNo = sector.getSequenceNo();
      auditJdl.sectors[i].sideTripIndex = sector.getSideTripIndex();
      auditJdl.sectors[i].sideTripPlus = sector.getSideTripPlus();
      auditJdl.sectors[i].spaBaseAmt = sector.getSpaBaseAmt();
      auditJdl.sectors[i].spaClassDiff = sector.getSpaClassDiff();
      auditJdl.sectors[i].spaDay5Rate = sector.getSpaDay5Rate();
      auditJdl.sectors[i].spaDiscountRate = sector.getSpaDiscountRate();
      auditJdl.sectors[i].spaNuc = sector.getSpaNuc();
      auditJdl.sectors[i].srpNuc = sector.getSrpNuc();
      auditJdl.sectors[i].stopOver = sector.getStopOver();
      auditJdl.sectors[i].stopOverPlus = sector.getStopOverPlus();
      auditJdl.sectors[i].tax = sector.getTax();
      auditJdl.sectors[i].taxInLocal = sector.getTaxInLocal();
      auditJdl.sectors[i].taxIndex = sector.getTaxIndex();
      auditJdl.sectors[i].apdpBaseAmtType = sector.getApdpBaseAmtType();
      auditJdl.sectors[i].carrier = sector.getCarrier();
      auditJdl.sectors[i].classOfService = sector.getClassOfService();
      auditJdl.sectors[i].depAirport = sector.getDepAirport();
      auditJdl.sectors[i].depCode = sector.getDepCode();
      auditJdl.sectors[i].depTime = sector.getDepTime();
      auditJdl.sectors[i].destAirport = sector.getDestAirport();
      auditJdl.sectors[i].destCode = sector.getDestCode();
      auditJdl.sectors[i].errorString = sector.getErrorString();
      auditJdl.sectors[i].fareBasis = sector.getFareBasis();
      auditJdl.sectors[i].fareBasisFullStr = sector.getFareBasisFullStr();
      auditJdl.sectors[i].fixCurrency = sector.getFixCurrency();
      auditJdl.sectors[i].flightDate = sector.getFlightDate();
      auditJdl.sectors[i].flightNo = sector.getFlightNo();
      auditJdl.sectors[i].opCarrier = sector.getOpCarrier();
      auditJdl.sectors[i].spaBaseAmtType = sector.getSpaBaseAmtType();
      auditJdl.sectors[i].viaRouting = sector.getViaRouting();
    }
    if (audit.getComponents() != null && audit.getComponents().length > 0) {
      if (auditJdl.components == null
	  || audit.getComponents().length > auditJdl.components.length) {
	auditJdl.components
	  = new ProrateFareComponentJdl[audit.getComponents().length];
	for (int i = 0; i < audit.getComponents().length; i++) {
	  auditJdl.components[i] = new ProrateFareComponentJdl();
	}
      }
      for (int i = 0; i < audit.getComponents().length; i++) {
	ProrateFareComponent	fcomp = audit.getComponents()[i];
	auditJdl.components[i].fixedFareDiscount
	  = fcomp.getFixedFareDiscount();
	auditJdl.components[i].kind = fcomp.getKind();
	auditJdl.components[i].value = fcomp.getValue();
	ProrateSector[]	sectors = fcomp.getSectors();
	for (int j = 0; j < sectors.length; j++) {
	  for (int k = 0; k < audit.getSectors().length; k++) {
	    if (sectors[j].getSequenceNo()
		== audit.getSectors()[k].getSequenceNo()) {
	      auditJdl.components[i].sectors[j] = auditJdl.sectors[k];
	      break;
	    }
	  }
	}
      }
    }
    else {
      auditJdl.components = new ProrateFareComponentJdl[0];
    }
    if (audit.getTax() != null && audit.getTax().length > 0) {
      if (auditJdl.tax == null
	  || audit.getTax().length > auditJdl.tax.length) {
	auditJdl.tax = new ProrateTaxDataJdl[audit.getTax().length];
	for (int i = 0; i < audit.getTax().length; i++) {
	  auditJdl.tax[i] = new ProrateTaxDataJdl();
	}
      }
      for (int i = 0; i < audit.getTax().length; i++) {
	auditJdl.tax[i].type = audit.getTax()[i].getType();
	auditJdl.tax[i].amount = audit.getTax()[i].getAmount();
      }
    }
    else {
      auditJdl.tax = new ProrateTaxDataJdl[0];
    }
    if (audit.getTaxMisc() != null && audit.getTaxMisc().length > 0) {
      if (auditJdl.taxMisc == null
	  || audit.getTaxMisc().length > auditJdl.taxMisc.length) {
	auditJdl.taxMisc = new ProrateTaxDataJdl[audit.getTaxMisc().length];
	for (int i = 0; i < audit.getTaxMisc().length; i++) {
	  auditJdl.taxMisc[i] = new ProrateTaxDataJdl();
	}
      }
      for (int i = 0; i < audit.getTaxMisc().length; i++) {
	auditJdl.taxMisc[i].type = audit.getTaxMisc()[i].getType();
	auditJdl.taxMisc[i].amount = audit.getTaxMisc()[i].getAmount();
      }
    }
    else {
      auditJdl.taxMisc = new ProrateTaxDataJdl[0];
    }
    if (audit.getAskTable() != null && audit.getAskTable().length > 0) {
      if (auditJdl.askTable == null
	  || audit.getAskTable().length > auditJdl.askTable.length) {
	auditJdl.askTable = new ProrateAskTableJdl[audit.getAskTable().length];
	for (int i = 0; i < audit.getAskTable().length; i++) {
	  auditJdl.askTable[i] = new ProrateAskTableJdl();
	}
      }
      for (int i = 0; i < audit.getAskTable().length; i++) {
	auditJdl.askTable[i].isArea = audit.getAskTable()[i].isArea();
	auditJdl.askTable[i].answer = audit.getAskTable()[i].getAnswer();
	auditJdl.askTable[i].place = audit.getAskTable()[i].getPlace();
      }
    }
    else {
      auditJdl.askTable = new ProrateAskTableJdl[0];
    }
    auditJdlHolder.value = auditJdl;

    try{
      // ͡ॵӥؤλȤ
      org.omg.CORBA.Object
	objRef = orb.resolve_initial_references("NameService");
      NamingContextExt ncRef = NamingContextExtHelper.narrow(objRef);

      // ͡ॵӥ Prorate Ȥ̾ΥХȤ򸡺
      // Ȥ
      String name = "Prorate";
      prorateRef = ProrateJdlHelper.narrow(ncRef.resolve_str(name));
      prorateRef.prorate(auditJdlHolder);
    } catch (Exception e) {
      System.out.println("ERROR : " + e) ;
      e.printStackTrace(System.out);
    }

    auditJdl = auditJdlHolder.value;

    audit.setAmountRatio(auditJdl.amountRatio);
    audit.setCommissionAmt(auditJdl.commissionAmt);
    audit.setCommissionRate(auditJdl.commissionRate);
    audit.setDay5Rate(auditJdl.day5Rate);
    audit.setErrorFlag(auditJdl.errorFlag);
    audit.setFareDirtyFlag(auditJdl.fareDirtyFlag);
    audit.setFixedFare(auditJdl.fixedFare);
    audit.setIgnoreFareCalc(auditJdl.ignoreFareCalc);
    audit.setInward(auditJdl.isInward);
    audit.setNotDivideTax(auditJdl.isNotDivideTax);
    audit.setNotRuleApply(auditJdl.isNotRuleApply);
    audit.setOneComponent(auditJdl.isOneComponent);
    audit.setOwnAudit(auditJdl.isOwnAudit);
    audit.setTicketing(auditJdl.isTicketing);
    audit.setLessAdjustment(auditJdl.lessAdjustment);
    audit.setLessAmt(auditJdl.lessAmt);
    audit.setMeanRate(auditJdl.meanRate);
    audit.setNonProrateRest(auditJdl.nonProrateRest);
    audit.setPlusAdjustment(auditJdl.plusAdjustment);
    audit.setPlusFlg(auditJdl.plusFlg);
    audit.setRoeRate(auditJdl.roeRate);
    audit.setSalesFare(auditJdl.salesFare);
    audit.setStopOverCharge(auditJdl.stopOverCharge);
    audit.setTicketFare(auditJdl.ticketFare);
    audit.setTotalNuc(auditJdl.totalNuc);
    audit.setTraceLevel(auditJdl.traceLevel);
    audit.setAgentCode(auditJdl.agentCode);
    audit.setAirwayId(auditJdl.airwayId);
    audit.setAirwayNumber(auditJdl.airwayNumber);
    audit.setCommissionCurrency(auditJdl.commissionCurrency);
    audit.setCurrency(auditJdl.currency);
    audit.setDestination(auditJdl.destination);
    audit.setEndorsement(auditJdl.endorsement);
    audit.setErrorString(auditJdl.errorString);
    audit.setFareCalculation(auditJdl.fareCalculation);
    audit.setInvoiceMonth(auditJdl.invoiceMonth);
    audit.setInwardId(auditJdl.inwardId);
    audit.setInwardNumber(auditJdl.inwardNumber);
    audit.setIssueDate(auditJdl.issueDate);
    audit.setIssuePlace(auditJdl.issuePlace);
    audit.setOrigin(auditJdl.origin);
    audit.setOwnAirwayId(auditJdl.ownAirwayId);
    audit.setSalesCurrency(auditJdl.salesCurrency);
    audit.setTourCode(auditJdl.tourCode);
    audit.setTraceStrings(auditJdl.traceStrings);
    ProrateSectorJdl[]	sectorsJdl = auditJdl.sectors;
    if (sectorsJdl != null && sectorsJdl.length > 0) {
      ProrateSector[]	sectors = new ProrateSector[sectorsJdl.length];
      for (int i = 0; i < sectorsJdl.length; i++) {
	sectors[i] = new ProrateSector();
	sectors[i].setAmountInLocal(sectorsJdl[i].amountInLocal);
	sectors[i].setApdpBaseAmt(sectorsJdl[i].apdpBaseAmt);
	sectors[i].setApdpClassDiff(sectorsJdl[i].apdpClassDiff);
	sectors[i].setApdpDay5Rate(sectorsJdl[i].apdpDay5Rate);
	sectors[i].setApdpDiscountRate(sectorsJdl[i].apdpDiscountRate);
	sectors[i].setApdpNuc(sectorsJdl[i].apdpNuc);
	sectors[i].setCertainty(sectorsJdl[i].certainty);
	sectors[i].setClassDiffIndex(sectorsJdl[i].classDiffIndex);
	sectors[i].setClassDiffPlus(sectorsJdl[i].classDiffPlus);
	sectors[i].setCommission(sectorsJdl[i].commission);
	sectors[i].setComponentIndex(sectorsJdl[i].componentIndex);
	sectors[i].setComponentKind(sectorsJdl[i].componentKind);
	sectors[i].setErrorFlag(sectorsJdl[i].errorFlag);
	sectors[i].setExstPlus(sectorsJdl[i].exstPlus);
	sectors[i].setFareComponent(sectorsJdl[i].fareComponent);
	sectors[i].setFareType(sectorsJdl[i].fareType);
	sectors[i].setFixAmount(sectorsJdl[i].fixAmount);
	sectors[i].setFixValue(sectorsJdl[i].fixValue);
	sectors[i].setFixedFareCheck(sectorsJdl[i].fixedFareCheck);
	sectors[i].setFixedFareDiscount(sectorsJdl[i].fixedFareDiscount);
	sectors[i].setInvoiceFlg(sectorsJdl[i].invoiceFlg);
	sectors[i].setInvoiceValue(sectorsJdl[i].invoiceValue);
	sectors[i].setNpClassDiff(sectorsJdl[i].npClassDiff);
	sectors[i].setNpPvalues(sectorsJdl[i].npPvalues);
	sectors[i].setProrateError(sectorsJdl[i].prorateError);
	sectors[i].setProrateFactor(sectorsJdl[i].prorateFactor);
	sectors[i].setProrateValue(sectorsJdl[i].prorateValue);
	sectors[i].setProratedClassDiff(sectorsJdl[i].proratedClassDiff);
	sectors[i].setProratedExstPlus(sectorsJdl[i].proratedExstPlus);
	sectors[i].setProratedSecureCharge(sectorsJdl[i].proratedSecureCharge);
	sectors[i].setProrationType(sectorsJdl[i].prorationType);
	sectors[i].setSecureCharge(sectorsJdl[i].secureCharge);
	sectors[i].setSecureChargeSaved(sectorsJdl[i].secureChargeSaved);
	sectors[i].setSecureIndex(sectorsJdl[i].secureIndex);
	sectors[i].setSequenceNo(sectorsJdl[i].sequenceNo);
	sectors[i].setSideTripIndex(sectorsJdl[i].sideTripIndex);
	sectors[i].setSideTripPlus(sectorsJdl[i].sideTripPlus);
	sectors[i].setSpaBaseAmt(sectorsJdl[i].spaBaseAmt);
	sectors[i].setSpaClassDiff(sectorsJdl[i].spaClassDiff);
	sectors[i].setSpaDay5Rate(sectorsJdl[i].spaDay5Rate);
	sectors[i].setSpaDiscountRate(sectorsJdl[i].spaDiscountRate);
	sectors[i].setSpaNuc(sectorsJdl[i].spaNuc);
	sectors[i].setSrpNuc(sectorsJdl[i].srpNuc);
	sectors[i].setStopOver(sectorsJdl[i].stopOver);
	sectors[i].setStopOverPlus(sectorsJdl[i].stopOverPlus);
	sectors[i].setTax(sectorsJdl[i].tax);
	sectors[i].setTaxInLocal(sectorsJdl[i].taxInLocal);
	sectors[i].setTaxIndex(sectorsJdl[i].taxIndex);
	sectors[i].setApdpBaseAmtType(sectorsJdl[i].apdpBaseAmtType);
	sectors[i].setCarrier(sectorsJdl[i].carrier);
	sectors[i].setClassOfService(sectorsJdl[i].classOfService);
	sectors[i].setDepAirport(sectorsJdl[i].depAirport);
	sectors[i].setDepCode(sectorsJdl[i].depCode);
	sectors[i].setDepTime(sectorsJdl[i].depTime);
	sectors[i].setDestAirport(sectorsJdl[i].destAirport);
	sectors[i].setDestCode(sectorsJdl[i].destCode);
	sectors[i].setErrorString(sectorsJdl[i].errorString);
	sectors[i].setFareBasis(sectorsJdl[i].fareBasis);
	sectors[i].setFareBasisFullStr(sectorsJdl[i].fareBasisFullStr);
	sectors[i].setFixCurrency(sectorsJdl[i].fixCurrency);
	sectors[i].setFlightDate(sectorsJdl[i].flightDate);
	sectors[i].setFlightNo(sectorsJdl[i].flightNo);
	sectors[i].setOpCarrier(sectorsJdl[i].opCarrier);
	sectors[i].setSpaBaseAmtType(sectorsJdl[i].spaBaseAmtType);
	sectors[i].setViaRouting(sectorsJdl[i].viaRouting);
      }
      audit.setSectors(sectors);
    }
    else {
      audit.setSectors(null);
    }
    ProrateFareComponentJdl[]	componentsJdl = auditJdl.components;
    if (componentsJdl != null && componentsJdl.length > 0) {
      ProrateFareComponent[]
	components = new ProrateFareComponent[componentsJdl.length];
      for (int i = 0; i < componentsJdl.length; i++) {
	components[i] = new ProrateFareComponent();
	components[i].setFixedFareDiscount(componentsJdl[i].fixedFareDiscount);
	components[i].setKind(componentsJdl[i].kind);
	components[i].setValue(componentsJdl[i].value);
	components[i].setAudit(audit);
	ProrateSector[]
	  sectors = new ProrateSector[componentsJdl[i].sectors.length];
	for (int j = 0; j < componentsJdl[i].sectors.length; j++) {
	  for (int k = 0; k < audit.getSectors().length; k++) {
	    ProrateSector	sector = audit.getSectors()[k];
	    if (sector.getSequenceNo()
		== componentsJdl[i].sectors[j].sequenceNo) {
	      sectors[j] = sector;
	      break;
	    }
	  }
	}
	components[i].setSectors(sectors);
      }
      audit.setComponents(components);
    }
    else {
      audit.setComponents(null);
    }
    ProrateTaxDataJdl[]	taxJdl = auditJdl.tax;
    if (taxJdl != null && taxJdl.length > 0) {
      ProrateTaxData[]	tax = new ProrateTaxData[taxJdl.length];
      for (int i = 0; i < taxJdl.length; i++) {
	tax[i].setType(taxJdl[i].type);
	tax[i].setAmount(taxJdl[i].amount);
      }
      audit.setTax(tax);
    }
    else {
      audit.setTax(null);
    }
    ProrateTaxDataJdl[]	taxMiscJdl = auditJdl.taxMisc;
    if (taxMiscJdl != null && taxMiscJdl.length > 0) {
      ProrateTaxData[]	taxMisc = new ProrateTaxData[taxMiscJdl.length];
      for (int i = 0; i < taxMiscJdl.length; i++) {
	taxMisc[i].setType(taxMiscJdl[i].type);
	taxMisc[i].setAmount(taxMiscJdl[i].amount);
      }
      audit.setTaxMisc(taxMisc);
    }
    else {
      audit.setTaxMisc(null);
    }
    ProrateAskTableJdl[]	askTableJdl = auditJdl.askTable;
    if (askTableJdl != null && askTableJdl.length > 0) {
      ProrateAskTable[]	askTable = new ProrateAskTable[askTableJdl.length];
      for (int i = 0; i < askTableJdl.length; i++) {
	askTable[i].setArea(askTableJdl[i].isArea);
	askTable[i].setAnswer(askTableJdl[i].answer);
	askTable[i].setPlace(askTableJdl[i].place);
      }
      audit.setAskTable(askTable);
    }
    else {
      audit.setAskTable(null);
    }

    return audit;
  }

}
