package jp.sourceforge.gnp.prorate.jdl;

import javax.ejb.EJB;
import javax.naming.NamingException;

import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.prorate.ejb.client.ProrateEjbClient;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;
import jp.sourceforge.gnp.prorate.export.ProrateAskTable;

public class ProrateJdlEjbClientImpl extends ProrateJdlPOA {
  /**
   * variable <code>prorate</code>	ProrateEjb EJB3 object
   *
   */
  @EJB(beanName="ProrateEjbBean")
  ProrateEjb	prorate = null;

  /**
   * Creates a new <code>ProrateJdlEjbClientImpl</code> instance.
   *
   * @exception Exception if an error occurs
   */
  public ProrateJdlEjbClientImpl() throws Exception {
    super();
    prorate = ProrateEjbClient.makeInstance();
  }

  public void prorate (ProrateAuditJdlHolder auditHolder)
    throws ProrateExceptionJdl {
    ProrateAudit	audit = new ProrateAudit();
    ProrateAuditJdl	auditJdl = auditHolder.value;
    audit.setAmountRatio(auditJdl.amountRatio);
    audit.setCommissionAmt(auditJdl.commissionAmt);
    audit.setCommissionRate(auditJdl.commissionRate);
    audit.setDay5Rate(auditJdl.day5Rate);
    audit.setErrorFlag(auditJdl.errorFlag);
    audit.setFareDirtyFlag(auditJdl.fareDirtyFlag);
    audit.setFixedFare(auditJdl.fixedFare);
    audit.setIgnoreFareCalc(auditJdl.ignoreFareCalc);
    audit.setInward(auditJdl.isInward);
    audit.setNotDivideTax(auditJdl.isNotDivideTax);
    audit.setNotRuleApply(auditJdl.isNotRuleApply);
    audit.setOneComponent(auditJdl.isOneComponent);
    audit.setOwnAudit(auditJdl.isOwnAudit);
    audit.setTicketing(auditJdl.isTicketing);
    audit.setLessAdjustment(auditJdl.lessAdjustment);
    audit.setLessAmt(auditJdl.lessAmt);
    audit.setMeanRate(auditJdl.meanRate);
    audit.setNonProrateRest(auditJdl.nonProrateRest);
    audit.setPlusAdjustment(auditJdl.plusAdjustment);
    audit.setPlusFlg(auditJdl.plusFlg);
    audit.setRoeRate(auditJdl.roeRate);
    audit.setSalesFare(auditJdl.salesFare);
    audit.setStopOverCharge(auditJdl.stopOverCharge);
    audit.setTicketFare(auditJdl.ticketFare);
    audit.setTotalNuc(auditJdl.totalNuc);
    audit.setTraceLevel(auditJdl.traceLevel);
    audit.setAgentCode(auditJdl.agentCode);
    audit.setAirwayId(auditJdl.airwayId);
    audit.setAirwayNumber(auditJdl.airwayNumber);
    audit.setCommissionCurrency(auditJdl.commissionCurrency);
    audit.setCurrency(auditJdl.currency);
    audit.setDestination(auditJdl.destination);
    audit.setEndorsement(auditJdl.endorsement);
    audit.setErrorString(auditJdl.errorString);
    audit.setFareCalculation(auditJdl.fareCalculation);
    audit.setInvoiceMonth(auditJdl.invoiceMonth);
    audit.setInwardId(auditJdl.inwardId);
    audit.setInwardNumber(auditJdl.inwardNumber);
    audit.setIssueDate(auditJdl.issueDate);
    audit.setIssuePlace(auditJdl.issuePlace);
    audit.setOrigin(auditJdl.origin);
    audit.setOwnAirwayId(auditJdl.ownAirwayId);
    audit.setSalesCurrency(auditJdl.salesCurrency);
    audit.setTourCode(auditJdl.tourCode);
    audit.setTraceStrings(auditJdl.traceStrings);
    ProrateSectorJdl[]	sectorsJdl = auditJdl.sectors;
    if (sectorsJdl != null && sectorsJdl.length > 0) {
      ProrateSector[]	sectors = new ProrateSector[sectorsJdl.length];
      for (int i = 0; i < sectorsJdl.length; i++) {
	sectors[i] = new ProrateSector();
	sectors[i].setAmountInLocal(sectorsJdl[i].amountInLocal);
	sectors[i].setApdpBaseAmt(sectorsJdl[i].apdpBaseAmt);
	sectors[i].setApdpClassDiff(sectorsJdl[i].apdpClassDiff);
	sectors[i].setApdpDay5Rate(sectorsJdl[i].apdpDay5Rate);
	sectors[i].setApdpDiscountRate(sectorsJdl[i].apdpDiscountRate);
	sectors[i].setApdpNuc(sectorsJdl[i].apdpNuc);
	sectors[i].setCertainty(sectorsJdl[i].certainty);
	sectors[i].setClassDiffIndex(sectorsJdl[i].classDiffIndex);
	sectors[i].setClassDiffPlus(sectorsJdl[i].classDiffPlus);
	sectors[i].setCommission(sectorsJdl[i].commission);
	sectors[i].setComponentIndex(sectorsJdl[i].componentIndex);
	sectors[i].setComponentKind(sectorsJdl[i].componentKind);
	sectors[i].setErrorFlag(sectorsJdl[i].errorFlag);
	sectors[i].setExstPlus(sectorsJdl[i].exstPlus);
	sectors[i].setFareComponent(sectorsJdl[i].fareComponent);
	sectors[i].setFareType(sectorsJdl[i].fareType);
	sectors[i].setFixAmount(sectorsJdl[i].fixAmount);
	sectors[i].setFixValue(sectorsJdl[i].fixValue);
	sectors[i].setFixedFareCheck(sectorsJdl[i].fixedFareCheck);
	sectors[i].setFixedFareDiscount(sectorsJdl[i].fixedFareDiscount);
	sectors[i].setInvoiceFlg(sectorsJdl[i].invoiceFlg);
	sectors[i].setInvoiceValue(sectorsJdl[i].invoiceValue);
	sectors[i].setNpClassDiff(sectorsJdl[i].npClassDiff);
	sectors[i].setNpPvalues(sectorsJdl[i].npPvalues);
	sectors[i].setProrateError(sectorsJdl[i].prorateError);
	sectors[i].setProrateFactor(sectorsJdl[i].prorateFactor);
	sectors[i].setProrateValue(sectorsJdl[i].prorateValue);
	sectors[i].setProratedClassDiff(sectorsJdl[i].proratedClassDiff);
	sectors[i].setProratedExstPlus(sectorsJdl[i].proratedExstPlus);
	sectors[i].setProratedSecureCharge(sectorsJdl[i].proratedSecureCharge);
	sectors[i].setProrationType(sectorsJdl[i].prorationType);
	sectors[i].setSecureCharge(sectorsJdl[i].secureCharge);
	sectors[i].setSecureChargeSaved(sectorsJdl[i].secureChargeSaved);
	sectors[i].setSecureIndex(sectorsJdl[i].secureIndex);
	sectors[i].setSequenceNo(sectorsJdl[i].sequenceNo);
	sectors[i].setSideTripIndex(sectorsJdl[i].sideTripIndex);
	sectors[i].setSideTripPlus(sectorsJdl[i].sideTripPlus);
	sectors[i].setSpaBaseAmt(sectorsJdl[i].spaBaseAmt);
	sectors[i].setSpaClassDiff(sectorsJdl[i].spaClassDiff);
	sectors[i].setSpaDay5Rate(sectorsJdl[i].spaDay5Rate);
	sectors[i].setSpaDiscountRate(sectorsJdl[i].spaDiscountRate);
	sectors[i].setSpaNuc(sectorsJdl[i].spaNuc);
	sectors[i].setSrpNuc(sectorsJdl[i].srpNuc);
	sectors[i].setStopOver(sectorsJdl[i].stopOver);
	sectors[i].setStopOverPlus(sectorsJdl[i].stopOverPlus);
	sectors[i].setTax(sectorsJdl[i].tax);
	sectors[i].setTaxInLocal(sectorsJdl[i].taxInLocal);
	sectors[i].setTaxIndex(sectorsJdl[i].taxIndex);
	sectors[i].setApdpBaseAmtType(sectorsJdl[i].apdpBaseAmtType);
	sectors[i].setCarrier(sectorsJdl[i].carrier);
	sectors[i].setClassOfService(sectorsJdl[i].classOfService);
	sectors[i].setDepAirport(sectorsJdl[i].depAirport);
	sectors[i].setDepCode(sectorsJdl[i].depCode);
	sectors[i].setDepTime(sectorsJdl[i].depTime);
	sectors[i].setDestAirport(sectorsJdl[i].destAirport);
	sectors[i].setDestCode(sectorsJdl[i].destCode);
	sectors[i].setErrorString(sectorsJdl[i].errorString);
	sectors[i].setFareBasis(sectorsJdl[i].fareBasis);
	sectors[i].setFareBasisFullStr(sectorsJdl[i].fareBasisFullStr);
	sectors[i].setFixCurrency(sectorsJdl[i].fixCurrency);
	sectors[i].setFlightDate(sectorsJdl[i].flightDate);
	sectors[i].setFlightNo(sectorsJdl[i].flightNo);
	sectors[i].setOpCarrier(sectorsJdl[i].opCarrier);
	sectors[i].setSpaBaseAmtType(sectorsJdl[i].spaBaseAmtType);
	sectors[i].setViaRouting(sectorsJdl[i].viaRouting);
      }
      audit.setSectors(sectors);
    }
    else {
      audit.setSectors(null);
    }
    ProrateFareComponentJdl[]	componentsJdl = auditJdl.components;
    if (componentsJdl != null && componentsJdl.length > 0) {
      ProrateFareComponent[]
	components = new ProrateFareComponent[componentsJdl.length];
      for (int i = 0; i < componentsJdl.length; i++) {
	components[i] = new ProrateFareComponent();
	components[i].setFixedFareDiscount(componentsJdl[i].fixedFareDiscount);
	components[i].setKind(componentsJdl[i].kind);
	components[i].setValue(componentsJdl[i].value);
	components[i].setAudit(audit);
	ProrateSector[]
	  sectors = new ProrateSector[componentsJdl[i].sectors.length];
	for (int j = 0; j < componentsJdl[i].sectors.length; j++) {
	  for (int k = 0; k < audit.getSectors().length; k++) {
	    ProrateSector	sector = audit.getSectors()[k];
	    if (sector.getSequenceNo()
		== componentsJdl[i].sectors[j].sequenceNo) {
	      sectors[j] = sector;
	      break;
	    }
	  }
	}
	components[i].setSectors(sectors);
      }
      audit.setComponents(components);
    }
    else {
      audit.setComponents(null);
    }
    ProrateTaxDataJdl[]	taxJdl = auditJdl.tax;
    if (taxJdl != null && taxJdl.length > 0) {
      ProrateTaxData[]	tax = new ProrateTaxData[taxJdl.length];
      for (int i = 0; i < taxJdl.length; i++) {
	tax[i] = new ProrateTaxData();
	tax[i].setType(taxJdl[i].type);
	tax[i].setAmount(taxJdl[i].amount);
      }
      audit.setTax(tax);
    }
    else {
      audit.setTax(null);
    }
    ProrateTaxDataJdl[]	taxMiscJdl = auditJdl.taxMisc;
    if (taxMiscJdl != null && taxMiscJdl.length > 0) {
      ProrateTaxData[]	taxMisc = new ProrateTaxData[taxMiscJdl.length];
      for (int i = 0; i < taxMiscJdl.length; i++) {
	taxMisc[i] = new ProrateTaxData();
	taxMisc[i].setType(taxMiscJdl[i].type);
	taxMisc[i].setAmount(taxMiscJdl[i].amount);
      }
      audit.setTaxMisc(taxMisc);
    }
    else {
      audit.setTaxMisc(null);
    }
    ProrateAskTableJdl[]	askTableJdl = auditJdl.askTable;
    if (askTableJdl != null && askTableJdl.length > 0) {
      ProrateAskTable[]	askTable = new ProrateAskTable[askTableJdl.length];
      for (int i = 0; i < askTableJdl.length; i++) {
	askTable[i] = new ProrateAskTable();
	askTable[i].setArea(askTableJdl[i].isArea);
	askTable[i].setAnswer(askTableJdl[i].answer);
	askTable[i].setPlace(askTableJdl[i].place);
      }
      audit.setAskTable(askTable);
    }
    else {
      audit.setAskTable(null);
    }

    ProrateAudit	ret = null;
    try {
      ret = prorate.prorate(audit);
    }
    catch (Exception e) {
      throw new ProrateExceptionJdl(e.getMessage());
    }

    auditJdl.amountRatio = ret.getAmountRatio();
    auditJdl.commissionAmt = ret.getCommissionAmt();
    auditJdl.commissionRate = ret.getCommissionRate();
    auditJdl.day5Rate = ret.getDay5Rate();
    auditJdl.errorFlag = ret.getErrorFlag();
    auditJdl.fareDirtyFlag = ret.getFareDirtyFlag();
    auditJdl.fixedFare = ret.getFixedFare();
    auditJdl.ignoreFareCalc = ret.isIgnoreFareCalc();
    auditJdl.isInward = ret.isInward();
    auditJdl.isNotDivideTax = ret.isNotDivideTax();
    auditJdl.isNotRuleApply = ret.isNotRuleApply();
    auditJdl.isOneComponent = ret.isOneComponent();
    auditJdl.isOwnAudit = ret.isOwnAudit();
    auditJdl.isTicketing = ret.isTicketing();
    auditJdl.lessAdjustment = ret.getLessAdjustment();
    auditJdl.lessAmt = ret.getLessAmt();
    auditJdl.meanRate = ret.getMeanRate();
    auditJdl.nonProrateRest = ret.isNonProrateRest();
    auditJdl.plusAdjustment = ret.getPlusAdjustment();
    auditJdl.plusFlg = ret.isPlusFlg();
    auditJdl.roeRate = ret.getRoeRate();
    auditJdl.salesFare = ret.getSalesFare();
    auditJdl.stopOverCharge = ret.getStopOverCharge();
    auditJdl.ticketFare = ret.getTicketFare();
    auditJdl.totalNuc = ret.getTotalNuc();
    auditJdl.traceLevel = ret.getTraceLevel();
    auditJdl.agentCode = ret.getAgentCode();
    auditJdl.airwayId = ret.getAirwayId();
    auditJdl.airwayNumber = ret.getAirwayNumber();
    auditJdl.commissionCurrency = ret.getCommissionCurrency();
    auditJdl.currency = ret.getCurrency();
    auditJdl.destination = ret.getDestination();
    auditJdl.endorsement = ret.getEndorsement();
    auditJdl.errorString = ret.getErrorString();
    auditJdl.fareCalculation = ret.getFareCalculation();
    auditJdl.invoiceMonth = ret.getInvoiceMonth();
    auditJdl.inwardId = ret.getInwardId();
    auditJdl.inwardNumber = ret.getInwardNumber();
    auditJdl.issueDate = ret.getIssueDate();
    auditJdl.issuePlace = ret.getIssuePlace();
    auditJdl.origin = ret.getOrigin();
    auditJdl.ownAirwayId = ret.getOwnAirwayId();
    auditJdl.salesCurrency = ret.getSalesCurrency();
    auditJdl.tourCode = ret.getTourCode();
    auditJdl.traceStrings = ret.getTraceStrings();
    if (auditJdl.sectors == null
	|| ret.getSectors().length > auditJdl.sectors.length) {
      auditJdl.sectors = new ProrateSectorJdl[ret.getSectors().length];
      for (int i = 0; i < ret.getSectors().length; i++) {
	auditJdl.sectors[i] = new ProrateSectorJdl();
      }
    }
    for (int i = 0; i < ret.getSectors().length; i++) {
      ProrateSector	sector = ret.getSectors()[i];
      auditJdl.sectors[i].amountInLocal = sector.getAmountInLocal();
      auditJdl.sectors[i].apdpBaseAmt = sector.getApdpBaseAmt();
      auditJdl.sectors[i].apdpClassDiff = sector.getApdpClassDiff();
      auditJdl.sectors[i].apdpDay5Rate = sector.getApdpDay5Rate();
      auditJdl.sectors[i].apdpDiscountRate = sector.getApdpDiscountRate();
      auditJdl.sectors[i].apdpNuc = sector.getApdpNuc();
      auditJdl.sectors[i].certainty = sector.getCertainty();
      auditJdl.sectors[i].classDiffIndex = sector.getClassDiffIndex();
      auditJdl.sectors[i].classDiffPlus = sector.getClassDiffPlus();
      auditJdl.sectors[i].commission = sector.getCommission();
      auditJdl.sectors[i].componentIndex = sector.getComponentIndex();
      auditJdl.sectors[i].componentKind = sector.getComponentKind();
      auditJdl.sectors[i].errorFlag = sector.getErrorFlag();
      auditJdl.sectors[i].exstPlus = sector.getExstPlus();
      auditJdl.sectors[i].fareComponent = sector.getFareComponent();
      auditJdl.sectors[i].fareType = sector.getFareType();
      auditJdl.sectors[i].fixAmount = sector.getFixAmount();
      auditJdl.sectors[i].fixValue = sector.getFixValue();
      auditJdl.sectors[i].fixedFareCheck = sector.getFixedFareCheck();
      auditJdl.sectors[i].fixedFareDiscount = sector.getFixedFareDiscount();
      auditJdl.sectors[i].invoiceFlg = sector.isInvoiceFlg();
      auditJdl.sectors[i].invoiceValue = sector.getInvoiceValue();
      auditJdl.sectors[i].npClassDiff = sector.getNpClassDiff();
      auditJdl.sectors[i].npPvalues = sector.getNpPvalues();
      auditJdl.sectors[i].prorateError = sector.getProrateError();
      auditJdl.sectors[i].prorateFactor = sector.getProrateFactor();
      auditJdl.sectors[i].prorateValue = sector.getProrateValue();
      auditJdl.sectors[i].proratedClassDiff = sector.getProratedClassDiff();
      auditJdl.sectors[i].proratedExstPlus = sector.getProratedExstPlus();
      auditJdl.sectors[i].proratedSecureCharge
	= sector.getProratedSecureCharge();
      auditJdl.sectors[i].prorationType = sector.getProrationType();
      auditJdl.sectors[i].secureCharge = sector.getSecureCharge();
      auditJdl.sectors[i].secureChargeSaved = sector.getSecureChargeSaved();
      auditJdl.sectors[i].secureIndex = sector.getSecureIndex();
      auditJdl.sectors[i].sequenceNo = sector.getSequenceNo();
      auditJdl.sectors[i].sideTripIndex = sector.getSideTripIndex();
      auditJdl.sectors[i].sideTripPlus = sector.getSideTripPlus();
      auditJdl.sectors[i].spaBaseAmt = sector.getSpaBaseAmt();
      auditJdl.sectors[i].spaClassDiff = sector.getSpaClassDiff();
      auditJdl.sectors[i].spaDay5Rate = sector.getSpaDay5Rate();
      auditJdl.sectors[i].spaDiscountRate = sector.getSpaDiscountRate();
      auditJdl.sectors[i].spaNuc = sector.getSpaNuc();
      auditJdl.sectors[i].srpNuc = sector.getSrpNuc();
      auditJdl.sectors[i].stopOver = sector.getStopOver();
      auditJdl.sectors[i].stopOverPlus = sector.getStopOverPlus();
      auditJdl.sectors[i].tax = sector.getTax();
      auditJdl.sectors[i].taxInLocal = sector.getTaxInLocal();
      auditJdl.sectors[i].taxIndex = sector.getTaxIndex();
      auditJdl.sectors[i].apdpBaseAmtType = sector.getApdpBaseAmtType();
      auditJdl.sectors[i].carrier = sector.getCarrier();
      auditJdl.sectors[i].classOfService = sector.getClassOfService();
      auditJdl.sectors[i].depAirport = sector.getDepAirport();
      auditJdl.sectors[i].depCode = sector.getDepCode();
      auditJdl.sectors[i].depTime = sector.getDepTime();
      auditJdl.sectors[i].destAirport = sector.getDestAirport();
      auditJdl.sectors[i].destCode = sector.getDestCode();
      auditJdl.sectors[i].errorString = sector.getErrorString();
      auditJdl.sectors[i].fareBasis = sector.getFareBasis();
      auditJdl.sectors[i].fareBasisFullStr = sector.getFareBasisFullStr();
      auditJdl.sectors[i].fixCurrency = sector.getFixCurrency();
      auditJdl.sectors[i].flightDate = sector.getFlightDate();
      auditJdl.sectors[i].flightNo = sector.getFlightNo();
      auditJdl.sectors[i].opCarrier = sector.getOpCarrier();
      auditJdl.sectors[i].spaBaseAmtType = sector.getSpaBaseAmtType();
      auditJdl.sectors[i].viaRouting = sector.getViaRouting();
    }
    if (ret.getComponents() != null && ret.getComponents().length > 0) {
      if (auditJdl.components == null
	  || ret.getComponents().length > auditJdl.components.length) {
	auditJdl.components
	  = new ProrateFareComponentJdl[ret.getComponents().length];
	for (int i = 0; i < ret.getComponents().length; i++) {
	  auditJdl.components[i] = new ProrateFareComponentJdl();
	}
      }
      for (int i = 0; i < ret.getComponents().length; i++) {
	ProrateFareComponent	fcomp = ret.getComponents()[i];
	auditJdl.components[i].fixedFareDiscount
	  = fcomp.getFixedFareDiscount();
	auditJdl.components[i].kind = fcomp.getKind();
	auditJdl.components[i].value = fcomp.getValue();
	ProrateSector[]	sectors = fcomp.getSectors();
	if (auditJdl.components[i].sectors == null
	    || sectors.length > auditJdl.components[i].sectors.length) {
	  auditJdl.components[i].sectors
	    = new ProrateSectorJdl[sectors.length];
	}
	for (int j = 0; j < sectors.length; j++) {
	  for (int k = 0; k < audit.getSectors().length; k++) {
	    if (sectors[j].getSequenceNo()
		== audit.getSectors()[k].getSequenceNo()) {
	      auditJdl.components[i].sectors[j] = auditJdl.sectors[k];
	      break;
	    }
	  }
	}
      }
    }
    if (ret.getTax() != null && ret.getTax().length > 0) {
      if (auditJdl.tax == null
	  || ret.getTax().length > auditJdl.tax.length) {
	auditJdl.tax = new ProrateTaxDataJdl[ret.getTax().length];
	for (int i = 0; i < ret.getTax().length; i++) {
	  auditJdl.tax[i] = new ProrateTaxDataJdl();
	}
      }
      for (int i = 0; i < ret.getTax().length; i++) {
	auditJdl.tax[i].type = ret.getTax()[i].getType();
	auditJdl.tax[i].amount = ret.getTax()[i].getAmount();
      }
    }
    if (ret.getTaxMisc() != null && ret.getTaxMisc().length > 0) {
      if (auditJdl.taxMisc == null
	  || ret.getTaxMisc().length > auditJdl.taxMisc.length) {
	auditJdl.taxMisc = new ProrateTaxDataJdl[ret.getTaxMisc().length];
	for (int i = 0; i < ret.getTaxMisc().length; i++) {
	  auditJdl.taxMisc[i] = new ProrateTaxDataJdl();
	}
      }
      for (int i = 0; i < ret.getTaxMisc().length; i++) {
	auditJdl.taxMisc[i].type = ret.getTaxMisc()[i].getType();
	auditJdl.taxMisc[i].amount = ret.getTaxMisc()[i].getAmount();
      }
    }
    if (ret.getAskTable() != null && ret.getAskTable().length > 0) {
      if (auditJdl.askTable == null
	  || ret.getAskTable().length > auditJdl.askTable.length) {
	auditJdl.askTable = new ProrateAskTableJdl[ret.getAskTable().length];
	for (int i = 0; i < ret.getAskTable().length; i++) {
	  auditJdl.askTable[i] = new ProrateAskTableJdl();
	}
      }
      for (int i = 0; i < ret.getAskTable().length; i++) {
	auditJdl.askTable[i].isArea = ret.getAskTable()[i].isArea();
	auditJdl.askTable[i].answer = ret.getAskTable()[i].getAnswer();
	auditJdl.askTable[i].place = ret.getAskTable()[i].getPlace();
      }
    }
  }
    
}
