// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.rmi;


import java.rmi.RemoteException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import jp.sourceforge.gnp.prorate.export.ProrateAudit;


/**
 * class <code>RemoteProrateClient</code>
 *	RMI-IIOPproration¹Ԥ륯饤ȥ饹
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PortableRemoteProrateClient implements RemoteProrate {
  
  // Constructor
  /**
   * Creates a new <code>RemoteProrateClient</code> instance.
   *
   */
  public PortableRemoteProrateClient() {
  }

  // Operations
  /**
   * <code>prorate</code> method
   *	RMI-IIOPǥ⡼prorationꤹ롣proration̤֤
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateAudit</code> value
   * @exception RemoteException if an error occurs
   */
  public ProrateAudit	prorate(ProrateAudit audit) throws Exception {
    // Now look up that RemoteProrate server using the Naming object, which
    // contacts the orbd server.  Given the url, this call returns
    // a RemoteProrate object whose methods may be invoked remotely
    // Figure out what to name it
    String name =
      System.getProperty("proratename", "RemoteProrate");
    // Name it that
    Context nc = new InitialContext();
    RemoteProrate
      prorate =
      (RemoteProrate)PortableRemoteObject.narrow(nc.lookup(name),
						 RemoteProrate.class);
    return prorate.prorate(audit);
  }
}
