// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.rmi;


import java.rmi.Naming;
import java.rmi.RemoteException;

import jp.sourceforge.gnp.prorate.export.ProrateAudit;

/**
 * class <code>RemoteProrateClient</code>
 *	RMIproration¹Ԥ륯饤ȥ饹
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class RemoteProrateClient implements RemoteProrate {
  
  /**
   * Creates a new <code>RemoteProrateClient</code> instance.
   *
   */
  public RemoteProrateClient() {
  }

  /**
   * <code>prorate</code> method
   *	RMIǥ⡼prorationꤹ롣proration̤֤
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateAudit</code> value
   * @exception RemoteException if an error occurs
   */
  public ProrateAudit	prorate(ProrateAudit audit) throws Exception {
    // Figure out what RemoteAuth to connect to by reading a system
    // property (specified on the command line with a -D option to java)
    // or, if it is not defined, use a default URL.  Note that by default
    // this client tries to connect to a server on the local machine
    String name = System.getProperty("proratename", "RemoteProrate");
    String url = "rmi:///" + name;

    // Now look up that RemoteAuth server using the Naming object, which
    // contacts the rmiregistry server.  Given the url, this call returns
    // a RemoteAuth object whose methods may be invoked remotely
    RemoteProrate prorate = (RemoteProrate) Naming.lookup(url);
    return prorate.prorate(audit);
  }
}
