// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.rmi;


import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebase;


/**
 * class <code>RemoteProrateServer</code> RMIproration¹Ԥ륵Х饹
 * @author   <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */
public class RemoteProrateServer
  extends UnicastRemoteObject implements RemoteProrate {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  /**
   * variable <code>prorate</code>	prorationӥ饹
   *
   */
  static ProrateImpl	prorate = null;

  /**
   * Creates a new <code>RemoteProrateServer</code> instance.
   *
   * @exception RemoteException if an error occurs
   */
  public RemoteProrateServer() throws RemoteException {
  }
  
  /**
   * <code>main</code> method	RMIproration륵Фmainȥݥ
   *
   * @param args a <code>String[]</code> value
   */
  public static void main(String[] args) {
    if (System.getSecurityManager() == null) {
      System.setSecurityManager(new RMISecurityManager());
    }
    try {
      // Create a prorate server object
      RemoteProrateServer server = new RemoteProrateServer();
      // prorationӥ
      if (!initialize()) {
	System.exit(1); // prorationӥ
      }
      // Figure out what to name it
      String name = System.getProperty("proratename", "RemoteProrate");
      // Name it that
      Naming.rebind(name, server);
      // Tell the world we're up and running
      System.out.println(name + " is open and ready for customers.");
    }
    catch (Exception e) {
      System.err.println(e);
      System.err
	.println("Usage: java [-Dproratename=<name>] RemoteProrateServer");
      System.exit(1); // Force an exit because there might be other threads
    }
  }
  
  static boolean initialize() {
    ProrateRulebase rulebase = null;
    try {
      rulebase = new XmlRulebase();
      XmlRulebase.initialize();
    } catch (Exception e) {
      e.printStackTrace();
      System.err.println("proration service rulebase initialization failed:"
			 + e.getMessage());
      return false;
    }
    ProrateRulebaseElementFactory factory = new ProrateRuleObjectFactory();
    rulebase.setElementFactory(factory);
    prorate = new ProrateImpl();
    prorate.setRulebase(rulebase);
    prorate.setFcalc(new ProrateFCalcImpl());
    prorate.setTax(new ProrateTaxImpl());
    ProrateTrace	trace = new ProrateTraceString();
    prorate.setTrace(trace);
    prorate.setDatabase(new ProrateRdb());
    if (!prorate.getDatabase().openDatabase()) {
      System.err.println("proration service database initialization failed:"
			 + prorate.getDatabase().getErrMessage());
      return false;
    }
    return true;
  }

  /**
   * <code>prorate</code> method	RMIproration¹Ԥ̤֤
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateAudit</code> value
   * @throws Exception 
   */
  public ProrateAudit	prorate(ProrateAudit audit) throws Exception {
    prorate.getTrace().setData(audit);
    ProrateAudit	auditRet = prorate.prorate(audit);
    prorate.getTrace().close();
    List<String>
      traceStrings = ((ProrateTraceString)prorate.getTrace()).getStrings();
    String[]	traceStringsArray = new String[traceStrings.size()];
    for (int i = 0; i < traceStrings.size(); i++) {
      traceStringsArray[i] = (String)traceStrings.get(i);
    }
    auditRet.setTraceStrings(traceStringsArray);
    return auditRet;
  }
}
