// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.struts.action;

import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;
import jp.sourceforge.gnp.prorate.struts.IConstants;
import jp.sourceforge.gnp.prorate.struts.form.ProrateForm;
import jp.sourceforge.gnp.prorate.struts.service.IProrateService;
import jp.sourceforge.gnp.prorate.struts.view.ProrateView;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * class <code>ProrateAction</code> This Action is called by the ActionServlet when a prorate attempt is made by the user. The ActionForm should be an instance of a ProrateForm and contain the credentials needed by the Prorate service.
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public abstract class ProrateAction extends Action {
  
  /**
   * @uml.property  name="errorString"
   */
  String	errorString = "";	/* 顼ʸ **OUT** */

  // Constructor
  /**
   * Creates a new <code>ProrateAction</code> instance.
   *
   */
  public ProrateAction() {
    super();
  }

  // Operations
  /**
   * <code>execute</code> method
   *
   * @param mapping an <code>ActionMapping</code> value
   * @param form an <code>ActionForm</code> value
   * @param request a <code>HttpServletRequest</code> value
   * @param response a <code>HttpServletResponse</code> value
   * @return an <code>ActionForward</code> value
   * @exception Exception if an error occurs
   */
  public ActionForward execute(ActionMapping mapping,
			       ActionForm form,
			       HttpServletRequest request,
			       HttpServletResponse response)
    throws Exception {

    // The ActionForward to return when completed
    ActionForward	forward = null;
    ProrateForm	iform = (ProrateForm)form;

    // create audit data
    ProrateAudit	audit = new ProrateAudit();

    // data used to inform error
    String	errorId = null;
    String	errorItem = null;
    /* ;;; set input data from iform into audit */
    audit.setOwnAudit(false);
    audit.setTicketing(false);
    audit.setInward(false);
    String	prorateType = iform.getProrateType();
    if (prorateType.equals("issued by own carrier")) {
      audit.setOwnAudit(true);
      audit.setTicketing(true);
    }
    else if (prorateType.equals("inward")) {
      audit.setOwnAudit(true);
      audit.setInward(true);
    }
    audit.setTraceLevel(iform.getTraceLevel().equals("detail") ? 10000 : 0);

    audit.setOwnAirwayId(iform.getOwnAirwayId());
    if (audit.getOwnAirwayId() == null
	|| audit.getOwnAirwayId().length() == 0) {
      errorId = "ownAirwayId";
      errorItem = iform.getOwnAirwayId();
      String	errorString =
	errorId + " [" + errorItem + "] : Own Airway Id not defined ";
      ProrateView	errorView = new ProrateView();
      errorView.setErrorString(errorString);
      copy(iform, errorView);
      request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					      errorView );
      forward = mapping.findForward(IConstants.FAILURE_KEY );
      return forward;
    }

    audit.setAirwayNumber(iform.getAirwayNumber());
    int	cpn = -1;
    try {
      errorId = "couponNumber";
      errorItem = iform.getCouponNumber();
      cpn = (iform.getCouponNumber().length() > 0 ?
	     Integer.parseInt(iform.getCouponNumber()) : (int)0);
    }
    catch (NumberFormatException e) {
      String	errorString =
	errorId + " [" + errorItem + "] : "
	+ "Number Format Exception " + e.getMessage();
      ProrateView	errorView = new ProrateView();
      errorView.setErrorString(errorString);
      copy(iform, errorView);
      request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					      errorView );
      forward = mapping.findForward(IConstants.FAILURE_KEY );
      return forward;
    }
    audit.setInwardNumber(iform.getInwardNumber());

    audit.setEndorsement(iform.getEndorsement());
    audit.setIssueDate(iform.getIssueDate());
    audit.setInvoiceMonth(iform.getInvoiceMonth());
    audit.setIssuePlace(iform.getIssuePlace());
    audit.setOrigin(iform.getOrigin());
    audit.setDestination(iform.getDestination());
    audit.setCurrency(iform.getCurrency());
    audit.setSalesCurrency(iform.getSalesCurrency());
    audit.setFareCalculation(iform.getFareCalculation());
    audit.setTourCode(iform.getTourCode());
    audit.setAgentCode(iform.getAgentCode());
    try {
      errorId = "ticketFare";
      errorItem = iform.getTicketFare();
      audit.setTicketFare(iform.getTicketFare().length() > 0 ?
			  Double.parseDouble(iform.getTicketFare())
			  : (double)0);
      errorId = "salesFare";
      errorItem = iform.getSalesFare();
      audit.setSalesFare(iform.getSalesFare().length() > 0 ?
			 Double.parseDouble(iform.getSalesFare())
			 : (double)0);
      errorId = "totalNuc";
      errorItem = iform.getTotalNuc();
      audit.setTotalNuc(iform.getTotalNuc().length() > 0 ?
			Double.parseDouble(iform.getTotalNuc())
			: (double)0);
      errorId = "lessAmt";
      errorItem = iform.getLessAmt();
      audit.setLessAmt(iform.getLessAmt().length() > 0 ?
		       Double.parseDouble(iform.getLessAmt())
		       : (double)0);
      errorId = "stopOverCharge";
      errorItem = iform.getStopOverCharge();
      audit.setStopOverCharge(iform.getStopOverCharge().length() > 0 ?
			      Double.parseDouble(iform.getStopOverCharge())
			      : (double)0);
      errorId = "commissionRate";
      errorItem = iform.getCommissionRate();
      audit.setCommissionRate(iform.getCommissionRate().length() > 0 ?
			Double.parseDouble(iform.getCommissionRate())
			: (double)0);
    }
    catch (NumberFormatException e) {
      String	errorString =
	errorId + " [" + errorItem + "] : "
	+ "Number Format Exception " + e.getMessage();
      ProrateView	errorView = new ProrateView();
      errorView.setErrorString(errorString);
      copy(iform, errorView);
      request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					      errorView );
      forward = mapping.findForward(IConstants.FAILURE_KEY );
      return forward;
    }
    
    if (audit.isOwnAudit() && audit.isTicketing()) {
      if (audit.getSalesCurrency().equals("")) {
	audit.setSalesCurrency(audit.getCurrency());
      }
      if (audit.getSalesFare() == (double)0) {
	audit.setSalesFare(audit.getTicketFare());
      }
    }

    audit.setNotDivideTax(iform.isNotDivideTax());
    List	taxList = new Vector();
    for (int i = 0; i < (int)iform.getNumTaxes(); i++) {
      if (iform.getTaxType(i) != null
	  && iform.getTaxType(i).length() > 0) {
	ProrateTaxData	tax = new ProrateTaxData();
	tax.setType(iform.getTaxType(i));
	try {
	  errorId = "taxAmount" + i;
	  errorItem = iform.getTaxAmount(i);
	  tax.setAmount(iform.getTaxAmount(i).length() > 0 ?
			Double.parseDouble(iform.getTaxAmount(i)) : (int)0);
	}
	catch (NumberFormatException e) {
	  String	errorString =
	    errorId + " [" + errorItem + "] : "
	    + "Number Format Exception " + e.getMessage();
	  ProrateView	errorView = new ProrateView();
	  errorView.setErrorString(errorString);
	  copy(iform, errorView);
	  request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
						  errorView );
	  forward = mapping.findForward(IConstants.FAILURE_KEY );
	  return forward;
	}
	taxList.add(tax);
      }
    }
    ProrateTaxData[] taxListArray = new ProrateTaxData[taxList.size()];
    for (int i = 0; i < taxList.size(); i++) {
      taxListArray[i] = (ProrateTaxData)taxList.get(i);
    }
    audit.setTax(taxListArray);
    List	taxMiscs = new Vector();
    for (int i = 0; i < (int)iform.getNumTaxMiscs(); i++) {
      if (iform.getTaxMiscType(i) != null
	  &&iform.getTaxMiscType(i).length() > 0) {
	ProrateTaxData	tax = new ProrateTaxData();
	tax.setType(iform.getTaxMiscType(i));
	try {
	  errorId = "taxMiscAmount" + i;
	  errorItem = iform.getTaxMiscAmount(i);
	  tax.setAmount(iform.getTaxMiscAmount(i).length() > 0 ?
			Double.parseDouble(iform.getTaxMiscAmount(i))
			: (int)0);
	}
	catch (NumberFormatException e) {
	  String	errorString =
	    errorId + " [" + errorItem + "] : "
	    + "Number Format Exception " + e.getMessage();
	  ProrateView	errorView = new ProrateView();
	  errorView.setErrorString(errorString);
	  copy(iform, errorView);
	  request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
						  errorView );
	  forward = mapping.findForward(IConstants.FAILURE_KEY );
	  return forward;
	}
	taxMiscs.add(tax);
      }
    }
    ProrateTaxData[] taxMiscsArray = new ProrateTaxData[taxMiscs.size()];
    for (int i = 0; i < taxMiscs.size(); i++) {
      taxMiscsArray[i] = (ProrateTaxData)taxMiscs.get(i);
    }
    audit.setTaxMisc(taxMiscsArray);

    /* ;;; set input data from iform into sectors */
    List	sectors = new Vector();

    /* ;;; set input data from iform into sectors */
    for (int i = 0; i < (int)iform.getNumSectors(); i++) {
      if (iform.getDepCode(i).length() > 0
	  && iform.getDestCode(i).length() > 0
	  && iform.getCarrier(i).length() > 0) {
	ProrateSector	sector = new ProrateSector();
	/* ;;; 2006.09.20 add set sequenceNo */
	sector.setSequenceNo(i);
	if (cpn >= 0 && i == cpn) {
	  sector.setInvoiceFlg(true);
	}
	sector.setStopOver(iform.getStopOver(i).length() > 0 ?
			   (byte)iform.getStopOver(i).charAt(0) : (byte)0);
	sector.setDepCode(iform.getDepCode(i));
	sector.setDestCode(iform.getDestCode(i));
	sector.setFareBasis(iform.getFareBasis(i));
	sector.setCarrier(iform.getCarrier(i));
	sector.setClassOfService(iform.getClassOfService(i));
	sector.setFlightNo(iform.getFlightNo(i));
	sector.setFlightDate(iform.getFlightDate(i));
	try {
	  errorId = "fareComponent";
	  errorItem = iform.getFareComponent(i);
	  sector.setFareComponent(iform.getFareComponent(i).length() > 0 ?
				  Double.parseDouble(iform.getFareComponent(i))
				  : (double)-1);
	  errorId = "fareClassDiffPlus";
	  errorItem = iform.getClassDiffPlus(i);
	  sector.setClassDiffPlus(iform.getClassDiffPlus(i).length() > 0 ?
				  Double.parseDouble(iform.getClassDiffPlus(i))
				  : (double)0);
	  errorId = "secureCharge";
	  errorItem = iform.getSecureCharge(i);
	  sector.setSecureCharge(iform.getSecureCharge(i).length() > 0 ?
				 Double.parseDouble(iform.getSecureCharge(i))
				 : (double)0);
	  errorId = "sideTripPlus";
	  errorItem = iform.getSideTripPlus(i);
	  sector.setSideTripPlus(iform.getSideTripPlus(i).length() > 0 ?
				 Double.parseDouble(iform.getSideTripPlus(i))
				 : (double)0);
	  errorId = "stopOverPlus";
	  errorItem = iform.getStopOverPlus(i);
	  sector.setStopOverPlus(iform.getStopOverPlus(i).length() > 0 ?
				 Double.parseDouble(iform.getStopOverPlus(i))
				 : (double)0);
	  sector.setTax((double)0);
	}
	catch (NumberFormatException e) {
	  String	errorString =
	    errorId + " [" + errorItem + "] in sector " + i + " : "
	    + "Number Format Exception " + e.getMessage();
	  ProrateView	errorView = new ProrateView();
	  errorView.setErrorString(errorString);
	  copy(iform, errorView);
	  request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
						  errorView );
	  forward = mapping.findForward(IConstants.FAILURE_KEY );
	  return forward;
	}
	sector.setFixCurrency("");
	sector.setFixValue((double)0);
	sectors.add(sector);
      }
    }
    ProrateSector[]	sectorsArray = new ProrateSector[sectors.size()];
    for (int j = 0; j < sectors.size(); j++) {
      sectorsArray[j] = (ProrateSector)sectors.get(j);
    }
    audit.setSectors(sectorsArray);

    // ;;; deBug
    System.err.println("audit.getSectors().length="
		       + audit.getSectors().length);

    if ((int)audit.getSectors().length == 0) {
      String	errorString = "no sectors in audit";
      ProrateView	errorView = new ProrateView();
      errorView.setErrorString(errorString);
      copy(iform, errorView);
      request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					      errorView );
      forward = mapping.findForward(IConstants.FAILURE_KEY );
      return forward;
    }

    /*
     * In a real application, you would typically get a reference
     * to a proration service through something like JNDI or a factory.
     */
    IProrateService	service = createProrateService();
    if (service == null) {
      // Store the ProrateView into the request and return
      ProrateView errorView = new ProrateView();
      errorView.setErrorString(getErrorString());
      copy(iform, errorView);
      request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					      errorView );
      forward = mapping.findForward(IConstants.FAILURE_KEY );
      return forward;
    }

    // Attempt to prorate
    ProrateView	prorateView = service.prorate(audit);
    
    if (prorateView == null) {
      // Store the ProrateView into the request and return
      ProrateView errorView = new ProrateView();
      errorView.setErrorString("Proration Service returned null view");
      copy(iform, errorView);
      request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					      errorView );
      forward = mapping.findForward(IConstants.FAILURE_KEY );
      return forward;
    }
    if (prorateView.isFatalError()) {
      copy(iform, prorateView);
      // Store the ProrateView into the request and return
      request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					      prorateView );
      forward = mapping.findForward(IConstants.FAILURE_KEY );
      return forward;
    }

    // Store the ProrateView into the request and return
    request.getSession(false).setAttribute( IConstants.PRORATE_VIEW_KEY,
					    prorateView );
    forward = mapping.findForward(IConstants.SUCCESS_KEY );
    return forward;
  }
  
  /**
   * <code>copy</code> method	copy all properties from the form to the view.
   *
   * @param form a <code>ProrateForm</code> value
   * @param view a <code>ProrateView</code> value
   */
  void	copy(ProrateForm form, ProrateView view) {
    view.setOwnAirwayId(form.getOwnAirwayId());
    view.setFareCalculation(form.getFareCalculation());
    view.setAirwayNumber(form.getAirwayNumber());
    view.setCouponNumber(form.getCouponNumber());
    view.setInwardNumber(form.getInwardNumber());
    view.setEndorsement(form.getEndorsement());
    view.setIssueDate(form.getIssueDate());
    view.setIssuePlace(form.getIssuePlace());
    view.setInvoiceMonth(form.getInvoiceMonth());
    view.setOrigin(form.getOrigin());
    view.setDestination(form.getDestination());
    view.setCurrency(form.getCurrency());
    view.setTicketFare(form.getTicketFare());
    view.setSalesCurrency(form.getSalesCurrency());
    view.setSalesFare(form.getSalesFare());
    view.setPlusAdjustment(form.getPlusAdjustment());
    view.setLessAdjustment(form.getLessAdjustment());
    view.setCommissionCurrency(form.getCommissionCurrency());
    view.setCommissionRate(form.getCommissionRate());
    view.setCommissionAmt(form.getCommissionAmt());
    view.setTotalNuc(form.getTotalNuc());
    view.setLessAmt(form.getLessAmt());
    view.setStopOverCharge(form.getStopOverCharge());
    view.setTourCode(form.getTourCode());
    view.setAgentCode(form.getAgentCode());

    view.setProrateType(form.getProrateType());
    view.setProrateTypeList(form.getProrateTypeList());
    view.setTraceLevel(form.getTraceLevel());
    view.setTraceLevelList(form.getTraceLevelList());

    view.setTaxType(form.getTaxType());
    view.setTaxAmount(form.getTaxAmount());
    view.setTaxMiscType(form.getTaxMiscType());
    view.setTaxMiscAmount(form.getTaxMiscAmount());

    view.setStopOver(form.getStopOver());
    view.setDepCode(form.getDepCode());
    view.setDestCode(form.getDestCode());
    view.setFareBasis(form.getFareBasis());
    view.setCarrier(form.getCarrier());
    view.setClassOfService(form.getClassOfService());
    view.setFareComponent(form.getFareComponent());
    view.setFlightNo(form.getFlightNo());
    view.setFlightDate(form.getFlightDate());
    view.setClassDiffPlus(form.getClassDiffPlus());
    view.setSecureCharge(form.getSecureCharge());
    view.setSideTripPlus(form.getSideTripPlus());
    view.setStopOverPlus(form.getStopOverPlus());
  }

  public abstract IProrateService	createProrateService();

  /**
   * @return  errorString ᤷޤ
   * @uml.property  name="errorString"
   */
  public String getErrorString() {
    return errorString;
  }
  /**
   * @param errorString  errorString ꡣ
   * @uml.property  name="errorString"
   */
  public void setErrorString(String errorString) {
    this.errorString = errorString;
  }
}
