// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.struts.form;

import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

/**
 * class <code>ProrateForm</code> This ActionForm is used by the online prorate appliation to validate input data facilities for proration calculation. If any of the required fields are empty or any of the input data are invalid when validate is called by the ActionServlet, error messages are created.
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class ProrateForm extends ActionForm {

  /**
   * <code>serialVersionUID</code> Υ
   */
  private static final long serialVersionUID = 1L;

  // Attributes
  /**
   * @uml.property  name="fareCalculation"
   */
  String	fareCalculation = "";	/* Fare Calculation */

  /**
   * @uml.property  name="ownAirwayId"
   */
  String	ownAirwayId = "";	/* ҹҶID ;;; version 3 */
  /**
   * @uml.property  name="airwayNumber"
   */
  String	airwayNumber = "";	/* ȯҶֹ */
  /**
   * @uml.property  name="couponNumber"
   */
  String	couponNumber = "";	/* ݥֹ */
  /**
   * @uml.property  name="inwardNumber"
   */
  String	inwardNumber = "";	/* Ҷֹ */
  /**
   * @uml.property  name="endorsement"
   */
  String	endorsement = "";	/* ENDORSEMENT/RESTRICTION */
  /**
   * @uml.property  name="issueDate"
   */
  String	issueDate = "";		/* ȯ */
  /**
   * @uml.property  name="issuePlace"
   */
  String	issuePlace = "";	/* ȯ */
  /**
   * @uml.property  name="invoiceMonth"
   */
  String	invoiceMonth = "";	/*  */
  /**
   * @uml.property  name="origin"
   */
  String	origin = "";		/* ϶ */
  /**
   * @uml.property  name="destination"
   */
  String	destination = "";	/* ǽ϶ */
  /**
   * @uml.property  name="currency"
   */
  String	currency = "";		/* ̶̲ۤߥ */
  /**
   * @uml.property  name="ticketFare"
   */
  String	ticketFare = "";	/* ̶ */
  /**
   * @uml.property  name="salesCurrency"
   */
  String	salesCurrency = "";	/* ȯ̲ۤߥ */
  /**
   * @uml.property  name="salesFare"
   */
  String	salesFare = "";		/* ȯ */
  /**
   * @uml.property  name="plusAdjustment"
   */
  String	plusAdjustment = "";	/* PLUSĴ */
  /**
   * @uml.property  name="lessAdjustment"
   */
  String	lessAdjustment = "";	/* LESSĴ */
  /**
   * @uml.property  name="commissionCurrency"
   */
  String	commissionCurrency = "";	/* ̲ۤߥ */
  /**
   * @uml.property  name="commissionRate"
   */
  String	commissionRate = "";	/* Ψ */
  /**
   * @uml.property  name="commissionAmt"
   */
  String	commissionAmt = "";	/*  */
  /**
   * @uml.property  name="totalNuc"
   */
  String	totalNuc = "";		/* Total Nuc */
  /**
   * @uml.property  name="lessAmt"
   */
  String	lessAmt = "";		/* LESS */
  /**
   * @uml.property  name="stopOverCharge"
   */
  String	stopOverCharge = "";	/* StopOver */
  /**
   * @uml.property  name="tourCode"
   */
  String	tourCode = "";	/* ĥ	;;; version 3 */
  /**
   * @uml.property  name="agentCode"
   */
  String	agentCode = "";	/* Ź	;;; version 3 */
  /**
   * @uml.property  name="errorFlag"
   */
  String	errorFlag = "";		/* 顼 **OUT** */
  /**
   * @uml.property  name="errorString"
   */
  String	errorString = "";	/* 顼ʸ **OUT** */

  /**
   * @uml.property  name="traceLevel"
   */
  String	traceLevel = "standard";	/* ȥ졼٥ */
  /**
   * @uml.property  name="traceLevelList"
   */
  List	traceLevelList = null;		/* ȥ졼٥ꥹ */

  /**
   * @uml.property  name="prorateType"
   */
  String	prorateType = "outward";	/* ץ졼 */
  /**
   * @uml.property  name="prorateTypeList"
   */
  List	prorateTypeList = null;

  // Attributes for tax
  /**
   * @uml.property  name="isNotDivideTax"
   */
  boolean	isNotDivideTax = false;
  /**
   * @uml.property  name="numTaxes"
   */
  int	numTaxes = 3;
  /**
   * @uml.property  name="taxType"
   */
  String[]	taxType = new String[numTaxes];
  /**
   * @uml.property  name="taxAmount"
   */
  String[]	taxAmount = new String[numTaxes];
  /**
   * @uml.property  name="numTaxMiscs"
   */
  int	numTaxMiscs = 10;
  /**
   * @uml.property  name="taxMiscType"
   */
  String[]	taxMiscType = new String[numTaxMiscs];
  /**
   * @uml.property  name="taxMiscAmount"
   */
  String[]	taxMiscAmount = new String[numTaxMiscs];

  // Attributes for Sectors
  /**
   * @uml.property  name="numSectors"
   */
  int	numSectors = 40;

  /**
   * @uml.property  name="stopOver"
   */
  String[]	stopOver = new String[numSectors];/* ߵ̵ͭե饰 */
  /**
   * @uml.property  name="depCode"
   */
  String[]	depCode = new String[numSectors];	/* ȯ϶ */
  /**
   * @uml.property  name="destCode"
   */
  String[]	destCode = new String[numSectors];	/* ϶ */
  /**
   * @uml.property  name="fareBasis"
   */
  String[]	fareBasis = new String[numSectors];/* ¼ ;;; default Y */
  /**
   * @uml.property  name="carrier"
   */
  String[]	carrier = new String[numSectors];	/* ͢Ҷ */
  /**
   * @uml.property  name="classOfService"
   */
  String[]	classOfService = new String[numSectors];/* class of service */
  /* եݡͥȲͳ */
  /**
   * @uml.property  name="fareComponent"
   */
  String[]	fareComponent = new String[numSectors];
  /**
   * @uml.property  name="flightNo"
   */
  String[]	flightNo = new String[numSectors];	/* ̾ */
  /**
   * @uml.property  name="flightDate"
   */
  String[]	flightDate = new String[numSectors];	/* ͽ */
  /* 饹ǥե󥷥ղó */
  /**
   * @uml.property  name="classDiffPlus"
   */
  String[]	classDiffPlus = new String[numSectors];
  /* ƥ㡼 */
  /**
   * @uml.property  name="secureCharge"
   */
  String[]	secureCharge = new String[numSectors];
  /* ɥȥåղó */
  /**
   * @uml.property  name="sideTripPlus"
   */
  String[]	sideTripPlus = new String[numSectors];
  /**
   * @uml.property  name="stopOverPlus"
   */
  String[]	stopOverPlus = new String[numSectors];	/* ߵղó */

  // Constructor
  /**
   * Creates a new <code>ProrateForm</code> instance.
   *
   */
  public ProrateForm() {
    super();
    resetFields();
    List	traceLevelList = new Vector();
    traceLevelList.add("standard");
    traceLevelList.add("detail");
    setTraceLevelList(traceLevelList);
    List	prorateTypeList = new Vector();
    prorateTypeList.add("issued by own carrier");
    prorateTypeList.add("outward");
    prorateTypeList.add("inward");
    setProrateTypeList(prorateTypeList);
  }

  // Operations
  /**
   * Describe <code>validate</code> method
   * Called by the framework to validate the fields
   * in which user has entered the data for proration calculation.
   *
   * @param mapping an <code>ActionMapping</code> value
   * @param request a <code>HttpServletRequest</code> value
   * @return an <code>ActionErrors</code> value
   */
  public ActionErrors validate(ActionMapping mapping,
			       HttpServletRequest request) {
    ActionErrors	errors = new ActionErrors();

    // Get access to the message resources for this application
    // There's not an easy way to access the resources from an ActionForm
    MessageResources	resources =
      (MessageResources)request.getAttribute( Globals.MESSAGES_KEY );

    // Check and see if the uid is missing
    if (false/*error*/) {
      String	label = resources.getMessage( "label" );
      ActionMessage	newError =
        new ActionMessage("global.error.login.requiredfield", label );
      errors.add(ActionMessages.GLOBAL_MESSAGE, newError);
    }

    // Return the ActionErrors, in any.
    return errors;
  }

  /**
   * <code>reset</code> method
   * Called by the framework to reset the fields back to their default values.
   *
   * @param mapping an <code>ActionMapping</code> value
   * @param request a <code>HttpServletRequest</code> value
   */
  public void reset(ActionMapping mapping, HttpServletRequest request) {
    // Clear out the uid and passwd fields
    resetFields();
  }

  /**
   * <code>resetFields</code> method
   * Reset the fields back to their defaults.
   *
   */
  protected void resetFields() {
  }

  /**
   * @return  ownAirwayId ᤷޤ
   * @uml.property  name="ownAirwayId"
   */
  public String getOwnAirwayId() {
    return ownAirwayId;
  }
  /**
   * @param ownAirwayId  ownAirwayId ꡣ
   * @uml.property  name="ownAirwayId"
   */
  public void setOwnAirwayId(String ownAirwayId) {
    this.ownAirwayId = ownAirwayId;
  }

  /**
   * @return  agentCode ᤷޤ
   * @uml.property  name="agentCode"
   */
  public String getAgentCode() {
    return agentCode;
  }
  /**
   * @param agentCode  agentCode ꡣ
   * @uml.property  name="agentCode"
   */
  public void setAgentCode(String agentCode) {
    this.agentCode = agentCode;
  }
  /**
   * @return  airwayNumber ᤷޤ
   * @uml.property  name="airwayNumber"
   */
  public String getAirwayNumber() {
    return airwayNumber;
  }
  /**
   * @param airwayNumber  airwayNumber ꡣ
   * @uml.property  name="airwayNumber"
   */
  public void setAirwayNumber(String airwayNumber) {
    this.airwayNumber = airwayNumber;
  }
  /**
   * @return  commissionAmt ᤷޤ
   * @uml.property  name="commissionAmt"
   */
  public String getCommissionAmt() {
    return commissionAmt;
  }
  /**
   * @param commissionAmt  commissionAmt ꡣ
   * @uml.property  name="commissionAmt"
   */
  public void setCommissionAmt(String commissionAmt) {
    this.commissionAmt = commissionAmt;
  }
  /**
   * @return  commissionCurrency ᤷޤ
   * @uml.property  name="commissionCurrency"
   */
  public String getCommissionCurrency() {
    return commissionCurrency;
  }
  /**
   * @param commissionCurrency  commissionCurrency ꡣ
   * @uml.property  name="commissionCurrency"
   */
  public void setCommissionCurrency(String commissionCurrency) {
    this.commissionCurrency = commissionCurrency;
  }
  /**
   * @return  commissionRate ᤷޤ
   * @uml.property  name="commissionRate"
   */
  public String getCommissionRate() {
    return commissionRate;
  }
  /**
   * @param commissionRate  commissionRate ꡣ
   * @uml.property  name="commissionRate"
   */
  public void setCommissionRate(String commissionRate) {
    this.commissionRate = commissionRate;
  }
  /**
   * @return  couponNumber ᤷޤ
   * @uml.property  name="couponNumber"
   */
  public String getCouponNumber() {
    return couponNumber;
  }
  /**
   * @param couponNumber  couponNumber ꡣ
   * @uml.property  name="couponNumber"
   */
  public void setCouponNumber(String couponNumber) {
    this.couponNumber = couponNumber;
  }
  /**
   * @return  currency ᤷޤ
   * @uml.property  name="currency"
   */
  public String getCurrency() {
    return currency;
  }
  /**
   * @param currency  currency ꡣ
   * @uml.property  name="currency"
   */
  public void setCurrency(String currency) {
    this.currency = currency;
  }
  /**
   * @return  destination ᤷޤ
   * @uml.property  name="destination"
   */
  public String getDestination() {
    return destination;
  }
  /**
   * @param destination  destination ꡣ
   * @uml.property  name="destination"
   */
  public void setDestination(String destination) {
    this.destination = destination;
  }
  /**
   * @return  endorsement ᤷޤ
   * @uml.property  name="endorsement"
   */
  public String getEndorsement() {
    return endorsement;
  }
  /**
   * @param endorsement  endorsement ꡣ
   * @uml.property  name="endorsement"
   */
  public void setEndorsement(String endorsement) {
    this.endorsement = endorsement;
  }
  /**
   * @return  errorFlag ᤷޤ
   * @uml.property  name="errorFlag"
   */
  public String getErrorFlag() {
    return errorFlag;
  }
  /**
   * @param errorFlag  errorFlag ꡣ
   * @uml.property  name="errorFlag"
   */
  public void setErrorFlag(String errorFlag) {
    this.errorFlag = errorFlag;
  }
  /**
   * @return  errorString ᤷޤ
   * @uml.property  name="errorString"
   */
  public String getErrorString() {
    return errorString;
  }
  /**
   * @param errorString  errorString ꡣ
   * @uml.property  name="errorString"
   */
  public void setErrorString(String errorString) {
    this.errorString = errorString;
  }
  /**
   * @return  fareCalculation ᤷޤ
   * @uml.property  name="fareCalculation"
   */
  public String getFareCalculation() {
    return fareCalculation;
  }
  /**
   * @param fareCalculation  fareCalculation ꡣ
   * @uml.property  name="fareCalculation"
   */
  public void setFareCalculation(String fareCalculation) {
    this.fareCalculation = fareCalculation;
  }
  /**
   * @return  invoiceMonth ᤷޤ
   * @uml.property  name="invoiceMonth"
   */
  public String getInvoiceMonth() {
    return invoiceMonth;
  }
  /**
   * @param invoiceMonth  invoiceMonth ꡣ
   * @uml.property  name="invoiceMonth"
   */
  public void setInvoiceMonth(String invoiceMonth) {
    this.invoiceMonth = invoiceMonth;
  }
  /**
   * @return  inwardNumber ᤷޤ
   * @uml.property  name="inwardNumber"
   */
  public String getInwardNumber() {
    return inwardNumber;
  }
  /**
   * @param inwardNumber  inwardNumber ꡣ
   * @uml.property  name="inwardNumber"
   */
  public void setInwardNumber(String inwardNumber) {
    this.inwardNumber = inwardNumber;
  }
  /**
   * @return  issueDate ᤷޤ
   * @uml.property  name="issueDate"
   */
  public String getIssueDate() {
    return issueDate;
  }
  /**
   * @param issueDate  issueDate ꡣ
   * @uml.property  name="issueDate"
   */
  public void setIssueDate(String issueDate) {
    this.issueDate = issueDate;
  }
  /**
   * @return  issuePlace ᤷޤ
   * @uml.property  name="issuePlace"
   */
  public String getIssuePlace() {
    return issuePlace;
  }
  /**
   * @param issuePlace  issuePlace ꡣ
   * @uml.property  name="issuePlace"
   */
  public void setIssuePlace(String issuePlace) {
    this.issuePlace = issuePlace;
  }
  /**
   * @return  lessAdjustment ᤷޤ
   * @uml.property  name="lessAdjustment"
   */
  public String getLessAdjustment() {
    return lessAdjustment;
  }
  /**
   * @param lessAdjustment  lessAdjustment ꡣ
   * @uml.property  name="lessAdjustment"
   */
  public void setLessAdjustment(String lessAdjustment) {
    this.lessAdjustment = lessAdjustment;
  }
  /**
   * @return  lessAmt ᤷޤ
   * @uml.property  name="lessAmt"
   */
  public String getLessAmt() {
    return lessAmt;
  }
  /**
   * @param lessAmt  lessAmt ꡣ
   * @uml.property  name="lessAmt"
   */
  public void setLessAmt(String lessAmt) {
    this.lessAmt = lessAmt;
  }
  /**
   * @return  origin ᤷޤ
   * @uml.property  name="origin"
   */
  public String getOrigin() {
    return origin;
  }
  /**
   * @param origin  origin ꡣ
   * @uml.property  name="origin"
   */
  public void setOrigin(String origin) {
    this.origin = origin;
  }
  /**
   * @return  plusAdjustment ᤷޤ
   * @uml.property  name="plusAdjustment"
   */
  public String getPlusAdjustment() {
    return plusAdjustment;
  }
  /**
   * @param plusAdjustment  plusAdjustment ꡣ
   * @uml.property  name="plusAdjustment"
   */
  public void setPlusAdjustment(String plusAdjustment) {
    this.plusAdjustment = plusAdjustment;
  }
  /**
   * @return  salesCurrency ᤷޤ
   * @uml.property  name="salesCurrency"
   */
  public String getSalesCurrency() {
    return salesCurrency;
  }
  /**
   * @param salesCurrency  salesCurrency ꡣ
   * @uml.property  name="salesCurrency"
   */
  public void setSalesCurrency(String salesCurrency) {
    this.salesCurrency = salesCurrency;
  }
  /**
   * @return  salesFare ᤷޤ
   * @uml.property  name="salesFare"
   */
  public String getSalesFare() {
    return salesFare;
  }
  /**
   * @param salesFare  salesFare ꡣ
   * @uml.property  name="salesFare"
   */
  public void setSalesFare(String salesFare) {
    this.salesFare = salesFare;
  }
  /**
   * @return  stopOverCharge ᤷޤ
   * @uml.property  name="stopOverCharge"
   */
  public String getStopOverCharge() {
    return stopOverCharge;
  }
  /**
   * @param stopOverCharge  stopOverCharge ꡣ
   * @uml.property  name="stopOverCharge"
   */
  public void setStopOverCharge(String stopOverCharge) {
    this.stopOverCharge = stopOverCharge;
  }
  /**
   * @return  ticketFare ᤷޤ
   * @uml.property  name="ticketFare"
   */
  public String getTicketFare() {
    return ticketFare;
  }
  /**
   * @param ticketFare  ticketFare ꡣ
   * @uml.property  name="ticketFare"
   */
  public void setTicketFare(String ticketFare) {
    this.ticketFare = ticketFare;
  }
  /**
   * @return  totalNuc ᤷޤ
   * @uml.property  name="totalNuc"
   */
  public String getTotalNuc() {
    return totalNuc;
  }
  /**
   * @param totalNuc  totalNuc ꡣ
   * @uml.property  name="totalNuc"
   */
  public void setTotalNuc(String totalNuc) {
    this.totalNuc = totalNuc;
  }
  /**
   * @return  numSectors ᤷޤ
   * @uml.property  name="numSectors"
   */
  public int getNumSectors() {
    return numSectors;
  }
  /**
   * @param numSectors  numSectors ꡣ
   * @uml.property  name="numSectors"
   */
  public void setNumSectors(int numSectors) {
    this.numSectors = numSectors;
  }

  // TODO: ;;; FIXME: property="propertyName[i]" does not work. why???
  /**
   * @return  carrier ᤷޤ
   * @uml.property  name="carrier"
   */
  public String[] getCarrier() {
    return carrier;
  }
  /**
   * @param carrier  carrier ꡣ
   * @uml.property  name="carrier"
   */
  public void setCarrier(String[] carrier) {
    this.carrier = carrier;
  }
  /**
   * @return carrier ᤷޤ
   */
  public String getCarrier(int i) {
    return carrier[i];
  }
  /**
   * @param carrier carrier ꡣ
   */
  public void setCarrier(int i, String carrier) {
    this.carrier[i] = carrier;
  }
  /**
   * @return  classDiffPlus ᤷޤ
   * @uml.property  name="classDiffPlus"
   */
  public String[] getClassDiffPlus() {
    return classDiffPlus;
  }
  /**
   * @param classDiffPlus  classDiffPlus ꡣ
   * @uml.property  name="classDiffPlus"
   */
  public void setClassDiffPlus(String[] classDiffPlus) {
    this.classDiffPlus = classDiffPlus;
  }
  /**
   * @return classDiffPlus ᤷޤ
   */
  public String getClassDiffPlus(int i) {
    return classDiffPlus[i];
  }
  /**
   * @param classDiffPlus classDiffPlus ꡣ
   */
  public void setClassDiffPlus(int i, String classDiffPlus) {
    this.classDiffPlus[i] = classDiffPlus;
  }
  /**
   * @return  classOfService ᤷޤ
   * @uml.property  name="classOfService"
   */
  public String[] getClassOfService() {
    return classOfService;
  }
  /**
   * @param classOfService  classOfService ꡣ
   * @uml.property  name="classOfService"
   */
  public void setClassOfService(String[] classOfService) {
    this.classOfService = classOfService;
  }
  /**
   * @return classOfService ᤷޤ
   */
  public String getClassOfService(int i) {
    return classOfService[i];
  }
  /**
   * @param classOfService classOfService ꡣ
   */
  public void setClassOfService(int i, String classOfService) {
    this.classOfService[i] = classOfService;
  }
  /**
   * @return  depCode ᤷޤ
   * @uml.property  name="depCode"
   */
  public String[] getDepCode() {
    return depCode;
  }
  /**
   * @param depCode  depCode ꡣ
   * @uml.property  name="depCode"
   */
  public void setDepCode(String[] depCode) {
    this.depCode = depCode;
  }
  /**
   * @return depCode ᤷޤ
   */
  public String getDepCode(int i) {
    return depCode[i];
  }
  /**
   * @param depCode depCode ꡣ
   */
  public void setDepCode(int i, String depCode) {
    this.depCode[i] = depCode;
  }
  /**
   * @return  destCode ᤷޤ
   * @uml.property  name="destCode"
   */
  public String[] getDestCode() {
    return destCode;
  }
  /**
   * @param destCode  destCode ꡣ
   * @uml.property  name="destCode"
   */
  public void setDestCode(String[] destCode) {
    this.destCode = destCode;
  }
  /**
   * @return destCode ᤷޤ
   */
  public String getDestCode(int i) {
    return destCode[i];
  }
  /**
   * @param destCode destCode ꡣ
   */
  public void setDestCode(int i, String destCode) {
    this.destCode[i] = destCode;
  }
  /**
   * @return  fareBasis ᤷޤ
   * @uml.property  name="fareBasis"
   */
  public String[] getFareBasis() {
    return fareBasis;
  }
  /**
   * @param fareBasis  fareBasis ꡣ
   * @uml.property  name="fareBasis"
   */
  public void setFareBasis(String[] fareBasis) {
    this.fareBasis = fareBasis;
  }
  /**
   * @return fareBasis ᤷޤ
   */
  public String getFareBasis(int i) {
    return fareBasis[i];
  }
  /**
   * @param fareBasis fareBasis ꡣ
   */
  public void setFareBasis(int i, String fareBasis) {
    this.fareBasis[i] = fareBasis;
  }
  /**
   * @return  fareComponent ᤷޤ
   * @uml.property  name="fareComponent"
   */
  public String[] getFareComponent() {
    return fareComponent;
  }
  /**
   * @param fareComponent  fareComponent ꡣ
   * @uml.property  name="fareComponent"
   */
  public void setFareComponent(String[] fareComponent) {
    this.fareComponent = fareComponent;
  }
  /**
   * @return fareComponent ᤷޤ
   */
  public String getFareComponent(int i) {
    return fareComponent[i];
  }
  /**
   * @param fareComponent fareComponent ꡣ
   */
  public void setFareComponent(int i, String fareComponent) {
    this.fareComponent[i] = fareComponent;
  }
  /**
   * @return  flightDate ᤷޤ
   * @uml.property  name="flightDate"
   */
  public String[] getFlightDate() {
    return flightDate;
  }
  /**
   * @param flightDate  flightDate ꡣ
   * @uml.property  name="flightDate"
   */
  public void setFlightDate(String[] flightDate) {
    this.flightDate = flightDate;
  }
  /**
   * @return flightDate ᤷޤ
   */
  public String getFlightDate(int i) {
    return flightDate[i];
  }
  /**
   * @param flightDate flightDate ꡣ
   */
  public void setFlightDate(int i, String flightDate) {
    this.flightDate[i] = flightDate;
  }
  /**
   * @return  flightNo ᤷޤ
   * @uml.property  name="flightNo"
   */
  public String[] getFlightNo() {
    return flightNo;
  }
  /**
   * @param flightNo  flightNo ꡣ
   * @uml.property  name="flightNo"
   */
  public void setFlightNo(String[] flightNo) {
    this.flightNo = flightNo;
  }
  /**
   * @return flightNo ᤷޤ
   */
  public String getFlightNo(int i) {
    return flightNo[i];
  }
  /**
   * @param flightNo flightNo ꡣ
   */
  public void setFlightNo(int i, String flightNo) {
    this.flightNo[i] = flightNo;
  }
  /**
   * @return  secureCharge ᤷޤ
   * @uml.property  name="secureCharge"
   */
  public String[] getSecureCharge() {
    return secureCharge;
  }
  /**
   * @param secureCharge  secureCharge ꡣ
   * @uml.property  name="secureCharge"
   */
  public void setSecureCharge(String[] secureCharge) {
    this.secureCharge = secureCharge;
  }
  /**
   * @return secureCharge ᤷޤ
   */
  public String getSecureCharge(int i) {
    return secureCharge[i];
  }
  /**
   * @param secureCharge secureCharge ꡣ
   */
  public void setSecureCharge(int i, String secureCharge) {
    this.secureCharge[i] = secureCharge;
  }
  /**
   * @return  sideTripPlus ᤷޤ
   * @uml.property  name="sideTripPlus"
   */
  public String[] getSideTripPlus() {
    return sideTripPlus;
  }
  /**
   * @param sideTripPlus  sideTripPlus ꡣ
   * @uml.property  name="sideTripPlus"
   */
  public void setSideTripPlus(String[] sideTripPlus) {
    this.sideTripPlus = sideTripPlus;
  }
  /**
   * @return sideTripPlus ᤷޤ
   */
  public String getSideTripPlus(int i) {
    return sideTripPlus[i];
  }
  /**
   * @param sideTripPlus sideTripPlus ꡣ
   */
  public void setSideTripPlus(int i, String sideTripPlus) {
    this.sideTripPlus[i] = sideTripPlus;
  }
  /**
   * @return  stopOver ᤷޤ
   * @uml.property  name="stopOver"
   */
  public String[] getStopOver() {
    return stopOver;
  }
  /**
   * @param stopOver  stopOver ꡣ
   * @uml.property  name="stopOver"
   */
  public void setStopOver(String[] stopOver) {
    this.stopOver = stopOver;
  }
  /**
   * @return stopOver ᤷޤ
   */
  public String getStopOver(int i) {
    return stopOver[i];
  }
  /**
   * @param stopOver stopOver ꡣ
   */
  public void setStopOver(int i, String stopOver) {
    this.stopOver[i] = stopOver;
  }
  /**
   * @return  stopOverPlus ᤷޤ
   * @uml.property  name="stopOverPlus"
   */
  public String[] getStopOverPlus() {
    return stopOverPlus;
  }
  /**
   * @param stopOverPlus  stopOverPlus ꡣ
   * @uml.property  name="stopOverPlus"
   */
  public void setStopOverPlus(String[] stopOverPlus) {
    this.stopOverPlus = stopOverPlus;
  }
  /**
   * @return stopOverPlus ᤷޤ
   */
  public String getStopOverPlus(int i) {
    return stopOverPlus[i];
  }
  /**
   * @param stopOverPlus stopOverPlus ꡣ
   */
  public void setStopOverPlus(int i, String stopOverPlus) {
    this.stopOverPlus[i] = stopOverPlus;
  }
  /**
   * @return  tourCode ᤷޤ
   * @uml.property  name="tourCode"
   */
  public String getTourCode() {
    return tourCode;
  }
  /**
   * @param tourCode  tourCode ꡣ
   * @uml.property  name="tourCode"
   */
  public void setTourCode(String tourCode) {
    this.tourCode = tourCode;
  }
  /**
   * @return  traceLevel ᤷޤ
   * @uml.property  name="traceLevel"
   */
  public String getTraceLevel() {
    return traceLevel;
  }
  /**
   * @param traceLevel  traceLevel ꡣ
   * @uml.property  name="traceLevel"
   */
  public void setTraceLevel(String traceLevel) {
    this.traceLevel = traceLevel;
  }
  /**
   * @return  traceLevelList ᤷޤ
   * @uml.property  name="traceLevelList"
   */
  public List getTraceLevelList() {
    return traceLevelList;
  }
  /**
   * @param traceLevelList  traceLevelList ꡣ
   * @uml.property  name="traceLevelList"
   */
  public void setTraceLevelList(List traceLevelList) {
    this.traceLevelList = traceLevelList;
  }
  /**
   * @return  prorateType ᤷޤ
   * @uml.property  name="prorateType"
   */
  public String getProrateType() {
    return prorateType;
  }
  /**
   * @param prorateType  prorateType ꡣ
   * @uml.property  name="prorateType"
   */
  public void setProrateType(String prorateType) {
    this.prorateType = prorateType;
  }
  /**
   * @return  prorateTypeList ᤷޤ
   * @uml.property  name="prorateTypeList"
   */
  public List getProrateTypeList() {
    return prorateTypeList;
  }
  /**
   * @param prorateTypeList  prorateTypeList ꡣ
   * @uml.property  name="prorateTypeList"
   */
  public void setProrateTypeList(List prorateTypeList) {
    this.prorateTypeList = prorateTypeList;
  }

  /**
   * @return  isNotDivideTax ᤷޤ
   * @uml.property  name="isNotDivideTax"
   */
  public boolean isNotDivideTax() {
    return isNotDivideTax;
  }

  /**
   * @param isNotDivideTax   isNotDivideTaxꡣ
   * @uml.property  name="isNotDivideTax"
   */
  public void setNotDivideTax(boolean isNotDivideTax) {
    this.isNotDivideTax = isNotDivideTax;
  }

  /**
   * @return  numTaxes ᤷޤ
   * @uml.property  name="numTaxes"
   */
  public int getNumTaxes() {
    return numTaxes;
  }

  /**
   * @param numTaxes  numTaxes ꡣ
   * @uml.property  name="numTaxes"
   */
  public void setNumTaxes(int numTaxes) {
    this.numTaxes = numTaxes;
  }

  /**
   * @return  numTaxMiscs ᤷޤ
   * @uml.property  name="numTaxMiscs"
   */
  public int getNumTaxMiscs() {
    return numTaxMiscs;
  }

  /**
   * @param numTaxMiscs  numTaxMiscs ꡣ
   * @uml.property  name="numTaxMiscs"
   */
  public void setNumTaxMiscs(int numTaxMiscs) {
    this.numTaxMiscs = numTaxMiscs;
  }

  /**
   * @return  taxAmount ᤷޤ
   * @uml.property  name="taxAmount"
   */
  public String[] getTaxAmount() {
    return taxAmount;
  }

  /**
   * @param taxAmount  taxAmount ꡣ
   * @uml.property  name="taxAmount"
   */
  public void setTaxAmount(String[] taxAmount) {
    this.taxAmount = taxAmount;
  }

  /**
   * @return taxAmount ᤷޤ
   */
  public String getTaxAmount(int i) {
    return taxAmount[i];
  }
  /**
   * @param taxAmount taxAmount ꡣ
   */
  public void setTaxAmount(int i, String taxAmount) {
    this.taxAmount[i] = taxAmount;
  }

  /**
   * @return  taxType ᤷޤ
   * @uml.property  name="taxType"
   */
  public String[] getTaxType() {
    return taxType;
  }

  /**
   * @param taxType  taxType ꡣ
   * @uml.property  name="taxType"
   */
  public void setTaxType(String[] taxType) {
    this.taxType = taxType;
  }

  /**
   * @return taxType ᤷޤ
   */
  public String getTaxType(int i) {
    return taxType[i];
  }
  /**
   * @param taxType taxType ꡣ
   */
  public void setTaxType(int i, String taxType) {
    this.taxType[i] = taxType;
  }

  /**
   * @return  taxMiscAmount ᤷޤ
   * @uml.property  name="taxMiscAmount"
   */
  public String[] getTaxMiscAmount() {
    return taxMiscAmount;
  }

  /**
   * @param taxMiscAmount  taxMiscAmount ꡣ
   * @uml.property  name="taxMiscAmount"
   */
  public void setTaxMiscAmount(String[] taxMiscAmount) {
    this.taxMiscAmount = taxMiscAmount;
  }

  /**
   * @return taxMiscAmount ᤷޤ
   */
  public String getTaxMiscAmount(int i) {
    return taxMiscAmount[i];
  }
  /**
   * @param taxMiscAmount taxMiscAmount ꡣ
   */
  public void setTaxMiscAmount(int i, String taxMiscAmount) {
    this.taxMiscAmount[i] = taxMiscAmount;
  }

  /**
   * @return  taxMiscType ᤷޤ
   * @uml.property  name="taxMiscType"
   */
  public String[] getTaxMiscType() {
    return taxMiscType;
  }

  /**
   * @param taxMiscType  taxMiscType ꡣ
   * @uml.property  name="taxMiscType"
   */
  public void setTaxMiscType(String[] taxMiscType) {
    this.taxMiscType = taxMiscType;
  }

  /**
   * @return taxMiscType ᤷޤ
   */
  public String getTaxMiscType(int i) {
    return taxMiscType[i];
  }
  /**
   * @param taxMiscType taxMiscType ꡣ
   */
  public void setTaxMiscType(int i, String taxMiscType) {
    this.taxMiscType[i] = taxMiscType;
  }
}
