package jp.sourceforge.gnp.prorate.struts.service;


import java.util.List;

import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.prorate.struts.view.ProrateView;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebase;

/**
 * Describe class <code>ProrateServiceAll</code> here.
 *	struts proration service using remote prorate client
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class ProrateServiceAll extends ProrateService {

  // Constructor
  /**
   * Creates a new <code>ProrateServiceAll</code> instance.
   *
   * @exception Exception if an error occurs
   */
  public ProrateServiceAll() throws Exception {
    super();
  }

  // Operations
  /**
   * <code>prorate</code> method
   *	creates prorate rmi client object,
   *	requests a prorate calculation to the rmi proration server.
   *	creates prorate view, sets data from the proration result,
   *	and returns it.
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateView</code> value
   */
  public ProrateView prorate(ProrateAudit audit) {
    ProrateImpl	prorate = null;
    try {
      prorate = (ProrateImpl)createProrate();
    }
    catch (Exception e) {
      // TODO ư줿 catch ֥å
      e.printStackTrace();
      ProrateView	errorView = createErrorView(audit);
      errorView.setFatalError(true);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }

    ProrateRulebase rulebase = null;
    try {
      rulebase = new XmlRulebase();
      XmlRulebase.initialize();
    } catch (Exception e) {
      // TODO ư줿 catch ֥å
      e.printStackTrace();
      ProrateView       errorView = createErrorView(audit);
      errorView.setFatalError(true);
      errorView.setErrorString(e.getMessage());
      return errorView;
    }
    ProrateRulebaseElementFactory factory = new ProrateRuleObjectFactory();
    rulebase.setElementFactory(factory);
    prorate.setRulebase(rulebase);
    prorate.setFcalc(new ProrateFCalcImpl());
    ProrateTrace	trace = new ProrateTraceString();
    trace.setData(audit);
    prorate.setTrace(trace);
    prorate.setDatabase(new ProrateRdb());
    if (!prorate.getDatabase().openDatabase()) {
      ProrateView	errorView = createErrorView(audit);
      errorView
	.setErrorString("proration service database initialization failed");
      return errorView;
    }

    ProrateAudit	auditRet = null;
    try {
      auditRet = prorate.prorate(audit);
    }
    catch (Exception e) {
      ProrateView	errorView = createErrorView(audit);
      errorView.setFatalError(true);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    List<String>
      traceStrings = ((ProrateTraceString)prorate.getTrace()).getStrings();
    String[]	traceStringsArray = new String[traceStrings.size()];
    for (int i = 0; i < traceStrings.size(); i++) {
      traceStringsArray[i] = (String)traceStrings.get(i);
    }
    auditRet.setTraceStrings(traceStringsArray);

    prorate.getDatabase().closeDatabase();
    prorate.setDatabase(null);
    prorate.setTrace(null);
    prorate.setFcalc(null);
    prorate.setRulebase(null);

    ProrateView	prorateView = createView(auditRet);
    return prorateView;
  }

  /**
   * <code>createProrate</code> method
   *	creates prorate rmi client object and returns it.
   *
   * @return a <code>Prorate</code> value
   * @exception Exception if an error occurs
   */
  public Prorate	createProrate() throws Exception {
    ProrateImpl	prorate = new ProrateImpl();
    return (Prorate)prorate;
  }
}
