// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.struts.service;

import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.prorate.ejb.client.ProrateEjbClient;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.struts.view.ProrateView;

/**
 * Describe class <code>ProrateServiceEjb</code> here. struts proration service using remote prorate client
 * @author   <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */
public class ProrateServiceEjb extends ProrateService {

  /**
   * variable <code>prorate</code>	ProrateEjb EJB3 object
   *
   */
  ProrateEjb	prorate = null;

  // Constructor
  /**
   * Creates a new <code>ProrateServiceEjb</code> instance.
   * @throws Exception 
   *
   */
  public ProrateServiceEjb() throws Exception {
    super();
    /* ;;; This does not work properly
    prorate = ProrateEjbClient.makeInstance();
    */
    Context context = null;
    try {
      context = new InitialContext();
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    Object ref = null;
    try {
      ref = context.lookup(ProrateEjb.JNDI_NAME);
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    prorate = (ProrateEjb)ref;
  }

  // Operations
  /**
   * <code>prorate</code> method
   *	creates prorate Ejb3 client session Bean object,
   *	requests a prorate calculation to the Ejb3 proration session Bean.
   *	creates prorate view, sets data from the proration result,
   *	and returns it.
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateView</code> value
   */
  public ProrateView prorate(ProrateAudit audit) {
    ProrateAudit	auditRet = null;
    try {
      auditRet = prorate.prorate(audit);
    }
    catch (Exception e) {
      // TODO ư줿 catch ֥å
      e.printStackTrace();
      ProrateView	errorView = createErrorView(audit);
      errorView.setFatalError(true);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    ProrateView	prorateView = createView(auditRet);
    return prorateView;
  }
}
