package jp.sourceforge.gnp.prorate.struts.service;


import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.rmi.RemoteProrate;
import jp.sourceforge.gnp.prorate.rmi.RemoteProrateClient;
import jp.sourceforge.gnp.prorate.struts.view.ProrateView;

/**
 * Describe class <code>ProrateServiceRmi</code> here.
 *	struts proration service using remote prorate client
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class ProrateServiceRmi extends ProrateService {

  // Constructor
  /**
   * Creates a new <code>ProrateServiceRmi</code> instance.
   *
   * @exception Exception if an error occurs
   */
  public ProrateServiceRmi() throws Exception {
    super();
  }

  // Operations
  /**
   * <code>prorate</code> method
   *	creates prorate rmi client object,
   *	requests a prorate calculation to the rmi proration server.
   *	creates prorate view, sets data from the proration result,
   *	and returns it.
   *
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateView</code> value
   */
  public ProrateView prorate(ProrateAudit audit) {
    ProrateAudit	auditRet = null;
    RemoteProrate	prorate = null;
    try {
      prorate = createProrate();
    }
    catch (Exception e) {
      // TODO $B<+F0@8@.$5$l$?(B catch $B%V%m%C%/(B
      e.printStackTrace();
      ProrateView	errorView = createErrorView(audit);
      errorView.setFatalError(true);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    try {
      auditRet = prorate.prorate(audit);
    }
    catch (Exception e) {
      // TODO $B<+F0@8@.$5$l$?(B catch $B%V%m%C%/(B
      e.printStackTrace();
      ProrateView	errorView = createErrorView(audit);
      errorView.setFatalError(true);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    ProrateView	prorateView = createView(auditRet);
    return prorateView;
  }

  /**
   * <code>createProrate</code> method
   *	creates prorate rmi client object and returns it.
   *
   * @return a <code>Prorate</code> value
   * @exception Exception if an error occurs
   */
  public RemoteProrate	createProrate() throws Exception {
    RemoteProrate	prorate = new RemoteProrateClient();
    return prorate;
  }
}
