// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate.struts.view;

import java.io.Serializable;
import java.util.List;
import jp.sourceforge.gnp.prorate.struts.form.ProrateForm;

/**
 * class <code>ProrateView</code> A value object for that wraps all of the proration result information
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class ProrateView extends ProrateForm implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  // Attributes
  /**
   * @uml.property  name="airwayId"
   */
  String	airwayId = "";	/* ҹҶID **OUT** */
  /**
   * @uml.property  name="inwardId"
   */
  String	inwardId = "";	/* ҶID **OUT** */
  /**
   * @uml.property  name="roeRate"
   */
  String	roeRate = "";	/* Roe졼 **OUT** */
  /**
   * @uml.property  name="day5Rate"
   */
  String	day5Rate = "";	/* 5Day졼 **OUT** */
  /**
   * @uml.property  name="meanRate"
   */
  String	meanRate = "";	/* Mean졼 **OUT** */
  /**
   * @uml.property  name="fixedFare"
   */
  String	fixedFare = "";	/* Fixed Fare Checkδ **OUT** */

  /**
   * @uml.property  name="traceRows"
   */
  int	traceRows = 0;	/* ȥ졼ʸԿ */
  /**
   * @uml.property  name="traceString"
   */
  String	traceString;	/* ȥ졼ʸꥹ */
  /**
   * variable <code>fatalError</code>	flag to indicate fatal error
   *
   */
  boolean	fatalError;	/* fatal error ե饰 */

  // Attributes for Sectors
  /**
   * @uml.property  name="sectorsList"
   */
  List	sectorsList;

  // Constructor
  /**
   * Creates a new <code>ProrateView</code> instance.
   *
   */
  public ProrateView() {
    super();
  }

  /**
   * @return  airwayId ᤷޤ
   * @uml.property  name="airwayId"
   */
  public String getAirwayId() {
    return airwayId;
  }
  /**
   * @param airwayId  airwayId ꡣ
   * @uml.property  name="airwayId"
   */
  public void setAirwayId(String airwayId) {
    this.airwayId = airwayId;
  }
  /**
   * @return  day5Rate ᤷޤ
   * @uml.property  name="day5Rate"
   */
  public String getDay5Rate() {
    return day5Rate;
  }
  /**
   * @param day5Rate  day5Rate ꡣ
   * @uml.property  name="day5Rate"
   */
  public void setDay5Rate(String day5Rate) {
    this.day5Rate = day5Rate;
  }
  /**
   * @return  fixedFare ᤷޤ
   * @uml.property  name="fixedFare"
   */
  public String getFixedFare() {
    return fixedFare;
  }
  /**
   * @param fixedFare  fixedFare ꡣ
   * @uml.property  name="fixedFare"
   */
  public void setFixedFare(String fixedFare) {
    this.fixedFare = fixedFare;
  }
  /**
   * @return  inwardId ᤷޤ
   * @uml.property  name="inwardId"
   */
  public String getInwardId() {
    return inwardId;
  }
  /**
   * @param inwardId  inwardId ꡣ
   * @uml.property  name="inwardId"
   */
  public void setInwardId(String inwardId) {
    this.inwardId = inwardId;
  }
  /**
   * @return  meanRate ᤷޤ
   * @uml.property  name="meanRate"
   */
  public String getMeanRate() {
    return meanRate;
  }
  /**
   * @param meanRate  meanRate ꡣ
   * @uml.property  name="meanRate"
   */
  public void setMeanRate(String meanRate) {
    this.meanRate = meanRate;
  }
  /**
   * @return  roeRate ᤷޤ
   * @uml.property  name="roeRate"
   */
  public String getRoeRate() {
    return roeRate;
  }
  /**
   * @param roeRate  roeRate ꡣ
   * @uml.property  name="roeRate"
   */
  public void setRoeRate(String roeRate) {
    this.roeRate = roeRate;
  }

  /**
   * @return  traceRows ᤷޤ
   * @uml.property  name="traceRows"
   */
  public int getTraceRows() {
    return traceRows;
  }
  /**
   * @param traceRows  traceRows ꡣ
   * @uml.property  name="traceRows"
   */
  public void setTraceRows(int traceRows) {
    this.traceRows = traceRows;
  }
  /**
   * @return  traceString ᤷޤ
   * @uml.property  name="traceString"
   */
  public String getTraceString() {
    return traceString;
  }
  /**
   * @param traceStrings  traceStrings ꡣ
   * @uml.property  name="traceString"
   */
  public void setTraceString(String traceString) {
    this.traceString = traceString;
  }

  /**
   * <code>isFatalError</code> method	returns fatalError
   *
   * @return a <code>boolean</code> value
   */
  public boolean isFatalError() {
    return fatalError;
  }
  /**
   * <code>setFatalError</code> method	set fatalError
   *
   * @param fatalError a <code>boolean</code> value
   */
  public void setFatalError(boolean fatalError) {
    this.fatalError = fatalError;
  }

  /**
   * @return  sectorsList ᤷޤ
   * @uml.property  name="sectorsList"
   */
  public List getSectorsList() {
    return sectorsList;
  }
  /**
   * @param sectorsList  sectorsList ꡣ
   * @uml.property  name="sectorsList"
   */
  public void setSectorsList(List sectorsList) {
    this.sectorsList = sectorsList;
  }
}
