// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import jp.sourceforge.glj.lisp.Lisp;

import jp.sourceforge.gnp.rulebase.xml.PrubaeReaderXmlUrl;
import jp.sourceforge.gnp.rulebase.xml.PrubaeWriterXml;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


public class PrubaeApplet extends JApplet {

  /**
   * <code>serialVersionUID</code>
   */
  private static final long serialVersionUID = 1L;
  static final String	prubaercFilename = "prubaerc";
  static final String	prubaePropertyFilename = "prubae.properties";
  static Logger	logger = Logger.getLogger(PrubaeApplet.class.getName());
  // Constructor  
  /**
   * Creates a new <code>PrubaeApplet</code> instance.
   */
  public PrubaeApplet() {
    super();
  }  

  // Operations  
  /**
   * <code>initialize</code> method 
   * reads configuration lists from prubaerc file.
   * configuration lists are in Scheme Lisp format.
   * this method uses GNU Kawa library(Java Scheme system).
   */
  public void initialize(Prubae prubae) {
    String	baseUrlStr = getDocumentBase().toString();
    /* ;;; deBug ??? getDocumentBase() returns code base url, not directory */
    int	index = -1;
    if ((index = baseUrlStr.indexOf('?')) >= 0) {
      baseUrlStr = baseUrlStr.substring(0, index);
    }
    if ((index = baseUrlStr.lastIndexOf('/')) >= 0) {
      baseUrlStr = baseUrlStr.substring(0, index);
    }
    System.out.println("baseUrlStr = " + baseUrlStr);
    logger.info("baseUrlStr = " + baseUrlStr);

    String
      propertyFile = (baseUrlStr + System.getProperty("file.separator")
		      + prubaePropertyFilename);
    prubae.setAdditionalPropertyFilename(propertyFile);
    System.out.println("propertyFile = " + propertyFile);
    logger.info("propertyFile = " + propertyFile);

    String	rcFile = (baseUrlStr + System.getProperty("file.separator")
			  + prubaercFilename);
    System.out.println("rcFile = " + rcFile);
    logger.info("rcFile = " + rcFile);
    /* ;;; deBug
    if ((index = baseUrlStr.indexOf("http://")) >= 0) {
      int	indexEnd = -1;
      if ((indexEnd = baseUrlStr.indexOf('/', index+"http://".length()))
	  >= 0) {
	prubae.setDtdDir(baseUrlStr.substring(0, indexEnd));
	System.out.println("dtdDir = " + prubae.getDtdDir());
	logger.info("dtdDir = " + prubae.getDtdDir());
      }
    }
    */
    URL rcUrl = null;
    try {
      rcUrl = new URL(rcFile);
      System.out.println("rcUrl = " + rcUrl);
      logger.info("rcUrl = " + rcUrl);
    } catch (MalformedURLException e) {
      JOptionPane
	.showMessageDialog(null, rcFile + " : " + "url not found :"
			   + e.getMessage());
      rcUrl = null;
    }
    System.out.println("URL rcUrl = " + rcUrl);
    //logger.info("URL rcUrl = " + rcUrl);
    InputStream	rcIn = null;
    if (rcUrl != null) {
      try {
	/*	;;; 2009/07/22
	rcIn = rcUrl.openStream();
	*/
	URLConnection	connection = rcUrl.openConnection();
	connection.setUseCaches(false);
	rcIn = connection.getInputStream();
      }
      catch (IOException e) {
	JOptionPane
	  .showMessageDialog(null,
			     rcFile + " : " +
			     "IOException in openStream() : "
			     + e.getMessage());
	rcIn = null;
      }
    }
    System.out.println("stream rcIn = " + rcIn);
    logger.info("stream rcIn = " + rcIn);

    LList	tree = null;
    try {
      if (rcIn != null) {
	tree = Lisp.read(rcIn);
      }
      else {
	ClassLoader	loader = Prubae.class.getClassLoader();
	InputStream	is = loader.getResourceAsStream(Prubae.prubaercFile);
	tree = Lisp.read(is);
      }
    }
    catch (Exception e) {
      e.printStackTrace();
      return;
    }

    prubae.initConfTree(tree);
  }

  /**
   * <code>init</code> method
   * is the overrided init method of the Applet Class.
   * creates prubae instance,
   * and put the prubae panel in the center of the Applet panel.
   */
  public void init() {
    logger.setLevel(Level.INFO);
    String	laf = UIManager.getSystemLookAndFeelClassName();
    try {
      UIManager.setLookAndFeel(laf);
    } catch (UnsupportedLookAndFeelException exc) {
      System.out.println("Warning: UnsupportedLookAndFeel: " + laf);
      logger.info("Warning: UnsupportedLookAndFeel: " + laf);
    } catch (Exception exc) {
      System.out.println("Error loading " + laf + ": " + exc);
      logger.info("Error loading " + laf + ": " + exc);
    }

    Prubae	prubae = new Prubae() {
	public PrubaeModel setFunction(PrubaeModel model) {
	  getPartPanel().setVisible(false);
	  getPartPanel().removeAll();
	  PrubaeModel	ret = super.setFunction(model);
	  getPartPanel().setVisible(true);
	  return ret;
	}
	public void closeFunction() {
	  getPartPanel().setVisible(false);
	  getPartPanel().removeAll();
	  super.closeFunction();
	  getPartPanel().setVisible(true);
	}
      };
    if (prubae == null) {
      return;
    }

    String	baseUrlStr = getDocumentBase().toString();
    /* ;;; deBug ??? getDocumentBase() returns code base url, not directory */
    int	index = -1;
    if ((index = baseUrlStr.indexOf('?')) >= 0) {
      baseUrlStr = baseUrlStr.substring(0, index);
    }
    if ((index = baseUrlStr.lastIndexOf('/')) >= 0) {
      baseUrlStr = baseUrlStr.substring(0, index);
    }
    System.out.println("baseUrlStr = " + baseUrlStr);
    logger.info("baseUrlStr = " + baseUrlStr);
    if (prubae.getWriter() == null) {
      prubae.setWriter(new PrubaeWriterXml());
      prubae.getWriter().setEditor(prubae);
    }
    System.err.println("Prubae(): before getReader() and new PrubaeReaderXmlUrl()");
    if (prubae.getReader() == null) {
      System.err.println("Prubae(): getReader()==" + prubae.getReader() + ", before new PrubaeReaderXmlUrl()");
      prubae.setReader(new PrubaeReaderXmlUrl());
      prubae.getReader().setEditor(prubae);
      ((PrubaeReaderXmlUrl)prubae.getReader()).setBaseUrl(baseUrlStr);
      prubae.getReader().initialize();
      System.err.println("Prubae(): getReader()==" + prubae.getReader() + ", after new PrubaeReaderXmlUrl()");
      prubae.getReader().setEditor(prubae);
    }

    String	urlname = getParameter("openurl");
    URL	openUrl = null;
    System.out.println("urlname = " + urlname);
    logger.info("urlname = " + urlname);
    if (urlname != null) {
      try {
	openUrl = new URL(urlname);
      } catch (MalformedURLException e) {
	/* ;;; deBug ??? getDocumentBase() returns file, not directory */
	String	urlFullname =
	  (baseUrlStr + System.getProperty("file.separator") + urlname);
	/* ;;; deBug
	if ((index = baseUrlStr.indexOf("http://")) >= 0) {
	  int	indexEnd = -1;
	  if ((indexEnd = baseUrlStr.indexOf('/', index+"http://".length()))
	      >= 0) {
	    prubae.setDtdDir(baseUrlStr.substring(0, indexEnd));
	    System.out.println("dtdDir = " + prubae.getDtdDir());
	    logger.info("dtdDir = " + prubae.getDtdDir());
	  }
	}
	*/
	try {
	  openUrl = new URL(urlFullname);
	} catch (MalformedURLException e1) {
	  JOptionPane
	    .showMessageDialog(null, urlFullname + " : " + "url not found :"
			       + e.getMessage());
	  openUrl = null;
	}
      }
    }

    System.out.println("initialize");
    logger.info("initialize");
    initialize(prubae);

    if (openUrl != null) {
      prubae.setEditType(Prubae.PrubaeEditUrl);
      prubae.setUrlname(urlname);
      prubae.setFilename(null);
    }
    else {
      prubae.setEditType(Prubae.PrubaeEditFile);
      prubae.setUrlname(null);
      prubae.setFilename(null);
    }

    System.out.println("initPanel");
    logger.info("initPanel");
    prubae.initPanel();

    if (openUrl != null) {
      InputStream	in = null;
      Reader	ruleReader = null;
      boolean	alreadyDialog = false;
      try {
	/*	;;; 2009/07/22
	in = openUrl.openStream();
	*/
	URLConnection	connection = openUrl.openConnection();
	connection.setUseCaches(false);
	in = connection.getInputStream();
      }
      catch (IOException e) {
	JOptionPane
	  .showMessageDialog(null, urlname + " : IOException : "
			     + e.getMessage());
	alreadyDialog = true;
	in = null;
      }
      if (in != null) {
	ruleReader = new InputStreamReader(in);
      }
      if (ruleReader != null) {
	PrubaeModel	modelSaved = prubae.getModel();
	PrubaeModel	model = null;
	prubae.getReader().read(ruleReader);
	model = prubae.getModel();
	prubae.setModel(modelSaved);
	prubae.setFunction(model);
      }
      else if (!alreadyDialog) {
	JOptionPane.showMessageDialog(null, urlname + " not found");
      }
    }

    /* ;;; deBug */
    if (prubae.getRootPanel() == null) {
      return;
    }

    getContentPane().add("Center", prubae.getRootPanel());
  }

  public static void main(String[] args) {
    PrubaeApplet	applet = new PrubaeApplet();
    applet.init();
  }

} /* end class PrubaeApplet */
