// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import javax.swing.JApplet;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class PrubaeAppletSigned extends JApplet {

  /**
   * <code>serialVersionUID</code>
   */
  private static final long serialVersionUID = 1L;

  // Constructor  
  /**
   * Creates a new <code>PrubaeAppletSigned</code> instance.
   */
  public PrubaeAppletSigned() {
    super();  
  }  

  // Operations  
  /**
   * <code>init</code> method
   * is the overrided init method of the Applet Class.
   * creates prubae instance,
   * and put the prubae panel in the center of the Applet panel.
   */
  public void init() {
    String	laf = UIManager.getSystemLookAndFeelClassName();
    try {
      UIManager.setLookAndFeel(laf);
    } catch (UnsupportedLookAndFeelException exc) {
      System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
    } catch (Exception exc) {
      System.err.println("Error loading " + laf + ": " + exc);
    }

    Prubae	prubae = new Prubae() {
	public PrubaeModel setFunction(PrubaeModel model) {
	  getPartPanel().setVisible(false);
	  getPartPanel().removeAll();
	  PrubaeModel	ret = super.setFunction(model);
	  getPartPanel().setVisible(true);
	  return ret;
	}
	public void closeFunction() {
	  getPartPanel().setVisible(false);
	  getPartPanel().removeAll();
	  super.closeFunction();
	  getPartPanel().setVisible(true);
	}
      };
    if (prubae == null) {
      return;
    }

    System.err.println("initialize");
    prubae.initialize();
    System.err.println("initPanel");
    prubae.initPanel();
    /*
      for (int i = 0; i < prubae.getFileMenu().getItemCount(); i++) {
      if (prubae.getFileMenu().getItem(i).getText().equals("Open")) {
      prubae.getFileMenu().getItem(i).setEnabled(false);
      }
      else if (prubae.getFileMenu().getItem(i).getText().equals("Save")) {
      prubae.getFileMenu().getItem(i).setEnabled(false);
      }
      }
    */

    /* ;;; deBug */
    if (prubae.getRootPanel() == null) {
      return;
    }

    getContentPane().add("Center", prubae.getRootPanel());
  }

  public static void main(String[] args) {
    PrubaeAppletSigned	applet = new PrubaeAppletSigned();
    applet.init();
  }

} /* end class PrubaeAppletSigned */
