// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

/**
 * class <code>PrubaeComboItem</code>	Object of items to add into JComboBox.
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
class PrubaeComboItem {
  // Attributes
  /**
   * variable <code>displayString</code>	display string
   *
   */
  private String	displayString;
  /**
   * variable <code>itemString</code>	item string
   *
   */
  private String	itemString;

  /**
   * Creates a new <code>PrubaeComboItem</code> instance.
   *
   */
  PrubaeComboItem() {
    super();
  }
  
  /**
   * Creates a new <code>PrubaeComboItem</code> instance.
   *
   * @param display a <code>String</code> display string value to set.
   * @param item a <code>String</code> item string value to set.
   */
  PrubaeComboItem(String display, String item) {
    super();
    displayString = display;
    itemString = item;
  }
  
  /**
   * <code>toString</code> method	returns display string to display.
   *
   * @return a <code>String</code> value
   */
  public String	toString() {
    return displayString;
  }

  public String getDisplayString() {
    return displayString;
  }

  public void setDisplayString(String displayString) {
    this.displayString = displayString;
  }

  public String getItemString() {
    return itemString;
  }

  public void setItemString(String itemString) {
    this.itemString = itemString;
  }
}
