// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;

/**
 * class <code>PrubaeControllerAndOr</code>
 * is the controller of the prubae rule and/or-statement element model.
 * this class controls the details input/display panel on the part panel.
 * this class controls the tree node related to the and/or-statement model,
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeControllerAndOr extends PrubaeControllerJudge {

  // Attributes
  /**
   * variable <code>andButton</code> is a button to set this model to and.
   * @uml.property  name="andButton"
   */
  private JRadioButton	andButton;
  /**
   * variable <code>orButton</code> is a button to set this model to or.
   * @uml.property  name="orButton"
   */
  private JRadioButton	orButton;

  // Constructor  
  /**
   * Creates a new <code>PrubaeControllerAndOr</code> instance.
   *
   */
  public PrubaeControllerAndOr() {  
    super();  
  }  

  // Operations  
  /**
   * <code>createButtons</code> method
   * creates and/or button which is to set this model to and/or rule element.
   */
  protected void createButtons() {
    super.createButtons();

    setAndButton(new JRadioButton("AND"));
    andButton.setActionCommand("And");
    andButton.addActionListener(this);
    setOrButton(new JRadioButton("OR"));
    orButton.setActionCommand("Or");
    orButton.addActionListener(this);
    ButtonGroup	group = new ButtonGroup();
    group.add(andButton);
    group.add(orButton);
    andButton.setSelected(((PrubaeModelAndOr)getModel()).isAnd());
    orButton.setSelected(!((PrubaeModelAndOr)getModel()).isAnd());
    JPanel	opPanel = new JPanel();
    opPanel.setLayout(new BoxLayout(opPanel, BoxLayout.X_AXIS));
    opPanel.add(andButton);
    opPanel.add(orButton);
    getPanel().add(opPanel);
  }

  /**
   * <code>initialize</code> method
   * first creates treeNode related to this model using super.initialize().
   * and sets tree nodes related to the judges in statements list
   * if they exist, as the child nodes of the treeNode.
   */
  public void initialize() {
    super.initialize();

    List	vec = ((PrubaeModelAndOr)getModel()).getStatements();
    if (vec != null) {
      for (int i = 0; i < vec.size(); i++) {
	DefaultMutableTreeNode
	  node = ((PrubaeModel)vec.get(i)).getController().getTreeNode();
	getTreeNode().add(node);
      }
    }
  }

  /**
   * <code>setTreeNodes</code> method
   * set child tree nodes relates to the judge models in the statements list.
   */
  public void setTreeNodes() {
    PrubaeModel
      car = (PrubaeModel)((PrubaeModelAndOr)getModel()).getStatements().get(0);
    PrubaeModel
      cdr = (PrubaeModel)((PrubaeModelAndOr)getModel()).getStatements().get(1);
    getTreeNode().add(car.getController().getTreeNode());
    getTreeNode().add(cdr.getController().getTreeNode());
    getEditor().getTreeModel().reload(getTreeNode());
  }

  /**
   * <code>destroyPanel</code> method
   *
   */
  public void destroyPanel() {
    setAndButton(null);
    setOrButton(null);
    super.destroyPanel();
  }

  /**
   * <code>actionPerformed</code> method
   * handles the action events returned from GUI items on the panel
   * when the action command is "And" or "Or",
   * set selection of the and/or radio buttons, set model isAnd attribute,
   * and send display() method to the view to refresh the screen.
   * @param e an <code>ActionEvent</code> value is the action event.
   */
  public void actionPerformed(ActionEvent e) {  
    if (e.getActionCommand().equals("And")) {
      andButton.setSelected(true);
      orButton.setSelected(false);
      ((PrubaeModelAndOr)getModel()).setAnd(true);
      getModel().setRegist((short) ProrateRulebaseElement.AND_CODE);
      getView().display();
    }
    else if (e.getActionCommand().equals("Or")) {
      andButton.setSelected(false);
      orButton.setSelected(true);
      ((PrubaeModelAndOr)getModel()).setAnd(false);
      getModel().setRegist((short) ProrateRulebaseElement.OR_CODE);
      getView().display();
    }
    else {
      super.actionPerformed(e);
    }
  }

  // Setters and Getters  
  /**
   * 
   * @uml.property name="andButton"
   */
  public void setAndButton(JRadioButton theAndButton) {
    andButton = theAndButton;
  }

  /**
   * 
   * @uml.property name="andButton"
   */
  public JRadioButton getAndButton() {
    return andButton;
  }

  /**
   * 
   * @uml.property name="orButton"
   */
  public void setOrButton(JRadioButton theOrButton) {
    orButton = theOrButton;
  }

  /**
   * 
   * @uml.property name="orButton"
   */
  public JRadioButton getOrButton() {
    return orButton;
  }

} /* end class PrubaeControllerAndOr */
