// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * class <code>PrubaeControllerDo</code>
 * is the common controller utility of the prubae rule actions element model.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeControllerDo extends PrubaeController {

  // Constructor  
  /**
   * Creates a new <code>PrubaeControllerDo</code> instance.
   * this creates all GUI elements on the panel
   * to controll/display the details of the action rule element models.
   */
  public PrubaeControllerDo() {  
    super();
  }

  // Operations  
  /**
   * <code>createButtons</code> method
   * creates if button, switch button, table button and do button,
   * which to create if-statement, switch-statement, table-statement,
   * and to create other action statements.
   */
  protected void createButtons() {
    JButton	ifButton = new JButton("If");
    ifButton.setActionCommand("If");
    ifButton.addActionListener(this);
    JButton	switchButton = new JButton("Switch");
    switchButton.setActionCommand("Switch");
    switchButton.addActionListener(this);
    JButton	tableButton = new JButton("Table");
    tableButton.setActionCommand("Table");
    tableButton.addActionListener(this);
    JButton	doButton = new JButton("Do Statement");
    doButton.setActionCommand("DoStatement");
    doButton.addActionListener(this);
    JPanel	opPanel = new JPanel();
    opPanel.setLayout(new BoxLayout(opPanel, BoxLayout.Y_AXIS));
    opPanel.add(ifButton);
    opPanel.add(switchButton);
    opPanel.add(tableButton);
    opPanel.add(doButton);
    getPanel().add(opPanel);
  }

  /**
   * <code>insert</code> method
   * creates new action model and insert before this model,
   * sending insertToParent method to the new model.
   * this also inserts the tree node related to the new model created,
   * this method is only used in the actionPerformed method of the subclasses.
   */
  protected void insert() {
    PrubaeModel	newModel = new PrubaeModelDo();
    newModel.insertToParent(getModel().getParentList(),
			    getModel().getParent(),
			    getModel());
    DefaultMutableTreeNode
      treeParent = (DefaultMutableTreeNode)getTreeNode().getParent();
    newModel.getController().insertTreeNode(treeParent, getTreeNode());
  }

  /**
   * <code>createPanel</code> method
   *
   */
  public void createPanel() {
    super.createPanel();
    createButtons();
  }

  /**
   * <code>actionPerformed</code> method
   * handles the action events returned from GUI items on the panel
   *
   * send the model delete when the action command is "delete",
   *
   * do nothing when the action command is "insert",
   *
   * otherwise, creates the appropriate action model class,
   * and swap this model with the new model, by sending swap to the new model.
   * then swap the tree node related to this model
   * with the tree node related with the new model
   * by sending swapTreeNode method to the controller related to the new model.
   * then delete this model and all GUI elements related to this model
   * by sending delete method to this model.
   * and refresh the screen and open part panel.
   * by sending display method to the view related to the new model,
   * and by sending open method to the controller related to the new model.
   *
   * @param e an <code>ActionEvent</code> value
   */
  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("delete")) {
      PrubaeController	cntl = getEditor().getController();
      System.err.println("PrubaeControllerDo.actionPerformed(delete) : this cntl = " + this + ", editor cntl = " + cntl);
      if (this == cntl) {
	deleteAndUp();
      }
      else {
	delete();
      }
    }
    else if (e.getActionCommand().equals("insert")) {
    }
    else {
      String	className = getClass().getName();
      int	rindex = className.lastIndexOf('.')+1;
      className =
	className.substring(0, rindex) + "PrubaeModel" + e.getActionCommand();
      PrubaeModelDo	newModel = null;
      try {
	Class	c = Class.forName(className);
	newModel = (PrubaeModelDo)c.newInstance();
      }
      catch (Exception exc) {
	System.err.println(exc.toString());
      };
      newModel.swap(getModel());
      DefaultMutableTreeNode
	node = (DefaultMutableTreeNode)getTreeNode().getParent();
      newModel.getController().swapTreeNode(node, getTreeNode());
      getModel().delete();
      newModel.getController().open();
      newModel.getView().display();
    }
  }

  /**
   * <code>createPopupMenu</code> method create popup menu for this node.
   *
   */
  void createPopupMenu() {
    JMenuItem	mi = null;
    setPopupMenu(new JPopupMenu());
    mi = new JMenuItem("delete this action");
    mi.setActionCommand("delete");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("insert action before this");
    mi.setActionCommand("insert");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("If");
    mi.setActionCommand("If");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("Switch");
    mi.setActionCommand("Switch");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("Table");
    mi.setActionCommand("Table");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("Do Statement");
    mi.setActionCommand("DoStatement");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
  }

} /* end class PrubaeControllerDo */
