// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;


/**
 * class <code>PrubaeControllerDoStatement</code>
 * is the controller of the prubae rule action statement element model.
 * this class controls the details input/display panel on the part panel.
 * this class also controls the tree node related to this statement model,
 *
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeControllerDoStatement extends PrubaeControllerDo {

  // Attributes  
  /**
   * variable <code>statementField</code> is the JTextField to display the action statement string. not editable.
   * @uml.property  name="statementField"
   */
  private JTextField statementField;
  /**
   * variable <code>functionBox</code> is the JComboBox to select the function type of the action statement.
   * @uml.property  name="functionBox"
   */
  private JComboBox functionBox;
  /**
   * variable <code>percentPanel</code> is the panel which contains percent field for changing visibility.
   * @uml.property  name="percentPanel"
   */
  private JPanel percentPanel;
  /**
   * variable <code>percentField</code> is the JTextField to display/input the percent value.
   * @uml.property  name="percentField"
   */
  private JTextField percentField;
  /**
   * variable <code>amountPanel</code> is the panel which contains amount fields for changing visibility.
   * @uml.property  name="amountPanel"
   */
  private JPanel amountPanel;
  /**
   * variable <code>currencyField</code> is the JTextField to display/input the currency string.
   * @uml.property  name="currencyField"
   */
  private JTextField currencyField;
  /**
   * variable <code>amountField</code> is the JTextField to display/input the amount value.
   * @uml.property  name="amountField"
   */
  private JTextField amountField;

  /**
   * variable <code>comboItems</code> is the List of PrubaeComboItems.
   *
   */
  private List<PrubaeComboItem>	comboItems;

  // Constructor  
  /**
   * Creates a new <code>PrubaeControllerDoStatement</code> instance.
   *
   */
  public PrubaeControllerDoStatement() {  
    super();  
  }  

  // Operations  
  /**
   * <code>createButtons</code> method
   * creates statementField, functionBox, parcentField, currency/amount fields.
   */
  protected void createButtons() {  
    setStatementField(new JTextField("", 16));
    getStatementField().setEditable(false);
    JPanel	doPanel = new JPanel();
    doPanel.setLayout(new BoxLayout(doPanel, BoxLayout.X_AXIS));
    JLabel	doLabel = new JLabel("Do : ");
    doPanel.add(doLabel);
    doPanel.add(getStatementField());
    getPanel().add(doPanel);

    setFunctionBox(new JComboBox());
    getFunctionBox().setMaximumRowCount(4);
    getFunctionBox().setActionCommand("select function");

    setPercentPanel(new JPanel());
    setPercentField(new JTextField("", 4));
    JLabel	percentLabel = new JLabel("% of");
    getPercentPanel().setLayout(new BoxLayout(getPercentPanel(),
					      BoxLayout.X_AXIS));
    getPercentPanel().add(getPercentField());
    getPercentPanel().add(percentLabel);

    JPanel	doFPanel = new JPanel();
    doFPanel.setLayout(new BoxLayout(doFPanel, BoxLayout.X_AXIS));
    doFPanel.add(getPercentPanel());
    doFPanel.add(getFunctionBox());
    getPercentPanel().setVisible(false);
    getPanel().add(doFPanel);

    setAmountPanel(new JPanel());
    setCurrencyField(new JTextField("", 4));
    setAmountField(new JTextField("", 4));
    JLabel	amountLabel = new JLabel("AMOUNT");
    getAmountPanel().setLayout(new BoxLayout(getAmountPanel(),
					     BoxLayout.X_AXIS));
    getAmountPanel().add(amountLabel);
    getAmountPanel().add(getCurrencyField());
    getAmountPanel().add(getAmountField());
    getAmountPanel().setVisible(false);
    getPanel().add(getAmountPanel());
  }  

  /**
   * <code>update</code> method
   * updates the model with the input values on the panel.
   * this updates percent value from the input in the percent field,
   * updates currency/amount value from the input in currency/amount fields.
   * this also updates the statements of the model with updateStatement(),
   * and updates comment string using super.update().
   */
  public void update() {
    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    if (getPercentPanel().isVisible() && getPercentField().isVisible()) {
      double	value = (double)0;
      try {
	value = Double.parseDouble(getPercentField().getText());
      }
      catch (NumberFormatException e) {
	value = 0;
      }
      model.setPercent(value);
    }
    else {
      model.setPercent((double)0);
    }
    if (getAmountPanel().isVisible()
	&& getCurrencyField().isVisible() && getAmountField().isVisible()) {
      System.err.println("amount visible");
      String	currency = getCurrencyField().getText();
      double	value = (double)0;
      try {
	value = Double.parseDouble(getAmountField().getText());
      }
      catch (NumberFormatException e) {
	value = 0;
      }
      model.getValues().set(0, currency);
      model.getValues().set(1, new Double(value));
    }
    model.updateStatement();
    super.update();
  }

  /**
   * <code>createPanel</code> method
   * first creates panel and buttons using super.createPanel().
   * set functionBox items from the list doList of the editor.
   *
   */
  public void createPanel() {
    super.createPanel();

    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    LList	list = getEditor().getDoList();
    if (model.getValues() != null) {
      int	numArgs = model.getValues().size();
      LList	doList = Lisp.assoc(new IntNum(model.getRegist()), list);
      if (doList != null) {
	Object
	  listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
	Object[]	typeArgs = new Object[numArgs];
	for (int i = 0; i < numArgs; i++) {
	  typeArgs[i] = Lisp.car(listArgs);
	  listArgs = Lisp.cdr(listArgs);
	  System.err.println("PrubaeControllerDoStatement.createPanel(): typeArgs[" + i + "] = " + typeArgs[i]);
	}
	for (int i = 0; i < model.getValues().size(); i++) {
	  if (model.getValues().get(i) instanceof PrubaeModelValue) {
	    PrubaeModelValue
	      child = (PrubaeModelValue)model.getValues().get(i);
	    if (child instanceof PrubaeModelValueStatement) {
	      if (i > 0 && typeArgs[i] != null
		  && typeArgs[i].equals("first")) {
		child
		  .setRequiredType(((PrubaeModelValue)model.getValues().get(0))
				   .getType());
	      }
	      /* ;;; 2009.07.10 add start */
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.MULTIVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getRequiredType() != null)) {
		//System.err.println("PrubaeControllerDoStatement.createPanel(): model = " + model + ", requiredType = " + ((PrubaeModelValue)model.getValues().get(i)).getType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getRequiredType());
	      }
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.MULTIVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getType() != null)) {
		//System.err.println("PrubaeControllerDoStatement.createPanel(): model = " + model + ", type = " + ((PrubaeModelValue)model.getValues().get(i)).getType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getType());
	      }
	      /* ;;; 2009.07.10 add end */
	      /* ;;; 2009.07.15 add start */
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.INTERVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getRequiredType() != null)) {
		//System.err.println("PrubaeControllerDoStatement.createPanel(): model = " + model + ", requiredType = " + ((PrubaeModelValue)model.getValues().get(i)).getType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getRequiredType());
	      }
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.INTERVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getType() != null)) {
		//System.err.println("PrubaeControllerDoStatement.createPanel(): model = " + model + ", type = " + ((PrubaeModelValue)model.getValues().get(i)).getType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getType());
	      }
	      /* ;;; 2009.07.15 add end */
	      else if (typeArgs[i] != null) {
		child.setRequiredType(typeArgs[i]);
	      }
	    }
	    if (child.getController() == null) {
	      child.openUI();
	    }
	    child.getController().createPanel();
	  }
	}
      }
    }

    setComboItems(new Vector());
    PrubaeComboItem item = new PrubaeComboItem("", "");
    getComboItems().add(item);
    getFunctionBox().addItem(item);
    for ( ; !Lisp.isNil(list); list = (LList)Lisp.cdr(list)) {
      LList	doList = (LList)Lisp.car(list);
      String	dispStr = (Lisp.car(Lisp.cdr(doList))).toString();
      String	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(doList)))).toString();
      item = new PrubaeComboItem(dispStr, itemStr);
      getComboItems().add(item);
      getFunctionBox().addItem(item);
    }
    getFunctionBox().addActionListener(this);
  }

  /**
   * <code>destroyPanel</code> method
   *
   */
  public void destroyPanel() {
    setStatementField(null);
    setFunctionBox(null);
    setPercentPanel(null);
    setPercentField(null);
    setAmountPanel(null);
    setCurrencyField(null);
    setAmountField(null);
    super.destroyPanel();
  }

  /**
   * <code>select</code> method
   * handles the selection in the function box.
   * first, get regist code of selected item using doList of the editor.
   * if the regist code is changed by selection,
   * delete view and controller and close GUI items
   * by sending closeUI() method to the models in the values list.
   * and clear the values list.
   * set the regist code to the model.
   * handle percent field using percent().
   * handle GUI panels of values using arguments().
   * update statement of the model by sending updateStatement() to the model.
   * @param selected a <code>String</code> value is the selected item string.
   */
  protected void select(String selected) {
    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    LList	list = getEditor().getDoList();
    for ( ; !Lisp.isNil(list); list = (LList)Lisp.cdr(list)) {
      LList	doList = (LList)Lisp.car(list);
      String	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(doList)))).toString();
      if (selected.equals(itemStr)) {
	short	regist = (short)((IntNum)Lisp.car(doList)).intValue();
	if (model.getRegist() == regist && model.getName().equals(selected)) {
	}
	else {
	  if (model.getValues() != null) {
	    for (int i = 0; i < model.getValues().size(); i++) {
	      if (model.getValues().get(i) instanceof PrubaeModel) {
		((PrubaeModel)model.getValues().get(i)).closeUI();
	      }
	    }
	    model.getValues().clear();
	  }
	  model.setRegist(regist);
	  model.setName(selected);
	  /* percent */
	  percent(doList);
	  /* arguments */
	  arguments(doList);
	  model.updateStatement();
	  getStatementField().setText(model.getStatement());
	}
	break;
      }
    }
  }

  /**
   * <code>percent</code> method
   * this handles the percent field.
   * if the statement is not require the percent to input/display,
   * set the percent panel (and field) invisible.
   * otherwise, if the percent value is not 0, set the value to the field.
   * set the percent panel (and field) visible.
   * @param doList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the doList of the editor.
   */
  private void percent(LList doList) {
    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    Object	isPercent = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList))));
    if (isPercent == null || Lisp.isNil(isPercent)) {
      model.setPercent((double)0);
      getPercentField().setText("");
      getPercentPanel().setVisible(false);
    }
    else {
      System.err.println("isPercent not nil, percent set visible");
      if (model.getPercent() != (double)0) {
	String	percentStr = Double.toString(model.getPercent());
	getPercentField().setText(percentStr);
      }
      else {
	getPercentField().setText("");
      }
      getPercentPanel().setVisible(true);
    }
  }

  /**
   * <code>arguments</code> method
   * handles the display/input arguments required by the action functions.
   * if the action is fixed-amount-setting(the type is "setamount"),
   * add currency "" and amount value 0 to the values list of the model,
   * and set amount panel visible.
   * otherwise, for all values required by the action function,
   * creates value statement model and send initialize, openUI to it,
   * and add it to the values list of the model,
   * and add its panel on the panel.
   * @param doList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the doList of the editor.
   */
  private void arguments(LList doList) {
    PrubaeModelDoStatement	model = (PrubaeModelDoStatement)getModel();
    Object
      isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
    getAmountPanel().setVisible(false);
    System.err.println("do controller Arguments : judgeList = " + doList);
    if (isArgs == null) {
      return;
    }
    else if (!(isArgs instanceof IntNum)) {
      return;
    }
    System.err.println("numArgs = " + isArgs);
    int	numArgs = ((IntNum)isArgs).intValue();
    if (numArgs <= 0) {
      return;
    }
    System.err.println("do controller Arguments = " + numArgs);
    Object
      listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(doList)))));
    Object[]	typeArgs = new Object[numArgs];
    for (int i = 0; i < numArgs; i++) {
      typeArgs[i] = Lisp.car(listArgs);
      listArgs = Lisp.cdr(listArgs);
    }
    if (model.getValues() == null) {
      model.setValues(new Vector());
    }
    if (numArgs == 1
	&& typeArgs[0] != null && typeArgs[0].equals("setamount")) {
      /* set amount statement */
      model.getValues().add("");
      model.getValues().add(new Double((double)0));
      getAmountPanel().setVisible(true);
      return;
    }
    for (int i = 0; i < numArgs && typeArgs[i] != null; i++) {
      String	type;
      if (typeArgs[i] instanceof Pair) {
	type = (String)Lisp.car(typeArgs[i]);
      }
      else {
	type = (String)typeArgs[i];
      }
      //System.err.println("Arguments(" + i + ") = " + type);
      if (type.equals("setnumber")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.NUMBER_CODE);
	ret.setComment("");
	ret.setStatement("" + 0);
	ret.setValues(new Vector());
	ret.getValues().add(new Double((double)0));
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setdate")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.DATE_CODE);
	ret.setComment("");
	ret.setStatement("" + 0 + "/" + 0);
	ret.setValues(new Vector());
	ret.getValues().add(new Short((short)0));
	ret.getValues().add(new Short((short)0));
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setstring")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.STRING_CODE);
	ret.setComment("");
	ret.setStatement("\"\"");
	ret.setValues(new Vector());
	ret.getValues().add("");
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setamount")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.AMOUNT_CODE);
	ret.setComment("");
	ret.setValues(new Vector());
	ret.getValues().add("");
	ret.getValues().add(new Double((double)0));
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setpath")) {
	/* not implemented yet *//* probably not in use now */
      }
      else {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setComment("");
	ret.setStatement("");
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
    }
    return;
  }

  /**
   * <code>activateSelection</code> method
   *	activates JComboBox selection action.
   *
   */
  public void	activateSelection() {
    getFunctionBox().setActionCommand("select function");
  }
  
  /**
   * <code>inactivateSelection</code> method
   *	inactivates JComboBox selection action.
   *
   */
  public void	inactivateSelection() {
    getFunctionBox().setActionCommand("nop");
  }

  /**
   * <code>actionPerformed</code> method
   * handles the action events returned from GUI items on the panel
   * send the model delete when the action command is "delete",
   * call insert() method when the action command is "insert",
   * call select() when the action command is "select function",
   * @param e an <code>ActionEvent</code> value is the action event.
   */
  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("delete")) {
      PrubaeController	cntl = getEditor().getController();
      System.err.println("PrubaeControllerDoStatement.actionPerformed(delete) : this cntl = " + this + ", editor cntl = " + cntl);
      if (this == cntl) {
	deleteAndUp();
      }
      else {
	delete();
      }
    }
    else if (e.getActionCommand().equals("insert")) {
      insert();
    }
    else if (e.getActionCommand().equals("select function")) {
      PrubaeComboItem
	selected =
	(PrubaeComboItem)((JComboBox)e.getSource()).getSelectedItem();
      select(selected.getItemString());
    }
    else if (e.getActionCommand().equals("nop")) {
    }
    else {
    }
  }

  /**
   * <code>createPopupMenu</code> method create popup menu for this node.
   *
   */
  void createPopupMenu() {
    JMenuItem	mi = null;
    setPopupMenu(new JPopupMenu());
    mi = new JMenuItem("delete this action");
    mi.setActionCommand("delete");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("insert action before this");
    mi.setActionCommand("insert");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
  }

  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeControllerDoStatement	clone = null;
    clone = (PrubaeControllerDoStatement)super.clone();
    if (getStatementField() != null) {
      clone.setStatementField(new JTextField());
    }
    if (getFunctionBox() != null) {
      clone.setFunctionBox(new JComboBox());
      clone.getFunctionBox()
	.setSelectedItem(getFunctionBox().getSelectedItem());
    }
    if (getPercentPanel() != null) {
      clone.setPercentPanel(new JPanel());
    }
    if (getPercentField() != null) {
      clone.setPercentField(new JTextField());
    }
    if (getAmountPanel() != null) {
      clone.setAmountPanel(new JPanel());
    }
    if (getCurrencyField() != null) {
      clone.setCurrencyField(new JTextField());
    }
    if (getAmountField() != null) {
      clone.setAmountField(new JTextField());
    }
    return clone;
  }

  // Setters and Getters  
  /**
   * 
   * @uml.property name="statementField"
   */
  public void setStatementField(JTextField theStatementField) {
    statementField = theStatementField;
  }

  /**
   * 
   * @uml.property name="statementField"
   */
  public JTextField getStatementField() {
    return statementField;
  }

  /**
   * 
   * @uml.property name="functionBox"
   */
  public void setFunctionBox(JComboBox theFunctionBox) {
    functionBox = theFunctionBox;
  }

  /**
   * 
   * @uml.property name="functionBox"
   */
  public JComboBox getFunctionBox() {
    return functionBox;
  }

  /**
   * 
   * @uml.property name="percentPanel"
   */
  public void setPercentPanel(JPanel thePercentPanel) {
    percentPanel = thePercentPanel;
  }

  /**
   * 
   * @uml.property name="percentPanel"
   */
  public JPanel getPercentPanel() {
    return percentPanel;
  }

  /**
   * 
   * @uml.property name="percentField"
   */
  public void setPercentField(JTextField thePercentField) {
    percentField = thePercentField;
  }

  /**
   * 
   * @uml.property name="percentField"
   */
  public JTextField getPercentField() {
    return percentField;
  }

  /**
   * 
   * @uml.property name="amountPanel"
   */
  public void setAmountPanel(JPanel theAmountPanel) {
    amountPanel = theAmountPanel;
  }

  /**
   * 
   * @uml.property name="amountPanel"
   */
  public JPanel getAmountPanel() {
    return amountPanel;
  }

  /**
   * 
   * @uml.property name="currencyField"
   */
  public void setCurrencyField(JTextField theCurrencyField) {
    currencyField = theCurrencyField;
  }

  /**
   * 
   * @uml.property name="currencyField"
   */
  public JTextField getCurrencyField() {
    return currencyField;
  }

  /**
   * 
   * @uml.property name="amountField"
   */
  public void setAmountField(JTextField theAmountField) {
    amountField = theAmountField;
  }

  /**
   * 
   * @uml.property name="amountField"
   */
  public JTextField getAmountField() {
    return amountField;
  }

  public List getComboItems() {
    return comboItems;
  }

  public void setComboItems(List comboItems) {
    this.comboItems = comboItems;
  }
  
  public PrubaeComboItem	getComboItem(String itemStr) {
    for (int i = 0; i < getComboItems().size(); i++) {
      PrubaeComboItem	ret = (PrubaeComboItem)getComboItems().get(i);
      if (itemStr.equals(ret.getItemString())) {
	return ret;
      }
    }
    return (PrubaeComboItem)getComboItems().get(0);
  }

} /* end class PrubaeControllerDoStatement */
