// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * class <code>PrubaeControllerJudge</code>
 * is the common controller utility of the prubae rule judgement element model.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeControllerJudge extends PrubaeController {

  // Constructor  
  /**
   * Creates a new <code>PrubaeControllerJudge</code> instance.
   * this creates all GUI elements on the panel
   * to controll/display the details of the judgement rule element models.
   */
  public PrubaeControllerJudge() {  
    super();  
  }

  // Operations  
  /**
   * <code>createButtons</code> method
   * creates or button and judge button,
   * which to create and/or-statement and to create other judge statements.
   */
  protected void createButtons() {  
    JButton	orButton = new JButton("And/Or");
    orButton.setActionCommand("AndOr");
    orButton.addActionListener(this);
    JButton	judgeButton = new JButton("Judge");
    judgeButton.setActionCommand("JudgeStatement");
    judgeButton.addActionListener(this);
    JPanel	opPanel = new JPanel();
    opPanel.setLayout(new BoxLayout(opPanel, BoxLayout.Y_AXIS));
    opPanel.add(orButton);
    opPanel.add(judgeButton);
    getPanel().add(opPanel);
  }

  /**
   * <code>createPanel</code> method
   *
   */
  public void createPanel() {
    super.createPanel();
    createButtons();
  }

  /**
   * <code>actionPerformed</code> method
   * handles the action events returned from GUI items on the panel
   *
   * Send the model delete when the action command is "delete",
   *
   * When the action command is "insert",
   * creates new and/or element model and swap this model with the new one.
   * then swap the tree node related to this model
   * with the tree node related with the new model
   * by sending swapTreeNode method to the controller related to the new model.
   * And creates new judge statement and sets this model and the new judge,
   * to the judges list of the new and/or element model.
   * And then set the tree nodes to the treeNode related to the new model
   * as the child by sending setTreeNodes() to the controller of the new model.
   * And then refresh the screen and open part panel
   * by sending display method to the view related to the new model;
   * and by sending open method to the controller related to the new model.
   *
   * Otherwise, creates the appropriate action model class,
   * and swap this model with the new model, by sending swap to the new model.
   * then swap the tree node related to this model
   * with the tree node related with the new model
   * by sending swapTreeNode method to the controller related to the new model.
   * then delete this model and all GUI elements related to this model
   * by sending delete method to this model.
   * if the new model is and/or element,
   * then creates two new judge statement
   * and sets them to the judges list of the new and/or element model,
   * then set the tree nodes to the treeNode related to the new model
   * as the child,
   * and refresh the screen and open part panel
   * by sending display method to the view related to the new model,
   * and by sending open method to the controller related to the new model.
   *
   * @param e an <code>ActionEvent</code> value
   */
  public void actionPerformed(ActionEvent e) {  
    if (e.getActionCommand().equals("delete")) {
      PrubaeController	cntl = getEditor().getController();
      System.err.println("PrubaeControllerJudge.actionPerformed(delete) : this cntl = " + this + ", editor cntl = " + cntl);
      if (this == cntl) {
	deleteAndUp();
      }
      else {
	delete();
      }
    }
    else if (e.getActionCommand().equals("insert")) {
      PrubaeModelAndOr	newModel = new PrubaeModelAndOr();
      newModel.swap(getModel());
      DefaultMutableTreeNode
	node = (DefaultMutableTreeNode)getTreeNode().getParent();
      newModel.getController().swapTreeNode(node, getTreeNode());
      newModel.setJudges(getModel(), new PrubaeModelJudge());
      ((PrubaeControllerAndOr)newModel.getController()).setTreeNodes();
      newModel.getView().display();
      newModel.getController().open();
    }
    else if (e.getActionCommand().equals("override")) {
      PrubaeModel	parent = getModel().getParent();
      if (parent instanceof PrubaeModelAndOr) {
	getModel().swap(parent);
	PrubaeModel	grandParent = parent.getParent();
	PrubaeController	parentCntl = parent.getController();
	PrubaeController	grandParentCntl = grandParent.getController();
	DefaultMutableTreeNode	grandParentNode =
	  (DefaultMutableTreeNode)grandParentCntl.getTreeNode();
	swapTreeNode(grandParentNode, parentCntl.getTreeNode());
	getView().display();
	open();
      }
    }
    else {
      String	className = getClass().getName();
      int	rindex = className.lastIndexOf('.')+1;
      String	oldClassName = className;
      oldClassName = oldClassName.substring(rindex+16);
      if (e.getActionCommand().equals(oldClassName)) {
	System.err.println(oldClassName + " need not swap");
	return;
      }
      System.err.println(oldClassName + "(" + getClass().getName() + ") swap "
			 + e.getActionCommand());
      className =
	className.substring(0, rindex) + "PrubaeModel" + e.getActionCommand();
      PrubaeModelJudge	newModel = null;
      try {
	Class	c = Class.forName(className);
	newModel = (PrubaeModelJudge)c.newInstance();
      }
      catch (Exception exc) {
	System.err.println(exc.toString());
      };
      newModel.swap(getModel());
      DefaultMutableTreeNode
	node = (DefaultMutableTreeNode)getTreeNode().getParent();
      newModel.getController().swapTreeNode(node, getTreeNode());
      getModel().delete();
      if (e.getActionCommand().equals("AndOr")) {
	((PrubaeModelAndOr)newModel).setJudges(new PrubaeModelJudge(),
					       new PrubaeModelJudge());
	((PrubaeControllerAndOr)newModel.getController()).setTreeNodes();
      }
      newModel.getController().open();
      newModel.getView().display();
    }
  }

  /**
   * <code>createPopupMenu</code> method create popup menu for this node.
   *
   */
  void createPopupMenu() {
    JMenuItem	mi = null;
    setPopupMenu(new JPopupMenu());
    mi = new JMenuItem("insert And/Or upon this");
    mi.setActionCommand("insert");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("override And/Or upon this");
    mi.setActionCommand("override");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("And/Or");
    mi.setActionCommand("AndOr");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("Judge");
    mi.setActionCommand("JudgeStatement");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
  }

} /* end class PrubaeControllerJudge */
