// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;


/**
 * class <code>PrubaeControllerJudgeStatement</code>
 * is the controller of the prubae rule judge statement element model.
 * this class controls the details input/display panel on the part panel.
 * this class also controls the tree node related to this statement model,
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeControllerJudgeStatement extends PrubaeControllerJudge {

  // Attributes  
  /**
   * attribute variable <code>statementField</code> is the JTextField to display the judge statement string. not editable.
   * @uml.property  name="statementField"
   */
  private JTextField statementField;
  /**
   * attribute variable <code>functionBox</code> is the JComboBox to select the function type of the judge statement.
   * @uml.property  name="functionBox"
   */
  private JComboBox functionBox;

  /**
   * variable <code>comboItems</code> is the List of PrubaeComboItems.
   *
   */
  private List<PrubaeComboItem>	comboItems;

  // Constructor  
  /**
   * Creates a new <code>PrubaeControllerJudgeStatement</code> instance.
   *
   */
  public PrubaeControllerJudgeStatement() {  
    super();  
  }  

  // Operations  
  /**
   * <code>createButtons</code> method
   * creates statementField and functionBox
   */
  protected void createButtons() {  
    super.createButtons();

    setStatementField(new JTextField("", 16));
    getStatementField().setEditable(false);
    JPanel	judgePanel = new JPanel();
    judgePanel.setLayout(new BoxLayout(judgePanel, BoxLayout.X_AXIS));
    JLabel	judgeLabel = new JLabel("Judge : ");
    judgePanel.add(judgeLabel);
    judgePanel.add(getStatementField());
    getPanel().add(judgePanel);

    setFunctionBox(new JComboBox());
    getFunctionBox().setMaximumRowCount(4);
    getFunctionBox().setActionCommand("select function");
    getPanel().add(getFunctionBox());
  }  

  /**
   * <code>update</code> method
   * updates the statements of the model with updateStatement(),
   * and updates comment string using super.update().
   */
  public void update() {
    ((PrubaeModelJudgeStatement)getModel()).updateStatement();
    super.update();
  }

  /**
   * <code>createPanel</code> method
   * first creates panel and buttons using super.createPanel().
   * set functionBox items from the list judgeList of the editor.
   *
   */
  public void createPanel() {
    super.createPanel();

    PrubaeModelJudgeStatement	model = (PrubaeModelJudgeStatement)getModel();
    LList	list = getEditor().getJudgeList();
    if (model.getValues() != null) {
      int	numArgs = model.getValues().size();
      LList	judgeList = Lisp.assoc(new IntNum(model.getRegist()), list);
      if (judgeList != null) {
	Object	listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
	Object[]	typeArgs = new Object[numArgs];
	for (int i = 0; i < numArgs; i++) {
	  typeArgs[i] = Lisp.car(listArgs);
	  listArgs = Lisp.cdr(listArgs);
	  //System.err.println("PrubaeControllerJudgeStatement.createPanel(): typeArgs[" + i + "] = " + typeArgs[i]);
	}
	for (int i = 0; i < model.getValues().size(); i++) {
	  if (model.getValues().get(i) instanceof PrubaeModelValue) {
	    PrubaeModelValue
	      child = (PrubaeModelValue)model.getValues().get(i);
	    if (child instanceof PrubaeModelValueStatement) {
	      if (i > 0 && typeArgs[i] != null
		  && typeArgs[i].equals("first")) {
		child
		  .setRequiredType(((PrubaeModelValue)model.getValues().get(0))
				   .getType());
	      }
	      /* ;;; 2009.07.10 add start */
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.MULTIVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getRequiredType() != null)) {
		//System.err.println("PrubaeControllerJudgeStatement.createPanel(): model = " + model + ", requiredType = " + ((PrubaeModelValue)model.getValues().get(i)).getRequiredType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getRequiredType());
	      }
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.MULTIVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getType() != null)) {
		//System.err.println("PrubaeControllerJudgeStatement.createPanel(): model = " + model + ", type = " + ((PrubaeModelValue)model.getValues().get(i)).getType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getType());
	      }
	      /* ;;; 2009.07.10 add end */
	      /* ;;; 2009.07.15 add start */
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.INTERVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getRequiredType() != null)) {
		//System.err.println("PrubaeControllerJudgeStatement.createPanel(): model = " + model + ", requiredType = " + ((PrubaeModelValue)model.getValues().get(i)).getRequiredType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getRequiredType());
	      }
	      else if (((PrubaeModel)model.getValues().get(i)).getRegist()
		       == ProrateRulebaseElement.INTERVAL_CODE
		       && (((PrubaeModelValue)model.getValues().get(i))
			   .getType() != null)) {
		//System.err.println("PrubaeControllerJudgeStatement.createPanel(): model = " + model + ", type = " + ((PrubaeModelValue)model.getValues().get(i)).getType());
		child.setRequiredType(((PrubaeModelValue)model.getValues()
				       .get(i)).getType());
	      }
	      /* ;;; 2009.07.15 add end */
	      else if (typeArgs[i] != null) {
		child.setRequiredType(typeArgs[i]);
	      }
	      if (child.getController() == null) {
		child.openUI();
	      }
	      child.getController().createPanel();
	    }
	  }
	}
      }
    }

    setComboItems(new Vector());
    PrubaeComboItem item = new PrubaeComboItem("", "");
    getComboItems().add(item);
    getFunctionBox().addItem(item);
    for ( ; !Lisp.isNil(list); list = (LList)Lisp.cdr(list)) {
      LList	judgeList = (LList)Lisp.car(list);
      String	dispStr = (Lisp.car(Lisp.cdr(judgeList))).toString();
      String	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(judgeList)))).toString();
      item = new PrubaeComboItem(dispStr, itemStr);
      getComboItems().add(item);
      getFunctionBox().addItem(item);
    }
    getFunctionBox().addActionListener(this);
  }

  /**
   * <code>destroyPanel</code> method
   *
   */
  public void destroyPanel() {
    setStatementField(null);
    setFunctionBox(null);
    super.destroyPanel();
  }

  /**
   * <code>select</code> method
   * handles the selection in the function box.
   * first, get regist code of selected item using judgeList of the editor.
   * if the regist code is changed by selection,
   * delete view and controller and close GUI items
   * by sending closeUI() method to the models in the values list.
   * and clear the values list.
   * set the regist code to the model.
   * handle GUI panels of values using arguments().
   * update statement of the model by sending updateStatement() to the model.
   * @param selected a <code>String</code> value
   */
  protected void select(String selected) {
    PrubaeModelJudgeStatement	model = (PrubaeModelJudgeStatement)getModel();
    LList	list = getEditor().getJudgeList();
    for ( ; !Lisp.isNil(list); list = (LList)Lisp.cdr(list)) {
      LList	judgeList = (LList)Lisp.car(list);
      String	itemStr = (Lisp.car(Lisp.cdr(Lisp.cdr(judgeList)))).toString();
      if (selected.equals(itemStr)) {
	short	regist = (short)((IntNum)Lisp.car(judgeList)).intValue();
	if (model.getRegist() == regist && model.getName().equals(selected)) {
	}
	else {
	  if (model.getValues() != null) {
	    for (int i = 0; i < model.getValues().size(); i++) {
	      if (model.getValues().get(i) instanceof PrubaeModel) {
		((PrubaeModel)model.getValues().get(i)).closeUI();
	      }
	    }
	    model.getValues().clear();
	  }
	  model.setRegist(regist);
	  model.setName(selected);
	  /* arguments */
	  arguments(judgeList);
	  model.updateStatement();
	  getStatementField().setText(model.getStatement());
	}
	break;
      }
    }
  }

  /**
   * <code>arguments</code> method
   * handles the display/input arguments required by the judge functions.
   * if the judge is fixed-amount-setting(the type is "setamount"),
   * add currency "" and amount value 0 to the values list of the model,
   * and set amount panel visible.
   * otherwise, for all values required by the judge function,
   * creates value statement model and send initialize, openUI to it,
   * and add it to the values list of the model,
   * and add its panel on the panel.
   * @param judgeList a <code>LList</code> value
   * is the associated list element matched to current regist code
   * in the judgeList of the editor.
   */
  private void arguments(LList judgeList) {
    PrubaeModelJudgeStatement	model = (PrubaeModelJudgeStatement)getModel();
    Object	isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
    System.err.println("judge controller Arguments : judgeList = " + judgeList);
    if (isArgs == null) {
      return;
    }
    else if (!(isArgs instanceof IntNum)) {
      return;
    }
    System.err.println("numArgs = " + isArgs);
    int	numArgs = ((IntNum)isArgs).intValue();
    if (numArgs <= 0) {
      return;
    }
    System.err.println("judge controller Arguments = " + numArgs);
    Object	listArgs = Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(judgeList))));
    Object[]	typeArgs = new Object[numArgs];
    for (int i = 0; i < numArgs; i++) {
      typeArgs[i] = Lisp.car(listArgs);
      listArgs = Lisp.cdr(listArgs);
    }
    if (model.getValues() == null) {
      model.setValues(new Vector());
    }
    if (numArgs == 1
	&& typeArgs[0] != null && typeArgs[0].equals("setamount")) {
      /* set amount statement */
      model.getValues().add("");
      model.getValues().add(new Double((double)0));
      return;
    }
    for (int i = 0; i < numArgs && typeArgs[i] != null; i++) {
      /* not implemented yet */
      String	type;
      if (typeArgs[i] instanceof Pair) {
	type = (String)Lisp.car(typeArgs[i]);
      }
      else {
	type = (String)typeArgs[i];
      }
      //System.err.println("Arguments(" + i + ") = " + type);
      if (type.equals("setnumber")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.NUMBER_CODE);
	ret.setComment("");
	ret.setStatement("" + 0);
	ret.setValues(new Vector());
	ret.getValues().add(new Double((double)0));
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setdate")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.DATE_CODE);
	ret.setComment("");
	ret.setStatement("" + 0 + "/" + 0);
	ret.setValues(new Vector());
	ret.getValues().add(new Short((short)0));
	ret.getValues().add(new Short((short)0));
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setstring")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.STRING_CODE);
	ret.setComment("");
	ret.setStatement("\"\"");
	ret.setValues(new Vector());
	ret.getValues().add("");
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setamount")) {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setRegist((short)ProrateRulebaseElement.AMOUNT_CODE);
	ret.setComment("");
	ret.setValues(new Vector());
	ret.getValues().add("");
	ret.getValues().add(new Double((double)0));
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
      }
      else if (type.equals("setpath")) {
	/* not implemented yet */
      }
      else {
	PrubaeModelValue	ret = new PrubaeModelValueStatement();
	ret.setComment("");
	ret.setStatement("");
	ret.setType(typeArgs[i]);
	ret.initialize(getEditor(), model, model.getValues());
	ret.openUI();
	model.getValues().add(ret);
	getPanel().add(ret.getController().getPanel());
	/* not implemented yet */
      }
    }
    return;
  }

  /**
   * <code>activateSelection</code> method
   *	activates JComboBox selection action.
   *
   */
  public void	activateSelection() {
    getFunctionBox().setActionCommand("select function");
  }
  
  /**
   * <code>inactivateSelection</code> method
   *	inactivates JComboBox selection action.
   *
   */
  public void	inactivateSelection() {
    getFunctionBox().setActionCommand("nop");
  }

  /**
   * <code>actionPerformed</code> method
   * handles the action events returned from GUI items on the panel
   * call select() when the action command is "select function",
   * handle other actions using super.actionPerformed().
   * @param e an <code>ActionEvent</code> value
   */
  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("select function")) {
      PrubaeComboItem
	selected =
	(PrubaeComboItem)((JComboBox)e.getSource()).getSelectedItem();
      select(selected.getItemString());
    }
    else if (e.getActionCommand().equals("nop")) {
    }
    else {
      super.actionPerformed(e);
    }
  }

  /**
   * <code>createPopupMenu</code> method create popup menu for this node.
   *
   */
  void createPopupMenu() {
    JMenuItem	mi = null;
    setPopupMenu(new JPopupMenu());
    mi = new JMenuItem("insert And/Or upon this");
    mi.setActionCommand("insert");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("override And/Or upon this");
    mi.setActionCommand("override");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
  }

  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeControllerJudgeStatement	clone = null;
    clone = (PrubaeControllerJudgeStatement)super.clone();
    if (getStatementField() != null) {
      clone.setStatementField(new JTextField());
    }
    if (getFunctionBox() != null) {
      clone.setFunctionBox(new JComboBox());
      clone.getFunctionBox()
	.setSelectedItem(getFunctionBox().getSelectedItem());
    }
    return clone;
  }

  // Setters and Getters  
  /**
   * <code>setStatementField</code> method
   * sets theStatementField to statementField attribute 
   * @param theStatementField a <code>JTextField</code> value
   * 
   * @uml.property name="statementField"
   */
  public void setStatementField(JTextField theStatementField) {
    statementField = theStatementField;
  }

  /**
   * <code>getStatementField</code> method
   * returns statementField attribute value
   * @return a <code>JTextField</code> value
   * 
   * @uml.property name="statementField"
   */
  public JTextField getStatementField() {
    return statementField;
  }

  /**
   * <code>setFunctionBox</code> method here.
   * sets theFunctionBox to functionBox attribute
   * @param theFunctionBox a <code>JComboBox</code> value
   * 
   * @uml.property name="functionBox"
   */
  public void setFunctionBox(JComboBox theFunctionBox) {
    functionBox = theFunctionBox;
  }

  /**
   * <code>getFunctionBox</code> method
   * returns functionBox attribute
   * @return a <code>JComboBox</code> value
   * 
   * @uml.property name="functionBox"
   */
  public JComboBox getFunctionBox() {
    return functionBox;
  }

  public List getComboItems() {
    return comboItems;
  }

  public void setComboItems(List comboItems) {
    this.comboItems = comboItems;
  }
  
  public PrubaeComboItem	getComboItem(String itemStr) {
    for (int i = 0; i < getComboItems().size(); i++) {
      PrubaeComboItem	ret = (PrubaeComboItem)getComboItems().get(i);
      if (itemStr.equals(ret.getItemString())) {
	return ret;
      }
    }
    return (PrubaeComboItem)getComboItems().get(0);
  }

} /* end class PrubaeControllerJudgeStatement */
