// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;


import gnu.lists.LList;
import gnu.math.IntNum;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;


/**
 * class <code>PrubaeControllerTable</code>
 * is the controller of the prubae rule table-statement element model.
 * this class controls the details input/display panel on the part panel.
 * not implemented yet. *FIXME*
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeControllerTable
  extends PrubaeControllerDo implements TableModel {

  // Attributes
  /**
   * variable <code>rowButton</code> is the radio button to select the table is a row_col(2 dimensions) table.
   * @uml.property  name="rowButton"
   */
  private JRadioButton rowButton;
  /**
   * variable <code>colButton</code> is the radio button to select the table is a col(1 dimension) table.
   * @uml.property  name="colButton"
   */
  private JRadioButton colButton;
  /**
   * variable <code>rowPanel</code> is the panel which contains panels which sets the row var and row values.
   * @uml.property  name="rowPanel"
   */
  private JPanel rowPanel;
  /**
   * variable <code>colPanel</code> is the panel which contains panels which sets the col var and col values.
   * @uml.property  name="colPanel"
   */
  private JPanel colPanel;
  /**
   * variable <code>varRowPanel</code> is the panel which sets the row var.
   * @uml.property  name="varRowPanel"
   */
  private JPanel varRowPanel;
  /**
   * variable <code>varColPanel</code> is the panel which sets the col var.
   * @uml.property  name="varColPanel"
   */
  private JPanel varColPanel;
  /**
   * variable <code>rowsCountPanel</code> is the panel which contains the rows count field to change visibility.
   * @uml.property  name="rowsCountPanel"
   */
  private JPanel rowsCountPanel;
  /**
   * variable <code>rowsCountLabel</code> is the label before rows count field.
   * @uml.property  name="rowsCountLabel"
   */
  private JLabel rowsCountLabel;
  /**
   * variable <code>rowsCountField</code> is the field to display/input the rows count value
   * @uml.property  name="rowsCountField"
   */
  private JTextField rowsCountField;
  /**
   * variable <code>rowsCountButton</code> is the button to refresh rows count and the rows panels.
   * @uml.property  name="rowsCountButton"
   */
  private JButton rowsCountButton;
  /**
   * variable <code>rowsCount</code> is the number of rows.
   * @uml.property  name="rowsCount"
   */
  private int rowsCount = 0;
  /**
   * variable <code>colsCountPanel</code> is the label before cols count field. is the panel which contains the cols count field to change visibility.
   * @uml.property  name="colsCountPanel"
   */
  private JPanel colsCountPanel;
  /**
   * variable <code>colsCountLabel</code> is the label before cols count field.
   * @uml.property  name="colsCountLabel"
   */
  private JLabel colsCountLabel;
  /**
   * variable <code>colsCountField</code> is the field to display/input the cols count value
   * @uml.property  name="colsCountField"
   */
  private JTextField colsCountField;
  /**
   * variable <code>colsCountButton</code> is the button to refresh cols count and the cols panels.
   * @uml.property  name="colsCountButton"
   */
  private JButton colsCountButton;
  /**
   * variable <code>colsCount</code> is the number of cols.
   * @uml.property  name="colsCount"
   */
  private int colsCount = 0; 

  /**
   * variable <code>table</code> is the table of the amount table.
   * @uml.property  name="table"
   */
  private JTable table;

  /**
   * variable <code>tablePanel</code> is the panel which holds the table.
   * @uml.property  name="tablePanel"
   */
  private JScrollPane tablePanel;

  // Constructor
  /**
   * Creates a new <code>PrubaeControllerTable</code> instance.
   * not implemented yet. *FIXME*
   */
  public PrubaeControllerTable() {  
    super();
  }

  // Operations  
  /**
   * <code>createButtons</code> method
   * creates a button to select col(1 dimension)/row_col(2 dimensions) tables,
   * creates rows and/or cols count field to input the number of rows/cols.
   * not implemented yet. *FIXME*
   */
  protected void createButtons() {
    setRowButton(new JRadioButton("row col(2-dim)"));
    setColButton(new JRadioButton("col(1-dim)"));
    ButtonGroup	group = new ButtonGroup();
    group.add(getRowButton());
    group.add(getColButton());
    getRowButton().setActionCommand("row");
    getRowButton().addActionListener(this);
    getColButton().setActionCommand("col");
    getColButton().addActionListener(this);
    getRowButton().setSelected(true);
    getColButton().setSelected(false);
    JPanel	rowColPanel = new JPanel();
    rowColPanel.setLayout(new BoxLayout(rowColPanel, BoxLayout.X_AXIS));
    rowColPanel.add(new JLabel("TABLE"));
    rowColPanel.add(getRowButton());
    rowColPanel.add(getColButton());
    getPanel().add(rowColPanel);

    setRowPanel(new JPanel());
    getRowPanel().setLayout(new BoxLayout(getRowPanel(), BoxLayout.Y_AXIS));
    getRowPanel().setBorder(BorderFactory.createLineBorder(Color.black, 5));
    setVarRowPanel(new JPanel());
    getVarRowPanel().setBorder(BorderFactory.createLineBorder(Color.black, 1));
    getRowPanel().add(getVarRowPanel());
    setRowsCountPanel(new JPanel());
    setRowsCountLabel(new JLabel("COUNT"));
    setRowsCountField(new JTextField("", 4));
    setRowsCountButton(new JButton("INPUT"));
    getRowsCountButton().setActionCommand("set rows");
    getRowsCountButton().addActionListener(this);
    getRowsCountPanel().setLayout(new BoxLayout(getRowsCountPanel(),
						BoxLayout.X_AXIS));
    getRowsCountPanel().add(getRowsCountLabel());
    getRowsCountPanel().add(getRowsCountField());
    getRowsCountPanel().add(getRowsCountButton());
    getRowPanel().add(getRowsCountPanel());

    setColPanel(new JPanel());
    getColPanel().setLayout(new BoxLayout(getColPanel(), BoxLayout.Y_AXIS));
    getColPanel().setBorder(BorderFactory.createLineBorder(Color.black, 5));
    setVarColPanel(new JPanel());
    getVarColPanel().setBorder(BorderFactory.createLineBorder(Color.black, 1));
    getColPanel().add(getVarColPanel());
    setColsCountPanel(new JPanel());
    setColsCountLabel(new JLabel("COUNT"));
    setColsCountField(new JTextField("", 4));
    setColsCountButton(new JButton("INPUT"));
    getColsCountButton().setActionCommand("set cols");
    getColsCountButton().addActionListener(this);
    getColsCountPanel().setLayout(new BoxLayout(getColsCountPanel(),
						BoxLayout.X_AXIS));
    getColsCountPanel().add(getColsCountLabel());
    getColsCountPanel().add(getColsCountField());
    getColsCountPanel().add(getColsCountButton());
    getColPanel().add(getColsCountPanel());

    setTable(new JTable());
    setTablePanel(new JScrollPane());
    getTablePanel().setPreferredSize(new Dimension(200, 200));
    getTablePanel().getViewport().add(getTable());
    getPanel().add(getTablePanel());
  }

  public void initialize() {
    super.initialize();
    setRowsCount(0);
    setColsCount(0);
  }

  /**
   * <code>update</code> method
   * send updateVarRow() and updateVarCol() to the model
   * to update varrow and varcol,
   * send updateRows() to the model to update all values in rows,
   * send updateCols() to the model to update all values in cols,
   * and updates comment by using super.update().
   */
  public void update() {
    ((PrubaeModelTable)getModel()).updateVarRow();
    ((PrubaeModelTable)getModel()).updateVarCol();
    ((PrubaeModelTable)getModel()).updateRows();
    ((PrubaeModelTable)getModel()).updateCols();
    super.update();
  }

  /**
   * <code>updateRowsCount</code> method
   * get and save old rows count and set the new rows count from the input.
   * if new rows count > old one, increase rows using addRows() of the model,
   * new rows count < old one, decrease rows using removeRows() of the model.
   */
  private void updateRowsCount() {
    ((PrubaeModelTable)getModel()).updateRows();
    int	numArgs = 0;
    try {
      numArgs = Integer.parseInt(getRowsCountField().getText());
    }
    catch (NumberFormatException e) {
      return;
    }
    int	oldArgsCount = getRowsCount();
    setRowsCount(numArgs);
    if (numArgs > oldArgsCount) {
      addRows(oldArgsCount, numArgs);
    }
    else if (numArgs < oldArgsCount) {
      removeRows(numArgs, oldArgsCount);
    }
  }

  /**
   * <code>updateColsCount</code> method
   * get and save old cols count and set the new cols count from the input.
   * if new cols count > old one, increase cols using addCols() of the model,
   * new cols count < old one, decrease cols using removeCols() of the model.
   */
  private void updateColsCount() {
    ((PrubaeModelTable)getModel()).updateCols();
    int	numArgs = 0;
    try {
      numArgs = Integer.parseInt(getColsCountField().getText());
    }
    catch (NumberFormatException e) {
      return;
    }
    int	oldArgsCount = getColsCount();
    setColsCount(numArgs);
    if (numArgs > oldArgsCount) {
      addCols(oldArgsCount, numArgs);
    }
    else if (numArgs < oldArgsCount) {
      removeCols(numArgs, oldArgsCount);
    }
  }

  /**
   * <code>destroyPanel</code> method
   *
   */
  public void destroyPanel() {
    setRowButton(null);
    setColButton(null);
    setRowPanel(null);
    setVarRowPanel(null);
    setRowsCountPanel(null);
    setRowsCountLabel(null);
    setRowsCountField(null);
    setRowsCountButton(null);
    setColPanel(null);
    setVarColPanel(null);
    setColsCountPanel(null);
    setColsCountLabel(null);
    setColsCountField(null);
    setColsCountButton(null);
    setTable(null);
    setTablePanel(null);
    super.destroyPanel();
  }

  /**
   * <code>addRows</code> method
   * creates new row value models for increased row values,
   * creates view and controller and opens the GUI by sending openUI to them,
   * and add them to the row values list of this model.
   * @param minArgs an <code>int</code> value
   * is the number of arguments before increment.
   * @param numArgs an <code>int</code> value
   * is the number of arguments to increase to.
   */
  public void addRows(int minArgs, int numArgs) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    if (model.getRows() == null) {
      model.setRows(new Vector());
    }
    List	newTbls = new Vector();
    int	rowsCnt = (model.getRows() == null ? 1 :
		   (model.getRows().size() == 0 ? 1 : model.getRows().size()));
    for (int i = 0; i < rowsCnt; i++) {
      for (int j = 0; j < model.getCols().size(); j++) {
	PrubaeModel	amt =
	  (PrubaeModel)model.getTbls().get(i * model.getCols().size() + j);
	amt.setParentList(newTbls);
	newTbls.add(amt);
      }
    }
    /* ;;; add 2009.07.14 start */
    LList
      list = Lisp.append(Lisp.append(Lisp.append(getEditor().getValueList(),
						 getEditor().getVarList()),
				     getEditor().getConstList()),
			 getEditor().getSettablevarList());
    PrubaeModel	var = (PrubaeModel)model.getVarRow();
    LList	valueList = Lisp.assoc(new IntNum(var.getRegist()), list);
    Object	type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
    /* ;;; add 2009.07.14 end */
    for (int i = minArgs; i < numArgs; i++) {
      PrubaeModelValue	child = new PrubaeModelValueStatement();
      child.setComment("");
      child.setStatement("");
      child.initialize(getEditor(), model, model.getRows());
      child.setRequiredType(type);	/* ;;; add 2009.07.14 */
      child.openUI();
      model.getRows().add(child);
    }
    for (int i = rowsCnt; i < numArgs; i++) {
      for (int j = 0; j < model.getCols().size(); j++) {
	PrubaeModelDoStatement	amt = new PrubaeModelDoStatement();
	amt.setComment("");
	amt.setStatement("");
	amt.setRegist((short)ProrateRulebaseElement.AMOUNT_CODE);
	amt.setValues(new Vector());
	amt.getValues().add("   ");
	amt.getValues().add(new Double((double)0));
	amt.initialize(getEditor(), model, newTbls);
	amt.openUI();
	newTbls.add(amt);
      }
    }
    model.setTbls(newTbls);
  }

  /**
   * <code>removeRows</code> method
   * for all decreased row values,
   * delete all view and controller and delete GUI items of them,
   * and remove the row value from the row values list of this model.
   * @param minArgs an <code>int</code> value
   * is the number of arguments to decrease to.
   * @param numArgs an <code>int</code> value
   * is the number of arguments before decrement.
   */
  public void removeRows(int minArgs, int numArgs) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    for (int i = numArgs-1; i >= minArgs; i--) {
      PrubaeModelValue	child = (PrubaeModelValue)model.getRows().get(i);
      getRowPanel().remove(child.getController().getPanel());
      child.closeUI();
      model.getRows().remove(child);
    }
    List	newTbls = new Vector();
    int	rowsCnt = (model.getRows() == null ? 1 :
		   (model.getRows().size() == 0 ? 1 : model.getRows().size()));
    for (int i = 0; i < rowsCnt; i++) {
      for (int j = 0; j < model.getCols().size(); j++) {
	PrubaeModel	amt =
	  (PrubaeModel)model.getTbls().get(i * model.getCols().size() + j);
	amt.setParentList(newTbls);
	newTbls.add(amt);
      }
    }
    model.setTbls(newTbls);
  }

  /**
   * Describe <code>addCols</code> method here.
   * creates new row value models for increased row values,
   * creates view and controller and opens the GUI by sending openUI to them,
   * and add them to the row values list of this model.
   * @param minArgs an <code>int</code> value
   * is the number of arguments before increment.
   * @param numArgs an <code>int</code> value
   * is the number of arguments to increase to.
   */
  public void addCols(int minArgs, int numArgs) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    if (model.getCols() == null) {
      model.setCols(new Vector());
    }
    /* ;;; add 2009.07.15 start */
    LList
      list = Lisp.append(Lisp.append(Lisp.append(getEditor().getValueList(),
						 getEditor().getVarList()),
				     getEditor().getConstList()),
			 getEditor().getSettablevarList());
    PrubaeModel	var = (PrubaeModel)model.getVarCol();
    LList	valueList = Lisp.assoc(new IntNum(var.getRegist()), list);
    Object	type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
    /* ;;; add 2009.07.15 end */
    for (int i = minArgs; i < numArgs; i++) {
      PrubaeModelValue	child = new PrubaeModelValueStatement();
      child.setComment("");
      child.setStatement("");
      child.initialize(getEditor(), model, model.getCols());
      child.setRequiredType(type);	/* ;;; add 2009.07.15 */
      child.openUI();
      model.getCols().add(child);
    }
    List	newTbls = new Vector();
    int	rowsCnt = (model.getRows() == null ? 1 :
		   (model.getRows().size() == 0 ? 1 : model.getRows().size()));
    for (int i = 0; i < rowsCnt; i++) {
      for (int j = 0; j < minArgs; j++) {
	PrubaeModel amt = (PrubaeModel)model.getTbls().get(i * minArgs + j);
	amt.setParentList(newTbls);
	newTbls.add(amt);
      }
      for (int j = minArgs; j < numArgs; j++) {
	PrubaeModelDoStatement	amt = new PrubaeModelDoStatement();
	amt.setComment("");
	amt.setStatement("");
	amt.setRegist((short)ProrateRulebaseElement.AMOUNT_CODE);
	amt.setValues(new Vector());
	amt.getValues().add("   ");
	amt.getValues().add(new Double((double)0));
	amt.initialize(getEditor(), model, newTbls);
	amt.openUI();
	newTbls.add(amt);
      }
    }
    model.setTbls(newTbls);
  }

  /**
   * <code>removeCols</code> method
   * for all decreased row values,
   * delete all view and controller and delete GUI items of them,
   * and remove the row value from the row values list of this model.
   * @param minArgs an <code>int</code> value
   * is the number of arguments to decrease to.
   * @param numArgs an <code>int</code> value
   * is the number of arguments before decrement.
   */
  public void removeCols(int minArgs, int numArgs) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    for (int i = numArgs-1; i >= minArgs; i--) {
      PrubaeModelValue	child = (PrubaeModelValue)model.getCols().get(i);
      getColPanel().remove(child.getController().getPanel());
      child.closeUI();
      model.getCols().remove(child);
    }
    List	newTbls = new Vector();
    int	rowsCnt = (model.getRows() == null ? 1 :
		   (model.getRows().size() == 0 ? 1 : model.getRows().size()));
    for (int i = 0; i < rowsCnt; i++) {
      for (int j = 0; j < minArgs; j++) {
	PrubaeModel amt = (PrubaeModel)model.getTbls().get(i * numArgs + j);
	amt.setParentList(newTbls);
	newTbls.add(amt);
      }
    }
    model.setTbls(newTbls);
  }
  
  /* ;;; add 2009.07.16 start */
  /**
   * <code>resetRows</code> method
   *	clear all row values when row variable is changed
   *
   */
  public void resetRows() {
    int	rows = ((PrubaeModelTable)getModel()).getRows().size();
    removeRows(0, rows);
  }

  /**
   * <code>resetCols</code> method
   *	clear all col values when col variable is changed
   *
   */
  public void resetCols() {
    int	cols = ((PrubaeModelTable)getModel()).getCols().size();
    removeCols(0, cols);
  }
  /* ;;; add 2009.07.16 end */

  /**
   * <code>actionPerformed</code> method.
   * handles the action events returned from GUI items on the panel
   * send the model delete when the action command is "delete",
   * call insert() method when the action command is "insert",
   * not implemented yet. *FIXME*
   * @param e an <code>ActionEvent</code> value
   */
  public void actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals("delete")) {
      PrubaeController	cntl = getEditor().getController();
      if (this == cntl) {
	deleteAndUp();
      }
      else {
	delete();
      }
    }
    else if (e.getActionCommand().equals("insert")) {
      insert();
    }
    else {
      System.err.println("action = " + e.getActionCommand());
      if (e.getActionCommand().equals("row")) {
	PrubaeModelTable	model = (PrubaeModelTable)getModel();
	if (model.getVarRow() == null) {
	  model.setVarRow(new PrubaeModelValueStatement());
	  model.getVarRow().setComment("");
	  model.getVarRow().setStatement("");
	  model.getVarRow().initialize(getEditor(), model, null);
	}
	if (model.getRows() == null) {
	  model.setRows(new Vector());
	}
      }
      else if (e.getActionCommand().equals("col")) {
	PrubaeModelValue	varRow =
	  (PrubaeModelValue)((PrubaeModelTable)getModel()).getVarRow();
	if (varRow != null) {
	  PrubaeControllerValueStatement
	    varRowCtl = (PrubaeControllerValueStatement)varRow.getController();
	  if (getVarRowPanel().isAncestorOf(varRowCtl.getPanel())) {
	    getVarRowPanel().remove(varRowCtl.getPanel());
	  }
	  ((PrubaeModelTable)getModel()).setVarRow(null);
	}
	if (((PrubaeModelTable)getModel()).getRows() != null) {
	  int	rows = ((PrubaeModelTable)getModel()).getRows().size();
	  removeRows(0, rows);
	  ((PrubaeModelTable)getModel()).setRows(null);
	}
      }
      else if (e.getActionCommand().equals("set rows")) {
	updateRowsCount();
      }
      else if (e.getActionCommand().equals("set cols")) {
	updateColsCount();
      }
      view.display();
    }
  }

  /**
   * <code>createPopupMenu</code> method create popup menu for this node.
   *
   */
  void createPopupMenu() {
    JMenuItem	mi = null;
    setPopupMenu(new JPopupMenu());
    mi = new JMenuItem("delete this action");
    mi.setActionCommand("delete");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
    mi = new JMenuItem("insert action before this");
    mi.setActionCommand("insert");
    mi.addActionListener(this);
    getPopupMenu().add(mi);
  }

  /**
   * Describe <code>updateTable</code> method here.
   *
   */
  public void updateTable() {
    getTablePanel().getViewport().remove(getTable());
    setTable(new JTable(this));
    if (!isCellEditable(0, 0)) {
      DefaultTableCellRenderer	renderer = new DefaultTableCellRenderer();
      renderer.setBackground(Color.lightGray);
      getTable().getColumnModel().getColumn(0).setCellRenderer(renderer);
    }
    getTablePanel().getViewport().add(getTable());
  }

  /**
   * <code>addTableModelListener</code> method
   * is the TableModel interface method.
   * @param listener a <code>TableModelListener</code>
   */
  public void addTableModelListener(TableModelListener listener) {
  }

  /**
   * <code>removeTableModelListener</code> method
   * is the TableModel interface method.
   * @param listener a <code>TableModelListener</code> value
   */
  public void removeTableModelListener(TableModelListener listener) {
  }

  /**
   * <code>isCellEditable</code> method
   * is the TableModel interface method.
   * @param rowIndex an <code>int</code> value
   * @param columnIndex an <code>int</code> value
   * @return a <code>boolean</code> value
   */
  public boolean isCellEditable(int rowIndex, int columnIndex) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    if (model == null) {
      return false;
    }
    if (model.getRows() == null	|| model.getRows().size() == 0) {
      return true;
    }
    if (columnIndex < 1) {
      return false;
    }
    return true;
  }

  /**
   * <code>getColumnName</code> method
   * is the TableModel interface method.
   * @param columnIndex an <code>int</code> value
   * @return a <code>String</code> value
   */
  public String getColumnName(int columnIndex) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    if (model == null) {
      System.err.println("getColumnName model is null");
      return "";
    }
    if (model.getRows() == null	|| model.getRows().size() == 0) {
    }
    else if (columnIndex < 1) {
      System.err.println("getColumnName columnIndex(<1) = " + columnIndex);
      return "";	/* ;;; */
    }
    else {
      columnIndex--;
    }
    PrubaeModelStatement
      stmt = (PrubaeModelStatement)model.getCols().get(columnIndex);
    System.err.println("getColumnName columnIndex = " + columnIndex + ":"
		       + model.getCols() + ":" + model.getCols().size() + ":"
		       + stmt);
    String	columnName = ((PrubaeModel)stmt).getComment();
    if (columnName == null || columnName.equals("")) {
      columnName = stmt.getStatement();
    }
    System.err.println("getColumnName columnIndex = " + columnIndex + ":"
		       + columnName);
    return columnName;
  }

  /**
   * <code>getColumnClass</code> method
   * is the TableModel interface method.
   * @param columnIndex an <code>int</code> value
   * @return a <code>Class</code> value
   */
  public Class getColumnClass(int columnIndex) {
    return String.class;
  }

  /**
   * <code>getRowCount</code> method
   * is the TableModel interface method.
   * @return an <code>int</code> value
   */
  public int getRowCount() {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    if (model == null) {
      return 0;
    }
    if (model.getRows() == null	|| model.getRows().size() == 0) {
      return 1;
    }
    return model.getRows().size();
  }

  /**
   * <code>getColumnCount</code> method
   * is the TableModel interface method.
   * @return an <code>int</code> value
   */
  public int getColumnCount() {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    if (model == null) {
      return 0;
    }
    if (model.getCols() == null	|| model.getCols().size() == 0) {
      return 0;
    }
    if (model.getRows() == null	|| model.getRows().size() == 0) {
      return (model.getCols().size());
    }
    return (model.getCols().size()+1);
  }

  /**
   * <code>getValueAt</code> method
   * is the TableModel interface method.
   * @param rowIndex an <code>int</code> value
   * @param columnIndex an <code>int</code> value
   * @return an <code>Object</code> value
   */
  public Object getValueAt(int rowIndex, int columnIndex) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    int	index = 0;
    if (model.getRows() == null	|| model.getRows().size() == 0) {
      index = columnIndex;
    }
    else if (columnIndex < 1) {
      List	rows = model.getRows();
      PrubaeModelStatement
	stmt = (PrubaeModelStatement)rows.get(rowIndex);
      String	str = stmt.getStatement();
      int	left = str.indexOf('(');
      int	right = str.indexOf(')', (left < 0 ? 0 : left));
      if (left >= 0 || right >= 0) {
	str = str.substring(left+1, right);
      }
      return str;
    }
    else {
      int	rowsStart = model.getCols().size();
      index = rowIndex * rowsStart + columnIndex - 1;
    }
    List	tbls = model.getTbls();
    PrubaeModelStatement	stmt = (PrubaeModelStatement)tbls.get(index);
    String	str = stmt.getStatement();
    int	left = str.indexOf('(');
    int	right = str.indexOf(')', (left < 0 ? 0 : left));
    if (left >= 0 || right >= 0) {
      str = str.substring(left+1, right);
    }
    return str;
  }

  /**
   * <code>setValueAt</code> method
   * is the TableModel interface method.
   * @param aValue an <code>Object</code> value
   * @param rowIndex an <code>int</code> value
   * @param columnIndex an <code>int</code> value
   */
  public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    PrubaeModelTable	model = (PrubaeModelTable)getModel();
    int	index = 0;
    if (model.getRows() == null	|| model.getRows().size() == 0) {
      index = columnIndex;
    }
    else if (columnIndex < 1) {
      return;
    }
    else {
      int	rowsStart = model.getCols().size();
      index = rowIndex * rowsStart + columnIndex - 1;
    }
    List	tbls = model.getTbls();
    PrubaeModelDoStatement	stmt = (PrubaeModelDoStatement)tbls.get(index);
    String	str = (String)aValue;
    System.err.println("setValueAt:" + str + ":"
		       + rowIndex + "/" + columnIndex + "/" + index);
    String	currency = "   ";
    double	value = (double)0;
    if (str.length() > 3) {
      currency = str.substring(0, 3);
      str = str.substring(3);
      try {
	value = Double.parseDouble(str);
      }
      catch (NumberFormatException e) {
      }
    }
    System.err.println("setValueAt:[" + currency + "] [" + value + "]:"
		       + rowIndex + "/" + columnIndex + "/" + index);
    stmt.setRegist((short)ProrateRulebaseElement.AMOUNT_CODE);
    stmt.setValues(new Vector());
    stmt.getValues().add(currency);
    stmt.getValues().add(new Double(value));
    stmt.updateStatement();
    tbls.set(index, stmt);
  }

  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeControllerTable	clone = null;
    clone = (PrubaeControllerTable)super.clone();
    if (getRowPanel() != null) {
      clone.setRowPanel(new JPanel());
    }
    if (getColPanel() != null) {
      clone.setColPanel(new JPanel());
    }
    if (getVarRowPanel() != null) {
      clone.setVarRowPanel(new JPanel());
    }
    if (getVarColPanel() != null) {
      clone.setVarColPanel(new JPanel());
    }
    if (getRowsCountPanel() != null) {
      clone.setRowsCountPanel(new JPanel());
    }
    if (getRowsCountField() != null) {
      clone.setRowsCountField(new JTextField());
    }
    if (getColsCountPanel() != null) {
      clone.setColsCountPanel(new JPanel());
    }
    if (getColsCountField() != null) {
      clone.setColsCountField(new JTextField());
    }
    return clone;
  }

  // Setters and Getters
  /**
   * 
   * @uml.property name="rowButton"
   */
  public void setRowButton(JRadioButton theRowButton) {
    rowButton = theRowButton;
  }

  /**
   * 
   * @uml.property name="rowButton"
   */
  public JRadioButton getRowButton() {
    return rowButton;
  }

  /**
   * 
   * @uml.property name="colButton"
   */
  public void setColButton(JRadioButton theColButton) {
    colButton = theColButton;
  }

  /**
   * 
   * @uml.property name="colButton"
   */
  public JRadioButton getColButton() {
    return colButton;
  }

  /**
   * 
   * @uml.property name="rowPanel"
   */
  public void setRowPanel(JPanel theRowPanel) {
    rowPanel = theRowPanel;
  }

  /**
   * 
   * @uml.property name="rowPanel"
   */
  public JPanel getRowPanel() {
    return rowPanel;
  }

  /**
   * 
   * @uml.property name="colPanel"
   */
  public void setColPanel(JPanel theColPanel) {
    colPanel = theColPanel;
  }

  /**
   * 
   * @uml.property name="colPanel"
   */
  public JPanel getColPanel() {
    return colPanel;
  }

  /**
   * 
   * @uml.property name="rowsCountPanel"
   */
  public void setRowsCountPanel(JPanel theRowsCountPanel) {
    rowsCountPanel = theRowsCountPanel;
  }

  /**
   * 
   * @uml.property name="varRowPanel"
   */
  public void setVarRowPanel(JPanel theVarRowPanel) {
    varRowPanel = theVarRowPanel;
  }

  /**
   * 
   * @uml.property name="varRowPanel"
   */
  public JPanel getVarRowPanel() {
    return varRowPanel;
  }

  /**
   * 
   * @uml.property name="varColPanel"
   */
  public void setVarColPanel(JPanel theVarColPanel) {
    varColPanel = theVarColPanel;
  }

  /**
   * 
   * @uml.property name="varColPanel"
   */
  public JPanel getVarColPanel() {
    return varColPanel;
  }

  /**
   * 
   * @uml.property name="rowsCountPanel"
   */
  public JPanel getRowsCountPanel() {
    return rowsCountPanel;
  }

  /**
   * 
   * @uml.property name="rowsCountLabel"
   */
  public void setRowsCountLabel(JLabel theRowsCountLabel) {
    rowsCountLabel = theRowsCountLabel;
  }

  /**
   * 
   * @uml.property name="rowsCountLabel"
   */
  public JLabel getRowsCountLabel() {
    return rowsCountLabel;
  }

  /**
   * 
   * @uml.property name="rowsCountField"
   */
  public void setRowsCountField(JTextField theRowsCountField) {
    rowsCountField = theRowsCountField;
  }

  /**
   * 
   * @uml.property name="rowsCountField"
   */
  public JTextField getRowsCountField() {
    return rowsCountField;
  }

  /**
   * 
   * @uml.property name="rowsCountButton"
   */
  public void setRowsCountButton(JButton theRowsCountButton) {
    rowsCountButton = theRowsCountButton;
  }

  /**
   * 
   * @uml.property name="rowsCountButton"
   */
  public JButton getRowsCountButton() {
    return rowsCountButton;
  }

  /**
   * 
   * @uml.property name="rowsCount"
   */
  public void setRowsCount(int theRowsCount) {
    rowsCount = theRowsCount;
  }

  /**
   * 
   * @uml.property name="rowsCount"
   */
  public int getRowsCount() {
    return rowsCount;
  }

  /**
   * 
   * @uml.property name="colsCountPanel"
   */
  public void setColsCountPanel(JPanel theColsCountPanel) {
    colsCountPanel = theColsCountPanel;
  }

  /**
   * 
   * @uml.property name="colsCountPanel"
   */
  public JPanel getColsCountPanel() {
    return colsCountPanel;
  }

  /**
   * 
   * @uml.property name="colsCountLabel"
   */
  public void setColsCountLabel(JLabel theColsCountLabel) {
    colsCountLabel = theColsCountLabel;
  }

  /**
   * 
   * @uml.property name="colsCountLabel"
   */
  public JLabel getColsCountLabel() {
    return colsCountLabel;
  }

  /**
   * 
   * @uml.property name="colsCountField"
   */
  public void setColsCountField(JTextField theColsCountField) {
    colsCountField = theColsCountField;
  }

  /**
   * 
   * @uml.property name="colsCountField"
   */
  public JTextField getColsCountField() {
    return colsCountField;
  }

  /**
   * 
   * @uml.property name="colsCountButton"
   */
  public void setColsCountButton(JButton theColsCountButton) {
    colsCountButton = theColsCountButton;
  }

  /**
   * 
   * @uml.property name="colsCountButton"
   */
  public JButton getColsCountButton() {
    return colsCountButton;
  }

  /**
   * 
   * @uml.property name="colsCount"
   */
  public void setColsCount(int theColsCount) {
    colsCount = theColsCount;
  }

  /**
   * 
   * @uml.property name="colsCount"
   */
  public int getColsCount() {
    return colsCount;
  }

  /**
   * 
   * @uml.property name="table"
   */
  public void setTable(JTable theTable) {
    table = theTable;
  }

  /**
   * 
   * @uml.property name="table"
   */
  public JTable getTable() {
    return table;
  }

  /**
   * 
   * @uml.property name="tablePanel"
   */
  public void setTablePanel(JScrollPane theTablePanel) {
    tablePanel = theTablePanel;
  }

  /**
   * 
   * @uml.property name="tablePanel"
   */
  public JScrollPane getTablePanel() {
    return tablePanel;
  }

} /* end class PrubaeControllerTable */
