// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Logger;

public class PrubaeFrame extends Prubae {

  // Attributes  
  /**
   * @uml.property  name="frame"
   */
  private static JFrame frame = null;  
  static Logger	logger = Logger.getLogger(PrubaeFrame.class.getName());
  static String defaultLookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";

  // Constructor  
  public PrubaeFrame() {  
    super();  

    initialize();

    initPanel();

    JMenuItem	exitItem = new JMenuItem("Exit");
    exitItem.setActionCommand("exit");
    exitItem.addActionListener(this);
    getFileMenu().add(exitItem);
  }  

  // Operations  
  public static void main(String[] args) {  
    String	laf = UIManager.getSystemLookAndFeelClassName();
    try {
      UIManager.setLookAndFeel(laf);
    }
    catch (Exception e) {
      laf = defaultLookAndFeel;
      try {
	UIManager.setLookAndFeel(laf);
      } catch (UnsupportedLookAndFeelException exc) {
	System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
	System.exit(0);
      } catch (Exception exc) {
	System.err.println("Error loading " + laf + ": " + exc);
	System.exit(0);
      }
    }

    URL	openUrl = null;
    String	urlname = null;
    String	filename = null;
    if (args.length > 0) {
      /* user arguments */
      boolean	alreadyDialog = false;
      urlname = args[0];
      System.out.println("urlname = " + urlname);
      logger.info("urlname = " + urlname);
      if (urlname != null && !urlname.equals("")) {
	if (urlname.startsWith("http:")) {
	  try {
	    openUrl = new URL(urlname);
	  } catch (MalformedURLException e) {
	    JOptionPane
	      .showMessageDialog(null, urlname + " : " + "url not found :"
				 + e.getMessage());
	    alreadyDialog = true;
	    openUrl = null;
	  }
	  if (openUrl == null && !alreadyDialog) {
	    JOptionPane.showMessageDialog(null, urlname + " not found");
	  }
	}
	else {
	  openUrl = null;
	  filename = urlname;
	}
      }
    }

    Prubae	prubae = new PrubaeFrame();
    if (prubae == null) {
      return;
    }

    if (openUrl != null) {
      boolean	alreadyDialog = false;
      prubae.setEditType(PrubaeEditUrl);
      prubae.setUrlname(urlname);
      prubae.setFilename(null);
      InputStream	in = null;
      Reader	ruleReader = null;
      try {
	in = openUrl.openStream();
      }
      catch (IOException e) {
	JOptionPane
	  .showMessageDialog(null, urlname + " : IOException : "
			     + e.getMessage());
	alreadyDialog = true;
	in = null;
      }
      if (in != null) {
	ruleReader = new InputStreamReader(in);
      }
      if (ruleReader != null) {
	PrubaeModel	modelSaved = prubae.getModel();
	PrubaeModel	model = null;
	prubae.getReader().read(ruleReader);
	model = prubae.getModel();
	prubae.setModel(modelSaved);
	prubae.setFunction(model);
      }
      else if (!alreadyDialog) {
	JOptionPane.showMessageDialog(null, urlname + " not found");
      }
    }
    else {
      prubae.setEditType(PrubaeEditFile);
      prubae.setUrlname(null);
      prubae.setFilename(filename);
      if (filename != null) {
	InputStream	in = null;
	Reader	ruleReader = null;
	boolean	alreadyDialog = false;
	try {
	  in = new FileInputStream(filename);
	}
	catch (IOException e) {
	  JOptionPane
	    .showMessageDialog(null, filename + " : IOException : "
			       + e.getMessage());
	  alreadyDialog = true;
	  in = null;
	}
	if (in != null) {
	  ruleReader = new InputStreamReader(in);
	}
	if (ruleReader != null) {
	  PrubaeModel	modelSaved = prubae.getModel();
	  PrubaeModel	model = null;
	  prubae.getReader().read(ruleReader);
	  model = prubae.getModel();
	  prubae.setModel(modelSaved);
	  prubae.setFunction(model);
	}
	else if (!alreadyDialog) {
	  JOptionPane.showMessageDialog(null, filename + " not found");
	}
      }
    }

    frame = new JFrame("Prubae");
    frame.addWindowListener(new WindowAdapter() {
	public void windowClosing(WindowEvent e) {
	  System.exit(0);
	}
      });

    frame.getContentPane().add("Center", prubae.getRootPanel());
    frame.pack();
    frame.setVisible(true);
  }

  public void actionPerformed(ActionEvent e) {  
    if (e.getActionCommand().equals("exit")) {
      int confirm = JOptionPane.showConfirmDialog(null, "Save editing rule?");
      if (confirm == JOptionPane.CANCEL_OPTION) {
	return;
      }
      if (confirm == JOptionPane.OK_OPTION) {
	if (prepareSaveFunction()) {
	  saveFunction();
	  System.exit(0);
	}
      }
      else {
	System.exit(0);
      }
    }
    else {
      super.actionPerformed(e);
    }
  }

  // Setters and Getters  
  /**
   * 
   * @uml.property name="frame"
   */
  public static void setFrame(JFrame theFrame) {
    PrubaeFrame.frame = theFrame;
  }

  /**
   * 
   * @uml.property name="frame"
   */
  public static JFrame getFrame() {
    return PrubaeFrame.frame;
  }



} /* end class PrubaeFrame */
