// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;


import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

/**
 * class <code>PrubaeModelAndOr</code> handles and/or judge statement rule element models. this class has statements rule model list and boolean isAnd
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class PrubaeModelAndOr extends PrubaeModelJudge {

  // Attributes  
  /**
   * variable <code>isAnd</code> is boolean flag whether this model element is And(true) or Or(false).
   * @uml.property  name="isAnd"
   */
  private boolean isAnd = true;  
  /**
   * variable <code>statements</code> is a list of the rule element models of the judge statements under this.
   * @uml.property  name="statements"
   */
  private List statements = null;  

  // Constructor  
  /**
   * Creates a new <code>PrubaeModelAndOr</code> instance.
   * this creates all GUI elements on part panel of the function,
   * also sets default value(true) to the isAnd variable,
   * creates and sets the statements an an empty list.
   */
  public PrubaeModelAndOr() {  
    setView(new PrubaeViewAndOr());
    getView().setModel(this);
    setController(new PrubaeControllerAndOr());
    getController().setModel(this);
    getView().setController(getController());
    getController().setView(getView());

    setAnd(true);
    setRegist((short) ProrateRulebaseElement.AND_CODE);
    setStatements(new Vector());
  }  

  // Operations
  /**
   * <code>close</code> method
   * sends close to all the model elements in the statements list.
   * and then delete all GUI elements and other items related to this model
   * using super.close()
   */
  public void close() {
    /* ;;; deBug
    for (int i = 0; i < getStatements().size(); i++) {
      ((PrubaeModel)getStatements().get(i)).close();
    }
    */
    while (getStatements() != null && getStatements().size() > 0) {
      ((PrubaeModel)getStatements().get(0)).close();
    }
    super.close();    
  }  

  /**
   * <code>setJudges</code> method
   * insert car judge element model to the first position of the list judges.
   * insert cdr judge element model to the second position.
   * sends initialize() method to car and cdr.
   * @param car a <code>PrubaeModel</code> value
   * is the judge element model to insert to the first position of the list.
   * @param cdr a <code>PrubaeModel</code> value
   * is the judge element model to insert to the second position of the list.
   */
  public void setJudges(PrubaeModel car, PrubaeModel cdr) {
    if (getStatements().size() < 1) {
      getStatements().add(car);
    }
    else {
      getStatements().set(0, car);
    }
    if (getStatements().size() < 2) {
      getStatements().add(cdr);
    }
    else {
      getStatements().set(1, cdr);
    }
    car.initialize(getEditor(), this, getStatements());
    cdr.initialize(getEditor(), this, getStatements());
  }

  /**
   * <code>toString</code> method
   * returns comment string if exists,
   * if isAnd is true then returns "And", returns "Or" otherwise.
   * @return a <code>String</code> value is a returned string 
   */
  public String toString() {
    if (getComment() != null && !getComment().equals("")) {
      return getComment();
    }
    return (isAnd() ? "And" : "Or ");
  }  

  /**
   * <code>writeModel</code> method
   * writes first element in the statements list.
   * using the writer(PrubaeWriter) instance.
   * then writes the regist code(AND_CODE or OR_CODE).
   * and then writes the skip size bytes integer.
   * then writes the rest of the elements in the statements list.
   */
  public void writeModel(ProrateRulebaseWriter rulebase) {
    rulebase.writeAndOr(this);
  }

  /**
   * <code>getSize</code> method
   * counts the size of this rule and returns the size.
   * the size of all model elements in statements lists are included.
   * the size of skip size bytes integers are also included.
   * @param rulebase a <code>ProrateRulebaseWriter</code> value
   * @return an <code>int</code> value
   */
  public int getSize(ProrateRulebaseWriter rulebase) {
    return rulebase.getAndOrSize(this);
  }


  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeModelAndOr	clone = null;
    clone = (PrubaeModelAndOr)super.clone();
    clone.setStatements((List)((Vector)getStatements()).clone());
    return clone;
  } 

  // Setters and Getters  
  /**
   * Describe <code>setAnd</code> method here.
   * @param isAnd  a <code>boolean</code> value
   * @uml.property  name="isAnd"
   */
  public void setAnd(boolean isAnd) {
    this.isAnd = isAnd;
  }

  /**
   * Describe <code>isAnd</code> method here.
   * @return  a <code>boolean</code> value
   * @uml.property  name="isAnd"
   */
  public boolean isAnd() {
    return isAnd;
  }

  /**
   * 
   * @uml.property name="statements"
   */
  public void setStatements(List theStatements) {
    statements = theStatements;
  }

  /**
   * 
   * @uml.property name="statements"
   */
  public List getStatements() {
    return statements;
  }

} /* end class PrubaeModelAndOr */
