// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;


import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

/**
 * class <code>PrubaeModelCase</code>
 * handles case-branch statement rule model element.
 * this class has values and actions rule model lists.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeModelCase extends PrubaeModel {

  // Attributes  
  /**
   * variable <code>values</code> is a list of the rule element models of the case-branch values.
   * @uml.property  name="values"
   */
  private List values = null;  
  /**
   * variable <code>actions</code> is a list of the rule element models of the actions related to the case.
   * @uml.property  name="actions"
   */
  private List actions = null;  

  // Constructor  
  /**
   * Creates a new <code>PrubaeModelCase</code> instance.
   * this creates all GUI elements on part panel of the function,
   * also creates values and actions as empty lists.
   */
  public PrubaeModelCase() {  
    setView(new PrubaeViewCase());
    getView().setModel(this);
    setController(new PrubaeControllerCase());
    getController().setModel(this);
    getView().setController(getController());
    getController().setView(getView());

    setValues(new Vector());
    setActions(new Vector());
  }  

  // Operations  
  /**
   * <code>close</code> method here.
   * sends close to all the model elements in actions.
   * and then delete all GUI elements and other items related to this model
   * using super.close()
   */
  public void close() {
    /* ;;; deBug
    for (int i = 0; i < getActions().size(); i++) {
      ((PrubaeModel)getActions().get(i)).close();
    }
    */
    while (getActions() != null && getActions().size() > 0) {
      ((PrubaeModel)getActions().get(0)).close();
    }
    super.close();
  }  

  /**
   * <code>toString</code> method returns the string "Case".
   *
   * @return a <code>String</code> value is a returned string.
   */
  public String toString() {  
    if (getComment() != null && !getComment().equals("")) {
      return getComment();
    }
    return "Case";
  }  

  /**
   * <code>updateCases</code> method 
   * updates all rule element models in values list,
   * by sending updateStatement method.
   */
  public void updateCases() {
    System.err.println("updateCases : " + getValues().size());
    for (int i = 0; i < getValues().size(); i++) {
      if (getValues().get(i) instanceof PrubaeModelValue) {
	System.err.println("updateCases updateStatement (" + i + ")");
	((PrubaeModelValue)getValues().get(i)).updateStatement();
      }
    }
  }

  /**
   * <code>writeModel</code> method
   * writes all values and all actions,
   * using the writer(PrubaeWriter) instance.
   */
  public void writeModel(ProrateRulebaseWriter rulebase) {
    rulebase.writeCase(this);
  }

  /**
   * <code>getSize</code> method here.
   *
   * @param rulebase a <code>ProrateRulebaseWriter</code> value
   * @return an <code>int</code> value
   */
  public int getSize(ProrateRulebaseWriter rulebase) {
    return rulebase.getCaseSize(this);
  }

  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeModelCase	clone = null;
    clone = (PrubaeModelCase)super.clone();
    if (getValues() != null) {
      clone.setValues((List)((Vector)getValues()).clone());
      for (int i = 0; i < getValues().size(); i++) {
	clone.getValues().set(i, ((PrubaeModel)getValues().get(i)).clone());
	((PrubaeModel)clone.getValues().get(i))
	  .initialize(getEditor(), clone, clone.getValues());
      }
    }
    if (getActions() != null) {
      clone.setActions((List)((Vector)getActions()).clone());
      for (int i = 0; i < getActions().size(); i++) {
	clone.getActions().set(i, ((PrubaeModel)getActions().get(i)).clone());
	((PrubaeModel)clone.getActions().get(i))
	  .initialize(getEditor(), clone, clone.getActions());
	/*
	clone.getController().getTreeNode()
	  .add(((PrubaeModel)clone.getActions().get(i))
	       .getController().getTreeNode());
	*/
      }
    }
    return clone;
  }

  /* ;;; 2006.09.12 */
  /**
   * <code>check</code> method	check validity of the prubae model.
   *
   * @param errors a <code>List</code> value
   * @return a <code>boolean</code> value
   */
  public boolean check(List errors) {
    for (int i = 0; i < getValues().size(); i++) {
      if (!((PrubaeModel)getValues().get(i)).check(errors)) {
	errors.add("in values statement #" + (i+1) + " in Case Statement");
	return false;
      }
    }
    for (int i = 0; i < getActions().size(); i++) {
      if (!((PrubaeModel)getActions().get(i)).check(errors)) {
	errors.add("in actions statement #" + (i+1) + " in Case Statement");
	return false;
      }
    }
    return true;
  }

  // Setters and Getters  
  /**
   * 
   * @uml.property name="values"
   */
  public void setValues(List theValues) {
    values = theValues;
  }

  /**
   * 
   * @uml.property name="values"
   */
  public List getValues() {
    return values;
  }

  /**
   * 
   * @uml.property name="actions"
   */
  public void setActions(List theActions) {
    actions = theActions;
  }

  /**
   * 
   * @uml.property name="actions"
   */
  public List getActions() {
    return actions;
  }

} /* end class PrubaeModelCase */
