// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.util.List;

import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

/**
 * class <code>PrubaeModelDo</code>
 * is the common super class of prubae action statements rule element models,
 * such as if-statement, case-statement, table-statement and other actions.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeModelDo extends PrubaeModel {

  // Constructor  
  /**
   * Creates a new <code>PrubaeModelDo</code> instance.
   * this creates all GUI elements on part panel of the action statement.
   */
  public PrubaeModelDo() {  
    super();

    setView(new PrubaeViewDo());
    getView().setModel(this);
    setController(new PrubaeControllerDo());
    getController().setModel(this);
    getView().setController(getController());
    getController().setView(getView());
  }  

  // Operations  
  /**
   * <code>toString</code> method
   * returns comment string if exists, or returns "new action" otherwise.
   * @return a <code>String</code> value
   */
  public String toString() {  
    if (getComment() != null && !getComment().equals("")) {
      return getComment();
    }
    return "new action";
  }  

  /**
   * <code>writeModel</code> method writes this rule element model.
   * this actually does nothing.
   */
  public void writeModel(ProrateRulebaseWriter rulebase) {
  }

  /**
   * <code>getSize</code> method
   * counts the size of this rule and returns the size which is always 0.
   * @param rulebase a <code>ProrateRulebaseWriter</code> value
   * @return an <code>int</code> value
   */
  public int getSize(ProrateRulebaseWriter rulebase) {
    return 0;
  }

  /* ;;; 2006.09.12 */
  /**
   * <code>check</code> method	check validity of the prubae model.
   *
   * @param errors a <code>List</code> value
   * @return a <code>boolean</code> value
   */
  public boolean check(List errors) {
    errors.add("do statement not defined");
    return false;
  }

} /* end class PrubaeModelDo */
