// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import java.util.List;

/**
 * interface <code>PrubaeModelStatement</code> is the common interface definition of Prubae Statement Objects.
 * @author   <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */

public interface PrubaeModelStatement {
  // Operations
  /**
   * <code>toString</code> method
   *
   * @return a <code>String</code> value is a returned string.
   */
  public String toString();
  /**
   * <code>closeUI</code> method
   * sends closeUI() method to the all children models.
   */
  public void closeUI();
  /**
   * <code>updateStatement</code> method
   * creates statement string to describe this element model.
   */
  public void updateStatement();

  /**
   * <code>setRegist</code> method
   * @param theRegist a <code>short</code> value
   */
  public void setRegist(short theRegist);

  /**
   * <code>setComment</code> method
   * @param theComment a <code>String</code> value
   */
  public void setComment(String theComment);

  /**
   * <code>setEditor</code> method
   * @param theEditor a <code>Prubae</code> value
   */
  public void setEditor(Prubae theEditor);

  /**
   * <code>setName</code> method
   * @param theName   a <code>String</code> value
   * @uml.property  name="name"
   */
  public void setName(String theName);

  /**
   * <code>getName</code> method
   * @return   a <code>String</code> value
   * @uml.property  name="name"
   */
  public String getName();

  /**
   * <code>getStatement</code> method
   * @return   a <code>String</code> value
   * @uml.property  name="statement"
   */
  public String getStatement();

  /**
   * <code>setStatement</code> method
   * @param theStatement   a <code>String</code> value
   * @uml.property  name="statement"
   */
  public void setStatement(String theStatement);

  /**
   * <code>getValues</code> method
   * @return   a <code>List</code> value
   * @uml.property  name="values"
   */
  public List getValues();

  /**
   * <code>setValues</code> method
   * @param theValues   a <code>List</code> value
   * @uml.property  name="values"
   */
  public void setValues(List theValues);

  /**
   * <code>getRegist</code> method
   *
   * @return a <code>short</code> value
   */
  public short getRegist();

} /* end interface PrubaeModelStatement */
