// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;


import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;

/**
 * class <code>PrubaeModelSwitch</code>
 * handles case-statement rule model element.
 * this class has vars and cases rule model lists.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeModelSwitch extends PrubaeModelDo {

  // Attributes  
  /**
   * variable <code>vars</code> is a list of the rule element models of the case-var values.
   * @uml.property  name="vars"
   */
  private List vars = null;  
  /**
   * variable <code>cases</code> is a list of the rule element models of the case-branches, which are in the class of PrubaeModelCase.
   * @uml.property  name="cases"
   */
  private List cases = null;  

  // Constructor  
  /**
   * Creates a new <code>PrubaeModelSwitch</code> instance.
   * this creates all GUI elements on part panel of the function,
   * also creates vars and cases as empty lists.
   */
  public PrubaeModelSwitch() {  
    setView(new PrubaeViewSwitch());
    getView().setModel(this);
    setController(new PrubaeControllerSwitch());
    getController().setModel(this);
    getView().setController(getController());
    getController().setView(getView());

    setRegist((short)ProrateRulebaseElement.CASE_CODE);
    setVars(new Vector());
    setCases(new Vector());
  }  

  // Operations  
  /**
   * <code>close</code> method
   * sends close to all the model elemments in cases.
   * and then delete all GUI elements and other items related to this model
   * using super.close()
   */
  public void close() {
    /* ;;; deBug
    for (int i = 0; i < getCases().size(); i++) {
      ((PrubaeModel)getCases().get(i)).close();
    }
    */
    while (getCases() != null && getCases().size() > 0) {
      ((PrubaeModel)getCases().get(0)).close();
    }
    super.close();
  }  

  /**
   * <code>toString</code> method
   * returns comment string if exists, or returns string "Case" otherwise.
   * @return a <code>String</code> value is a returned string.
   */
  public String toString() {  
    if (getComment() != null && !getComment().equals("")) {
      return getComment();
    }
    return "Switch";
  }  

  /**
   * <code>updateVars</code> method
   * updates all rule element models in vars list,
   * by sending updateStatement method.
   */
  public void updateVars() {
    System.err.println("updateVars : " + getVars().size());
    for (int i = 0; i < getVars().size(); i++) {
      if (getVars().get(i) instanceof PrubaeModelValueStatement) {
	PrubaeController	cntl =
	  (PrubaeController)((PrubaeModel)getVars().get(i)).getController();
	if (cntl != null) {
	  cntl.update();
	}
      }
    }
  }

  /**
   * <code>writeModel</code> method
   * writes CASE_CODE, number of case-vars, and all case-vars,
   * using the writer(PrubaeWriter) instance.
   * and then, writes all case-branches, one by one,
   * and writes END_CODE and skip size bytes integer after each case.
   * then writes ENDCASE_CODE.
   */
  public void writeModel(ProrateRulebaseWriter rulebase) {
    rulebase.writeSwitch(this);
  }

  /**
   * <code>getSize</code> method
   * counts the size of this rule and returns the size.
   *
   * @param rulebase a <code>ProrateRulebaseWriter</code> value
   * @return an <code>int</code> value
   */
  public int getSize(ProrateRulebaseWriter rulebase) {
    return rulebase.getSwitchSize(this);
  }

  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeModelSwitch	clone = null;
    clone = (PrubaeModelSwitch)super.clone();
    if (getVars() != null) {
      clone.setVars((List)((Vector)getVars()).clone());
      for (int i = 0; i < getVars().size(); i++) {
	clone.getVars().set(i, ((PrubaeModel)getVars().get(i)).clone());
	((PrubaeModel)clone.getVars().get(i))
	  .initialize(getEditor(), clone, clone.getVars());
      }
    }
    if (getCases() != null) {
      clone.setCases((List)((Vector)getCases()).clone());
      for (int i = 0; i < getCases().size(); i++) {
	clone.getCases().set(i,
				((PrubaeModel)getCases().get(i)).clone());
	((PrubaeModel)clone.getCases().get(i))
	  .initialize(getEditor(), clone, clone.getCases());
	/*
	clone.getController().getTreeNode()
	  .add(((PrubaeModel)clone.getCases().get(i))
	       .getController().getTreeNode());
	*/
      }
    }
    return clone;
  } 

  /* ;;; 2006.09.12 */
  /**
   * <code>check</code> method	check validity of the prubae model.
   *
   * @param errors a <code>List</code> value
   * @return a <code>boolean</code> value
   */
  public boolean check(List errors) {
    for (int i = 0; i < getVars().size(); i++) {
      if (!((PrubaeModel)getVars().get(i)).check(errors)) {
	errors.add("in vars statement #" + (i+1) + " in Switch Statement");
	return false;
      }
    }
    for (int i = 0; i < getCases().size(); i++) {
      if (!((PrubaeModel)getCases().get(i)).check(errors)) {
	errors.add("in cases statement #" + (i+1) + " in Switch Statement");
	return false;
      }
    }
    return true;
  }

  // Setters and Getters  
  /**
   * 
   * @uml.property name="vars"
   */
  public void setVars(List theVars) {
    vars = theVars;
  }

  /**
   * 
   * @uml.property name="vars"
   */
  public List getVars() {
    return vars;
  }

  /**
   * 
   * @uml.property name="cases"
   */
  public void setCases(List theCases) {
    cases = theCases;
  }

  /**
   * 
   * @uml.property name="cases"
   */
  public List getCases() {
    return cases;
  }

} /* end class PrubaeModelSwitch */
