// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;


import gnu.lists.LList;
import gnu.math.IntNum;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;


/**
 * class <code>PrubaeModelValue</code> handles value rule element models such as constant values or case branch. this class has values rule model list and statement String.
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class PrubaeModelValue extends PrubaeModel {

  // Attributes  
  /**
   * variable <code>statement</code> is the statement String to describe the judge statement of this model.
   * @uml.property  name="statement"
   */
  private String statement = null;
  /**
   * variable <code>values</code> is a list of the rule element models of the statements functions.
   * @uml.property  name="values"
   */
  private List values = null;

  /**
   * variable <code>type</code> is a type string or a llist of type strings of the rule element model.
   * @uml.property  name="type"
   */
  private Object type = null;

  /**
   * variable <code>type</code> is a type string or a llist of type strings of the rule element model.
   * @uml.property  name="requiredType"
   */
  private Object requiredType = null;

  // Constructor  
  /**
   * Creates a new <code>PrubaeModelValue</code> instance.
   * this does NOT creates view nor controller nor any GUI elements.
   * this creates new empty list and sets it to the values variable.
   */
  public PrubaeModelValue() {  
    setView(null);
    setController(null);
    setStatement("");
    setValues(new Vector());
  }

  // Operations  
  /**
   * <code>initialize</code> method
   * sets the reference to the editor top class instance,
   * does not create nor set the reference of the view and controller.
   * sends initialize to the controller if the controller already exists,
   * which makes controller to create panel GUI objects and tree node/nodes.
   * sets parent and parentList references.
   * @param editor a <code>Prubae</code> value
   * is the reference to the editor top class instance.
   * @param parent a <code>PrubaeModel</code> value
   * is the reference to the parent model instance.
   * @param parentList a <code>List</code> value
   * is the reference to the parent list in which this model belongs.
   */
  public void initialize(Prubae editor, PrubaeModel parent,
			 List parentList) {
    System.err.println("modelValue initialize() " + this);
    setEditor(editor);
    if (getView() != null) {
      getView().setEditor(editor);
    }
    if (getController() != null) {
      getController().setEditor(editor);
      getController().initialize();
    }
    setParent(parent);
    setParentList(parentList);
  }

  /**
   * <code>closeUI</code> method
   * sends closeUI() method to the all models in the values list.
   */
  public void closeUI() {
    if (getValues() != null) {
      for (int i = 0; i < getValues().size(); i++) {
	if (getValues().get(i) instanceof PrubaeModel) {
	  ((PrubaeModel)getValues().get(i)).closeUI();
	}
      }
    }
  }

  /**
   * <code>toString</code> method
   * returns comment string if comment is not null nor "",
   * returns the statement string when it is not null nor "",
   * returns "Value" string otherwise.
   * @return a <code>String</code> value is a returned string.
   */
  public String toString() {
    if (getComment() != null && !getComment().equals("")) {
      return getComment();
    }
    if (getStatement() == null || getStatement().equals("")) {
      return "Value";
    }
    else {
      return getStatement();
    }
  }

  /**
   * <code>updateStatement</code> method
   * creates statement string to describe this value element model.
   * for all models in the values list, if the model is the value statement,
   * sends update() method to the controller of the model in the list.
   */
  public void updateStatement() {
    if (getValues() == null || getValues().size() <= 0) {
      return;
    }
    setStatement("");
    for (int i = 0; i < getValues().size(); i++) {
      if (i > 0) {
	setStatement(getStatement() + " ");
      }
      if (getValues().get(i) instanceof PrubaeModelValue) {
	if (getValues().get(i) instanceof PrubaeModelValueStatement) {
	  PrubaeController
	    cntl =
	    (PrubaeController)
	    ((PrubaeModel)getValues().get(i)).getController();
	  if (cntl != null) {
	    cntl.update();
	  }
	}
	((PrubaeModelValue)getValues().get(i)).updateStatement();
	setStatement(getStatement() +
		     ((PrubaeModelValue)getValues().get(i)).getStatement());
      }
      else {
	setStatement(getStatement() + getValues().get(i).toString());
      }
    }
  }

  /**
   * <code>writeModel</code> method
   * writes the regist code of the model and attributes with it,
   * writes all model values in the values list,
   * using the writer(PrubaeWriter) instance.
   */
  public void writeModel(ProrateRulebaseWriter rulebase) {
    rulebase.writeValue(this);
  }

  /**
   * <code>getSize</code> method
   * counts the size of this rule and returns the size.
   *
   * @param rulebase a <code>ProrateRulebaseWriter</code> value
   * @return an <code>int</code> value of size bytes
   */
  public int getSize(ProrateRulebaseWriter rulebase) {
    return rulebase.getValueSize(this);
  }

  /**
   * <code>clone</code> method	create clone object and returns it.
   *
   * @return an <code>Object</code> value
   */
  public Object clone() {
    PrubaeModelValue	clone = null;
    clone = (PrubaeModelValue)super.clone();
    if (getValues() != null) {
      clone.setValues((List)((Vector)getValues()).clone());
      for (int i = 0; i < getValues().size(); i++) {
	Object	arg = getValues().get(i);
	if (arg instanceof PrubaeModel) {
	  clone.getValues().set(i, ((PrubaeModel)arg).clone());
	  ((PrubaeModel)clone.getValues().get(i))
	    .initialize(getEditor(), clone, clone.getValues());
	}
      }
    }
    return clone;
  } 

  /* ;;; 2006.09.12 */
  /**
   * <code>check</code> method	check validity of the prubae model.
   *
   * @param errors a <code>List</code> value
   * @return a <code>boolean</code> value
   */
  public boolean check(List errors) {
    LList
      list = Lisp.append(Lisp.append(getEditor().getValueList(),
				     getEditor().getVarList()),
			 getEditor().getConstList());
    LList	valueList = Lisp.assoc(new IntNum(getRegist()), list);
    if (valueList == null || Lisp.isNil(valueList)) {
      errors.add("illegal regist code " + getRegist());
      return false;
    }
    Object	isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
    if (isArgs != null && (isArgs instanceof IntNum)) {
      int	numArgs = ((IntNum)isArgs).intValue();
      if (numArgs >= 0) {
	if (getValues() == null) {
	  if (numArgs != 0) {
	    errors.add("illegal argument count in " + getName() + " function");
	    return false;
	  }
	}
	else if (getValues().size() != numArgs) {
	  errors.add("illegal argument count in " + getName() + " function");
	  return false;
	}
      }
    }
    for (int i = 0; i < getValues().size(); i++) {
      Object	value = getValues().get(i);
      if (value instanceof PrubaeModel
	  && !((PrubaeModel)value).check(errors)) {
	errors.add("in argument #" + (i+1) + " of " + getName() + " function");
	return false;
      }
    }
    return true;
  }

  // Setters and Getters  
  /**
   * 
   * @uml.property name="statement"
   */
  public void setStatement(String theStatement) {
    statement = theStatement;
  }

  /**
   * 
   * @uml.property name="statement"
   */
  public String getStatement() {
    return statement;
  }

  /**
   * 
   * @uml.property name="values"
   */
  public void setValues(List theValues) {
    values = theValues;
  }

  /**
   * 
   * @uml.property name="values"
   */
  public List getValues() {
    return values;
  }

  /**
   * @return  an <code>Object</code> value
   * @uml.property  name="type"
   */
  public Object getType() {
    return type;
  }

  /**
   * @param type  an <code>Object</code> value
   * @uml.property  name="type"
   */
  public void setType(Object type) {
    this.type = type;
  }

  /**
   * @return  an <code>Object</code> value
   * @uml.property  name="requiredType"
   */
  public Object getRequiredType() {
    if (parent != null
	&& parent.getRegist() == ProrateRulebaseElement.PATH_CODE) {
      return Lisp.list("string", "airport");
    }
    return requiredType;
  }

  /**
   * @param requiredType  an <code>Object</code> value
   * @uml.property  name="requiredType"
   */
  public void setRequiredType(Object requiredType) {
    this.requiredType = requiredType;
  }

} /* end class PrubaeModelDoStatement */
