// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.math.IntNum;
import java.util.List;
import java.util.Vector;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseWriter;


/**
 * class <code>PrubaeModelValueStatement</code>
 * handles value statement rule element models as function etc.
 * this class has statement String(in the super class PrubaeModelValue),
 * and function name string as the attributes of the model.
 * @author <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class PrubaeModelValueStatement extends PrubaeModelValue
  implements PrubaeModelStatement {

  // Attributes
  /**
   * variable <code>name</code> is the function name of this statement
   * @uml.property  name="name"
   */
  private String name = null;

  // Constructor
  /**
   * Creates a new <code>PrubaeModelValueStatement</code> instance.
   * this does NOT creates view nor controller nor any GUI elements.
   */
  public PrubaeModelValueStatement() {
    super();
  }

  // Operations
  /**
   * <code>openUI</code> method
   * constructs view and controller, and opens GUI elements dynamically.
   * by using initialize() method.
   */
  public void openUI() {
    if (getView() == null) {
      setView(new PrubaeViewValueStatement());
    }
    getView().setModel(this);
    boolean	isControlActive = (getController() != null);
    if (!isControlActive) {
      setController(new PrubaeControllerValueStatement());
    }
    getController().setModel(this);
    getView().setController(getController());
    getController().setView(getView());
    initialize(getEditor(), getParent(), getParentList());
    if (!isControlActive) {
      getController().createPanel();
    }
    else if (getParent().getParent() instanceof PrubaeModelCase
	     && (getParent().getRegist()
		 == (short)ProrateRulebaseElement.CASE_BRANCH_BEGIN)) {
      getController().createPanel();
    }
  }

  /**
   * <code>closeUI</code> method
   * closes GUI elements and destructs view and controller dynamically.
   * by sending update() and removePanel() methods to the controller.
   */
  public void closeUI() {
    super.closeUI();
    if (getController() != null) {
      ((PrubaeControllerValueStatement)getController()).update();
      ((PrubaeControllerValueStatement)getController()).removePanel();
    }
    setView(null);
    setController(null);
  }  

  /**
   * <code>toString</code> method returns null String.
   * returns comment string if comment is not null nor "",
   * returns the statement string when it is not null nor "",
   * returns "ValueStatement" string otherwise.
   * @return a <code>String</code> value is always null.
   */
  public String toString() {
    if (getComment() != null && !getComment().equals("")) {
      return getComment();
    }
    if (getStatement() == null || getStatement().equals("")) {
      return "ValueStatement";
    }
    else {
      //System.err.println("PrubaeModelValueStatement.toString() : getStatement() = " + getStatement());
      return getStatement();
    }
  }

  /**
   * <code>updateStatement</code> method
   * creates statement string to describe this statement element model.
   * for all models in the values list, if the model is the value statement,
   * sends update() method to the controller of the model in the list.
   */
  public void updateStatement() {
    String	funcName = null;
    LList
      list = Lisp.append(Lisp.append(getEditor().getValueList(),
				     getEditor().getVarList()),
			 getEditor().getConstList());
    LList	item = null;
    System.err.println("PrubaeModelValueStatement().updateStatement() : regist = " + regist);
    if ((getRegist() & ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION)
	== ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION) {
      System.err.println("PrubaeModelValueStatement().updateStatement() : regist = " + regist + ", AUTO_VARIABLE");
      LList	top = Lisp.assoc(new IntNum(getRegist()), list);
      LList	autoList = Lisp.member(top, list);
      for (int i = 0; !Lisp.isNil(autoList);
	   autoList = (LList)Lisp.cdr(autoList), i++) {
	IntNum	registNum = (IntNum)Lisp.car(Lisp.car(autoList));
	int	regist = registNum.intValue();
	if ((regist & ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION)
	    != ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION) {
	  break;
	}
	if (Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.car(autoList))))
	    .equals(getStatement())) {
	  item = (LList)Lisp.car(autoList);
	  setRegist((short)(ProrateRulebaseElement.AUTO_VARIABLE_INITIAL_CODE
			    + i));
	  System.err.println("PrubaeModelValueStatement().updateStatement() : regist = " + regist + ", item = " + item);
	  break;
	}
      }
    }
    else if (getRegist() == (short) ProrateRulebaseElement.EXTERNAL_FUNCTION) {
      LList	top = Lisp.assoc(new IntNum(getRegist()), list);
      LList	extfList = Lisp.member(top, list);
      for (int i = 0; !Lisp.isNil(extfList);
	   extfList = (LList)Lisp.cdr(extfList), i++) {
	IntNum	registNum = (IntNum)Lisp.car(Lisp.car(extfList));
	int	regist = registNum.intValue();
	if (regist != ProrateRulebaseElement.EXTERNAL_FUNCTION) {
	  break;
	}
	String	itemStm = getName();
	int	index = itemStm.indexOf("(");
	if (index >= 0) {
	  itemStm = itemStm.substring(0, index);
	}
	String	itemStr =
	  (Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.car(extfList))))).toString();
	if (itemStr.equals(itemStm)) {
	  item = (LList)Lisp.car(extfList);
	  break;
	}
      }
    }
    else {
      item = Lisp.assoc(new IntNum(getRegist()), list);
    }
    //System.err.println("PrubaeModelValueStatement.updateStatement() : regist = " + getRegist() + ", item = " + item);
    if (item != null) {
      if (Lisp.car(Lisp.cdr(Lisp.cdr(item))) == null
	  || Lisp.isNil(Lisp.car(Lisp.cdr(Lisp.cdr(item))))) {
	funcName = "";
      }
      else {
	funcName = (Lisp.car(Lisp.cdr(Lisp.cdr(item)))).toString();
      }
    }
    if (funcName == null) {
      funcName = "";
    }
    if (funcName != null && funcName.length() > 0) {
      setName(funcName);
    }
    else if (getName() != null && getName().length() > 0) {
      funcName = getName();
    }
    //System.err.println("PrubaeModelValueStatement.updateStatement() : funcName = " + funcName);

    /* ;;; add start 2009.07.08 */
    Object
      type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(item))));
    setType(type);
    /* ;;; add end 2009.07.08 */
    /* ;;; add start 2009.07.07 */
    Object
      isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(item)))));
    if (isArgs != null && (isArgs instanceof IntNum)) {
      int	numArgs = ((IntNum)isArgs).intValue();
      if (numArgs >= 0) {
	if (getValues() == null) {
	  setValues(new Vector());
	}
	if (getValues().size() < numArgs) {
	  PrubaeModelValueStatement
	    value = new PrubaeModelValueStatement();
	  value.initialize(getEditor(), this, getValues());
	  getValues().add(value);
	}
	else if (getValues().size() > numArgs) {
	  int	maxArgs = getValues().size()-1;
	  for (int i = maxArgs; i >= numArgs; i--) {
	    getValues().remove(i);
	  }
	}
      }
    }
    /* ;;; add end 2009.07.07 */

    /* ;;; add start 2009.07.06 */
    if ((getRegist() & ProrateRulebaseElement.VARIABLE_SPECIFICATION) != 0) {
      setValues(null);
      //System.err.println("PrubaeModelValueStatement.updateStatement() : variable " + getRegist() + ", setValues(null)");
    }
    /* ;;; add end 2009.07.06 */

    //System.err.println("PrubaeModelValueStatement.updateStatement() : funcName = " + funcName + ", getValues() = " + getValues() + "getValues().size() = " + (getValues() == null ? "null" : getValues().size()));
    if (getValues() == null || getValues().size() <= 0) {
      if (funcName != null && funcName.length() > 0) {
	if ((getRegist() & ProrateRulebaseElement.FUNCTION_SPECIFICATION)
	    != 0) {
	  setStatement(funcName + "()");
	}
	else {
	  setStatement(funcName);
	}
      }
      return;
    }
    else if (getRegist() == ProrateRulebaseElement.NUMBER_CODE) {
      setStatement("");
      setStatement(getStatement() + (Number)getValues().get(0));
      return;
    }
    else if (getRegist() == ProrateRulebaseElement.DATE_CODE) {
      setStatement("");
      setStatement(getStatement() + (Short)getValues().get(0));
      setStatement(getStatement() + "/");
      setStatement(getStatement() + (Short)getValues().get(1));
      return;
    }
    else if (getRegist() == ProrateRulebaseElement.STRING_CODE) {
      setStatement("\"");
      setStatement(getStatement() + (String)getValues().get(0));
      setStatement(getStatement() + "\"");
      return;
    }
    else if (getRegist() == ProrateRulebaseElement.PATH_CODE
	     || getRegist() == ProrateRulebaseElement.MULTIVAL_CODE
	     || getRegist() == ProrateRulebaseElement.INTERVAL_CODE) {
      String
	marker = ((getRegist() == ProrateRulebaseElement.MULTIVAL_CODE) ?
		  "," : "-");
      setStatement("");
      for (int i = 0; i < getValues().size(); i++) {
	if (i > 0) {
	  setStatement(getStatement() + marker);
	}
	if (getValues().get(i) instanceof PrubaeModelValue) {
	  if (getValues().get(i) instanceof PrubaeModelValueStatement) {
	    PrubaeController
	      cntl =
	      (PrubaeController)
	      ((PrubaeModel)getValues().get(i)).getController();
	    if (cntl != null) {
	      cntl.update();
	    }
	  }
	  ((PrubaeModelValue)getValues().get(i)).updateStatement();
	  setStatement(getStatement() +
		       ((PrubaeModelValue)getValues().get(i)).getStatement());
	}
	else {
	  setStatement(getStatement() + getValues().get(i).toString());
	}
      }
      return;
    }
    setStatement(funcName + "(");
    for (int i = 0; i < getValues().size(); i++) {
      if (i > 0) {
	setStatement(getStatement() + " ");
      }
      if (getValues().get(i) instanceof PrubaeModelValue) {
	if (getValues().get(i) instanceof PrubaeModelValueStatement) {
	  PrubaeController
	    cntl =
	    (PrubaeController)
	    ((PrubaeModel)getValues().get(i)).getController();
	  if (cntl != null) {
	    cntl.update();
	  }
	}
	((PrubaeModelValue)getValues().get(i)).updateStatement();
	setStatement(getStatement() +
		     ((PrubaeModelValue)getValues().get(i)).getStatement());
      }
      else {
	setStatement(getStatement() + getValues().get(i).toString());
      }
    }
    setStatement(getStatement() + ")");
    if (getStatement().equals("()")) {
      setStatement("");
    }
    return;
  }

  /**
   * <code>writeModel</code> method
   * writes the regist code of the model and attributes with it,
   * writes all model values in the values list,
   * using the writer(PrubaeWriter) instance.
   */
  public void writeModel(ProrateRulebaseWriter rulebase) {
    rulebase.writeValueStatement(this);
  }

  /**
   * <code>getSize</code> method
   * counts the size of this rule and returns the size.
   *
   * @param rulebase a <code>ProrateRulebaseWriter</code> value
   * @return an <code>int</code> value of size bytes
   */
  public int getSize(ProrateRulebaseWriter rulebase) {
    return rulebase.getValueStatementSize(this);
  }

  /* ;;; 2006.09.12 */
  /**
   * <code>check</code> method	check validity of the prubae model.
   *
   * @param errors a <code>List</code> value
   * @return a <code>boolean</code> value
   */
  public boolean check(List errors) {
    LList
      list = Lisp.append(Lisp.append(getEditor().getValueList(),
				     getEditor().getVarList()),
			 getEditor().getConstList());
    LList	valueList = null;
    if ((getRegist() & ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION)
	== ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION) {
      LList	top = Lisp.assoc(new IntNum(getRegist()), list);
      LList	autoList = Lisp.member(top, list);
      for ( ; !Lisp.isNil(autoList); autoList = (LList)Lisp.cdr(autoList)) {
	IntNum	registNum = (IntNum)Lisp.car(Lisp.car(autoList));
	int	regist = registNum.intValue();
	if ((regist & ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION)
	    != ProrateRulebaseElement.AUTO_VARIABLE_SPECIFICATION) {
	  break;
	}
	if (Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.car(autoList))))
	    .equals(getStatement())) {
	  valueList = (LList)Lisp.car(autoList);
	  break;
	}
      }
    }
    else if (getRegist() == (short) ProrateRulebaseElement.EXTERNAL_FUNCTION) {
      LList	top = Lisp.assoc(new IntNum(getRegist()), list);
      LList	extfList = Lisp.member(top, list);
      for (int i = 0; !Lisp.isNil(extfList);
	   extfList = (LList)Lisp.cdr(extfList), i++) {
	IntNum	registNum = (IntNum)Lisp.car(Lisp.car(extfList));
	int	regist = registNum.intValue();
	if (regist != ProrateRulebaseElement.EXTERNAL_FUNCTION) {
	  break;
	}
	String	item = getName();
	int	index = item.indexOf("(");
	if (index >= 0) {
	  item = item.substring(0, index);
	}
	String	itemStr =
	  (Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.car(extfList))))).toString();
	if (itemStr.equals(item)) {
	  valueList = (LList)Lisp.car(extfList);
	  break;
	}
      }
    }
    else {
      valueList = Lisp.assoc(new IntNum(getRegist()), list);
    }
    if (valueList == null || Lisp.isNil(valueList)) {
      errors.add("illegal regist code " + getRegist());
      return false;
    }
    Object
      isArgs = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList)))));
    if (isArgs != null && (isArgs instanceof IntNum)) {
      int	numArgs = ((IntNum)isArgs).intValue();
      if (numArgs >= 0) {
	if (getValues() == null) {
	  if (numArgs != 0) {
	    errors.add("illegal argument count in " + getName() + " function");
	    return false;
	  }
	}
	else if (getValues().size() != numArgs) {
	  errors.add("illegal argument count in " + getName() + " function");
	  return false;
	}
      }
    }
    if (getValues() != null) {
      for (int i = 0; i < getValues().size(); i++) {
	Object	value = getValues().get(i);
	if (value instanceof PrubaeModel
	    && !((PrubaeModel)value).check(errors)) {
	  errors.add("in argument #" + (i+1)
		     + " of " + getName() + " function");
	  return false;
	}
      }
    }
    return true;
  }

  /* ;;; 2014.01.31 */
  public String	getStringValue() {
    List	valuesList = getValues();
    if (valuesList == null || valuesList.size() == 0) {
      return null;
    }
    return getValues().get(0).toString();
  }

  // Setters and Getters
  /**
   * 
   * @uml.property name="name"
   */
  public void setName(String theName) {
    name = theName;
  }

  /**
   * 
   * @uml.property name="name"
   */
  public String getName() {
    return name;
  }



} /* end class PrubaeModelValueStatement */
